/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.tier.sockets.Message;

public class PingOp {
    public static void execute(ExecutablePool pool, ServerLocation server) {
        PingOpImpl op = new PingOpImpl();
        pool.executeOn(server, op, false, false);
    }

    private PingOp() {
    }

    static class PingOpImpl
    extends AbstractOp {
        private long startTime;

        PingOpImpl() {
            super(5, 0);
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
            Message.MESSAGE_TYPE.set(null);
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.startTime = System.currentTimeMillis();
            this.getMessage().send(false);
            Message.MESSAGE_TYPE.set(5);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "ping");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startPing();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endPingSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endPing(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

