/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.DurableClientAttributes;
import org.apache.geode.distributed.internal.membership.MemberAttributes;
import org.apache.geode.distributed.internal.membership.NetMember;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.jgroups.util.UUID;

public class GMSMember
implements NetMember,
DataSerializableFixedID {
    private static final boolean SHOW_UUIDS = Boolean.getBoolean("gemfire.show_UUIDs");
    private int udpPort = 0;
    private boolean preferredForCoordinator;
    private boolean networkPartitionDetectionEnabled;
    private byte memberWeight;
    private InetAddress inetAddr;
    private int processId;
    private byte vmKind;
    private int vmViewId = -1;
    private int directPort;
    private String name;
    private DurableClientAttributes durableClientAttributes;
    private String[] groups;
    private short versionOrdinal = Version.CURRENT_ORDINAL;
    private long uuidLSBs;
    private long uuidMSBs;
    static final int NPD_ENABLED_BIT = 1;
    static final int PREFERRED_FOR_COORD_BIT = 2;

    public GMSMember() {
    }

    @Override
    public MemberAttributes getAttributes() {
        return new MemberAttributes(this.directPort, this.processId, this.vmKind, this.vmViewId, this.name, this.groups, this.durableClientAttributes);
    }

    @Override
    public void setAttributes(MemberAttributes p_attr) {
        MemberAttributes attr = p_attr;
        if (attr == null) {
            attr = MemberAttributes.INVALID;
        }
        this.processId = attr.getVmPid();
        this.vmKind = (byte)attr.getVmKind();
        this.directPort = attr.getPort();
        this.vmViewId = attr.getVmViewId();
        this.name = attr.getName();
        this.groups = attr.getGroups();
        this.durableClientAttributes = attr.getDurableClientAttributes();
    }

    public GMSMember(String i, int p) {
        this.udpPort = p;
        try {
            this.inetAddr = InetAddress.getByName(i);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public GMSMember(MemberAttributes attr, InetAddress i, int p, boolean networkPartitionDetectionEnabled, boolean preferredForCoordinator, short version, long msbs, long lsbs) {
        this.setAttributes(attr);
        this.inetAddr = i;
        this.udpPort = p;
        this.networkPartitionDetectionEnabled = networkPartitionDetectionEnabled;
        this.preferredForCoordinator = preferredForCoordinator;
        this.versionOrdinal = version;
        this.uuidMSBs = msbs;
        this.uuidLSBs = lsbs;
    }

    public GMSMember(InetAddress i, int p, short version, long msbs, long lsbs, int viewId) {
        this.inetAddr = i;
        this.udpPort = p;
        this.versionOrdinal = version;
        this.uuidMSBs = msbs;
        this.uuidLSBs = lsbs;
        this.vmViewId = viewId;
    }

    @Override
    public int getPort() {
        return this.udpPort;
    }

    @Override
    public boolean isMulticastAddress() {
        return false;
    }

    @Override
    public boolean preferredForCoordinator() {
        return this.preferredForCoordinator;
    }

    @Override
    public void setPreferredForCoordinator(boolean preferred) {
        this.preferredForCoordinator = preferred;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.inetAddr;
    }

    @Override
    public short getVersionOrdinal() {
        return this.versionOrdinal;
    }

    public void setVersionOrdinal(short versionOrdinal) {
        this.versionOrdinal = versionOrdinal;
    }

    public void setUUID(UUID u) {
        this.uuidLSBs = u.getLeastSignificantBits();
        this.uuidMSBs = u.getMostSignificantBits();
    }

    public UUID getUUID() {
        if (this.uuidLSBs == 0L && this.uuidMSBs == 0L) {
            return null;
        }
        return new UUID(this.uuidMSBs, this.uuidLSBs);
    }

    public long getUuidMSBs() {
        return this.uuidMSBs;
    }

    public long getUuidLSBs() {
        return this.uuidLSBs;
    }

    @Override
    public int compareTo(NetMember o) {
        if (o == this) {
            return 0;
        }
        if (o == null || !(o instanceof GMSMember)) {
            throw new ClassCastException(LocalizedStrings.Member_MEMBERCOMPARETO_COMPARISON_BETWEEN_DIFFERENT_CLASSES.toLocalizedString());
        }
        byte[] myAddr = this.inetAddr.getAddress();
        GMSMember his = (GMSMember)o;
        byte[] hisAddr = his.inetAddr.getAddress();
        if (myAddr != hisAddr) {
            for (int idx = 0; idx < myAddr.length; ++idx) {
                if (idx >= hisAddr.length) {
                    return 1;
                }
                if (myAddr[idx] > hisAddr[idx]) {
                    return 1;
                }
                if (myAddr[idx] >= hisAddr[idx]) continue;
                return -1;
            }
            if (hisAddr.length > myAddr.length) {
                return -1;
            }
        }
        if (this.udpPort < his.udpPort) {
            return -1;
        }
        if (his.udpPort < this.udpPort) {
            return 1;
        }
        int result = 0;
        if (this.vmViewId >= 0 && his.vmViewId >= 0) {
            if (this.vmViewId < his.vmViewId) {
                result = -1;
            } else if (his.vmViewId < this.vmViewId) {
                result = 1;
            }
        }
        if (result == 0 && this.uuidMSBs != 0L && his.uuidMSBs != 0L) {
            if (this.uuidMSBs < his.uuidMSBs) {
                result = -1;
            } else if (his.uuidMSBs < this.uuidMSBs) {
                result = 1;
            } else if (this.uuidLSBs < his.uuidLSBs) {
                result = -1;
            } else if (his.uuidLSBs < this.uuidLSBs) {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public int compareAdditionalData(NetMember other) {
        GMSMember his = (GMSMember)other;
        int result = 0;
        if (this.uuidMSBs != 0L && his.uuidMSBs != 0L) {
            if (this.uuidMSBs < his.uuidMSBs) {
                result = -1;
            } else if (his.uuidMSBs < this.uuidMSBs) {
                result = 1;
            } else if (this.uuidLSBs < his.uuidLSBs) {
                result = -1;
            } else if (his.uuidLSBs < this.uuidLSBs) {
                result = 1;
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GMSMember)) {
            return false;
        }
        return this.compareTo((GMSMember)obj) == 0;
    }

    public int hashCode() {
        if (this.inetAddr == null) {
            return this.udpPort;
        }
        return this.udpPort + this.inetAddr.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        String uuid = SHOW_UUIDS ? ";uuid=" + this.getUUID().toStringLong() : (this.uuidLSBs == 0L && this.uuidMSBs == 0L ? "; no uuid" : "; uuid set");
        sb.append("GMSMember[addr=").append(this.inetAddr).append(";port=").append(this.udpPort).append(";processId=").append(this.processId).append(";name=").append(this.name).append(uuid).append("]");
        return sb.toString();
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    @Override
    public boolean isNetworkPartitionDetectionEnabled() {
        return this.networkPartitionDetectionEnabled;
    }

    @Override
    public byte getMemberWeight() {
        return this.memberWeight;
    }

    public InetAddress getInetAddr() {
        return this.inetAddr;
    }

    @Override
    public int getProcessId() {
        return this.processId;
    }

    @Override
    public byte getVmKind() {
        return this.vmKind;
    }

    @Override
    public int getVmViewId() {
        return this.vmViewId;
    }

    @Override
    public void setVmViewId(int id) {
        this.vmViewId = id;
    }

    @Override
    public int getDirectPort() {
        return this.directPort;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DurableClientAttributes getDurableClientAttributes() {
        return this.durableClientAttributes;
    }

    public String[] getRoles() {
        return this.groups;
    }

    public void setUdpPort(int udpPort) {
        this.udpPort = udpPort;
    }

    @Override
    public void setNetworkPartitionDetectionEnabled(boolean networkPartitionDetectionEnabled) {
        this.networkPartitionDetectionEnabled = networkPartitionDetectionEnabled;
    }

    public void setMemberWeight(byte memberWeight) {
        this.memberWeight = memberWeight;
    }

    public void setInetAddr(InetAddress inetAddr) {
        this.inetAddr = inetAddr;
    }

    @Override
    public void setProcessId(int processId) {
        this.processId = processId;
    }

    @Override
    public void setVmKind(int vmKind) {
        this.vmKind = (byte)vmKind;
    }

    @Override
    public void setVersion(Version v) {
        this.versionOrdinal = v.ordinal();
    }

    public void setBirthViewId(int birthViewId) {
        this.vmViewId = birthViewId;
    }

    @Override
    public void setDirectPort(int directPort) {
        this.directPort = directPort;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setDurableClientAttributes(DurableClientAttributes durableClientAttributes) {
        this.durableClientAttributes = durableClientAttributes;
    }

    @Override
    public String[] getGroups() {
        return this.groups;
    }

    @Override
    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    @Override
    public void setPort(int p) {
        this.udpPort = p;
    }

    public boolean hasUUID() {
        return this.uuidLSBs != 0L || this.uuidMSBs != 0L;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public int getDSFID() {
        return -149;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        this.writeEssentialData(out);
        out.writeInt(this.directPort);
        out.writeByte(this.memberWeight);
        out.writeByte(this.vmKind);
        out.writeInt(this.processId);
        DataSerializer.writeString(this.name, out);
        DataSerializer.writeStringArray(this.groups, out);
    }

    public void writeEssentialData(DataOutput out) throws IOException {
        Version.writeOrdinal(out, this.versionOrdinal, true);
        int flags = 0;
        if (this.networkPartitionDetectionEnabled) {
            flags |= 1;
        }
        if (this.preferredForCoordinator) {
            flags |= 2;
        }
        out.writeShort(flags);
        DataSerializer.writeInetAddress(this.inetAddr, out);
        out.writeInt(this.udpPort);
        out.writeInt(this.vmViewId);
        out.writeLong(this.uuidMSBs);
        out.writeLong(this.uuidLSBs);
        if (InternalDataSerializer.getVersionForDataStream(out).compareTo(Version.GEODE_120) >= 0) {
            out.writeByte(this.vmKind);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.readEssentialData(in);
        this.directPort = in.readInt();
        this.memberWeight = in.readByte();
        this.vmKind = in.readByte();
        this.processId = in.readInt();
        this.name = DataSerializer.readString(in);
        this.groups = DataSerializer.readStringArray(in);
    }

    public void readEssentialData(DataInput in) throws IOException, ClassNotFoundException {
        this.versionOrdinal = Version.readOrdinal(in);
        short flags = in.readShort();
        this.networkPartitionDetectionEnabled = (flags & 1) != 0;
        this.preferredForCoordinator = (flags & 2) != 0;
        this.inetAddr = DataSerializer.readInetAddress(in);
        this.udpPort = in.readInt();
        this.vmViewId = in.readInt();
        this.uuidMSBs = in.readLong();
        this.uuidLSBs = in.readLong();
        if (InternalDataSerializer.getVersionForDataStream(in).compareTo(Version.GEODE_120) >= 0) {
            this.vmKind = in.readByte();
        }
    }

    @Override
    public boolean hasAdditionalData() {
        return this.uuidMSBs != 0L || this.uuidLSBs != 0L || this.memberWeight != 0;
    }

    @Override
    public void writeAdditionalData(DataOutput out) throws IOException {
        out.writeLong(this.uuidMSBs);
        out.writeLong(this.uuidLSBs);
        out.write(this.memberWeight);
    }

    @Override
    public void readAdditionalData(DataInput in) throws ClassNotFoundException, IOException {
        try {
            this.uuidMSBs = in.readLong();
            this.uuidLSBs = in.readLong();
            this.memberWeight = (byte)(in.readByte() & 0xFF);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }
}

