/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.SystemConnectException;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionException;
import org.apache.geode.distributed.internal.LocatorStats;
import org.apache.geode.distributed.internal.membership.DistributedMembershipListener;
import org.apache.geode.distributed.internal.membership.MemberAttributes;
import org.apache.geode.distributed.internal.membership.MemberServices;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.distributed.internal.membership.NetMember;
import org.apache.geode.distributed.internal.membership.gms.GMSMember;
import org.apache.geode.distributed.internal.membership.gms.NetLocator;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.locator.GMSLocator;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.admin.remote.RemoteTransportConfig;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.tcp.ConnectionException;
import org.apache.geode.security.GemFireSecurityException;

public class GMSMemberFactory
implements MemberServices {
    @Override
    public NetMember newNetMember(InetAddress i, int p, boolean splitBrainEnabled, boolean canBeCoordinator, MemberAttributes attr, short version) {
        GMSMember result = new GMSMember(attr, i, p, splitBrainEnabled, canBeCoordinator, version, 0L, 0L);
        return result;
    }

    @Override
    public NetMember newNetMember(InetAddress i, int p) {
        return new GMSMember(MemberAttributes.DEFAULT, i, p, false, true, Version.CURRENT_ORDINAL, 0L, 0L);
    }

    @Override
    public NetMember newNetMember(String s, int p) {
        InetAddress inetAddr = null;
        try {
            inetAddr = SocketCreator.getLocalHost();
        }
        catch (UnknownHostException e2) {
            throw new RuntimeException("Unable to create an identifier for testing for " + s, e2);
        }
        return this.newNetMember(inetAddr, p);
    }

    @Override
    public MembershipManager newMembershipManager(DistributedMembershipListener listener, DistributionConfig config, RemoteTransportConfig transport, DMStats stats) throws DistributionException {
        Services services = new Services(listener, config, transport, stats);
        try {
            services.init();
            services.start();
        }
        catch (ConnectionException e) {
            throw new DistributionException(LocalizedStrings.MemberFactory_UNABLE_TO_CREATE_MEMBERSHIP_MANAGER.toLocalizedString(), e);
        }
        catch (GemFireConfigException | SystemConnectException | GemFireSecurityException e) {
            throw e;
        }
        catch (RuntimeException e) {
            Services.getLogger().error("Unexpected problem starting up membership services", (Throwable)e);
            throw new SystemConnectException("Problem starting up membership services", e);
        }
        return (MembershipManager)((Object)services.getManager());
    }

    @Override
    public NetLocator newLocatorHandler(InetAddress bindAddress, File stateFile, String locatorString, boolean usePreferredCoordinators, boolean networkPartitionDetectionEnabled, LocatorStats stats, String securityUDPDHAlgo) {
        return new GMSLocator(bindAddress, stateFile, locatorString, usePreferredCoordinators, networkPartitionDetectionEnabled, stats, securityUDPDHAlgo);
    }
}

