/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.tcpserver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.UnsupportedVersionException;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.tcpserver.InfoRequest;
import org.apache.geode.distributed.internal.tcpserver.InfoResponse;
import org.apache.geode.distributed.internal.tcpserver.LocatorCancelException;
import org.apache.geode.distributed.internal.tcpserver.ShutdownRequest;
import org.apache.geode.distributed.internal.tcpserver.TcpServer;
import org.apache.geode.distributed.internal.tcpserver.VersionRequest;
import org.apache.geode.distributed.internal.tcpserver.VersionResponse;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.VersionedDataInputStream;
import org.apache.geode.internal.VersionedDataOutputStream;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.logging.log4j.Logger;

public class TcpClient {
    private static final Logger logger = LogService.getLogger();
    private static final int DEFAULT_REQUEST_TIMEOUT = 120000;
    private static Map<InetSocketAddress, Short> serverVersions = new HashMap<InetSocketAddress, Short>();
    private final SocketCreator socketCreator;

    public TcpClient(DistributionConfig distributionConfig) {
        SocketCreatorFactory.setDistributionConfig(distributionConfig);
        this(SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.LOCATOR));
    }

    public TcpClient() {
        this(SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.LOCATOR));
    }

    public TcpClient(SocketCreator socketCreator) {
        this.socketCreator = socketCreator;
    }

    public void stop(InetAddress addr, int port) throws ConnectException {
        try {
            ShutdownRequest request = new ShutdownRequest();
            this.requestToServer(addr, port, request, 120000);
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (Exception ex) {
            logger.error("TcpClient.stop(): exception connecting to locator " + addr + ":" + port + ": " + ex);
        }
    }

    public String[] getInfo(InetAddress addr, int port) {
        try {
            InfoRequest request = new InfoRequest();
            InfoResponse response = (InfoResponse)this.requestToServer(addr, port, request, 120000);
            return response.getInfo();
        }
        catch (ConnectException ignore) {
            return null;
        }
        catch (Exception ex) {
            logger.error("TcpClient.getInfo(): exception connecting to locator " + addr + ":" + port + ": " + ex);
            return null;
        }
    }

    public Object requestToServer(InetAddress addr, int port, Object request, int timeout) throws IOException, ClassNotFoundException {
        return this.requestToServer(addr, port, request, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object requestToServer(InetAddress addr, int port, Object request, int timeout, boolean replyExpected) throws IOException, ClassNotFoundException {
        long newTimeout;
        InetSocketAddress ipAddr = addr == null ? new InetSocketAddress(port) : new InetSocketAddress(addr, port);
        long giveupTime = System.currentTimeMillis() + (long)timeout;
        short serverVersion = this.getServerVersion(ipAddr, timeout);
        if (serverVersion > Version.CURRENT_ORDINAL) {
            serverVersion = Version.CURRENT_ORDINAL;
        }
        int gossipVersion = TcpServer.getCurrentGossipVersion();
        if (Version.GFE_71.compareTo(serverVersion) > 0) {
            gossipVersion = TcpServer.getOldGossipVersion();
        }
        if ((newTimeout = giveupTime - System.currentTimeMillis()) <= 0L) {
            return null;
        }
        logger.debug("TcpClient sending {} to {}", request, (Object)ipAddr);
        Socket sock = this.socketCreator.connect(ipAddr.getAddress(), ipAddr.getPort(), (int)newTimeout, null, false);
        sock.setSoTimeout((int)newTimeout);
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(sock.getOutputStream());
            if (serverVersion < Version.CURRENT_ORDINAL) {
                out = new VersionedDataOutputStream(out, Version.fromOrdinalNoThrow(serverVersion, false));
            }
            out.writeInt(gossipVersion);
            if (gossipVersion > TcpServer.getOldGossipVersion()) {
                out.writeShort(serverVersion);
            }
            DataSerializer.writeObject(request, out);
            out.flush();
            if (replyExpected) {
                DataInputStream in = new DataInputStream(sock.getInputStream());
                in = new VersionedDataInputStream(in, Version.fromOrdinal(serverVersion, false));
                try {
                    Object response = DataSerializer.readObject(in);
                    logger.debug("received response: {}", response);
                    Object t = response;
                    return t;
                }
                catch (EOFException ex) {
                    EOFException eof = new EOFException("Locator at " + ipAddr + " did not respond. This is normal if the locator was shutdown. If it wasn't check its log for exceptions.");
                    eof.initCause(ex);
                    throw eof;
                }
            }
            Object in = null;
            return in;
        }
        catch (UnsupportedVersionException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Remote TcpServer version: " + serverVersion + " is higher than local version: " + Version.CURRENT_ORDINAL + ". This is never expected as remoteVersion");
            }
            Object var16_19 = null;
            return var16_19;
        }
        finally {
            try {
                if (replyExpected && !sock.isClosed() && !this.socketCreator.useSSL()) {
                    sock.setSoLinger(true, 0);
                }
                sock.close();
            }
            catch (Exception e) {
                logger.error("Error closing socket ", (Throwable)e);
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Short getServerVersion(InetSocketAddress ipAddr, int timeout) throws IOException, ClassNotFoundException {
        block26: {
            int gossipVersion = TcpServer.getCurrentGossipVersion();
            Short serverVersion = null;
            Map<InetSocketAddress, Short> map = serverVersions;
            synchronized (map) {
                serverVersion = serverVersions.get(ipAddr);
            }
            if (serverVersion != null) {
                return serverVersion;
            }
            gossipVersion = TcpServer.getOldGossipVersion();
            Socket sock = null;
            try {
                sock = this.socketCreator.connect(ipAddr.getAddress(), ipAddr.getPort(), timeout, null, false);
                sock.setSoTimeout(timeout);
            }
            catch (SSLException e) {
                throw new LocatorCancelException("Unable to form SSL connection", e);
            }
            try {
                DataOutputStream out = new DataOutputStream(sock.getOutputStream());
                out = new VersionedDataOutputStream(out, Version.GFE_57);
                out.writeInt(gossipVersion);
                VersionRequest verRequest = new VersionRequest();
                DataSerializer.writeObject(verRequest, out);
                out.flush();
                InputStream inputStream = sock.getInputStream();
                DataInputStream in = new DataInputStream(inputStream);
                in = new VersionedDataInputStream(in, Version.GFE_57);
                try {
                    Object readObject = DataSerializer.readObject(in);
                    if (!(readObject instanceof VersionResponse)) {
                        throw new LocatorCancelException("Unrecognisable response received: object is null. This could be the result of trying to connect a non-SSL-enabled locator to an SSL-enabled locator.");
                    }
                    VersionResponse response = (VersionResponse)readObject;
                    if (response == null) break block26;
                    serverVersion = response.getVersionOrdinal();
                    Object object = serverVersions;
                    synchronized (object) {
                        serverVersions.put(ipAddr, serverVersion);
                    }
                    object = serverVersion;
                    return object;
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            finally {
                try {
                    sock.setSoLinger(true, 0);
                    sock.close();
                }
                catch (Exception e) {
                    logger.error("Error closing socket ", (Throwable)e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Locator " + ipAddr + " did not respond to a request for its version.  I will assume it is using v5.7 for safety.");
        }
        Map<InetSocketAddress, Short> map = serverVersions;
        synchronized (map) {
            serverVersions.put(ipAddr, Version.GFE_57.ordinal());
        }
        return Version.GFE_57.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearStaticData() {
        Map<InetSocketAddress, Short> map = serverVersions;
        synchronized (map) {
            serverVersions.clear();
        }
    }
}

