/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.AdminMessageType;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminWaiters;
import org.apache.geode.internal.i18n.LocalizedStrings;

public abstract class AdminResponse
extends HighPriorityDistributionMessage
implements AdminMessageType {
    private int msgId;

    int getMsgId() {
        return this.msgId;
    }

    public void setMsgId(int msgId) {
        this.msgId = msgId;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    @Override
    protected void process(DistributionManager dm) {
        AdminWaiters.sendResponse(this);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.msgId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.msgId = in.readInt();
    }

    public InternalDistributedMember getRecipient() {
        InternalDistributedMember[] recipients = this.getRecipients();
        int size = recipients.length;
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new IllegalStateException(LocalizedStrings.AdminResponse_COULD_NOT_RETURN_ONE_RECIPIENT_BECAUSE_THIS_MESSAGE_HAS_0_RECIPIENTS.toLocalizedString(size));
        }
        return recipients[0];
    }
}

