/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogWriterAppender;
import org.apache.geode.internal.logging.log4j.LogWriterAppenders;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class TailLogResponse
extends AdminResponse {
    private static final Logger logger = LogService.getLogger();
    private String tail;
    private String childTail;

    public static TailLogResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        TailLogResponse m = new TailLogResponse();
        m.setRecipient(recipient);
        try {
            InternalDistributedSystem sys = dm.getSystem();
            LogWriterAppender lwa = LogWriterAppenders.getAppender(LogWriterAppenders.Identifier.MAIN);
            if (lwa != null) {
                m.childTail = TailLogResponse.tailSystemLog(lwa.getChildLogFile());
                m.tail = TailLogResponse.tailSystemLog(sys.getConfig());
                if (m.tail == null) {
                    m.tail = LocalizedStrings.TailLogResponse_NO_LOG_FILE_WAS_SPECIFIED_IN_THE_CONFIGURATION_MESSAGES_WILL_BE_DIRECTED_TO_STDOUT.toLocalizedString();
                }
            } else {
                m.childTail = TailLogResponse.tailSystemLog((File)null);
                m.tail = TailLogResponse.tailSystemLog(sys.getConfig());
                if (m.tail == null) {
                    m.tail = LocalizedStrings.TailLogResponse_NO_LOG_FILE_WAS_SPECIFIED_IN_THE_CONFIGURATION_MESSAGES_WILL_BE_DIRECTED_TO_STDOUT.toLocalizedString();
                }
            }
        }
        catch (IOException e) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.TailLogResponse_ERROR_OCCURRED_WHILE_READING_SYSTEM_LOG__0, e));
            m.tail = "";
        }
        return m;
    }

    @Override
    public int getDSFID() {
        return 1062;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.tail, out);
        DataSerializer.writeString(this.childTail, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.tail = DataSerializer.readString(in);
        this.childTail = DataSerializer.readString(in);
    }

    public String getTail() {
        return this.tail;
    }

    public String getChildTail() {
        return this.childTail;
    }

    @Override
    public String toString() {
        return "TailLogResponse from " + this.getRecipient() + " <TAIL>" + this.getTail() + "</TAIL>";
    }

    public static String tailSystemLog(File logFile) throws IOException {
        if (logFile == null || logFile.equals(new File(""))) {
            return null;
        }
        int numLines = 30;
        int maxBuffer = 65500;
        long fileLength = logFile.length();
        byte[] buffer = fileLength > (long)maxBuffer ? new byte[maxBuffer] : new byte[(int)fileLength];
        int readSize = buffer.length;
        RandomAccessFile f = new RandomAccessFile(logFile, "r");
        f.seek(fileLength - (long)readSize);
        f.read(buffer, 0, readSize);
        f.close();
        String messageString = new String(buffer);
        char[] text = messageString.toCharArray();
        int j = 0;
        for (int i = text.length - 1; i >= 0; --i) {
            if (text[i] == '[') {
                ++j;
            }
            if (j != numLines) continue;
            messageString = messageString.substring(i);
            break;
        }
        return messageString.trim();
    }

    private static String tailSystemLog(DistributionConfig sc) throws IOException {
        File logFile = sc.getLogFile();
        if (logFile == null || logFile.equals(new File(""))) {
            return null;
        }
        if (!logFile.isAbsolute()) {
            logFile = new File(logFile.getAbsolutePath());
        }
        return TailLogResponse.tailSystemLog(logFile);
    }
}

