/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.client.internal.locator.SerializationHelper;
import org.apache.geode.cache.partition.PartitionListener;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.LockNotHeldException;
import org.apache.geode.distributed.LockServiceDestroyedException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.DistributedMemberLock;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.BucketRegionQueue;
import org.apache.geode.internal.cache.BucketServerLocation66;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionStats;
import org.apache.geode.internal.cache.ProxyBucketRegion;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.partitioned.BucketProfileUpdateMessage;
import org.apache.geode.internal.cache.partitioned.DeposePrimaryBucketMessage;
import org.apache.geode.internal.cache.partitioned.RegionAdvisor;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.util.StopWatch;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class BucketAdvisor
extends CacheDistributionAdvisor {
    private static final Logger logger = LogService.getLogger();
    public static final boolean ENFORCE_SAFE_CLOSE = false;
    private final AtomicReference primaryMember = new AtomicReference();
    protected final RegionAdvisor regionAdvisor;
    private DistributedMemberLock primaryLock;
    private static final byte NO_PRIMARY_NOT_HOSTING = 0;
    private static final byte NO_PRIMARY_HOSTING = 1;
    private static final byte OTHER_PRIMARY_NOT_HOSTING = 4;
    private static final byte OTHER_PRIMARY_HOSTING = 5;
    private static final byte VOLUNTEERING_HOSTING = 3;
    private static final byte BECOMING_HOSTING = 15;
    private static final byte IS_PRIMARY_HOSTING = 9;
    private static final byte CLOSED = 16;
    private byte primaryState = 0;
    private VolunteeringDelegate volunteeringDelegate;
    private static final Random myRand = new Random();
    private boolean redundancySatisfied = true;
    private boolean redundancyEverSatisfied = false;
    private final ReadWriteLock primaryMoveLock = new ReentrantReadWriteLock();
    private final Lock activeWriteLock = this.primaryMoveLock.readLock();
    private final Lock activePrimaryMoveLock = this.primaryMoveLock.writeLock();
    private BucketAdvisor parentAdvisor;
    private volatile int redundancy = -1;
    private volatile InternalDistributedMember primaryElector;
    private volatile BucketProfile localProfile;
    private volatile boolean everHadPrimary = false;
    private BucketAdvisor startingBucketAdvisor;
    private PartitionedRegion pRegion;
    private volatile boolean shadowBucketDestroyed;
    private static final long BUCKET_REDUNDANCY_WAIT = 15000L;
    private static final long BUCKET_STORAGE_WAIT = Long.getLong("gemfire.BUCKET_STORAGE_WAIT", 15000L);

    private BucketAdvisor(Bucket bucket, RegionAdvisor regionAdvisor) {
        super(bucket);
        this.regionAdvisor = regionAdvisor;
        this.pRegion = this.regionAdvisor.getPartitionedRegion();
        this.resetParentAdvisor(bucket.getId());
    }

    public static BucketAdvisor createBucketAdvisor(Bucket bucket, RegionAdvisor regionAdvisor) {
        BucketAdvisor advisor = new BucketAdvisor(bucket, regionAdvisor);
        advisor.initialize();
        return advisor;
    }

    public void resetParentAdvisor(int bucketId) {
        PartitionedRegion colocatedRegion = ColocationHelper.getColocatedRegion(this.pRegion);
        if (colocatedRegion != null) {
            if (colocatedRegion.isFixedPartitionedRegion()) {
                List<FixedPartitionAttributesImpl> fpas = colocatedRegion.getFixedPartitionAttributesImpl();
                if (fpas != null) {
                    for (FixedPartitionAttributesImpl fpa : fpas) {
                        if (!fpa.hasBucket(bucketId)) continue;
                        this.parentAdvisor = colocatedRegion.getRegionAdvisor().getBucketAdvisor(fpa.getStartingBucketID());
                        break;
                    }
                }
            } else {
                this.parentAdvisor = colocatedRegion.getRegionAdvisor().getBucketAdvisor(bucketId);
            }
        } else {
            this.parentAdvisor = null;
        }
    }

    private void assignStartingBucketAdvisor() {
        List<FixedPartitionAttributesImpl> fpas;
        if (this.pRegion.isFixedPartitionedRegion() && (fpas = this.pRegion.getFixedPartitionAttributesImpl()) != null) {
            int bucketId = this.getBucket().getId();
            for (FixedPartitionAttributesImpl fpa : fpas) {
                if (!fpa.hasBucket(bucketId) || bucketId == fpa.getStartingBucketID()) continue;
                this.startingBucketAdvisor = this.regionAdvisor.getBucketAdvisor(fpa.getStartingBucketID());
                break;
            }
        }
    }

    public Lock getActiveWriteLock() {
        return this.activeWriteLock;
    }

    Lock getParentActiveWriteLock() {
        if (this.parentAdvisor != null) {
            return this.parentAdvisor.getActiveWriteLock();
        }
        return null;
    }

    public void tryLockIfPrimary() {
        if (this.isPrimary()) {
            try {
                this.activePrimaryMoveLock.lock();
            }
            finally {
                this.activePrimaryMoveLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean deposePrimary() {
        boolean needToSendProfileUpdate;
        block10: {
            boolean bl;
            if (!this.isPrimary()) {
                this.sendProfileUpdate();
                return true;
            }
            this.activePrimaryMoveLock.lock();
            needToSendProfileUpdate = false;
            try {
                this.removePrimary(this.getDistributionManager().getId());
                BucketAdvisor bucketAdvisor = this;
                // MONITORENTER : bucketAdvisor
                if (this.isPrimary()) break block10;
                needToSendProfileUpdate = true;
                bl = true;
                // MONITOREXIT : bucketAdvisor
                this.activePrimaryMoveLock.unlock();
                if (!needToSendProfileUpdate) return bl;
            }
            catch (Throwable throwable) {
                this.activePrimaryMoveLock.unlock();
                if (!needToSendProfileUpdate) throw throwable;
                if (this.getBucket() instanceof BucketRegionQueue) {
                    BucketRegionQueue brq = (BucketRegionQueue)this.getBucket();
                    brq.decQueueSize(brq.size());
                }
                this.sendProfileUpdate();
                throw throwable;
            }
            if (this.getBucket() instanceof BucketRegionQueue) {
                BucketRegionQueue brq = (BucketRegionQueue)this.getBucket();
                brq.decQueueSize(brq.size());
            }
            this.sendProfileUpdate();
            return bl;
        }
        boolean bl = false;
        // MONITOREXIT : bucketAdvisor
        this.activePrimaryMoveLock.unlock();
        if (!needToSendProfileUpdate) return bl;
        if (this.getBucket() instanceof BucketRegionQueue) {
            BucketRegionQueue brq = (BucketRegionQueue)this.getBucket();
            brq.decQueueSize(brq.size());
        }
        this.sendProfileUpdate();
        return bl;
    }

    private boolean deposePrimaryForColocatedChildren() {
        boolean deposedChildPrimaries = true;
        List<PartitionedRegion> colocatedChildPRs = ColocationHelper.getColocatedChildRegions(this.pRegion);
        if (colocatedChildPRs != null) {
            for (PartitionedRegion pr : colocatedChildPRs) {
                Bucket b = pr.getRegionAdvisor().getBucket(this.getBucket().getId());
                if (b == null) continue;
                BucketAdvisor ba = b.getBucketAdvisor();
                deposedChildPrimaries = ba.deposePrimary() && deposedChildPrimaries;
            }
        }
        return deposedChildPrimaries;
    }

    private boolean deposeOtherPrimaryBucketForFixedPartition() {
        boolean deposedOtherPrimaries = true;
        int bucketId = this.getBucket().getId();
        List<FixedPartitionAttributesImpl> fpas = this.pRegion.getFixedPartitionAttributesImpl();
        if (fpas != null) {
            for (FixedPartitionAttributesImpl fpa : fpas) {
                if (fpa.getStartingBucketID() != bucketId) continue;
                for (int i = bucketId + 1; i <= fpa.getLastBucketID(); ++i) {
                    Bucket b = this.regionAdvisor.getBucket(i);
                    if (b == null) continue;
                    BucketAdvisor ba = b.getBucketAdvisor();
                    deposedOtherPrimaries = ba.deposePrimary() && deposedOtherPrimaries;
                }
            }
        }
        return deposedOtherPrimaries;
    }

    void removeBucket() {
        this.setHosting(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incLowRedundancyBucketCount(int val) {
        boolean HAS_LOW_REDUNDANCY = false;
        boolean ALREADY_GENERATED_WARNING = true;
        PartitionedRegionStats stats = this.getPartitionedRegionStats();
        boolean[] lowRedundancyFlags = this.regionAdvisor.getLowRedundancyFlags();
        int configuredRedundancy = this.pRegion.getRedundantCopies();
        boolean[] blArray = lowRedundancyFlags;
        synchronized (lowRedundancyFlags) {
            stats.incLowRedundancyBucketCount(val);
            if (stats.getLowRedundancyBucketCount() == 0) {
                lowRedundancyFlags[0] = false;
                lowRedundancyFlags[1] = false;
                stats.setActualRedundantCopies(configuredRedundancy);
            } else {
                int numBucketHosts = this.getBucketRedundancy() + 1;
                int actualRedundancy = Math.max(numBucketHosts - 1, 0);
                if (actualRedundancy < stats.getActualRedundantCopies()) {
                    lowRedundancyFlags[1] = false;
                }
                if (!lowRedundancyFlags[0] || !lowRedundancyFlags[1]) {
                    lowRedundancyFlags[0] = true;
                    stats.setActualRedundantCopies(actualRedundancy);
                    if (!lowRedundancyFlags[1] && this.redundancyEverSatisfied) {
                        lowRedundancyFlags[1] = true;
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.BucketAdvisor_REDUNDANCY_HAS_DROPPED_BELOW_0_CONFIGURED_COPIES_TO_1_ACTUAL_COPIES_FOR_2, new Object[]{configuredRedundancy, actualRedundancy, this.pRegion.getFullPath()}));
                    }
                }
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    public InternalDistributedMember getPreferredNode() {
        if (this.isHosting()) {
            this.getPartitionedRegionStats().incPreferredReadLocal();
            return this.getDistributionManager().getId();
        }
        DistributionAdvisor.Profile[] locProfiles = this.profiles;
        if (locProfiles.length == 0) {
            return null;
        }
        this.getPartitionedRegionStats().incPreferredReadRemote();
        if (locProfiles.length == 1) {
            return locProfiles[0].peerMemberId;
        }
        int i = myRand.nextInt(locProfiles.length);
        return locProfiles[i].peerMemberId;
    }

    Queue getVolunteeringQueue() {
        return this.regionAdvisor.getVolunteeringQueue();
    }

    Semaphore getVolunteeringSemaphore() {
        return this.regionAdvisor.getVolunteeringSemaphore();
    }

    PartitionedRegionStats getPartitionedRegionStats() {
        return this.regionAdvisor.getPartitionedRegionStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void profileCreated(DistributionAdvisor.Profile profile) {
        this.regionAdvisor.incrementBucketCount(profile);
        super.profileCreated(profile);
        if (this.updateRedundancy() > 0) {
            this.notifyAll();
        }
        this.regionAdvisor.updateBucketStatus(this.getBucket().getId(), profile.peerMemberId, false);
        if (logger.isDebugEnabled()) {
            logger.debug("Profile added {} Profile : {}", (Object)this.getBucket().getFullPath(), (Object)profile);
        }
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            this.updateServerBucketProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void profileUpdated(DistributionAdvisor.Profile profile) {
        super.profileUpdated(profile);
        if (this.updateRedundancy() > 0) {
            this.notifyAll();
        }
        this.regionAdvisor.updateBucketStatus(this.getBucket().getId(), profile.peerMemberId, false);
        if (logger.isDebugEnabled()) {
            logger.debug("Profile updated {} Profile : {}", (Object)this.getBucket().getFullPath(), (Object)profile);
        }
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            this.updateServerBucketProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void profileRemoved(DistributionAdvisor.Profile profile) {
        if (profile != null) {
            this.regionAdvisor.updateBucketStatus(this.getBucket().getId(), profile.getDistributedMember(), true);
            this.regionAdvisor.decrementsBucketCount(profile);
        }
        this.updateRedundancy();
        if (logger.isDebugEnabled()) {
            logger.debug("Profile removed {} the member lost {} Profile : {}", (Object)this.getBucket().getFullPath(), (Object)profile.getDistributedMember(), (Object)profile);
        }
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            this.updateServerBucketProfile();
        }
    }

    @Override
    public boolean shouldSyncForCrashedMember(InternalDistributedMember id) {
        BucketProfile profile = (BucketProfile)this.getProfile(id);
        return profile != null && profile.isPrimary;
    }

    @Override
    public DistributedRegion getRegionForDeltaGII() {
        DistributedRegion result = super.getRegionForDeltaGII();
        if (result == null && this.getAdvisee() instanceof ProxyBucketRegion) {
            result = ((ProxyBucketRegion)this.getAdvisee()).getHostedBucketRegion();
        }
        return result;
    }

    public void checkForLostPrimaryElector(DistributionAdvisor.Profile profile) {
        if (this.primaryElector != null && this.primaryElector.equals(profile.getDistributedMember())) {
            if (logger.isDebugEnabled()) {
                logger.debug("Bucket {} lost the member responsible for electing the primary. Finishing bucket creation", (Object)this.getBucket().getFullPath());
            }
            this.primaryElector = this.getBucket().getDistributionManager().getId();
            this.getBucket().getDistributionManager().getWaitingThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    BucketAdvisor.this.getBucket().getPartitionedRegion().getRedundancyProvider().finishIncompleteBucketCreation(BucketAdvisor.this.getBucket().getId());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putProfile(DistributionAdvisor.Profile profile, boolean forceProfile) {
        boolean applied;
        assert (profile instanceof BucketProfile);
        BucketProfile bp = (BucketProfile)profile;
        if (!bp.isHosting && !bp.isInitializing) {
            if (logger.isTraceEnabled(LogMarker.DA)) {
                logger.trace(LogMarker.DA, "BucketAdvisor#putProfile early out");
            }
            return false;
        }
        if (logger.isTraceEnabled(LogMarker.DA)) {
            logger.trace(LogMarker.DA, "BucketAdvisor#putProfile profile=<{}> force={}; profile = {}", (Object)profile, (Object)forceProfile, (Object)bp);
        }
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            profile.initialMembershipVersion = Long.MIN_VALUE;
            applied = super.putProfile(profile, forceProfile);
            if (applied && !this.isPrimary()) {
                if (bp.isPrimary) {
                    this.setPrimaryMember(bp.getDistributedMember());
                } else {
                    this.notPrimary(bp.getDistributedMember());
                }
            }
        }
        return applied;
    }

    private static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        if (map.isEmpty()) {
            return new SetFromMap<E>(map);
        }
        throw new IllegalArgumentException();
    }

    private void updateServerBucketProfile() {
        int bucketId = this.getBucket().getId();
        Set<ServerBucketProfile> serverProfiles = BucketAdvisor.newSetFromMap(new HashMap());
        for (DistributionAdvisor.Profile p : this.profiles) {
            if (!(p instanceof ServerBucketProfile)) continue;
            serverProfiles.add((ServerBucketProfile)p);
        }
        this.regionAdvisor.setClientBucketProfiles(bucketId, serverProfiles);
    }

    public synchronized void updateServerBucketProfile(BucketProfile p) {
        this.localProfile = p;
    }

    public BucketProfile getLocalProfile() {
        return this.localProfile;
    }

    @Override
    public boolean removeId(DistributionAdvisor.ProfileId memberId, boolean crashed, boolean destroyed, boolean fromMembershipListener) {
        boolean hadBucketRegion = super.removeId(memberId, crashed, destroyed, fromMembershipListener);
        if (hadBucketRegion) {
            try {
                this.notPrimary((InternalDistributedMember)memberId);
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
        return hadBucketRegion;
    }

    @Override
    public boolean removeIdWithSerial(InternalDistributedMember memberId, int serialNum, boolean regionDestroyed) {
        boolean hadBucketRegion = super.removeIdWithSerial(memberId, serialNum, regionDestroyed);
        if (hadBucketRegion) {
            this.notPrimary(memberId);
        }
        this.forceNewMembershipVersion();
        return hadBucketRegion;
    }

    @Override
    public Set adviseProfileExchange() {
        Assert.assertTrue(this.regionAdvisor.isInitialized());
        return this.regionAdvisor.adviseBucketProfileExchange();
    }

    @Override
    public Set adviseProfileUpdate() {
        return this.regionAdvisor.adviseGeneric();
    }

    @Override
    public void close() {
        this.setHosting(false);
    }

    public InternalDistributedMember getPrimary() {
        InternalDistributedMember primary = this.getExistingPrimary();
        if (primary == null) {
            primary = this.waitForNewPrimary();
        }
        return primary;
    }

    private InternalDistributedMember getExistingPrimary() {
        return this.basicGetPrimaryMember();
    }

    public boolean isPrimaryWithWait() {
        if (this.isPrimary()) {
            return true;
        }
        InternalDistributedMember primary = this.waitForNewPrimary();
        return primary != null;
    }

    private InternalDistributedMember waitForNewPrimary() {
        DM dm = this.regionAdvisor.getDistributionManager();
        DistributionConfig config = dm.getConfig();
        long timeout = config.getMemberTimeout() * 3;
        InternalDistributedMember newPrimary = this.waitForPrimaryMember(timeout += Long.getLong("gemfire.BucketAdvisor.getPrimaryTimeout", 15000L).longValue());
        return newPrimary;
    }

    public void notPrimary(InternalDistributedMember member) {
        if (!member.equals(this.getDistributionManager().getId())) {
            this.removePrimary(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removePrimary(InternalDistributedMember member) {
        boolean wasPrimary;
        boolean lostPrimary;
        boolean needToVolunteerForPrimary;
        block20: {
            needToVolunteerForPrimary = false;
            if (!this.isClosed()) {
                this.initializationGate();
            }
            lostPrimary = false;
            BucketAdvisor bucketAdvisor = this;
            // MONITORENTER : bucketAdvisor
            wasPrimary = this.isPrimary() && this.getDistributionManager().getId().equals(member);
            InternalDistributedMember currentPrimary = (InternalDistributedMember)this.primaryMember.get();
            if (currentPrimary != null && currentPrimary.equals(member)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("[BucketAdvisor.notPrimary] {} for {}", (Object)member, (Object)this);
                }
                this.primaryMember.set(null);
                break block20;
            }
            // MONITOREXIT : bucketAdvisor
            if (!lostPrimary) return;
            this.invokeAfterSecondaryInPartitionListeners();
            Bucket br = this.regionAdvisor.getBucket(this.getBucket().getId());
            if (br != null && br instanceof BucketRegion) {
                ((BucketRegion)br).beforeReleasingPrimaryLockDuringDemotion();
            }
            this.releasePrimaryLock();
            this.deposePrimaryForColocatedChildren();
            if (!this.pRegion.isFixedPartitionedRegion()) return;
            this.deposeOtherPrimaryBucketForFixedPartition();
            return;
        }
        if (this.isClosed()) {
            // MONITOREXIT : bucketAdvisor
            if (!lostPrimary) return;
            this.invokeAfterSecondaryInPartitionListeners();
            Bucket br = this.regionAdvisor.getBucket(this.getBucket().getId());
            if (br != null && br instanceof BucketRegion) {
                ((BucketRegion)br).beforeReleasingPrimaryLockDuringDemotion();
            }
            this.releasePrimaryLock();
            this.deposePrimaryForColocatedChildren();
            if (!this.pRegion.isFixedPartitionedRegion()) return;
            this.deposeOtherPrimaryBucketForFixedPartition();
            return;
        }
        try {
            if (this.isHosting()) {
                InternalDistributedMember primaryMember;
                this.requestPrimaryState((byte)1);
                needToVolunteerForPrimary = this.pRegion.isFixedPartitionedRegion() ? (primaryMember = this.regionAdvisor.adviseFixedPrimaryPartitionDataStore(this.getBucket().getId())) == null || primaryMember.equals(member) : true;
            } else {
                this.requestPrimaryState((byte)0);
            }
            if (wasPrimary) {
                lostPrimary = true;
            }
            this.findAndSetPrimaryMember();
            // MONITOREXIT : bucketAdvisor
        }
        finally {
            if (lostPrimary) {
                this.invokeAfterSecondaryInPartitionListeners();
                Bucket br = this.regionAdvisor.getBucket(this.getBucket().getId());
                if (br != null && br instanceof BucketRegion) {
                    ((BucketRegion)br).beforeReleasingPrimaryLockDuringDemotion();
                }
                this.releasePrimaryLock();
                this.deposePrimaryForColocatedChildren();
                if (this.pRegion.isFixedPartitionedRegion()) {
                    this.deposeOtherPrimaryBucketForFixedPartition();
                }
            }
        }
        if (!needToVolunteerForPrimary) return;
        this.volunteerForPrimary();
    }

    public ProxyBucketRegion getProxyBucketRegion() {
        return (ProxyBucketRegion)this.getAdvisee();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAdvisor() {
        boolean wasPrimary;
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            if (this.isClosed()) {
                return;
            }
            wasPrimary = this.isPrimary();
            super.close();
            this.requestPrimaryState((byte)16);
            if (!this.redundancySatisfied) {
                this.incLowRedundancyBucketCount(-1);
                this.redundancySatisfied = true;
            }
            this.localProfile = null;
        }
        if (wasPrimary) {
            this.releasePrimaryLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isClosed() {
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            return this.primaryState == 16;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrimary() {
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            return this.primaryState == 9;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isVolunteering() {
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            return this.primaryState == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBecomingPrimary() {
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            return this.primaryState == 15 && this.volunteeringDelegate != null && this.volunteeringDelegate.isAggressive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHosting() {
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            return this.primaryState == 1 || this.primaryState == 5 || this.primaryState == 3 || this.primaryState == 15 || this.primaryState == 9;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void volunteerForPrimary() {
        if (this.primaryElector != null) {
            return;
        }
        this.initializationGate();
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            if (this.isVolunteering() || this.isClosed() || !this.isHosting()) {
                return;
            }
            if (this.volunteeringDelegate == null) {
                this.volunteeringDelegate = new VolunteeringDelegate();
            }
            this.volunteeringDelegate.volunteerForPrimary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean becomePrimary(boolean isRebalance) {
        this.initializationGate();
        long startTime = this.getPartitionedRegionStats().startPrimaryTransfer(isRebalance);
        try {
            long waitTime = 2000L;
            while (!this.isPrimary()) {
                this.getAdvisee().getCancelCriterion().checkCancelInProgress(null);
                boolean attemptToBecomePrimary = false;
                boolean attemptToDeposePrimary = false;
                if (Thread.currentThread().isInterrupted()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Breaking from becomePrimary loop due to thread interrupt flag being set");
                    }
                    break;
                }
                if (this.isClosed() || !this.isHosting()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Breaking from becomePrimary loop because {} is closed or not hosting", (Object)this);
                    }
                    break;
                }
                VolunteeringDelegate vDelegate = null;
                BucketAdvisor bucketAdvisor = this;
                synchronized (bucketAdvisor) {
                    if (this.isVolunteering()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Waiting for volunteering thread {}. Time left: {} ms", (Object)this, (Object)waitTime);
                        }
                        this.wait(waitTime);
                        continue;
                    }
                    if (this.isBecomingPrimary()) {
                        attemptToDeposePrimary = true;
                    } else {
                        vDelegate = this.volunteeringDelegate;
                        if (vDelegate == null) {
                            this.volunteeringDelegate = vDelegate = new VolunteeringDelegate();
                        }
                    }
                }
                if (vDelegate != null) {
                    attemptToBecomePrimary = vDelegate.reserveForBecomePrimary();
                }
                if (attemptToBecomePrimary) {
                    bucketAdvisor = this;
                    synchronized (bucketAdvisor) {
                        if (this.volunteeringDelegate == null) {
                            this.volunteeringDelegate = new VolunteeringDelegate();
                        }
                        this.volunteeringDelegate.volunteerForPrimary();
                        attemptToDeposePrimary = true;
                    }
                    Thread.sleep(10L);
                }
                if (!attemptToDeposePrimary) continue;
                InternalDistributedMember otherPrimary = this.getPrimary();
                if (otherPrimary != null && !this.getDistributionManager().getId().equals(otherPrimary)) {
                    DeposePrimaryBucketMessage.DeposePrimaryBucketResponse response;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Attempting to depose primary on {} for {}", (Object)otherPrimary, (Object)this);
                    }
                    if ((response = DeposePrimaryBucketMessage.send(otherPrimary, this.pRegion, this.getBucket().getId())) != null) {
                        response.waitForRepliesUninterruptibly();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Deposed primary on {}", (Object)otherPrimary);
                        }
                    }
                }
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.getPartitionedRegionStats().endPrimaryTransfer(startTime, this.isPrimary(), isRebalance);
        }
        return this.isPrimary();
    }

    public InternalDistributedMember basicGetPrimaryMember() {
        return (InternalDistributedMember)this.primaryMember.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean acquiredPrimaryLock() {
        Bucket br;
        if (logger.isDebugEnabled()) {
            logger.debug("Acquired primary lock for BucketID {} PR : {}", (Object)this.getBucket().getId(), (Object)this.regionAdvisor.getPartitionedRegion().getFullPath());
        }
        boolean changedStateToIsPrimary = false;
        boolean shouldInvokeListeners = false;
        this.activePrimaryMoveLock.lock();
        try {
            BucketAdvisor bucketAdvisor = this;
            synchronized (bucketAdvisor) {
                if (this.isHosting() && (this.isVolunteering() || this.isBecomingPrimary())) {
                    br = this.regionAdvisor.getBucket(this.getBucket().getId());
                    if (br != null && br instanceof BucketRegion) {
                        ((BucketRegion)br).beforeAcquiringPrimaryState();
                    }
                    if (this.requestPrimaryState((byte)9)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Acquired primary lock for setting primary now BucketID {} PR : {}", (Object)this.getBucket().getId(), (Object)this.regionAdvisor.getPartitionedRegion().getFullPath());
                        }
                        this.setPrimaryMember(this.getDistributionManager().getId());
                        changedStateToIsPrimary = true;
                        if (this.hasPrimary() && this.isPrimary()) {
                            shouldInvokeListeners = true;
                        }
                    }
                }
            }
            if (shouldInvokeListeners) {
                this.invokePartitionListeners();
            }
            boolean bl = changedStateToIsPrimary;
            return bl;
        }
        finally {
            try {
                if (changedStateToIsPrimary) {
                    this.sendProfileUpdate();
                    br = this.regionAdvisor.getBucket(this.getBucket().getId());
                    if (br != null && br instanceof BucketRegion) {
                        ((BucketRegion)br).processPendingSecondaryExpires();
                    }
                    if (br instanceof BucketRegionQueue) {
                        BucketRegionQueue brq = (BucketRegionQueue)br;
                        brq.incQueueSize(brq.size());
                    }
                    if (br != null && br instanceof BucketRegion) {
                        ((BucketRegion)br).afterAcquiringPrimaryState();
                    }
                } else {
                    this.releasePrimaryLock();
                }
            }
            finally {
                this.activePrimaryMoveLock.unlock();
            }
        }
    }

    private void invokePartitionListeners() {
        PartitionListener[] listeners = this.pRegion.getPartitionListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            PartitionListener listener = listeners[i];
            if (listener == null) continue;
            listener.afterPrimary(this.getBucket().getId());
        }
    }

    private void invokeAfterSecondaryInPartitionListeners() {
        PartitionListener[] listeners = this.pRegion.getPartitionListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            PartitionListener listener = listeners[i];
            if (listener == null) continue;
            listener.afterSecondary(this.getBucket().getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DistributedMemberLock getPrimaryLock(boolean createDLS) {
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            if (this.primaryLock == null) {
                DistributedLockService dls = DistributedLockService.getServiceNamed("__PRLS");
                if (dls == null) {
                    if (!createDLS || this.getProxyBucketRegion().getCache().isClosed()) {
                        return null;
                    }
                    try {
                        dls = DLockService.create("__PRLS", this.getAdvisee().getSystem(), true, true, true);
                    }
                    catch (IllegalArgumentException e) {
                        dls = DistributedLockService.getServiceNamed("__PRLS");
                        if (dls == null) {
                            return null;
                        }
                    }
                    catch (IllegalStateException e) {
                        return null;
                    }
                    catch (DistributedSystemDisconnectedException e) {
                        return null;
                    }
                }
                this.primaryLock = new DistributedMemberLock(dls, (Serializable)((Object)this.getAdvisee().getName()), -1L, DistributedMemberLock.LockReentryPolicy.PREVENT_SILENTLY);
            }
            return this.primaryLock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquirePrimaryRecursivelyForColocated() {
        List<PartitionedRegion> colocatedWithList = ColocationHelper.getColocatedChildRegions(this.regionAdvisor.getPartitionedRegion());
        if (colocatedWithList != null) {
            for (PartitionedRegion childPR : colocatedWithList) {
                Bucket b = childPR.getRegionAdvisor().getBucket(this.getBucket().getId());
                BucketAdvisor childBA = b.getBucketAdvisor();
                Assert.assertHoldsLock(childBA, false);
                boolean acquireForChild = false;
                if (logger.isDebugEnabled()) {
                    logger.debug("BucketAdvisor.acquirePrimaryRecursivelyForColocated: about to take lock for bucket: {} of PR: {} with isHosting={}", (Object)this.getBucket().getId(), (Object)childPR.getFullPath(), (Object)childBA.isHosting());
                }
                childBA.activePrimaryMoveLock.lock();
                try {
                    if (childBA.isHosting() && this.isPrimary()) {
                        if (!childBA.isPrimary()) {
                            childBA.setVolunteering();
                            boolean acquired = childBA.acquiredPrimaryLock();
                            acquireForChild = true;
                            if (acquired && this.pRegion.isFixedPartitionedRegion()) {
                                childBA.acquirePrimaryForRestOfTheBucket();
                            }
                        } else {
                            acquireForChild = true;
                        }
                    }
                    if (!acquireForChild) continue;
                    childBA.acquirePrimaryRecursivelyForColocated();
                }
                finally {
                    childBA.activePrimaryMoveLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquirePrimaryForRestOfTheBucket() {
        List<FixedPartitionAttributesImpl> fpas = this.pRegion.getFixedPartitionAttributesImpl();
        if (fpas != null) {
            int bucketId = this.getBucket().getId();
            for (FixedPartitionAttributesImpl fpa : fpas) {
                if (fpa.getStartingBucketID() != bucketId) continue;
                int i = bucketId + 1;
                while (i <= fpa.getLastBucketID()) {
                    Bucket b;
                    if ((b = this.regionAdvisor.getBucket(i++)) == null) continue;
                    BucketAdvisor ba = b.getBucketAdvisor();
                    ba.activePrimaryMoveLock.lock();
                    try {
                        if (!ba.isHosting() || ba.isPrimary()) continue;
                        ba.setVolunteering();
                        ba.acquiredPrimaryLock();
                    }
                    finally {
                        ba.activePrimaryMoveLock.unlock();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setVolunteering() {
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            return this.requestPrimaryState((byte)3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setBecoming() {
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            return this.requestPrimaryState((byte)15);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InternalDistributedMember waitForPrimaryMember(long timeout) {
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            StopWatch timer = new StopWatch(true);
            long warnTime = (long)this.getDistributionManager().getConfig().getAckWaitThreshold() * 1000L;
            boolean loggedWarning = false;
            try {
                while (true) {
                    long elapsed;
                    long timeLeft;
                    this.getAdvisee().getCancelCriterion().checkCancelInProgress(null);
                    InternalCache cache = this.getBucket().getCache();
                    if (cache != null && cache.isCacheAtShutdownAll()) {
                        throw new CacheClosedException("Cache is shutting down");
                    }
                    if (this.getBucketRedundancy() == -1) {
                        InternalDistributedMember internalDistributedMember = null;
                        return internalDistributedMember;
                    }
                    this.getProxyBucketRegion().getPartitionedRegion().checkReadiness();
                    if (this.isClosed() || (timeLeft = timeout - (elapsed = timer.elapsedTimeMillis())) <= 0L || this.getBucketRedundancy() == -1 || this.isClosed()) return null;
                    InternalDistributedMember primary = this.basicGetPrimaryMember();
                    if (primary != null) {
                        InternalDistributedMember internalDistributedMember = primary;
                        return internalDistributedMember;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Waiting for bucket {}. Time left :{} ms", (Object)this, (Object)timeLeft);
                    }
                    if (!loggedWarning) {
                        long timeUntilWarning = warnTime - elapsed;
                        if (timeUntilWarning <= 0L) {
                            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.BucketAdvisor_WAITING_FOR_PRIMARY, new Object[]{warnTime / 1000L, this, this.adviseInitialized()}));
                            loggedWarning = true;
                        } else {
                            timeLeft = timeLeft > timeUntilWarning ? timeUntilWarning : timeLeft;
                        }
                    }
                    this.wait(timeLeft);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (loggedWarning) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.BucketAdvisor_WAITING_FOR_PRIMARY_DONE));
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForRedundancy(int minRedundancy) {
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            StopWatch timer = new StopWatch(true);
            try {
                while (true) {
                    if (this.getBucketRedundancy() >= minRedundancy) {
                        return true;
                    }
                    this.getProxyBucketRegion().getPartitionedRegion().checkReadiness();
                    if (this.isClosed()) {
                        return false;
                    }
                    long timeLeft = 15000L - timer.elapsedTimeMillis();
                    if (timeLeft <= 0L) {
                        return false;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Waiting for bucket {}", (Object)this);
                    }
                    this.wait(timeLeft);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForStorage() {
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            StopWatch timer = new StopWatch(true);
            try {
                while (true) {
                    if (this.regionAdvisor.isBucketLocal(this.getBucket().getId())) {
                        return true;
                    }
                    this.getProxyBucketRegion().getPartitionedRegion().checkReadiness();
                    if (this.isClosed()) {
                        return false;
                    }
                    long timeLeft = BUCKET_STORAGE_WAIT - timer.elapsedTimeMillis();
                    if (timeLeft <= 0L) {
                        return false;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Waiting for bucket storage" + this);
                    }
                    this.wait(timeLeft);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPrimaryElector() {
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            this.primaryElector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrimaryElector(InternalDistributedMember newPrimaryElector) {
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            if (this.primaryElector != null) {
                this.primaryElector = newPrimaryElector;
            }
        }
    }

    public synchronized void initializePrimaryElector(InternalDistributedMember primaryElector) {
        if (this.parentAdvisor == null) {
            this.primaryElector = primaryElector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setHosting(boolean value) {
        boolean needToVolunteerForPrimary = false;
        boolean wasPrimary = false;
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            wasPrimary = this.isPrimary();
            if (this.isClosed()) {
                return;
            }
            if (value) {
                if (this.hasPrimary()) {
                    this.requestPrimaryState((byte)5);
                } else {
                    this.requestPrimaryState((byte)1);
                    needToVolunteerForPrimary = true;
                }
            } else if (this.hasPrimary()) {
                if (this.isPrimary()) {
                    this.requestPrimaryState((byte)0);
                    this.primaryMember.set(null);
                    this.findAndSetPrimaryMember();
                } else {
                    this.requestPrimaryState((byte)4);
                }
            } else {
                this.requestPrimaryState((byte)0);
            }
            this.volunteeringDelegate = null;
            if (this.updateRedundancy() > 0 && this.isHosting()) {
                this.notifyAll();
            }
        }
        if (wasPrimary) {
            this.releasePrimaryLock();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("setHosting: {} needToVolunteerForPrimary={} primaryElector: {}", (Object)this, (Object)needToVolunteerForPrimary, (Object)this.primaryElector);
        }
        if (needToVolunteerForPrimary && this.primaryElector == null) {
            this.volunteerForPrimary();
        }
        this.sendProfileUpdate();
    }

    private void sendProfileUpdate() {
        if (this.getDistributionManager().getSystem().isLoner()) {
            return;
        }
        Assert.assertTrue(!Thread.holdsLock(this), "Attempting to sendProfileUpdate while synchronized may result in deadlock");
        int partitionedRegionId = this.pRegion.getPRId();
        int bucketId = ((ProxyBucketRegion)this.getAdvisee()).getBucketId();
        BucketProfile bp = (BucketProfile)this.createProfile();
        this.updateServerBucketProfile(bp);
        InternalDistributedMember primary = this.basicGetPrimaryMember();
        HashSet<InternalDistributedMember> hostsAndProxyMembers = new HashSet<InternalDistributedMember>();
        if (primary != null && !primary.equals(this.getDistributionManager().getId())) {
            hostsAndProxyMembers.add(primary);
        }
        hostsAndProxyMembers.addAll(this.adviseGeneric());
        hostsAndProxyMembers.addAll(this.adviseProfileUpdate());
        ReplyProcessor21 reply = BucketProfileUpdateMessage.send(hostsAndProxyMembers, this.getDistributionManager(), partitionedRegionId, bucketId, bp, true);
        if (reply != null) {
            reply.waitForRepliesUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPrimary() {
        BucketAdvisor bucketAdvisor = this;
        synchronized (bucketAdvisor) {
            return this.primaryState == 4 || this.primaryState == 5 || this.primaryState == 9;
        }
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        if (!this.pRegion.isShadowPR()) {
            InternalCache cache = this.getProxyBucketRegion().getCache();
            List<CacheServer> servers = null;
            servers = cache.getCacheServers();
            HashSet<BucketServerLocation66> serverLocations = new HashSet<BucketServerLocation66>();
            for (CacheServer object : servers) {
                CacheServerImpl server = (CacheServerImpl)object;
                if (!server.isRunning() || server.getExternalAddress() == null) continue;
                BucketServerLocation66 location = new BucketServerLocation66(this.getBucket().getId(), server.getPort(), server.getExternalAddress(), this.getBucket().isPrimary(), Integer.valueOf(version).byteValue(), server.getCombinedGroups());
                serverLocations.add(location);
            }
            if (serverLocations.size() > 0) {
                return new ServerBucketProfile(memberId, version, this.getBucket(), serverLocations);
            }
        }
        return new BucketProfile(memberId, version, this.getBucket());
    }

    void setPrimaryMember(InternalDistributedMember id) {
        if (!this.getDistributionManager().getId().equals(id)) {
            if (this.isHosting()) {
                this.requestPrimaryState((byte)5);
            } else {
                this.requestPrimaryState((byte)4);
            }
        }
        this.primaryMember.set(id);
        this.everHadPrimary = true;
        if (id != null && id.equals(this.primaryElector)) {
            this.primaryElector = null;
        }
        this.notifyAll();
    }

    public void setHadPrimary() {
        this.everHadPrimary = true;
    }

    public boolean getHadPrimary() {
        return this.everHadPrimary;
    }

    public InternalDistributedMember getPrimaryElector() {
        return this.primaryElector;
    }

    private int updateRedundancy() {
        int actualRedundancy;
        int desiredRedundancy = this.pRegion.getRedundantCopies();
        int numBucketHosts = this.getNumInitializedBuckets();
        if (this.isClosed()) {
            return numBucketHosts;
        }
        this.redundancy = actualRedundancy = numBucketHosts - 1;
        if (this.redundancySatisfied && numBucketHosts > 0 && actualRedundancy < desiredRedundancy) {
            this.incLowRedundancyBucketCount(1);
            this.redundancySatisfied = false;
        } else if (!this.redundancySatisfied && numBucketHosts > 0 && actualRedundancy >= desiredRedundancy) {
            this.incLowRedundancyBucketCount(-1);
            this.redundancySatisfied = true;
            this.redundancyEverSatisfied = true;
        }
        return numBucketHosts;
    }

    private InternalDistributedMember[] findPrimaryMembers() {
        Set<InternalDistributedMember> primaryMembers = this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof BucketProfile);
                BucketProfile srp = (BucketProfile)profile;
                return srp.isPrimary;
            }
        });
        if (primaryMembers.size() > 1 && logger.isDebugEnabled()) {
            logger.debug("[findPrimaryProfiles] found the following primary members for {}: {}", (Object)this.getAdvisee().getName(), primaryMembers);
        }
        return primaryMembers.toArray(new InternalDistributedMember[primaryMembers.size()]);
    }

    boolean findAndSetPrimaryMember() {
        if (this.isPrimary()) {
            this.setPrimaryMember(this.getDistributionManager().getDistributionManagerId());
            return true;
        }
        InternalDistributedMember[] primaryMembers = this.findPrimaryMembers();
        if (primaryMembers.length > 0) {
            this.setPrimaryMember(primaryMembers[0]);
            return true;
        }
        return false;
    }

    public int getBucketRedundancy() {
        return this.redundancy;
    }

    public Set<InternalDistributedMember> adviseInitialized() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof BucketProfile);
                BucketProfile bucketProfile = (BucketProfile)profile;
                return bucketProfile.isHosting;
            }
        });
    }

    public Set<InternalDistributedMember> adviseRecoveredFromDisk() {
        return this.regionAdvisor.adviseInitializedDataStore();
    }

    private int getNumInitializedBuckets() {
        DistributionAdvisor.Profile[] locProfiles = this.profiles;
        int count = 0;
        for (DistributionAdvisor.Profile profile : locProfiles) {
            BucketProfile bucketProfile = (BucketProfile)profile;
            if (!bucketProfile.isHosting) continue;
            ++count;
        }
        if (this.isHosting()) {
            ++count;
        }
        return count;
    }

    private Bucket getBucket() {
        return (Bucket)this.getAdvisee();
    }

    protected void releasePrimaryLock() {
        if (this.parentAdvisor != null) {
            return;
        }
        if (this.startingBucketAdvisor == null) {
            this.assignStartingBucketAdvisor();
            if (this.startingBucketAdvisor != null) {
                return;
            }
        } else {
            return;
        }
        try {
            DistributedMemberLock thePrimaryLock = this.getPrimaryLock(false);
            if (thePrimaryLock != null) {
                thePrimaryLock.unlock();
            }
        }
        catch (LockNotHeldException e) {
            Assert.assertTrue(!this.isHosting(), "Got LockNotHeldException for Bucket = " + this);
        }
        catch (LockServiceDestroyedException e) {
            Assert.assertTrue(this.isClosed(), "BucketAdvisor was not closed before destroying PR lock service");
        }
    }

    private String primaryStateToString() {
        return this.primaryStateToString(this.primaryState);
    }

    private String primaryStateToString(byte value) {
        switch (value) {
            case 0: {
                return "NO_PRIMARY_NOT_HOSTING";
            }
            case 1: {
                return "NO_PRIMARY_HOSTING";
            }
            case 4: {
                return "OTHER_PRIMARY_NOT_HOSTING";
            }
            case 5: {
                return "OTHER_PRIMARY_HOSTING";
            }
            case 3: {
                return "VOLUNTEERING_HOSTING";
            }
            case 15: {
                return "BECOMING_HOSTING";
            }
            case 9: {
                return "IS_PRIMARY_HOSTING";
            }
            case 16: {
                return "CLOSED";
            }
        }
        return "<unhandled primaryState " + value + " >";
    }

    private boolean requestPrimaryState(byte requestedState) {
        byte fromState = this.primaryState;
        block0 : switch (fromState) {
            case 0: {
                switch (requestedState) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        this.primaryState = requestedState;
                        break block0;
                    }
                    case 4: {
                        this.primaryState = requestedState;
                        break block0;
                    }
                    case 5: {
                        this.primaryState = requestedState;
                        break block0;
                    }
                    case 15: {
                        return false;
                    }
                    case 3: {
                        return false;
                    }
                    case 16: {
                        this.primaryState = requestedState;
                        break block0;
                    }
                }
                throw new IllegalStateException(LocalizedStrings.BucketAdvisor_CANNOT_CHANGE_FROM_0_TO_1.toLocalizedString(this.primaryStateToString(), this.primaryStateToString(requestedState)));
            }
            case 1: {
                switch (requestedState) {
                    case 0: {
                        this.primaryState = requestedState;
                        break block0;
                    }
                    case 1: {
                        return false;
                    }
                    case 3: {
                        this.primaryState = requestedState;
                        PartitionedRegionStats stats = this.getPartitionedRegionStats();
                        stats.putStartTime(this, stats.startVolunteering());
                        break block0;
                    }
                    case 15: {
                        this.primaryState = requestedState;
                        PartitionedRegionStats stats = this.getPartitionedRegionStats();
                        stats.putStartTime(this, stats.startVolunteering());
                        break block0;
                    }
                    case 5: {
                        this.primaryState = requestedState;
                        break block0;
                    }
                    case 16: {
                        this.primaryState = requestedState;
                        break block0;
                    }
                }
                throw new IllegalStateException(LocalizedStrings.BucketAdvisor_CANNOT_CHANGE_FROM_0_TO_1.toLocalizedString(this.primaryStateToString(), this.primaryStateToString(requestedState)));
            }
            case 4: {
                switch (requestedState) {
                    case 0: {
                        this.primaryState = requestedState;
                        break block0;
                    }
                    case 4: {
                        return false;
                    }
                    case 5: {
                        this.primaryState = requestedState;
                        break block0;
                    }
                    case 15: {
                        return false;
                    }
                    case 3: {
                        return false;
                    }
                    case 16: {
                        this.primaryState = requestedState;
                        break block0;
                    }
                }
                throw new IllegalStateException(LocalizedStrings.BucketAdvisor_CANNOT_CHANGE_FROM_0_TO_1.toLocalizedString(this.primaryStateToString(), this.primaryStateToString(requestedState)));
            }
            case 5: {
                switch (requestedState) {
                    case 4: {
                        this.primaryState = requestedState;
                        break block0;
                    }
                    case 5: {
                        return false;
                    }
                    case 1: {
                        this.primaryState = requestedState;
                        break block0;
                    }
                    case 16: {
                        this.primaryState = requestedState;
                        break block0;
                    }
                    case 3: {
                        return false;
                    }
                    case 15: {
                        this.primaryState = requestedState;
                        PartitionedRegionStats stats = this.getPartitionedRegionStats();
                        stats.putStartTime(this, stats.startVolunteering());
                        break block0;
                    }
                    case 9: {
                        this.primaryState = requestedState;
                        break block0;
                    }
                }
                throw new IllegalStateException(LocalizedStrings.BucketAdvisor_CANNOT_CHANGE_FROM_0_TO_1.toLocalizedString(this.primaryStateToString(), this.primaryStateToString(requestedState)));
            }
            case 3: {
                switch (requestedState) {
                    case 0: {
                        this.primaryState = requestedState;
                        PartitionedRegionStats stats = this.getPartitionedRegionStats();
                        stats.endVolunteeringClosed(stats.removeStartTime(this));
                        break block0;
                    }
                    case 4: {
                        this.primaryState = requestedState;
                        PartitionedRegionStats stats = this.getPartitionedRegionStats();
                        stats.endVolunteeringClosed(stats.removeStartTime(this));
                        break block0;
                    }
                    case 1: {
                        return false;
                    }
                    case 9: {
                        this.primaryState = requestedState;
                        PartitionedRegionStats stats = this.getPartitionedRegionStats();
                        stats.incPrimaryBucketCount(1);
                        stats.endVolunteeringBecamePrimary(stats.removeStartTime(this));
                        break block0;
                    }
                    case 5: {
                        this.primaryState = requestedState;
                        PartitionedRegionStats stats = this.getPartitionedRegionStats();
                        stats.endVolunteeringOtherPrimary(stats.removeStartTime(this));
                        break block0;
                    }
                    case 3: {
                        return false;
                    }
                    case 15: {
                        return false;
                    }
                    case 16: {
                        this.primaryState = requestedState;
                        PartitionedRegionStats stats = this.getPartitionedRegionStats();
                        stats.endVolunteeringClosed(stats.removeStartTime(this));
                        break block0;
                    }
                }
                throw new IllegalStateException(LocalizedStrings.BucketAdvisor_CANNOT_CHANGE_FROM_0_TO_1.toLocalizedString(this.primaryStateToString(), this.primaryStateToString(requestedState)));
            }
            case 15: {
                switch (requestedState) {
                    case 0: {
                        this.primaryState = requestedState;
                        PartitionedRegionStats stats = this.getPartitionedRegionStats();
                        stats.endVolunteeringClosed(stats.removeStartTime(this));
                        break block0;
                    }
                    case 4: {
                        this.primaryState = requestedState;
                        PartitionedRegionStats stats = this.getPartitionedRegionStats();
                        stats.endVolunteeringClosed(stats.removeStartTime(this));
                        break block0;
                    }
                    case 1: {
                        return false;
                    }
                    case 9: {
                        this.primaryState = requestedState;
                        PartitionedRegionStats stats = this.getPartitionedRegionStats();
                        stats.incPrimaryBucketCount(1);
                        stats.endVolunteeringBecamePrimary(stats.removeStartTime(this));
                        break block0;
                    }
                    case 5: {
                        return false;
                    }
                    case 3: {
                        return false;
                    }
                    case 15: {
                        return false;
                    }
                    case 16: {
                        this.primaryState = requestedState;
                        PartitionedRegionStats stats = this.getPartitionedRegionStats();
                        stats.endVolunteeringClosed(stats.removeStartTime(this));
                        break block0;
                    }
                }
                throw new IllegalStateException(LocalizedStrings.BucketAdvisor_CANNOT_CHANGE_FROM_0_TO_1.toLocalizedString(this.primaryStateToString(), this.primaryStateToString(requestedState)));
            }
            case 9: {
                switch (requestedState) {
                    case 1: {
                        this.changeFromPrimaryTo(requestedState);
                        break block0;
                    }
                    case 4: {
                        this.changeFromPrimaryTo(requestedState);
                        break block0;
                    }
                    case 0: {
                        this.changeFromPrimaryTo(requestedState);
                        break block0;
                    }
                    case 3: {
                        return false;
                    }
                    case 15: {
                        return false;
                    }
                    case 16: {
                        this.changeFromPrimaryTo(requestedState);
                        break block0;
                    }
                }
                throw new IllegalStateException("Cannot change from " + this.primaryStateToString() + " to " + this.primaryStateToString(requestedState));
            }
            case 16: {
                switch (requestedState) {
                    case 16: {
                        Exception e = new Exception(LocalizedStrings.BucketAdvisor_ATTEMPTED_TO_CLOSE_BUCKETADVISOR_THAT_IS_ALREADY_CLOSED.toLocalizedString());
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.BucketAdvisor_ATTEMPTED_TO_CLOSE_BUCKETADVISOR_THAT_IS_ALREADY_CLOSED), (Throwable)e);
                        break block0;
                    }
                    case 3: {
                        return false;
                    }
                    case 15: {
                        return false;
                    }
                    case 9: {
                        return false;
                    }
                    case 4: {
                        return false;
                    }
                }
                throw new IllegalStateException(LocalizedStrings.BucketAdvisor_CANNOT_CHANGE_FROM_0_TO_1_FOR_BUCKET_2.toLocalizedString(this.primaryStateToString(), this.primaryStateToString(requestedState), this.getAdvisee().getName()));
            }
        }
        return this.primaryState == requestedState;
    }

    private void changeFromPrimaryTo(byte requestedState) {
        try {
            this.primaryState = requestedState;
        }
        finally {
            this.getPartitionedRegionStats().incPrimaryBucketCount(-1);
        }
    }

    @Override
    public Set adviseDestroyRegion() {
        return this.regionAdvisor.adviseAllPRNodes();
    }

    public Set adviseRequiresTwoMessages() {
        return this.adviseNotInitialized();
    }

    public Set adviseNotInitialized() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheDistributionAdvisor.CacheProfile);
                CacheDistributionAdvisor.CacheProfile cp = (CacheDistributionAdvisor.CacheProfile)profile;
                return !cp.regionInitialized;
            }
        });
    }

    @Override
    public Set adviseNetWrite() {
        return this.regionAdvisor.adviseNetWrite();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[BucketAdvisor ").append(this.getAdvisee().getFullPath()).append(':').append(this.getAdvisee().getSerialNumber()).append(": ");
        sb.append("state=").append(this.primaryStateToString());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void addMembershipAndProxyListener(MembershipListener listener) {
        super.addMembershipAndProxyListener(listener);
        this.regionAdvisor.addMembershipListener(listener);
    }

    @Override
    public void removeMembershipAndProxyListener(MembershipListener listener) {
        this.regionAdvisor.removeMembershipListener(listener);
        super.removeMembershipAndProxyListener(listener);
    }

    public void endBucketCreation() {
        this.sendProfileUpdate();
    }

    public boolean setShadowBucketDestroyed(boolean destroyed) {
        this.shadowBucketDestroyed = destroyed;
        return this.shadowBucketDestroyed;
    }

    public boolean getShadowBucketDestroyed() {
        return this.shadowBucketDestroyed;
    }

    class VolunteeringDelegate {
        private Thread volunteeringThread;
        private boolean aggressive = false;

        VolunteeringDelegate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isAggressive() {
            BucketAdvisor bucketAdvisor = BucketAdvisor.this;
            synchronized (bucketAdvisor) {
                return this.aggressive;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void volunteerForPrimary() {
            boolean handedOff = false;
            while (!handedOff) {
                BucketAdvisor.this.getAdvisee().getCancelCriterion().checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.execute(new Runnable(){

                        @Override
                        public void run() {
                            VolunteeringDelegate.this.doVolunteerForPrimary();
                        }
                    });
                    handedOff = true;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    BucketAdvisor.this.getAdvisee().getCancelCriterion().checkCancelInProgress(e);
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean reserveForBecomePrimary() {
            BucketAdvisor bucketAdvisor = BucketAdvisor.this;
            synchronized (bucketAdvisor) {
                if (this.volunteeringThread != null) {
                    return false;
                }
                this.aggressive = true;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doVolunteerForPrimary() {
            if (!this.beginVolunteering()) {
                return;
            }
            boolean dlsDestroyed = false;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Begin volunteerForPrimary for {}", (Object)BucketAdvisor.this);
                }
                DistributedMemberLock thePrimaryLock = null;
                while (this.continueVolunteering()) {
                    BucketAdvisor parentBA = BucketAdvisor.this.parentAdvisor;
                    BucketAdvisor.this.activePrimaryMoveLock.lock();
                    try {
                        boolean acquiredLock = false;
                        BucketAdvisor.this.getAdvisee().getCancelCriterion().checkCancelInProgress(null);
                        if (parentBA != null) {
                            if (!parentBA.isPrimary()) return;
                            if (BucketAdvisor.this.isPrimary()) return;
                            acquiredLock = BucketAdvisor.this.acquiredPrimaryLock();
                        } else {
                            if (BucketAdvisor.this.startingBucketAdvisor == null) {
                                BucketAdvisor.this.assignStartingBucketAdvisor();
                            }
                            if (BucketAdvisor.this.startingBucketAdvisor != null) {
                                Assert.assertHoldsLock(this, false);
                                BucketAdvisor bucketAdvisor = BucketAdvisor.this.startingBucketAdvisor;
                                synchronized (bucketAdvisor) {
                                    if (!BucketAdvisor.this.startingBucketAdvisor.isPrimary()) return;
                                    if (BucketAdvisor.this.isPrimary()) return;
                                    acquiredLock = BucketAdvisor.this.acquiredPrimaryLock();
                                }
                            } else {
                                if (thePrimaryLock == null && (thePrimaryLock = BucketAdvisor.this.getPrimaryLock(true)) == null) {
                                    return;
                                }
                                Assert.assertTrue(!thePrimaryLock.holdsLock());
                                acquiredLock = this.isAggressive() ? thePrimaryLock.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS) : thePrimaryLock.tryLock();
                                if (acquiredLock) {
                                    acquiredLock = BucketAdvisor.this.acquiredPrimaryLock();
                                }
                            }
                        }
                        if (acquiredLock) {
                            BucketAdvisor.this.acquirePrimaryRecursivelyForColocated();
                            BucketAdvisor.this.acquirePrimaryForRestOfTheBucket();
                            return;
                        }
                    }
                    finally {
                        BucketAdvisor.this.activePrimaryMoveLock.unlock();
                    }
                    if (!this.continueVolunteering()) {
                        return;
                    }
                    this.waitIfNoPrimaryMemberFound();
                }
                return;
            }
            catch (LockServiceDestroyedException e) {
                dlsDestroyed = true;
                this.handleException(e, true);
                return;
            }
            catch (RegionDestroyedException e) {
                this.handleException(e, false);
                return;
            }
            catch (CancelException e) {
                this.handleException(e, false);
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.handleException(e, false);
                return;
            }
            finally {
                if (logger.isDebugEnabled()) {
                    logger.debug("Exit volunteerForPrimary for {}; dlsDestroyed={}", (Object)BucketAdvisor.this, (Object)dlsDestroyed);
                }
                this.endVolunteering();
            }
        }

        private void handleException(Exception e, boolean loggit) {
            boolean safe;
            boolean bl = safe = BucketAdvisor.this.isClosed() || BucketAdvisor.this.getAdvisee().getCancelCriterion().isCancelInProgress();
            if (!safe && loggit) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.BucketAdvisor_BUCKETADVISOR_WAS_NOT_CLOSED_PROPERLY), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean beginVolunteering() {
            BucketAdvisor bucketAdvisor = BucketAdvisor.this;
            synchronized (bucketAdvisor) {
                boolean bl;
                block9: {
                    if (Thread.currentThread().equals(this.volunteeringThread)) {
                        return true;
                    }
                    if (this.volunteeringThread != null) {
                        return false;
                    }
                    this.volunteeringThread = Thread.currentThread();
                    boolean changedState = false;
                    try {
                        changedState = this.isAggressive() ? BucketAdvisor.this.setBecoming() : BucketAdvisor.this.setVolunteering();
                        bl = changedState;
                        if (changedState) break block9;
                        this.aggressive = false;
                        this.volunteeringThread = null;
                    }
                    catch (Throwable throwable) {
                        if (!changedState) {
                            this.aggressive = false;
                            this.volunteeringThread = null;
                        }
                        throw throwable;
                    }
                }
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean continueVolunteering() {
            BucketAdvisor bucketAdvisor = BucketAdvisor.this;
            synchronized (bucketAdvisor) {
                if (!Thread.currentThread().equals(this.volunteeringThread)) {
                    return false;
                }
                if (!BucketAdvisor.this.isVolunteering() && !BucketAdvisor.this.isBecomingPrimary()) {
                    return false;
                }
                if (!this.isAggressive() && BucketAdvisor.this.basicGetPrimaryMember() != null) {
                    return false;
                }
                if (BucketAdvisor.this.isPrimary()) {
                    return false;
                }
                if (BucketAdvisor.this.isClosed()) {
                    return false;
                }
                return BucketAdvisor.this.isHosting();
                {
                }
            }
        }

        private void endVolunteering() {
            if (Thread.currentThread().equals(this.volunteeringThread)) {
                this.volunteeringThread = null;
                this.aggressive = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitIfNoPrimaryMemberFound() {
            BucketAdvisor bucketAdvisor = BucketAdvisor.this;
            synchronized (bucketAdvisor) {
                if (BucketAdvisor.this.basicGetPrimaryMember() == null) {
                    BucketAdvisor.this.waitForPrimaryMember(100L);
                    if (BucketAdvisor.this.basicGetPrimaryMember() == null) {
                        BucketAdvisor.this.findAndSetPrimaryMember();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(Runnable volunteeringTask) throws InterruptedException {
            Queue volunteeringQueue;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Queue queue = volunteeringQueue = BucketAdvisor.this.getVolunteeringQueue();
            synchronized (queue) {
                volunteeringQueue.add(volunteeringTask);
                if (BucketAdvisor.this.getVolunteeringSemaphore().tryAcquire()) {
                    boolean handedOff = false;
                    try {
                        BucketAdvisor.this.getDistributionManager().getWaitingThreadPool().execute(this.consumeQueue());
                        handedOff = true;
                    }
                    finally {
                        if (!handedOff) {
                            BucketAdvisor.this.getVolunteeringSemaphore().release();
                        }
                    }
                }
            }
        }

        private Runnable consumeQueue() {
            return new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    BucketAdvisor.this.getPartitionedRegionStats().incVolunteeringThreads(1);
                    releaseSemaphore = true;
                    volunteeringQueue = BucketAdvisor.this.getVolunteeringQueue();
                    queuedWork = null;
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        BucketAdvisor.this.getAdvisee().getCancelCriterion().checkCancelInProgress(null);
                        var4_4 = volunteeringQueue;
                        synchronized (var4_4) {
                            block15: {
                                queuedWork = (Runnable)volunteeringQueue.poll();
                                if (queuedWork != null) break block15;
                                BucketAdvisor.this.getVolunteeringSemaphore().release();
                                releaseSemaphore = false;
                                return;
                            }
                            ** try [egrp 3[TRYBLOCK] [1 : 119->125)] { 
                            {
                            }
                        }
lbl21:
                        // 1 sources

                        try {
                            queuedWork.run();
                        }
                        catch (CancelException e) {
                            BucketAdvisor.this.getPartitionedRegionStats().incVolunteeringThreads(-1);
                            if (releaseSemaphore) {
                                BucketAdvisor.this.getVolunteeringSemaphore().release();
                                releaseSemaphore = false;
                            }
                            return;
                        }
                        catch (RuntimeException e) {
                            BucketAdvisor.access$100().error(e.getMessage(), (Throwable)e);
                            continue;
                        }
                        break;
                    }
                    ** GOTO lbl-1000
                    finally {
                        BucketAdvisor.this.getPartitionedRegionStats().incVolunteeringThreads(-1);
                        if (releaseSemaphore) {
                            BucketAdvisor.this.getVolunteeringSemaphore().release();
                            releaseSemaphore = false;
                        }
                    }
                }
            };
        }
    }

    public static class ServerBucketProfile
    extends BucketProfile {
        public Set<BucketServerLocation66> bucketServerLocations;
        private int bucketId;

        public ServerBucketProfile() {
        }

        public ServerBucketProfile(InternalDistributedMember memberId, int version, Bucket bucket, HashSet<BucketServerLocation66> serverLocations) {
            super(memberId, version, bucket);
            this.bucketId = bucket.getId();
            this.bucketServerLocations = serverLocations;
        }

        @Override
        public StringBuilder getToStringHeader() {
            return new StringBuilder("BucketAdvisor.ServerBucketProfile");
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            for (BucketServerLocation66 location : this.bucketServerLocations) {
                sb.append("; hostName=" + location.getHostName());
                sb.append("; port=" + location.getPort());
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.bucketServerLocations = SerializationHelper.readBucketServerLocationSet(in);
            this.bucketId = DataSerializer.readPrimitiveInt(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            SerializationHelper.writeBucketServerLocationSet(this.bucketServerLocations, out);
            DataSerializer.writePrimitiveInt(this.bucketId, out);
        }

        public Set<BucketServerLocation66> getBucketServerLocations() {
            return this.bucketServerLocations;
        }

        @Override
        public int getDSFID() {
            return 40;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            BucketServerLocation66 sl = (BucketServerLocation66)this.bucketServerLocations.toArray()[0];
            result = 31 * this.bucketId + sl.getPort();
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ServerBucketProfile)) {
                return false;
            }
            ServerBucketProfile other = (ServerBucketProfile)obj;
            if (other.bucketId != this.bucketId) {
                return false;
            }
            if (other.bucketServerLocations.size() != this.bucketServerLocations.size()) {
                return false;
            }
            return other.bucketServerLocations.containsAll(this.bucketServerLocations);
        }
    }

    public static class BucketProfile
    extends CacheDistributionAdvisor.CacheProfile {
        public boolean isInitializing;
        public boolean isPrimary;
        public boolean isHosting;
        public boolean removed;

        public BucketProfile() {
        }

        public BucketProfile(InternalDistributedMember memberId, int version, Bucket bucket) {
            super(memberId, version);
            this.isPrimary = bucket.isPrimary();
            this.isHosting = bucket.isHosting();
        }

        @Override
        public StringBuilder getToStringHeader() {
            return new StringBuilder("BucketAdvisor.BucketProfile");
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            sb.append("; isPrimary=" + this.isPrimary);
            sb.append("; isHosting=" + this.isHosting);
            sb.append("; isInitializing=" + this.isInitializing);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.isPrimary = in.readBoolean();
            this.isHosting = in.readBoolean();
            this.isInitializing = in.readBoolean();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.isPrimary);
            out.writeBoolean(this.isHosting);
            out.writeBoolean(this.isInitializing);
        }

        @Override
        public int getDSFID() {
            return 17;
        }
    }

    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 2454657854757543876L;
        private Map<E, Boolean> m;
        private transient Set<E> backingSet;

        SetFromMap(Map<E, Boolean> map) {
            this.m = map;
            this.backingSet = map.keySet();
        }

        @Override
        public boolean equals(Object object) {
            return this.backingSet.equals(object);
        }

        @Override
        public int hashCode() {
            return this.backingSet.hashCode();
        }

        @Override
        public boolean add(E object) {
            return this.m.put(object, Boolean.TRUE) == null;
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public String toString() {
            return this.backingSet.toString();
        }

        @Override
        public boolean contains(Object object) {
            return this.backingSet.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.backingSet.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean remove(Object object) {
            return this.m.remove(object) != null;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.backingSet.retainAll(collection);
        }

        @Override
        public Object[] toArray() {
            return this.backingSet.toArray();
        }

        @Override
        public <T> T[] toArray(T[] contents) {
            return this.backingSet.toArray(contents);
        }

        @Override
        public Iterator<E> iterator() {
            return this.backingSet.iterator();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.backingSet = this.m.keySet();
        }
    }
}

