/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.internal.ConflationKey;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class DestroyOperation
extends DistributedCacheOperation {
    public DestroyOperation(EntryEventImpl event) {
        super(event);
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        if (this.event.hasClientOrigin()) {
            DestroyWithContextMessage msgwithContxt = new DestroyWithContextMessage(this.event);
            msgwithContxt.context = ((EntryEventImpl)this.event).getContext();
            return msgwithContxt;
        }
        return new DestroyMessage(this.event);
    }

    @Override
    protected void initMessage(DistributedCacheOperation.CacheOperationMessage msg, DirectReplyProcessor processor) {
        super.initMessage(msg, processor);
        DestroyMessage m = (DestroyMessage)msg;
        EntryEventImpl event = this.getEvent();
        m.key = event.getKey();
        m.eventId = event.getEventId();
    }

    public static class DestroyWithContextMessage
    extends DestroyMessage {
        transient ClientProxyMembershipID context;

        public DestroyWithContextMessage() {
        }

        public DestroyWithContextMessage(InternalCacheEvent event) {
            super(event);
        }

        @Override
        EntryEventImpl createEntryEvent(DistributedRegion rgn) {
            EntryEventImpl event = EntryEventImpl.create(rgn, this.getOperation(), this.key, null, this.callbackArg, true, this.getSender(), true);
            event.setContext(this.context);
            return event;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; membershipID=");
            buff.append(this.context == null ? "" : this.context.toString());
        }

        @Override
        public int getDSFID() {
            return 127;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.context = ClientProxyMembershipID.readCanonicalized(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.context, out);
        }
    }

    public static class DestroyMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected EventID eventId = null;
        protected Object key;
        protected EntryEventImpl event = null;
        private Long tailKey = 0L;

        public DestroyMessage() {
        }

        public DestroyMessage(InternalCacheEvent event) {
            this.event = (EntryEventImpl)event;
        }

        @Override
        protected boolean operateOnRegion(CacheEvent event, DistributionManager dm) throws EntryNotFoundException {
            EntryEventImpl ev = (EntryEventImpl)event;
            DistributedRegion rgn = (DistributedRegion)ev.region;
            try {
                if (!rgn.isCacheContentProxy()) {
                    rgn.basicDestroy(ev, false, null);
                }
                this.appliedOperation = true;
            }
            catch (ConcurrentCacheModificationException e) {
                this.dispatchElidedEvent(rgn, ev);
                return true;
            }
            catch (EntryNotFoundException e) {
                this.dispatchElidedEvent(rgn, ev);
                if (!ev.isConcurrencyConflict()) {
                    rgn.notifyGatewaySender(EnumListenerEvent.AFTER_DESTROY, ev);
                }
                throw e;
            }
            catch (CacheWriterException e) {
                throw new Error(LocalizedStrings.DestroyOperation_CACHEWRITER_SHOULD_NOT_BE_CALLED.toLocalizedString(), e);
            }
            catch (TimeoutException e) {
                throw new Error(LocalizedStrings.DestroyOperation_DISTRIBUTEDLOCK_SHOULD_NOT_BE_ACQUIRED.toLocalizedString(), e);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            EntryEventImpl ev = this.createEntryEvent(rgn);
            boolean evReturned = false;
            try {
                ev.setEventId(this.eventId);
                ev.setOldValueFromRegion();
                ev.setVersionTag(this.versionTag);
                if (this.filterRouting != null) {
                    ev.setLocalFilterInfo(this.filterRouting.getFilterInfo(rgn.getMyId()));
                }
                ev.setTailKey(this.tailKey);
                ev.setInhibitAllNotifications(this.inhibitAllNotifications);
                evReturned = true;
                EntryEventImpl entryEventImpl = ev;
                return entryEventImpl;
            }
            finally {
                if (!evReturned) {
                    ev.release();
                }
            }
        }

        EntryEventImpl createEntryEvent(DistributedRegion rgn) {
            EntryEventImpl event = EntryEventImpl.create((LocalRegion)rgn, this.getOperation(), this.key, null, this.callbackArg, true, this.getSender());
            this.setOldValueInEvent(event);
            event.setTailKey(this.tailKey);
            return event;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append(" key=").append(this.key).append(" id=").append(this.eventId);
        }

        @Override
        public int getDSFID() {
            return 102;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.eventId = (EventID)DataSerializer.readObject(in);
            this.key = DataSerializer.readObject(in);
            Boolean hasTailKey = DataSerializer.readBoolean(in);
            if (hasTailKey.booleanValue()) {
                this.tailKey = DataSerializer.readLong(in);
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.eventId, out);
            DataSerializer.writeObject(this.key, out);
            DistributedRegion region = (DistributedRegion)this.event.getRegion();
            if (region instanceof BucketRegion) {
                PartitionedRegion pr = region.getPartitionedRegion();
                if (pr.isParallelWanEnabled()) {
                    DataSerializer.writeBoolean(Boolean.TRUE, out);
                    DataSerializer.writeLong(this.event.getTailKey(), out);
                } else {
                    DataSerializer.writeBoolean(Boolean.FALSE, out);
                }
            } else if (region.isUsedForSerialGatewaySenderQueue()) {
                DataSerializer.writeBoolean(Boolean.TRUE, out);
                DataSerializer.writeLong(this.event.getTailKey(), out);
            } else {
                DataSerializer.writeBoolean(Boolean.FALSE, out);
            }
        }

        @Override
        public EventID getEventID() {
            return this.eventId;
        }

        @Override
        public ConflationKey getConflationKey() {
            if (!this.regionAllowsConflation || this.getProcessorId() != 0) {
                return null;
            }
            return new ConflationKey(this.key, this.regionPath, false);
        }

        @Override
        protected boolean mayAddToMultipleSerialGateways(DistributionManager dm) {
            return this._mayAddToMultipleSerialGateways(dm);
        }
    }
}

