/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import joptsimple.internal.Strings;
import org.apache.geode.CancelCriterion;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.compression.Compressor;
import org.apache.geode.internal.cache.AbstractDiskRegion;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CacheObserverHolder;
import org.apache.geode.internal.cache.CompactableOplog;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.cache.DiskEntry;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskInitFile;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.EntryBits;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.Oplog;
import org.apache.geode.internal.cache.OverflowOplog;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.persistence.BytesAndBits;
import org.apache.geode.internal.cache.persistence.DiskExceptionHandler;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.util.concurrent.StoppableReentrantReadWriteLock;

public class DiskRegion
extends AbstractDiskRegion {
    public static final long INVALID_ID = 0L;
    private final DiskRegionStats stats;
    final boolean overflowEnabled;
    private volatile boolean isRegionClosed = false;
    private final boolean isSync;
    private final String name;
    private final CancelCriterion cancel;
    private final DiskExceptionHandler exceptionHandler;
    private final StoppableReentrantReadWriteLock rwLock;
    private final AtomicInteger clearCount = new AtomicInteger();
    private final ThreadLocal<Integer> childReference = new ThreadLocal();

    protected DiskRegion(DiskStoreImpl ds, String name, boolean isBucket, boolean isPersistBackup, boolean overflowEnabled, boolean isSynchronous, DiskRegionStats stats, CancelCriterion cancel, DiskExceptionHandler exceptionHandler, RegionAttributes ra, EnumSet<DiskInitFile.DiskRegionFlag> flags, String partitionName, int startingBucketId, String compressorClassName, boolean offHeap) {
        super(ds, name);
        if (!(this.getPartitionName() == null || this.getStartingBucketId() == startingBucketId && this.getPartitionName().equals(partitionName))) {
            partitionName = this.getPartitionName();
            startingBucketId = this.getStartingBucketId();
        }
        if (this.isRecreated() && this.isBackup() && !isPersistBackup) {
            throw new IllegalStateException("The region \"" + name + "\" has been persisted to disk so it can not be recreated on the same disk store without persistence. Either destroy the persistent region, recreate it as overflow and persistent, or create the overflow only region on a different disk store.");
        }
        if (this.isRecreated() && isBucket != this.isBucket()) {
            if (this.isBucket()) {
                throw new IllegalStateException("The region \"" + name + "\" has been persisted to disk as a partition region bucket but is not being recreated as a bucket. This should not be possible.");
            }
            throw new IllegalStateException("The region \"" + name + "\" has not been persisted to disk as a partition region bucket but is now being recreated as a bucket. This should not be possible.");
        }
        if (this.isRecreated() && !flags.equals(this.getFlags())) {
            throw new IllegalStateException("The region \"" + name + "\" has changed it's concurrency enabled setting. Old setting " + this.getFlags() + ", new setting " + flags);
        }
        this.setBackup(isPersistBackup);
        this.overflowEnabled = overflowEnabled;
        this.stats = stats;
        this.name = name;
        this.isSync = isSynchronous;
        this.cancel = cancel;
        this.exceptionHandler = exceptionHandler;
        this.rwLock = new StoppableReentrantReadWriteLock(ds.getCancelCriterion());
        if (ra != null) {
            byte raLruAlgorithm = (byte)ra.getEvictionAttributes().getAlgorithm().getValue();
            byte raLruAction = (byte)ra.getEvictionAttributes().getAction().getValue();
            int raLruLimit = 0;
            if (!ra.getEvictionAttributes().getAlgorithm().isLRUHeap()) {
                raLruLimit = ra.getEvictionAttributes().getMaximum();
            }
            if (this.isRecreated() && (raLruAlgorithm != this.getLruAlgorithm() || raLruAction != this.getLruAction() || raLruLimit != this.getLruLimit() || ra.getConcurrencyLevel() != this.getConcurrencyLevel() || ra.getInitialCapacity() != this.getInitialCapacity() || ra.getLoadFactor() != this.getLoadFactor() || ra.getStatisticsEnabled() != this.getStatisticsEnabled() || offHeap != this.getOffHeap() || !this.hasSameCompressor(ra))) {
                if (this.getRecoveredEntryMap() != null) {
                    this.getRecoveredEntryMap().lruCloseStats();
                }
                this.setEntriesMapIncompatible(true);
                this.setConfigChanged(true);
            }
            this.setConfig(raLruAlgorithm, raLruAction, raLruLimit, ra.getConcurrencyLevel(), ra.getInitialCapacity(), ra.getLoadFactor(), ra.getStatisticsEnabled(), isBucket, flags, partitionName, startingBucketId, compressorClassName, offHeap);
        }
        if (!isBucket) {
            this.createDataStorage();
        }
    }

    static DiskRegion create(DiskStoreImpl dsi, String name, boolean isBucket, boolean isPersistBackup, boolean overflowEnabled, boolean isSynchronous, DiskRegionStats stats, CancelCriterion cancel, DiskExceptionHandler exceptionHandler, RegionAttributes ra, EnumSet<DiskInitFile.DiskRegionFlag> flags, String partitionName, int startingBucketId, Compressor compressor, boolean offHeap) {
        return dsi.getDiskInitFile().createDiskRegion(dsi, name, isBucket, isPersistBackup, overflowEnabled, isSynchronous, stats, cancel, exceptionHandler, ra, flags, partitionName, startingBucketId, compressor, offHeap);
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.cancel;
    }

    public DiskExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    private boolean hasSameCompressor(RegionAttributes<?, ?> ra) {
        Compressor raCompressor = ra.getCompressor();
        if (raCompressor == null) {
            return Strings.isNullOrEmpty((String)this.getCompressorClassName());
        }
        return raCompressor.getClass().getName().equals(this.getCompressorClassName());
    }

    protected void register() {
        this.getDiskStore().addDiskRegion(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DiskRegionStats getStats() {
        return this.stats;
    }

    @Override
    public void incNumOverflowBytesOnDisk(long delta) {
        this.getStats().incNumOverflowBytesOnDisk(delta);
        super.incNumOverflowBytesOnDisk(delta);
    }

    @Override
    public void incNumOverflowOnDisk(long delta) {
        this.getStats().incNumOverflowOnDisk(delta);
        super.incNumOverflowOnDisk(delta);
    }

    @Override
    public void incNumEntriesInVM(long delta) {
        this.getStats().incNumEntriesInVM(delta);
        super.incNumEntriesInVM(delta);
    }

    void initializeOwner(LocalRegion drs) {
        this.getDiskStore().initializeOwner(drs);
    }

    void finishInitializeOwner(LocalRegion drs, InitialImageOperation.GIIStatus giiStatus) {
        if (this.isReadyForRecovery()) {
            if (InitialImageOperation.GIIStatus.didFullGII(giiStatus)) {
                this.destroyRemainingRecoveredEntries(drs);
            } else if (!InitialImageOperation.GIIStatus.didDeltaGII(giiStatus) && this.getRegionVersionVector() != null) {
                this.destroyOldTomstones(drs);
            }
            this.releaseRecoveryData();
        }
        if (this.isBackup() && !this.isRegionClosed() && !this.getRVVTrusted()) {
            if (!InitialImageOperation.GIIStatus.didGII(giiStatus)) {
                drs.repairRVV();
            }
            if (this.isSync()) {
                this.writeRVV(null, true);
                this.writeRVVGC(drs);
            } else {
                this.getDiskStore().addDiskRegionToQueue(drs);
            }
        }
    }

    private void destroyOldTomstones(final DiskRecoveryStore drs) {
        drs.foreachRegionEntry(new LocalRegion.RegionEntryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleRegionEntry(RegionEntry regionEntry) {
                DiskEntry de;
                DiskEntry diskEntry = de = (DiskEntry)regionEntry;
                synchronized (diskEntry) {
                    DiskId id = de.getDiskId();
                    if (id != null && regionEntry.isTombstone()) {
                        VersionStamp stamp = regionEntry.getVersionStamp();
                        if (DiskRegion.this.getRegionVersionVector().isTombstoneTooOld(stamp.getMemberID(), stamp.getRegionVersion())) {
                            drs.destroyRecoveredEntry(de.getKey());
                        }
                    }
                }
            }
        });
    }

    private void destroyRemainingRecoveredEntries(final DiskRecoveryStore drs) {
        drs.foreachRegionEntry(new LocalRegion.RegionEntryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleRegionEntry(RegionEntry regionEntry) {
                DiskEntry de;
                DiskEntry diskEntry = de = (DiskEntry)regionEntry;
                synchronized (diskEntry) {
                    DiskId id = de.getDiskId();
                    if (id != null && EntryBits.isRecoveredFromDisk(id.getUserBits())) {
                        drs.destroyRecoveredEntry(de.getKey());
                    }
                }
            }
        });
    }

    public void resetRecoveredEntries(DiskRecoveryStore drs) {
        drs.foreachRegionEntry(new LocalRegion.RegionEntryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleRegionEntry(RegionEntry regionEntry) {
                DiskEntry de;
                DiskEntry diskEntry = de = (DiskEntry)regionEntry;
                synchronized (diskEntry) {
                    DiskId id = de.getDiskId();
                    if (id != null) {
                        id.setRecoveredFromDisk(true);
                    }
                }
            }
        });
    }

    public boolean isOverflowEnabled() {
        return this.overflowEnabled;
    }

    void put(DiskEntry entry, LocalRegion region, DiskEntry.Helper.ValueWrapper value, boolean async) throws RegionClearedException {
        this.getDiskStore().put(region, entry, value, async);
    }

    Object get(DiskId id) {
        return this.getDiskStore().get(this, id);
    }

    BytesAndBits getBytesAndBitsWithoutLock(DiskId id, boolean faultIn, boolean bitOnly) {
        return this.getDiskStore().getBytesAndBitsWithoutLock(this, id, faultIn, bitOnly);
    }

    BytesAndBits getBytesAndBits(DiskId id) {
        return this.getBytesAndBits(id, true);
    }

    BytesAndBits getBytesAndBits(DiskId id, boolean faultingIn) {
        return this.getDiskStore().getBytesAndBits(this, id, faultingIn);
    }

    byte getBits(DiskId id) {
        return this.getDiskStore().getBits(this, id);
    }

    public Object getNoBuffer(DiskId id) {
        return this.getDiskStore().getNoBuffer(this, id);
    }

    void remove(LocalRegion region, DiskEntry entry) throws RegionClearedException {
        this.getDiskStore().remove(region, entry, false, false);
    }

    void remove(LocalRegion region, DiskEntry entry, boolean async, boolean isClear) throws RegionClearedException {
        this.getDiskStore().remove(region, entry, async, isClear);
    }

    public void forceRolling() {
        this.getDiskStore().forceRolling(this);
    }

    public boolean forceCompaction() {
        return this.getDiskStore().forceCompaction(this);
    }

    public Object getSerializedData(DiskId id) {
        return this.getDiskStore().getSerializedData(this, id);
    }

    public void scheduleAsyncWrite(DiskStoreImpl.AsyncDiskEntry ade) {
        this.getDiskStore().scheduleAsyncWrite(ade);
    }

    public void unscheduleAsyncWrite(DiskId did) {
        this.getDiskStore().unscheduleAsyncWrite(did);
    }

    public boolean testWaitForAsyncFlusherThread(int waitMs) {
        return this.getDiskStore().testWaitForAsyncFlusherThread(waitMs);
    }

    public void asynchForceFlush() {
        this.getDiskStore().asynchForceFlush();
    }

    public void forceFlush() {
        this.getDiskStore().forceFlush();
    }

    private void statsClose(LocalRegion region) {
        if (region instanceof BucketRegion) {
            this.statsClear(region);
        } else {
            this.stats.close();
        }
    }

    void statsClear(LocalRegion region) {
        if (region instanceof BucketRegion) {
            BucketRegion owner = (BucketRegion)region;
            long curInVM = owner.getNumEntriesInVM() * -1L;
            long curOnDisk = owner.getNumOverflowOnDisk() * -1L;
            long curOnDiskBytes = owner.getNumOverflowBytesOnDisk() * -1L;
            this.incNumEntriesInVM(curInVM);
            this.incNumOverflowOnDisk(curOnDisk);
            this.incNumOverflowBytesOnDisk(curOnDiskBytes);
            owner.incNumEntriesInVM(curInVM);
            owner.incNumOverflowOnDisk(curOnDisk);
            owner.incNumOverflowBytesOnDisk(curOnDiskBytes);
        } else {
            this.incNumEntriesInVM(this.getNumEntriesInVM() * -1L);
            this.incNumOverflowOnDisk(this.getNumOverflowOnDisk() * -1L);
            this.incNumOverflowBytesOnDisk(this.getNumOverflowBytesOnDisk() * -1L);
        }
    }

    public boolean testIsRecoveredAndClear(RegionEntry re) {
        DiskEntry de = (DiskEntry)re;
        return this.testIsRecoveredAndClear(de.getDiskId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testIsRecoveredAndClear(DiskId id) {
        if (!this.isReadyForRecovery()) {
            return false;
        }
        if (id == null) {
            return false;
        }
        DiskId diskId = id;
        synchronized (diskId) {
            byte bits = id.getUserBits();
            if (EntryBits.isRecoveredFromDisk(bits)) {
                bits = EntryBits.setRecoveredFromDisk(bits, false);
                id.setUserBits(bits);
                return true;
            }
        }
        return false;
    }

    Oplog testHook_getChild() {
        return this.getDiskStore().persistentOplogs.getChild();
    }

    public void flushForTesting() {
        this.getDiskStore().flushForTesting();
    }

    public void pauseFlusherForTesting() {
        this.getDiskStore().pauseFlusherForTesting();
    }

    @Override
    public boolean isSync() {
        return this.isSync;
    }

    void clear(LocalRegion region, RegionVersionVector rvv) {
        this.getDiskStore().clear(region, this, rvv);
    }

    void close(LocalRegion region) {
        try {
            this.getDiskStore().close(region, this, false);
        }
        finally {
            this.statsClose(region);
        }
    }

    void close(LocalRegion region, boolean closeDataOnly) {
        try {
            this.getDiskStore().close(region, this, closeDataOnly);
        }
        finally {
            this.statsClose(region);
        }
    }

    @Override
    void beginDestroyRegion(LocalRegion region) {
        try {
            this.getDiskStore().beginDestroyRegion(region, this);
        }
        finally {
            this.statsClose(region);
        }
    }

    void incClearCount() {
        this.clearCount.incrementAndGet();
    }

    @Override
    public boolean didClearCountChange() {
        Integer i = this.childReference.get();
        boolean result = i != null && i.intValue() != this.clearCount.get();
        return result;
    }

    void removeClearCountReference() {
        this.childReference.set(null);
    }

    void setClearCountReference() {
        if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
            CacheObserverHolder.getInstance().beforeSettingDiskRef();
            this.childReference.set(this.clearCount.get());
            CacheObserverHolder.getInstance().afterSettingDiskRef();
        } else {
            this.childReference.set(this.clearCount.get());
        }
    }

    void acquireWriteLock() {
        this.rwLock.writeLock().lock();
    }

    void releaseWriteLock() {
        this.rwLock.writeLock().unlock();
    }

    @Override
    public void acquireReadLock() {
        this.getDiskStore().acquireReadLock(this);
    }

    @Override
    public void releaseReadLock() {
        this.getDiskStore().releaseReadLock(this);
    }

    void basicAcquireReadLock() {
        this.rwLock.readLock().lock();
    }

    void basicReleaseReadLock() {
        this.rwLock.readLock().unlock();
    }

    boolean isCompactionPossible() {
        return this.getDiskStore().isCompactionPossible();
    }

    void cleanupFailedInitialization(LocalRegion region) {
        if (this.isRecreated() && !this.wasAboutToDestroy() && !this.wasAboutToDestroyDataStorage()) {
            this.close(region, this.isBucket());
        } else {
            if (this.isBucket() && !this.wasAboutToDestroy()) {
                this.beginDestroyDataStorage();
            }
            this.endDestroy(region);
        }
    }

    void prepareForClose(LocalRegion region) {
        this.getDiskStore().prepareForClose(region, this);
    }

    @Override
    public boolean isRegionClosed() {
        return this.isRegionClosed;
    }

    void setRegionClosed(boolean v) {
        this.isRegionClosed = v;
    }

    public void forceIFCompaction() {
        this.getDiskStore().forceIFCompaction();
    }

    void addToBeCompacted(Oplog oplog) {
        this.getOplogSet().addToBeCompacted(oplog);
    }

    CompactableOplog[] getOplogToBeCompacted() {
        return this.getDiskStore().getOplogToBeCompacted();
    }

    Oplog removeOplog(long id) {
        return this.getOplogSet().removeOplog(id);
    }

    DirectoryHolder getNextDir() {
        return this.getOplogSet().getNextDir();
    }

    long newOplogEntryId() {
        return this.getOplogSet().newOplogEntryId();
    }

    void setChild(Oplog oplog) {
        this.getOplogSet().setChild(oplog);
    }

    DirectoryHolder getInfoFileDir() {
        return this.getDiskStore().getInfoFileDir();
    }

    public DirectoryHolder[] getDirectories() {
        return this.getDiskStore().directories;
    }

    Map<Long, Oplog> getOplogIdToOplog() {
        return this.getOplogSet().oplogIdToOplog;
    }

    void testHookCloseAllOverflowChannels() {
        this.getDiskStore().testHookCloseAllOverflowChannels();
    }

    void testHookCloseAllOverflowOplogs() {
        this.getDiskStore().testHookCloseAllOverflowOplogs();
    }

    void freeAllEntriesOnDisk(LocalRegion region) {
        if (region == null) {
            return;
        }
        region.foreachRegionEntry(new LocalRegion.RegionEntryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleRegionEntry(RegionEntry regionEntry) {
                DiskEntry de = (DiskEntry)regionEntry;
                DiskId id = de.getDiskId();
                if (id != null) {
                    DiskId diskId = id;
                    synchronized (diskId) {
                        regionEntry.setValueToNull();
                        regionEntry.removePhase2();
                        id.unmarkForWriting();
                        if (EntryBits.isNeedsValue(id.getUserBits())) {
                            long oplogId = id.getOplogId();
                            long offset = id.getOffsetInOplog();
                            if (oplogId != -1L && offset != -1L) {
                                id.setOplogId(-1L);
                                OverflowOplog oplog = DiskRegion.this.getDiskStore().overflowOplogs.getChild((int)oplogId);
                                if (oplog != null) {
                                    oplog.freeEntry(de);
                                }
                            }
                        }
                    }
                }
            }
        });
    }

    @Override
    public void finishPendingDestroy() {
        boolean wasFullDestroy = this.wasAboutToDestroy();
        super.endDestroy(null);
        if (wasFullDestroy) {
            this.setRegionClosed(false);
            this.register();
        }
    }

    @Override
    public DiskStoreID getDiskStoreID() {
        return this.getDiskStore().getDiskStoreID();
    }

    public void waitForAsyncRecovery() {
        this.getDiskStore().waitForAsyncRecovery(this);
    }

    @Override
    public void endRead(long start, long end, long bytesRead) {
        this.getStats().endRead(start, end, bytesRead);
    }

    public void writeRVVGC(LocalRegion region) {
        if (this.getFlags().contains((Object)DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING)) {
            this.getDiskStore().writeRVVGC(this, region);
        }
    }

    public void writeRVV(LocalRegion region, Boolean isRVVTrusted) {
        if (this.getFlags().contains((Object)DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING)) {
            this.getDiskStore().writeRVV(this, region, isRVVTrusted);
        }
    }

    public void replaceIncompatibleEntry(DiskEntry old, DiskEntry repl) {
        this.acquireReadLock();
        try {
            this.getOplogSet().getChild().replaceIncompatibleEntry(this, old, repl);
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public void close() {
    }
}

