/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.DiskEntry;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.ValidatingDiskRegion;
import org.apache.geode.internal.cache.persistence.DiskRegionView;

public class ExportDiskRegion
extends ValidatingDiskRegion {
    private Map<Object, DiskEntry.RecoveredEntry> currentOplogEntries = new HashMap<Object, DiskEntry.RecoveredEntry>();
    private ExportWriter writer;

    public ExportDiskRegion(DiskStoreImpl ds, DiskRegionView drv, ExportWriter writer) {
        super(ds, drv);
        this.writer = writer;
    }

    @Override
    public DiskEntry initializeRecoveredEntry(Object key, DiskEntry.RecoveredEntry re) {
        if (re.getValue() == null) {
            Assert.fail("Value should not have been null for key " + key);
        }
        this.currentOplogEntries.put(key, re);
        return super.initializeRecoveredEntry(key, re);
    }

    @Override
    public DiskEntry updateRecoveredEntry(Object key, DiskEntry.RecoveredEntry re) {
        this.currentOplogEntries.put(key, re);
        return super.updateRecoveredEntry(key, re);
    }

    @Override
    public void destroyRecoveredEntry(Object key) {
        this.currentOplogEntries.remove(key);
        super.destroyRecoveredEntry(key);
    }

    @Override
    public void oplogRecovered(long oplogId) {
        try {
            this.writer.writeBatch(this.currentOplogEntries);
        }
        catch (IOException e) {
            throw new DiskAccessException("Error during export", (Throwable)e, this.getDiskStore());
        }
        this.currentOplogEntries.clear();
    }

    public static interface ExportWriter {
        public void writeBatch(Map<Object, DiskEntry.RecoveredEntry> var1) throws IOException;
    }
}

