/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Hashtable;
import org.apache.geode.CancelException;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.TXEntryUserAttrState;
import org.apache.geode.internal.cache.TXRegionState;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class TXEntry
implements Region.Entry {
    private final LocalRegion localRegion;
    protected final KeyInfo keyInfo;
    private boolean entryIsDestroyed = false;
    private final boolean rememberReads;
    private final TXStateInterface myTX;

    TXEntry(LocalRegion localRegion, KeyInfo key, TXStateInterface tx) {
        this(localRegion, key, tx, true);
    }

    TXEntry(LocalRegion localRegion, KeyInfo key, TXStateInterface tx, boolean rememberReads) {
        this.localRegion = localRegion;
        this.localRegion.validateKey(key.getKey());
        this.keyInfo = key;
        this.myTX = tx;
        this.rememberReads = rememberReads;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    protected void checkTX() {
        if (!this.myTX.isInProgressAndSameAs(this.localRegion.getTXState())) {
            throw new IllegalStateException(LocalizedStrings.LocalRegion_REGIONENTRY_WAS_CREATED_WITH_TRANSACTION_THAT_IS_NO_LONGER_ACTIVE.toLocalizedString(this.myTX.getTransactionId()));
        }
    }

    @Override
    public boolean isDestroyed() {
        if (this.entryIsDestroyed) {
            return true;
        }
        this.checkTX();
        try {
            if (!this.myTX.containsKey(this.keyInfo, this.localRegion)) {
                this.entryIsDestroyed = true;
            }
        }
        catch (RegionDestroyedException ex) {
            this.entryIsDestroyed = true;
        }
        catch (CancelException ex) {
            this.entryIsDestroyed = true;
        }
        return this.entryIsDestroyed;
    }

    @Override
    public Object getKey() {
        this.checkEntryDestroyed();
        return this.keyInfo.getKey();
    }

    @Override
    public Object getValue() {
        this.checkTX();
        Object value = this.myTX.getDeserializedValue(this.keyInfo, this.localRegion, false, false, false, null, false, false);
        if (value == null) {
            throw new EntryDestroyedException(this.keyInfo.getKey().toString());
        }
        if (Token.isInvalid(value)) {
            return null;
        }
        return value;
    }

    public Region getRegion() {
        this.checkEntryDestroyed();
        return this.localRegion;
    }

    @Override
    public CacheStatistics getStatistics() {
        this.checkEntryDestroyed();
        this.checkTX();
        if (!this.localRegion.statisticsEnabled) {
            throw new StatisticsDisabledException(LocalizedStrings.LocalRegion_STATISTICS_DISABLED_FOR_REGION_0.toLocalizedString(this.localRegion.getFullPath()));
        }
        return new CacheStatistics(){

            @Override
            public long getLastModifiedTime() {
                return TXEntry.this.getRegion() != null ? ((LocalRegion)TXEntry.this.getRegion()).cacheTimeMillis() : System.currentTimeMillis();
            }

            @Override
            public long getLastAccessedTime() {
                return TXEntry.this.getRegion() != null ? ((LocalRegion)TXEntry.this.getRegion()).cacheTimeMillis() : System.currentTimeMillis();
            }

            @Override
            public long getMissCount() {
                return 0L;
            }

            @Override
            public long getHitCount() {
                return 0L;
            }

            @Override
            public float getHitRatio() {
                return 0.0f;
            }

            @Override
            public void resetCounts() {
            }
        };
    }

    @Override
    public Object getUserAttribute() {
        this.checkTX();
        this.throwIfUAOperationForPR();
        TXEntryUserAttrState tx = this.txReadUA(this.keyInfo);
        if (tx != null) {
            return tx.getPendingValue();
        }
        this.checkEntryDestroyed();
        return this.localRegion.basicGetEntryUserAttribute(this.keyInfo.getKey());
    }

    @Override
    public Object setUserAttribute(Object value) {
        this.checkTX();
        this.throwIfUAOperationForPR();
        TXEntryUserAttrState tx = this.txWriteUA(this.keyInfo);
        if (tx != null) {
            return tx.setPendingValue(value);
        }
        this.checkEntryDestroyed();
        if (this.localRegion.entryUserAttributes == null) {
            this.localRegion.entryUserAttributes = new Hashtable();
        }
        return this.localRegion.entryUserAttributes.put(this.keyInfo, value);
    }

    private void throwIfUAOperationForPR() {
        if (this.localRegion instanceof PartitionedRegion) {
            throw new UnsupportedOperationException(LocalizedStrings.TXEntry_UA_NOT_SUPPORTED_FOR_PR.toLocalizedString());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TXEntry)) {
            return false;
        }
        TXEntry lre = (TXEntry)obj;
        return this.keyInfo.getKey().equals(lre.keyInfo.getKey()) && this.getRegion() == lre.getRegion();
    }

    @Override
    public int hashCode() {
        return this.keyInfo.getKey().hashCode() ^ this.getRegion().hashCode();
    }

    private void checkEntryDestroyed() {
        if (this.isDestroyed()) {
            throw new EntryDestroyedException(this.keyInfo.getKey().toString());
        }
    }

    private TXEntryUserAttrState txReadUA(KeyInfo ki) {
        TXRegionState txr = this.myTX.txReadRegion(this.localRegion);
        if (txr != null) {
            return txr.readEntryUserAttr(ki.getKey());
        }
        return null;
    }

    protected TXEntryUserAttrState txWriteUA(KeyInfo ki) {
        TXRegionState txr = this.myTX.txWriteRegion(this.localRegion, ki);
        if (txr != null) {
            return txr.writeEntryUserAttr(ki.getKey(), this.localRegion);
        }
        return null;
    }

    @Override
    public Object setValue(Object arg0) {
        return this.localRegion.put(this.getKey(), arg0);
    }
}

