/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.SynchronizationCommitConflictException;
import org.apache.geode.cache.TransactionDataNodeHasDepartedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ReliableReplyException;
import org.apache.geode.distributed.internal.ReliableReplyProcessor21;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.JtaBeforeCompletionMessage;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXEvent;
import org.apache.geode.internal.cache.TXRegionState;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.TXRegionStub;
import org.apache.geode.internal.i18n.LocalizedStrings;

public abstract class TXStateStub
implements TXStateInterface {
    protected final DistributedMember target;
    protected final TXStateProxy proxy;
    protected Runnable internalAfterSendRollback;
    protected Runnable internalAfterSendCommit;
    Map<Region<?, ?>, TXRegionStub> regionStubs = new HashMap();

    protected TXStateStub(TXStateProxy stateProxy, DistributedMember target) {
        this.target = target;
        this.proxy = stateProxy;
        this.internalAfterSendRollback = null;
        this.internalAfterSendCommit = null;
    }

    @Override
    public void precommit() throws CommitConflictException, UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(LocalizedStrings.Dist_TX_PRECOMMIT_NOT_SUPPORTED_IN_A_TRANSACTION.toLocalizedString("precommit"));
    }

    @Override
    public abstract void commit() throws CommitConflictException;

    protected abstract void validateRegionCanJoinTransaction(LocalRegion var1) throws TransactionException;

    protected abstract TXRegionStub generateRegionStub(LocalRegion var1);

    @Override
    public abstract void rollback();

    public abstract void afterCompletion(int var1);

    public void beforeCompletion() {
        ReliableReplyProcessor21 response = JtaBeforeCompletionMessage.send(this.proxy.getCache(), this.proxy.getTxId().getUniqId(), this.getOriginatingMember(), this.target);
        try {
            try {
                response.waitForReliableDelivery();
            }
            catch (ReliableReplyException e) {
                throw new TransactionDataNodeHasDepartedException(e);
            }
            catch (ReplyException e) {
                e.handleAsUnexpected();
            }
            catch (InterruptedException e) {
            }
        }
        catch (SynchronizationCommitConflictException e) {
            throw e;
        }
        catch (CommitConflictException cce) {
            throw cce;
        }
        catch (TransactionException te) {
            throw te;
        }
    }

    protected TXRegionStub getTXRegionStub(LocalRegion region) {
        TXRegionStub stub = this.regionStubs.get(region);
        if (stub == null) {
            this.validateRegionCanJoinTransaction(region);
            stub = this.generateRegionStub(region);
            this.regionStubs.put(region, stub);
        }
        return stub;
    }

    public Map<Region<?, ?>, TXRegionStub> getRegionStubs() {
        return this.regionStubs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass()).append("@").append(System.identityHashCode(this)).append(" target node: ").append(this.target);
        return builder.toString();
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException {
        if (event.getOperation().isLocal()) {
            throw new UnsupportedOperationInTransactionException(LocalizedStrings.TXStateStub_LOCAL_DESTROY_NOT_ALLOWED_IN_TRANSACTION.toLocalizedString());
        }
        TXRegionStub rs = this.getTXRegionStub(event.getRegion());
        rs.destroyExistingEntry(event, cacheWrite, expectedOldValue);
    }

    @Override
    public long getBeginTime() {
        return 0L;
    }

    @Override
    public Cache getCache() {
        return this.proxy.getTxMgr().getCache();
    }

    @Override
    public int getChanges() {
        return 0;
    }

    @Override
    public Object getDeserializedValue(KeyInfo keyInfo, LocalRegion localRegion, boolean updateStats, boolean disableCopyOnRead, boolean preferCD, EntryEventImpl clientEvent, boolean returnTombstones, boolean retainResult) {
        return null;
    }

    public Object getDeserializedValue(KeyInfo keyInfo, LocalRegion localRegion, boolean updateStats, boolean disableCopyOnRead, boolean preferCD, EntryEventImpl clientEvent, boolean returnTombstones) {
        return null;
    }

    @Override
    public Region.Entry getEntry(KeyInfo keyInfo, LocalRegion r, boolean allowTombstones) {
        return this.getTXRegionStub(r).getEntry(keyInfo, allowTombstones);
    }

    @Override
    public TXEvent getEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getEvents() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<LocalRegion> getRegions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TransactionId getTransactionId() {
        return this.proxy.getTxId();
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        if (event.getOperation().isLocal()) {
            throw new UnsupportedOperationInTransactionException(LocalizedStrings.TXStateStub_LOCAL_INVALIDATE_NOT_ALLOWED_IN_TRANSACTION.toLocalizedString());
        }
        this.getTXRegionStub(event.getRegion()).invalidateExistingEntry(event, invokeCallbacks, forceNewEntry);
    }

    @Override
    public boolean isInProgress() {
        return this.proxy.isInProgress();
    }

    @Override
    public boolean isInProgressAndSameAs(TXStateInterface state) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean needsLargeModCount() {
        return false;
    }

    @Override
    public int nextModSerialNum() {
        return 0;
    }

    @Override
    public TXRegionState readRegion(LocalRegion r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rmRegion(LocalRegion r) {
        throw new UnsupportedOperationException();
    }

    public void setAfterSendRollback(Runnable afterSend) {
        this.internalAfterSendRollback = afterSend;
    }

    public void setAfterSendCommit(Runnable afterSend) {
        this.internalAfterSendCommit = afterSend;
    }

    @Override
    public boolean txPutEntry(EntryEventImpl event, boolean ifNew, boolean requireOldValue, boolean checkResources, Object expectedOldValue) {
        return false;
    }

    @Override
    public TXEntryState txReadEntry(KeyInfo entryKey, LocalRegion localRegion, boolean rememberRead, boolean createTxEntryIfAbsent) {
        return null;
    }

    @Override
    public TXRegionState txReadRegion(LocalRegion localRegion) {
        return null;
    }

    @Override
    public TXRegionState txWriteRegion(LocalRegion localRegion, KeyInfo entryKey) {
        return null;
    }

    @Override
    public TXRegionState writeRegion(LocalRegion r) {
        return null;
    }

    @Override
    public boolean containsKey(KeyInfo keyInfo, LocalRegion localRegion) {
        return this.getTXRegionStub(localRegion).containsKey(keyInfo);
    }

    @Override
    public boolean containsValueForKey(KeyInfo keyInfo, LocalRegion localRegion) {
        return this.getTXRegionStub(localRegion).containsValueForKey(keyInfo);
    }

    @Override
    public int entryCount(LocalRegion localRegion) {
        return this.getTXRegionStub(localRegion).entryCount();
    }

    @Override
    public Object findObject(KeyInfo keyInfo, LocalRegion r, boolean isCreate, boolean generateCallbacks, Object value, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) {
        return this.getTXRegionStub(r).findObject(keyInfo, isCreate, generateCallbacks, value, preferCD, requestingClient, clientEvent);
    }

    @Override
    public Set getAdditionalKeysForIterator(LocalRegion currRgn) {
        return null;
    }

    @Override
    public Object getEntryForIterator(KeyInfo keyInfo, LocalRegion currRgn, boolean rememberReads, boolean allowTombstones) {
        return this.getTXRegionStub(currRgn).getEntryForIterator(keyInfo, allowTombstones);
    }

    @Override
    public Object getKeyForIterator(KeyInfo keyInfo, LocalRegion currRgn, boolean rememberReads, boolean allowTombstones) {
        return keyInfo.getKey();
    }

    @Override
    public Object getValueInVM(KeyInfo keyInfo, LocalRegion localRegion, boolean rememberRead) {
        return null;
    }

    @Override
    public boolean isDeferredStats() {
        return true;
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        return this.getTXRegionStub(event.getRegion()).putEntry(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
    }

    @Override
    public Object getSerializedValue(LocalRegion localRegion, KeyInfo key, boolean doNotLockEntry, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean putEntryOnRemote(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws DataLocationException {
        throw new IllegalStateException();
    }

    @Override
    public boolean isFireCallbacks() {
        return false;
    }

    @Override
    public void destroyOnRemote(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws DataLocationException {
        throw new IllegalStateException();
    }

    @Override
    public void invalidateOnRemote(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws DataLocationException {
        throw new IllegalStateException();
    }

    @Override
    public void checkSupportsRegionDestroy() throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(LocalizedStrings.TXState_REGION_DESTROY_NOT_SUPPORTED_IN_A_TRANSACTION.toLocalizedString());
    }

    @Override
    public void checkSupportsRegionInvalidate() throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(LocalizedStrings.TXState_REGION_INVALIDATE_NOT_SUPPORTED_IN_A_TRANSACTION.toLocalizedString());
    }

    @Override
    public void checkSupportsRegionClear() throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(LocalizedStrings.TXState_REGION_CLEAR_NOT_SUPPORTED_IN_A_TRANSACTION.toLocalizedString());
    }

    @Override
    public Set getBucketKeys(LocalRegion localRegion, int bucketId, boolean allowTombstones) {
        PartitionedRegion pr = (PartitionedRegion)localRegion;
        return pr.getBucketKeys(bucketId, allowTombstones);
    }

    @Override
    public Region.Entry getEntryOnRemote(KeyInfo key, LocalRegion localRegion, boolean allowTombstones) throws DataLocationException {
        throw new IllegalStateException();
    }

    @Override
    public ReentrantLock getLock() {
        return this.proxy.getLock();
    }

    public Set getRegionKeysForIteration(LocalRegion currRegion) {
        return this.getTXRegionStub(currRegion).getRegionKeysForIteration(currRegion);
    }

    @Override
    public boolean isRealDealLocal() {
        return false;
    }

    public DistributedMember getTarget() {
        return this.target;
    }

    @Override
    public void postPutAll(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts, LocalRegion region) {
        this.getTXRegionStub(region).postPutAll(putallOp, successfulPuts, region);
    }

    @Override
    public void postRemoveAll(DistributedRemoveAllOperation op, VersionedObjectList successfulOps, LocalRegion region) {
        this.getTXRegionStub(region).postRemoveAll(op, successfulOps, region);
    }

    @Override
    public Region.Entry accessEntry(KeyInfo keyInfo, LocalRegion localRegion) {
        return this.getEntry(keyInfo, localRegion, false);
    }

    @Override
    public void updateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isTxState() {
        return false;
    }

    @Override
    public boolean isTxStateStub() {
        return true;
    }

    @Override
    public boolean isTxStateProxy() {
        return false;
    }

    @Override
    public boolean isDistTx() {
        return false;
    }

    @Override
    public boolean isCreatedOnDistTxCoordinator() {
        return false;
    }
}

