/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.cache.AbstractDiskRegionEntry;
import org.apache.geode.internal.cache.DiskEntry;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.VMStatsDiskLRURegionEntryHeap;
import org.apache.geode.internal.cache.lru.EnableLRU;
import org.apache.geode.internal.cache.lru.LRUClockNode;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMStatsDiskLRURegionEntryHeapStringKey2
extends VMStatsDiskLRURegionEntryHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VMStatsDiskLRURegionEntryHeapStringKey2> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VMStatsDiskLRURegionEntryHeapStringKey2.class, "lastModified");
    private volatile Object value;
    protected DiskId id;
    private LRUClockNode nextLRU;
    private LRUClockNode prevLRU;
    private int size;
    private volatile long lastAccessed;
    private volatile int hitCount;
    private volatile int missCount;
    private static final AtomicIntegerFieldUpdater<VMStatsDiskLRURegionEntryHeapStringKey2> hitCountUpdater = AtomicIntegerFieldUpdater.newUpdater(VMStatsDiskLRURegionEntryHeapStringKey2.class, "hitCount");
    private static final AtomicIntegerFieldUpdater<VMStatsDiskLRURegionEntryHeapStringKey2> missCountUpdater = AtomicIntegerFieldUpdater.newUpdater(VMStatsDiskLRURegionEntryHeapStringKey2.class, "missCount");
    private final long bits1;
    private final long bits2;

    public VMStatsDiskLRURegionEntryHeapStringKey2(RegionEntryContext context, String key, Object value, boolean byteEncode) {
        super(context, value instanceof DiskEntry.RecoveredEntry ? null : value);
        this.initialize(context, value);
        long tmpBits1 = 0L;
        long tmpBits2 = 0L;
        if (byteEncode) {
            for (int i = key.length() - 1; i >= 0; --i) {
                if (i < 7) {
                    tmpBits1 |= (long)((byte)key.charAt(i) & 0xFF);
                    tmpBits1 <<= 8;
                    continue;
                }
                tmpBits2 <<= 8;
                tmpBits2 |= (long)((byte)key.charAt(i) & 0xFF);
            }
            tmpBits1 |= 0x40L;
        } else {
            for (int i = key.length() - 1; i >= 0; --i) {
                if (i < 3) {
                    tmpBits1 |= (long)key.charAt(i);
                    tmpBits1 <<= 16;
                    continue;
                }
                tmpBits2 <<= 16;
                tmpBits2 |= (long)key.charAt(i);
            }
        }
        this.bits1 = tmpBits1 |= (long)key.length();
        this.bits2 = tmpBits2;
    }

    @Override
    protected Object getValueField() {
        return this.value;
    }

    @Override
    protected void setValueField(Object v) {
        this.value = v;
    }

    @Override
    protected long getLastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    protected void initialize(RegionEntryContext drs, Object value) {
        boolean isBackup;
        if (drs instanceof LocalRegion) {
            isBackup = ((LocalRegion)drs).getDiskRegion().isBackup();
        } else if (drs instanceof PlaceHolderDiskRegion) {
            isBackup = true;
        } else {
            throw new IllegalArgumentException("expected a LocalRegion or PlaceHolderDiskRegion");
        }
        if (isBackup) {
            this.diskInitialize(drs, value);
        }
    }

    @Override
    public synchronized int updateAsyncEntrySize(EnableLRU capacityController) {
        int oldSize = this.getEntrySize();
        int newSize = capacityController.entrySize(this.getKeyForSizing(), null);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    private void diskInitialize(RegionEntryContext context, Object value) {
        DiskRecoveryStore drs = (DiskRecoveryStore)((Object)context);
        DiskStoreImpl ds = drs.getDiskStore();
        long maxOplogSize = ds.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, true, ds.needsLinkedList());
        DiskEntry.Helper.initialize(this, drs, value);
    }

    @Override
    public DiskId getDiskId() {
        return this.id;
    }

    @Override
    void setDiskId(RegionEntry old) {
        this.id = ((AbstractDiskRegionEntry)old).getDiskId();
    }

    @Override
    public void setDelayedDiskId(LocalRegion r) {
        DiskStoreImpl ds = r.getDiskStore();
        long maxOplogSize = ds.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, false, ds.needsLinkedList());
    }

    @Override
    public synchronized int updateEntrySize(EnableLRU capacityController) {
        return this.updateEntrySize(capacityController, this._getValue());
    }

    @Override
    public synchronized int updateEntrySize(EnableLRU capacityController, Object value) {
        int oldSize = this.getEntrySize();
        int newSize = capacityController.entrySize(this.getKeyForSizing(), value);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public boolean testRecentlyUsed() {
        return this.areAnyBitsSet(0x1000000000000000L);
    }

    @Override
    public void setRecentlyUsed() {
        this.setBits(0x1000000000000000L);
    }

    @Override
    public void unsetRecentlyUsed() {
        this.clearBits(-1152921504606846977L);
    }

    @Override
    public boolean testEvicted() {
        return this.areAnyBitsSet(0x2000000000000000L);
    }

    @Override
    public void setEvicted() {
        this.setBits(0x2000000000000000L);
    }

    @Override
    public void unsetEvicted() {
        this.clearBits(-2305843009213693953L);
    }

    @Override
    public void setNextLRUNode(LRUClockNode next) {
        this.nextLRU = next;
    }

    @Override
    public LRUClockNode nextLRUNode() {
        return this.nextLRU;
    }

    @Override
    public void setPrevLRUNode(LRUClockNode prev) {
        this.prevLRU = prev;
    }

    @Override
    public LRUClockNode prevLRUNode() {
        return this.prevLRU;
    }

    @Override
    public int getEntrySize() {
        return this.size;
    }

    protected void setEntrySize(int size) {
        this.size = size;
    }

    @Override
    public Object getKeyForSizing() {
        return null;
    }

    @Override
    public void updateStatsForGet(boolean hit, long time) {
        this.setLastAccessed(time);
        if (hit) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
    }

    @Override
    protected void setLastModifiedAndAccessedTimes(long lastModified, long lastAccessed) {
        this._setLastModified(lastModified);
        if (!DISABLE_ACCESS_TIME_UPDATE_ON_PUT) {
            this.setLastAccessed(lastAccessed);
        }
    }

    @Override
    public long getLastAccessed() throws InternalStatisticsDisabledException {
        return this.lastAccessed;
    }

    private void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    @Override
    public long getHitCount() throws InternalStatisticsDisabledException {
        return (long)this.hitCount & 0xFFFFFFFFL;
    }

    @Override
    public long getMissCount() throws InternalStatisticsDisabledException {
        return (long)this.missCount & 0xFFFFFFFFL;
    }

    private void incrementHitCount() {
        hitCountUpdater.incrementAndGet(this);
    }

    private void incrementMissCount() {
        missCountUpdater.incrementAndGet(this);
    }

    @Override
    public void resetCounts() throws InternalStatisticsDisabledException {
        hitCountUpdater.set(this, 0);
        missCountUpdater.set(this, 0);
    }

    @Override
    public void txDidDestroy(long currTime) {
        this.setLastModified(currTime);
        this.setLastAccessed(currTime);
        this.hitCount = 0;
        this.missCount = 0;
    }

    @Override
    public boolean hasStats() {
        return true;
    }

    private int getKeyLength() {
        return (int)(this.bits1 & 0x3FL);
    }

    private int getEncoding() {
        return (int)(this.bits1 >> 6) & 3;
    }

    @Override
    public Object getKey() {
        int keylen = this.getKeyLength();
        char[] chars = new char[keylen];
        long tmpBits1 = this.bits1;
        long tmpBits2 = this.bits2;
        if (this.getEncoding() == 1) {
            for (int i = 0; i < keylen; ++i) {
                if (i < 7) {
                    chars[i] = (char)((tmpBits1 >>= 8) & 0xFFL);
                    continue;
                }
                chars[i] = (char)(tmpBits2 & 0xFFL);
                tmpBits2 >>= 8;
            }
        } else {
            for (int i = 0; i < keylen; ++i) {
                if (i < 3) {
                    chars[i] = (char)((tmpBits1 >>= 16) & 0xFFFFL);
                    continue;
                }
                chars[i] = (char)(tmpBits2 & 0xFFFFL);
                tmpBits2 >>= 16;
            }
        }
        return new String(chars);
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof String) {
            String str = (String)k;
            int keylen = this.getKeyLength();
            if (str.length() == keylen) {
                long tmpBits1 = this.bits1;
                long tmpBits2 = this.bits2;
                if (this.getEncoding() == 1) {
                    for (int i = 0; i < keylen; ++i) {
                        char c;
                        if (i < 7) {
                            c = (char)((tmpBits1 >>= 8) & 0xFFL);
                        } else {
                            c = (char)(tmpBits2 & 0xFFL);
                            tmpBits2 >>= 8;
                        }
                        if (str.charAt(i) == c) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < keylen; ++i) {
                        char c;
                        if (i < 3) {
                            c = (char)((tmpBits1 >>= 16) & 0xFFFFL);
                        } else {
                            c = (char)(tmpBits2 & 0xFFFFL);
                            tmpBits2 >>= 16;
                        }
                        if (str.charAt(i) == c) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

