/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.OffHeapRegionEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VMStatsDiskLRURegionEntry;
import org.apache.geode.internal.cache.VMStatsDiskLRURegionEntryHeap;
import org.apache.geode.internal.cache.VMStatsDiskLRURegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.VMStatsDiskLRURegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.VMStatsDiskLRURegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.VMStatsDiskLRURegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.VMStatsDiskLRURegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.VMStatsDiskLRURegionEntryOffHeapUUIDKey;
import org.apache.geode.internal.cache.VersionedStatsDiskLRURegionEntryOffHeap;

public abstract class VMStatsDiskLRURegionEntryOffHeap
extends VMStatsDiskLRURegionEntry
implements OffHeapRegionEntry {
    private static final VMStatsDiskLRURegionEntryOffHeapFactory factory = new VMStatsDiskLRURegionEntryOffHeapFactory();

    public VMStatsDiskLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsDiskLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMStatsDiskLRURegionEntryOffHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsDiskLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMStatsDiskLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsDiskLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMStatsDiskLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsDiskLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMStatsDiskLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VMStatsDiskLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsDiskLRURegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMStatsDiskLRURegionEntryHeap.getEntryFactory();
        }
    }
}

