/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VMStatsDiskRegionEntry;
import org.apache.geode.internal.cache.VMStatsDiskRegionEntryHeapIntKey;
import org.apache.geode.internal.cache.VMStatsDiskRegionEntryHeapLongKey;
import org.apache.geode.internal.cache.VMStatsDiskRegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.VMStatsDiskRegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.VMStatsDiskRegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.VMStatsDiskRegionEntryHeapUUIDKey;
import org.apache.geode.internal.cache.VersionedStatsDiskRegionEntryHeap;

public abstract class VMStatsDiskRegionEntryHeap
extends VMStatsDiskRegionEntry {
    private static final VMStatsDiskRegionEntryHeapFactory factory = new VMStatsDiskRegionEntryHeapFactory();

    public VMStatsDiskRegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsDiskRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMStatsDiskRegionEntryHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsDiskRegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMStatsDiskRegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsDiskRegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMStatsDiskRegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsDiskRegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMStatsDiskRegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VMStatsDiskRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsDiskRegionEntryHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

