/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.VMStatsRegionEntryHeap;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMStatsRegionEntryHeapStringKey1
extends VMStatsRegionEntryHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VMStatsRegionEntryHeapStringKey1> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VMStatsRegionEntryHeapStringKey1.class, "lastModified");
    private volatile Object value;
    private volatile long lastAccessed;
    private volatile int hitCount;
    private volatile int missCount;
    private static final AtomicIntegerFieldUpdater<VMStatsRegionEntryHeapStringKey1> hitCountUpdater = AtomicIntegerFieldUpdater.newUpdater(VMStatsRegionEntryHeapStringKey1.class, "hitCount");
    private static final AtomicIntegerFieldUpdater<VMStatsRegionEntryHeapStringKey1> missCountUpdater = AtomicIntegerFieldUpdater.newUpdater(VMStatsRegionEntryHeapStringKey1.class, "missCount");
    private final long bits1;

    public VMStatsRegionEntryHeapStringKey1(RegionEntryContext context, String key, Object value, boolean byteEncode) {
        super(context, value);
        long tmpBits1 = 0L;
        if (byteEncode) {
            for (int i = key.length() - 1; i >= 0; --i) {
                tmpBits1 |= (long)((byte)key.charAt(i) & 0xFF);
                tmpBits1 <<= 8;
            }
            tmpBits1 |= 0x40L;
        } else {
            for (int i = key.length() - 1; i >= 0; --i) {
                tmpBits1 |= (long)key.charAt(i);
                tmpBits1 <<= 16;
            }
        }
        this.bits1 = tmpBits1 |= (long)key.length();
    }

    @Override
    protected Object getValueField() {
        return this.value;
    }

    @Override
    protected void setValueField(Object v) {
        this.value = v;
    }

    @Override
    protected long getLastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    @Override
    public void updateStatsForGet(boolean hit, long time) {
        this.setLastAccessed(time);
        if (hit) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
    }

    @Override
    protected void setLastModifiedAndAccessedTimes(long lastModified, long lastAccessed) {
        this._setLastModified(lastModified);
        if (!DISABLE_ACCESS_TIME_UPDATE_ON_PUT) {
            this.setLastAccessed(lastAccessed);
        }
    }

    @Override
    public long getLastAccessed() throws InternalStatisticsDisabledException {
        return this.lastAccessed;
    }

    private void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    @Override
    public long getHitCount() throws InternalStatisticsDisabledException {
        return (long)this.hitCount & 0xFFFFFFFFL;
    }

    @Override
    public long getMissCount() throws InternalStatisticsDisabledException {
        return (long)this.missCount & 0xFFFFFFFFL;
    }

    private void incrementHitCount() {
        hitCountUpdater.incrementAndGet(this);
    }

    private void incrementMissCount() {
        missCountUpdater.incrementAndGet(this);
    }

    @Override
    public void resetCounts() throws InternalStatisticsDisabledException {
        hitCountUpdater.set(this, 0);
        missCountUpdater.set(this, 0);
    }

    @Override
    public void txDidDestroy(long currTime) {
        this.setLastModified(currTime);
        this.setLastAccessed(currTime);
        this.hitCount = 0;
        this.missCount = 0;
    }

    @Override
    public boolean hasStats() {
        return true;
    }

    private int getKeyLength() {
        return (int)(this.bits1 & 0x3FL);
    }

    private int getEncoding() {
        return (int)(this.bits1 >> 6) & 3;
    }

    @Override
    public Object getKey() {
        int keylen = this.getKeyLength();
        char[] chars = new char[keylen];
        long tmpBits1 = this.bits1;
        if (this.getEncoding() == 1) {
            for (int i = 0; i < keylen; ++i) {
                chars[i] = (char)((tmpBits1 >>= 8) & 0xFFL);
            }
        } else {
            for (int i = 0; i < keylen; ++i) {
                chars[i] = (char)((tmpBits1 >>= 16) & 0xFFFFL);
            }
        }
        return new String(chars);
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof String) {
            String str = (String)k;
            int keylen = this.getKeyLength();
            if (str.length() == keylen) {
                long tmpBits1 = this.bits1;
                if (this.getEncoding() == 1) {
                    for (int i = 0; i < keylen; ++i) {
                        char c = (char)((tmpBits1 >>= 8) & 0xFFL);
                        if (str.charAt(i) == c) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < keylen; ++i) {
                        char c = (char)((tmpBits1 >>= 16) & 0xFFFFL);
                        if (str.charAt(i) == c) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

