/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.OffHeapRegionEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VMStatsRegionEntry;
import org.apache.geode.internal.cache.VMStatsRegionEntryHeap;
import org.apache.geode.internal.cache.VMStatsRegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.VMStatsRegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.VMStatsRegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.VMStatsRegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.VMStatsRegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.VMStatsRegionEntryOffHeapUUIDKey;
import org.apache.geode.internal.cache.VersionedStatsRegionEntryOffHeap;

public abstract class VMStatsRegionEntryOffHeap
extends VMStatsRegionEntry
implements OffHeapRegionEntry {
    private static final VMStatsRegionEntryOffHeapFactory factory = new VMStatsRegionEntryOffHeapFactory();

    public VMStatsRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMStatsRegionEntryOffHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMStatsRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMStatsRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMStatsRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VMStatsRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsRegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMStatsRegionEntryHeap.getEntryFactory();
        }
    }
}

