/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.VMThinRegionEntryHeap;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMThinRegionEntryHeapStringKey1
extends VMThinRegionEntryHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VMThinRegionEntryHeapStringKey1> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VMThinRegionEntryHeapStringKey1.class, "lastModified");
    private volatile Object value;
    private final long bits1;

    public VMThinRegionEntryHeapStringKey1(RegionEntryContext context, String key, Object value, boolean byteEncode) {
        super(context, value);
        long tmpBits1 = 0L;
        if (byteEncode) {
            for (int i = key.length() - 1; i >= 0; --i) {
                tmpBits1 |= (long)((byte)key.charAt(i) & 0xFF);
                tmpBits1 <<= 8;
            }
            tmpBits1 |= 0x40L;
        } else {
            for (int i = key.length() - 1; i >= 0; --i) {
                tmpBits1 |= (long)key.charAt(i);
                tmpBits1 <<= 16;
            }
        }
        this.bits1 = tmpBits1 |= (long)key.length();
    }

    @Override
    protected Object getValueField() {
        return this.value;
    }

    @Override
    protected void setValueField(Object v) {
        this.value = v;
    }

    @Override
    protected long getLastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    private int getKeyLength() {
        return (int)(this.bits1 & 0x3FL);
    }

    private int getEncoding() {
        return (int)(this.bits1 >> 6) & 3;
    }

    @Override
    public Object getKey() {
        int keylen = this.getKeyLength();
        char[] chars = new char[keylen];
        long tmpBits1 = this.bits1;
        if (this.getEncoding() == 1) {
            for (int i = 0; i < keylen; ++i) {
                chars[i] = (char)((tmpBits1 >>= 8) & 0xFFL);
            }
        } else {
            for (int i = 0; i < keylen; ++i) {
                chars[i] = (char)((tmpBits1 >>= 16) & 0xFFFFL);
            }
        }
        return new String(chars);
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof String) {
            String str = (String)k;
            int keylen = this.getKeyLength();
            if (str.length() == keylen) {
                long tmpBits1 = this.bits1;
                if (this.getEncoding() == 1) {
                    for (int i = 0; i < keylen; ++i) {
                        char c = (char)((tmpBits1 >>= 8) & 0xFFL);
                        if (str.charAt(i) == c) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < keylen; ++i) {
                        char c = (char)((tmpBits1 >>= 16) & 0xFFFFL);
                        if (str.charAt(i) == c) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

