/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.VersionedThinLRURegionEntryOffHeap;
import org.apache.geode.internal.cache.lru.EnableLRU;
import org.apache.geode.internal.cache.lru.LRUClockNode;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VersionedThinLRURegionEntryOffHeapUUIDKey
extends VersionedThinLRURegionEntryOffHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VersionedThinLRURegionEntryOffHeapUUIDKey> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VersionedThinLRURegionEntryOffHeapUUIDKey.class, "lastModified");
    private volatile long ohAddress;
    private static final AtomicLongFieldUpdater<VersionedThinLRURegionEntryOffHeapUUIDKey> ohAddrUpdater = AtomicLongFieldUpdater.newUpdater(VersionedThinLRURegionEntryOffHeapUUIDKey.class, "ohAddress");
    private LRUClockNode nextLRU;
    private LRUClockNode prevLRU;
    private int size;
    private VersionSource memberID;
    private short entryVersionLowBytes;
    private short regionVersionHighBytes;
    private int regionVersionLowBytes;
    private byte entryVersionHighByte;
    private byte distributedSystemId;
    private final long keyMostSigBits;
    private final long keyLeastSigBits;

    public VersionedThinLRURegionEntryOffHeapUUIDKey(RegionEntryContext context, UUID key, Object value) {
        super(context, value);
        this.keyMostSigBits = key.getMostSignificantBits();
        this.keyLeastSigBits = key.getLeastSignificantBits();
    }

    @Override
    public Token getValueAsToken() {
        return OffHeapRegionEntryHelper.getValueAsToken(this);
    }

    @Override
    protected Object getValueField() {
        return OffHeapRegionEntryHelper._getValue(this);
    }

    @Override
    protected void setValueField(Object v) {
        OffHeapRegionEntryHelper.setValue(this, v);
    }

    @Override
    public Object _getValueRetain(RegionEntryContext context, boolean decompress) {
        return OffHeapRegionEntryHelper._getValueRetain(this, decompress, context);
    }

    @Override
    public long getAddress() {
        return ohAddrUpdater.get(this);
    }

    @Override
    public boolean setAddress(long expectedAddr, long newAddr) {
        return ohAddrUpdater.compareAndSet(this, expectedAddr, newAddr);
    }

    @Override
    public void release() {
        OffHeapRegionEntryHelper.releaseEntry(this);
    }

    @Override
    public void returnToPool() {
    }

    @Override
    protected long getLastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    @Override
    public void setDelayedDiskId(LocalRegion r) {
    }

    @Override
    public synchronized int updateEntrySize(EnableLRU capacityController) {
        return this.updateEntrySize(capacityController, this._getValue());
    }

    @Override
    public synchronized int updateEntrySize(EnableLRU capacityController, Object value) {
        int oldSize = this.getEntrySize();
        int newSize = capacityController.entrySize(this.getKeyForSizing(), value);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public boolean testRecentlyUsed() {
        return this.areAnyBitsSet(0x1000000000000000L);
    }

    @Override
    public void setRecentlyUsed() {
        this.setBits(0x1000000000000000L);
    }

    @Override
    public void unsetRecentlyUsed() {
        this.clearBits(-1152921504606846977L);
    }

    @Override
    public boolean testEvicted() {
        return this.areAnyBitsSet(0x2000000000000000L);
    }

    @Override
    public void setEvicted() {
        this.setBits(0x2000000000000000L);
    }

    @Override
    public void unsetEvicted() {
        this.clearBits(-2305843009213693953L);
    }

    @Override
    public void setNextLRUNode(LRUClockNode next) {
        this.nextLRU = next;
    }

    @Override
    public LRUClockNode nextLRUNode() {
        return this.nextLRU;
    }

    @Override
    public void setPrevLRUNode(LRUClockNode prev) {
        this.prevLRU = prev;
    }

    @Override
    public LRUClockNode prevLRUNode() {
        return this.prevLRU;
    }

    @Override
    public int getEntrySize() {
        return this.size;
    }

    protected void setEntrySize(int size) {
        this.size = size;
    }

    @Override
    public Object getKeyForSizing() {
        return null;
    }

    @Override
    public int getEntryVersion() {
        return this.entryVersionHighByte << 16 & 0xFF0000 | this.entryVersionLowBytes & 0xFFFF;
    }

    @Override
    public long getRegionVersion() {
        return (long)this.regionVersionHighBytes << 32 | (long)this.regionVersionLowBytes & 0xFFFFFFFFL;
    }

    @Override
    public long getVersionTimeStamp() {
        return this.getLastModified();
    }

    @Override
    public void setVersionTimeStamp(long time) {
        this.setLastModified(time);
    }

    @Override
    public VersionSource getMemberID() {
        return this.memberID;
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public void setVersions(VersionTag tag) {
        this.memberID = tag.getMemberID();
        int eVersion = tag.getEntryVersion();
        this.entryVersionLowBytes = (short)(eVersion & 0xFFFF);
        this.entryVersionHighByte = (byte)((eVersion & 0xFF0000) >> 16);
        this.regionVersionHighBytes = tag.getRegionVersionHighBytes();
        this.regionVersionLowBytes = tag.getRegionVersionLowBytes();
        if (!tag.isGatewayTag() && this.distributedSystemId == tag.getDistributedSystemId()) {
            if (this.getVersionTimeStamp() <= tag.getVersionTimeStamp()) {
                this.setVersionTimeStamp(tag.getVersionTimeStamp());
            } else {
                tag.setVersionTimeStamp(this.getVersionTimeStamp());
            }
        } else {
            this.setVersionTimeStamp(tag.getVersionTimeStamp());
        }
        this.distributedSystemId = (byte)(tag.getDistributedSystemId() & 0xFF);
    }

    @Override
    public void setMemberID(VersionSource memberID) {
        this.memberID = memberID;
    }

    @Override
    public VersionStamp getVersionStamp() {
        return this;
    }

    public VersionTag asVersionTag() {
        VersionTag tag = VersionTag.create(this.memberID);
        tag.setEntryVersion(this.getEntryVersion());
        tag.setRegionVersion(this.regionVersionHighBytes, this.regionVersionLowBytes);
        tag.setVersionTimeStamp(this.getVersionTimeStamp());
        tag.setDistributedSystemId(this.distributedSystemId);
        return tag;
    }

    public void processVersionTag(LocalRegion r, VersionTag tag, boolean isTombstoneFromGII, boolean hasDelta, VersionSource thisVM, InternalDistributedMember sender, boolean checkForConflicts) {
        this.basicProcessVersionTag(r, tag, isTombstoneFromGII, hasDelta, thisVM, sender, checkForConflicts);
    }

    @Override
    public void processVersionTag(EntryEvent cacheEvent) {
        super.processVersionTag(cacheEvent);
    }

    @Override
    public short getRegionVersionHighBytes() {
        return this.regionVersionHighBytes;
    }

    @Override
    public int getRegionVersionLowBytes() {
        return this.regionVersionLowBytes;
    }

    @Override
    public Object getKey() {
        return new UUID(this.keyMostSigBits, this.keyLeastSigBits);
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof UUID) {
            UUID uuid = (UUID)k;
            return uuid.getLeastSignificantBits() == this.keyLeastSigBits && uuid.getMostSignificantBits() == this.keyMostSigBits;
        }
        return false;
    }
}

