/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.OffHeapRegionEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VersionedThinRegionEntry;
import org.apache.geode.internal.cache.VersionedThinRegionEntryHeap;
import org.apache.geode.internal.cache.VersionedThinRegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.VersionedThinRegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.VersionedThinRegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.VersionedThinRegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.VersionedThinRegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.VersionedThinRegionEntryOffHeapUUIDKey;

public abstract class VersionedThinRegionEntryOffHeap
extends VersionedThinRegionEntry
implements OffHeapRegionEntry {
    private static final VersionedThinRegionEntryOffHeapFactory factory = new VersionedThinRegionEntryOffHeapFactory();

    public VersionedThinRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedThinRegionEntryOffHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VersionedThinRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedThinRegionEntryHeap.getEntryFactory();
        }
    }
}

