/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.locks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.locks.DLockGrantor;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.LockGrantorDestroyedException;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.locks.TXLockBatch;
import org.apache.geode.internal.cache.locks.TXLockId;
import org.apache.geode.internal.cache.locks.TXLockIdImpl;

public class TXLockUpdateParticipantsMessage
extends PooledDistributionMessage
implements MessageWithReply {
    private transient TXLockId txLockId;
    private transient String serviceName;
    private transient Set updatedParticipants;
    private transient int processorId;

    public TXLockUpdateParticipantsMessage(TXLockId txLockId, String serviceName, Set updatedParticipants, int processorId) {
        this.txLockId = txLockId;
        this.serviceName = serviceName;
        this.updatedParticipants = updatedParticipants;
        this.processorId = processorId;
    }

    public TXLockUpdateParticipantsMessage() {
        this.txLockId = null;
        this.serviceName = null;
        this.updatedParticipants = null;
    }

    @Override
    public void process(DistributionManager dm) {
        DLockService svc = DLockService.getInternalServiceNamed(this.serviceName);
        if (svc != null) {
            TXLockUpdateParticipantsMessage.updateParticipants(svc, this.txLockId, this.updatedParticipants);
        }
        TXLockUpdateParticipantsReplyMessage reply = new TXLockUpdateParticipantsReplyMessage();
        reply.setProcessorId(this.processorId);
        reply.setRecipient(this.getSender());
        dm.putOutgoing(reply);
    }

    public static void updateParticipants(DLockService svc, TXLockId txLockId, Set updatedParticipants) {
        DLockGrantor grantor = null;
        try {
            grantor = DLockGrantor.waitForGrantor(svc);
            if (grantor != null) {
                try {
                    TXLockBatch txb = (TXLockBatch)grantor.getLockBatch(txLockId);
                    if (txb == null) {
                        return;
                    }
                    txb.setParticipants(updatedParticipants);
                    grantor.updateLockBatch(txLockId, txb);
                }
                catch (LockGrantorDestroyedException txb) {}
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
        InternalDataSerializer.invokeToData(this.txLockId, out);
        DataSerializer.writeString(this.serviceName, out);
        InternalDataSerializer.writeSet(this.updatedParticipants, out);
    }

    @Override
    public int getDSFID() {
        return -76;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
        this.txLockId = TXLockIdImpl.createFromData(in);
        this.serviceName = DataSerializer.readString(in);
        this.updatedParticipants = InternalDataSerializer.readSet(in);
    }

    @Override
    public String toString() {
        return "TXLockUpdateParticipantsMessage for service=" + this.serviceName + "; updatedParticipants=" + this.updatedParticipants + "; txLockId=" + this.txLockId;
    }

    public static class TXLockUpdateParticipantsReplyMessage
    extends ReplyMessage {
        @Override
        public int getDSFID() {
            return -67;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
        }

        @Override
        public String toString() {
            return "TXLockUpdateParticipantsReplyMessage processorId=" + this.processorId + "; sender=" + this.getSender();
        }
    }
}

