/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.BucketPersistenceAdvisor;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.PRHARedundancyProvider;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.ProxyBucketRegion;
import org.apache.geode.internal.cache.partitioned.RecoveryRunnable;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentStateListener;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.process.StartupStatus;
import org.apache.geode.internal.util.TransformUtils;
import org.apache.logging.log4j.Logger;

public class RedundancyLogger
extends RecoveryRunnable
implements PersistentStateListener {
    private static final Logger logger = LogService.getLogger();
    private volatile boolean membershipChanged = true;
    private static final int SLEEP_PERIOD = 15000;
    private final CountDownLatch allBucketsRecoveredFromDisk;
    private final List<RegionStatus> regions;

    public RedundancyLogger(PRHARedundancyProvider prhaRedundancyProvider) {
        super(prhaRedundancyProvider);
        PartitionedRegion baseRegion = ColocationHelper.getLeaderRegion(this.redundancyProvider.prRegion);
        List<PartitionedRegion> colocatedRegions = ColocationHelper.getColocatedChildRegions(baseRegion);
        ArrayList<RegionStatus> allRegions = new ArrayList<RegionStatus>(colocatedRegions.size() + 1);
        if (baseRegion.getDataPolicy().withPersistence()) {
            allRegions.add(new RegionStatus(baseRegion));
        }
        for (PartitionedRegion region : colocatedRegions) {
            if (!region.getDataPolicy().withPersistence()) continue;
            allRegions.add(new RegionStatus(region));
        }
        this.regions = Collections.unmodifiableList(allRegions);
        this.allBucketsRecoveredFromDisk = this.redundancyProvider.getAllBucketsRecoveredFromDiskLatch();
        this.membershipChanged = true;
        this.addListeners();
    }

    @Override
    public void memberOnline(InternalDistributedMember member, PersistentMemberID persistentID) {
        this.membershipChanged = true;
    }

    @Override
    public void memberOffline(InternalDistributedMember member, PersistentMemberID persistentID) {
        this.membershipChanged = true;
    }

    @Override
    public void memberRemoved(PersistentMemberID persistentID, boolean revoked) {
        this.membershipChanged = true;
    }

    private void addListeners() {
        for (RegionStatus region : this.regions) {
            region.addListeners();
        }
    }

    private void removeListeners() {
        for (RegionStatus region : this.regions) {
            region.removeListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run2() {
        try {
            boolean warningLogged = false;
            while (this.allBucketsRecoveredFromDisk.getCount() > 0L) {
                int sleepMillis = 15000;
                if (!warningLogged) {
                    sleepMillis = 7500;
                }
                Thread.sleep(sleepMillis);
                if (!this.membershipChanged) continue;
                this.membershipChanged = false;
                for (RegionStatus region : this.regions) {
                    region.logWaitingForMembers();
                }
                warningLogged = true;
            }
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.removeListeners();
            for (RegionStatus region : this.regions) {
                if (region.loggedDoneMessage) continue;
                region.logDoneMessage();
            }
        }
    }

    private class RegionStatus {
        private final PersistentMemberID thisMember;
        private final String region;
        private final ProxyBucketRegion[] bucketRegions;
        private volatile boolean loggedDoneMessage = true;

        public RegionStatus(PartitionedRegion region) {
            this.thisMember = this.createPersistentMemberID(region);
            this.region = region.getFullPath();
            this.bucketRegions = region.getRegionAdvisor().getProxyBucketArray();
        }

        public void removeListeners() {
            for (ProxyBucketRegion proxyBucket : this.bucketRegions) {
                proxyBucket.getPersistenceAdvisor().removeListener(RedundancyLogger.this);
            }
        }

        public void addListeners() {
            for (ProxyBucketRegion proxyBucket : this.bucketRegions) {
                proxyBucket.getPersistenceAdvisor().addListener(RedundancyLogger.this);
            }
        }

        private PersistentMemberID createPersistentMemberID(PartitionedRegion region) {
            DiskStoreImpl diskStore = null;
            if (region.getAttributes().getDataPolicy().withPersistence()) {
                diskStore = region.getDiskStore();
            } else if (ColocationHelper.getLeaderRegion(region).getAttributes().getDataPolicy().withPersistence()) {
                diskStore = ColocationHelper.getLeaderRegion(region).getDiskStore();
            }
            if (null != diskStore) {
                return diskStore.generatePersistentID(null);
            }
            String name = "No name for this member";
            String diskDir = System.getProperty("user.dir");
            InetAddress localHost = null;
            try {
                localHost = SocketCreator.getLocalHost();
            }
            catch (UnknownHostException e) {
                logger.error("Could not determine my own host", (Throwable)e);
            }
            return new PersistentMemberID(null, localHost, diskDir, name, RedundancyLogger.this.redundancyProvider.prRegion.getCache().cacheTimeMillis(), 0);
        }

        private Map<PersistentMemberID, Set<Integer>> getMembersToWaitFor(boolean offlineOnly) {
            HashMap<PersistentMemberID, Set<Integer>> waitingForMembers = new HashMap<PersistentMemberID, Set<Integer>>();
            for (ProxyBucketRegion proxyBucket : this.bucketRegions) {
                Integer bucketId = proxyBucket.getBucketId();
                BucketPersistenceAdvisor persistenceAdvisor = proxyBucket.getPersistenceAdvisor();
                Set<PersistentMemberID> missingMembers = offlineOnly ? persistenceAdvisor.getMissingMembers() : persistenceAdvisor.getAllMembersToWaitFor();
                if (missingMembers == null) continue;
                for (PersistentMemberID missingMember : missingMembers) {
                    TreeSet<Integer> buckets = (TreeSet<Integer>)waitingForMembers.get(missingMember);
                    if (buckets == null) {
                        buckets = new TreeSet<Integer>();
                        waitingForMembers.put(missingMember, buckets);
                    }
                    buckets.add(bucketId);
                }
            }
            return waitingForMembers;
        }

        private void logDoneMessage() {
            this.loggedDoneMessage = true;
            StartupStatus.startup(LocalizedStrings.CreatePersistentRegionProcessor_DONE_WAITING_FOR_BUCKET_MEMBERS, new Object[]{this.region, TransformUtils.persistentMemberIdToLogEntryTransformer.transform(this.thisMember)});
        }

        private void logWaitingForMembers() {
            boolean thereAreBucketsToBeRecovered;
            Map<PersistentMemberID, Set<Integer>> offlineMembers = this.getMembersToWaitFor(true);
            Map<PersistentMemberID, Set<Integer>> allMembersToWaitFor = this.getMembersToWaitFor(false);
            boolean bl = thereAreBucketsToBeRecovered = RedundancyLogger.this.allBucketsRecoveredFromDisk.getCount() > 0L;
            if (thereAreBucketsToBeRecovered && !offlineMembers.isEmpty()) {
                HashSet membersToWaitForLogEntries = new HashSet();
                TransformUtils.transform(offlineMembers.entrySet(), membersToWaitForLogEntries, TransformUtils.persistentMemberEntryToLogEntryTransformer);
                Set<Integer> missingBuckets = this.getAllWaitingBuckets(offlineMembers);
                StartupStatus.startup(LocalizedStrings.CreatePersistentRegionProcessor_WAITING_FOR_OFFLINE_BUCKET_MEMBERS, new Object[]{this.region, missingBuckets, TransformUtils.persistentMemberIdToLogEntryTransformer.transform(this.thisMember), membersToWaitForLogEntries});
                this.loggedDoneMessage = false;
            } else if (thereAreBucketsToBeRecovered && !allMembersToWaitFor.isEmpty()) {
                HashSet membersToWaitForLogEntries = new HashSet();
                Set<Integer> missingBuckets = this.getAllWaitingBuckets(allMembersToWaitFor);
                TransformUtils.transform(allMembersToWaitFor.entrySet(), membersToWaitForLogEntries, TransformUtils.persistentMemberEntryToLogEntryTransformer);
                StartupStatus.startup(LocalizedStrings.CreatePersistentRegionProcessor_WAITING_FOR_ONLINE_BUCKET_MEMBERS, new Object[]{this.region, missingBuckets, TransformUtils.persistentMemberIdToLogEntryTransformer.transform(this.thisMember), membersToWaitForLogEntries});
                this.loggedDoneMessage = false;
            } else if (!this.loggedDoneMessage) {
                this.logDoneMessage();
            }
        }

        private Set<Integer> getAllWaitingBuckets(Map<PersistentMemberID, Set<Integer>> offlineMembers) {
            TreeSet<Integer> allWaitingBuckets = new TreeSet<Integer>();
            for (Set<Integer> missingPerMember : offlineMembers.values()) {
                allWaitingBuckets.addAll(missingPerMember);
            }
            return allWaitingBuckets;
        }
    }
}

