/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.DeployedJar;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.persistence.BackupInspector;
import org.apache.geode.internal.cache.persistence.RestoreScript;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class BackupManager
implements MembershipListener {
    public static final String INCOMPLETE_BACKUP = "INCOMPLETE_BACKUP";
    public static final String README = "README.txt";
    public static final String DATA_STORES = "diskstores";
    public static final String USER_FILES = "user";
    public static final String CONFIG = "config";
    private InternalDistributedMember sender;
    private InternalCache cache;
    private CountDownLatch allowDestroys = new CountDownLatch(1);
    private volatile boolean isCancelled = false;

    public BackupManager(InternalDistributedMember sender, InternalCache gemFireCache) {
        this.sender = sender;
        this.cache = gemFireCache;
    }

    public void start() {
        DM distributionManager = this.cache.getInternalDistributedSystem().getDistributionManager();
        Set allIds = distributionManager.addAllMembershipListenerAndGetAllIds(this);
        if (!allIds.contains(this.sender)) {
            this.cleanup();
            throw new IllegalStateException("The admin member requesting a backup has already departed");
        }
    }

    private void cleanup() {
        this.isCancelled = true;
        this.allowDestroys.countDown();
        Collection<DiskStore> diskStores = this.cache.listDiskStoresIncludingRegionOwned();
        for (DiskStore store : diskStores) {
            ((DiskStoreImpl)store).releaseBackupLock();
        }
        DM distributionManager = this.cache.getInternalDistributedSystem().getDistributionManager();
        distributionManager.removeAllMembershipListener(this);
        this.cache.clearBackupManager();
    }

    public HashSet<PersistentID> prepareBackup() {
        HashSet<PersistentID> persistentIds = new HashSet<PersistentID>();
        Collection<DiskStore> diskStores = this.cache.listDiskStoresIncludingRegionOwned();
        for (DiskStore store : diskStores) {
            DiskStoreImpl storeImpl = (DiskStoreImpl)store;
            storeImpl.lockStoreBeforeBackup();
            if (!storeImpl.hasPersistedData()) continue;
            persistentIds.add(storeImpl.getPersistentID());
            storeImpl.getStats().startBackup();
        }
        return persistentIds;
    }

    private File findBaselineForThisMember(File baselineParentDir) {
        File baselineDir = null;
        for (final DiskStore diskStore : this.cache.listDiskStoresIncludingRegionOwned()) {
            File[] matchingFiles = baselineParentDir.listFiles(new FilenameFilter(){
                Pattern pattern;
                {
                    this.pattern = Pattern.compile(".*" + ((DiskStoreImpl)diskStore).getBackupDirName() + "$");
                }

                @Override
                public boolean accept(File dir, String name) {
                    Matcher m = this.pattern.matcher(name);
                    return m.find();
                }
            });
            if (null == matchingFiles || matchingFiles.length <= 0) continue;
            baselineDir = matchingFiles[0].getParentFile().getParentFile();
        }
        return baselineDir;
    }

    private File checkBaseline(File baselineParentDir) throws IOException {
        File baselineDir = null;
        if (null != baselineParentDir) {
            File incompleteBackup;
            baselineDir = this.getBackupDir(baselineParentDir);
            if (!baselineDir.exists()) {
                baselineDir = this.findBaselineForThisMember(baselineParentDir);
            }
            if (null != baselineDir && (incompleteBackup = new File(baselineDir, INCOMPLETE_BACKUP)).exists()) {
                baselineDir = null;
            }
        }
        return baselineDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<PersistentID> finishBackup(File targetDir, File baselineDir, boolean abort) throws IOException {
        try {
            DiskStore store;
            if (abort) {
                HashSet<PersistentID> hashSet = new HashSet<PersistentID>();
                return hashSet;
            }
            File backupDir = this.getBackupDir(targetDir);
            BackupInspector inspector = (baselineDir = this.checkBaseline(baselineDir)) == null ? null : BackupInspector.createInspector(baselineDir);
            File storesDir = new File(backupDir, DATA_STORES);
            RestoreScript restoreScript = new RestoreScript();
            HashSet<PersistentID> persistentIds = new HashSet<PersistentID>();
            ArrayList<DiskStore> diskStores = new ArrayList<DiskStore>(this.cache.listDiskStoresIncludingRegionOwned());
            boolean foundPersistentData = false;
            Iterator itr = diskStores.iterator();
            while (itr.hasNext()) {
                store = (DiskStoreImpl)itr.next();
                if (((DiskStoreImpl)store).hasPersistedData()) {
                    if (!foundPersistentData) {
                        this.createBackupDir(backupDir);
                        foundPersistentData = true;
                    }
                    File diskStoreDir = new File(storesDir, ((DiskStoreImpl)store).getBackupDirName());
                    diskStoreDir.mkdir();
                    ((DiskStoreImpl)store).startBackup(diskStoreDir, inspector, restoreScript);
                } else {
                    itr.remove();
                }
                ((DiskStoreImpl)store).releaseBackupLock();
            }
            this.allowDestroys.countDown();
            itr = diskStores.iterator();
            while (itr.hasNext()) {
                DiskStore storeImpl = store = (DiskStore)itr.next();
                ((DiskStoreImpl)storeImpl).finishBackup(this);
                ((DiskStoreImpl)storeImpl).getStats().endBackup();
                persistentIds.add(((DiskStoreImpl)storeImpl).getPersistentID());
            }
            if (foundPersistentData) {
                this.backupConfigFiles(restoreScript, backupDir);
                this.backupUserFiles(restoreScript, backupDir);
                this.backupDeployedJars(restoreScript, backupDir);
                restoreScript.generate(backupDir);
                File incompleteFile = new File(backupDir, INCOMPLETE_BACKUP);
                if (!incompleteFile.delete()) {
                    throw new IOException("Could not delete file INCOMPLETE_BACKUP");
                }
            }
            HashSet<PersistentID> hashSet = persistentIds;
            return hashSet;
        }
        finally {
            this.cleanup();
        }
    }

    public void abort() {
        this.cleanup();
    }

    private void backupConfigFiles(RestoreScript restoreScript, File backupDir) throws IOException {
        URL propertyURL;
        File configBackupDir = new File(backupDir, CONFIG);
        configBackupDir.mkdirs();
        URL url = this.cache.getCacheXmlURL();
        if (url != null) {
            File cacheXMLBackup = new File(configBackupDir, DistributionConfig.DEFAULT_CACHE_XML_FILE.getName());
            FileUtils.copyFile((File)new File(this.cache.getCacheXmlURL().getFile()), (File)cacheXMLBackup);
        }
        if ((propertyURL = DistributedSystem.getPropertiesFileURL()) != null) {
            File propertyBackup = new File(configBackupDir, "gemfire.properties");
            FileUtils.copyFile((File)new File(DistributedSystem.getPropertiesFile()), (File)propertyBackup);
        }
    }

    private void backupUserFiles(RestoreScript restoreScript, File backupDir) throws IOException {
        List<File> backupFiles = this.cache.getBackupFiles();
        File userBackupDir = new File(backupDir, USER_FILES);
        if (!userBackupDir.exists()) {
            userBackupDir.mkdir();
        }
        for (File original : backupFiles) {
            if (!original.exists()) continue;
            original = original.getAbsoluteFile();
            File dest = new File(userBackupDir, original.getName());
            if (original.isDirectory()) {
                FileUtils.copyDirectory((File)original, (File)dest);
            } else {
                FileUtils.copyFile((File)original, (File)dest);
            }
            restoreScript.addExistenceTest(original);
            restoreScript.addFile(original, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupDeployedJars(RestoreScript restoreScript, File backupDir) throws IOException {
        JarDeployer deployer = null;
        try {
            deployer = ClassPathLoader.getLatest().getJarDeployer();
            deployer.suspendAll();
            List<DeployedJar> jarList = deployer.findDeployedJars();
            if (!jarList.isEmpty()) {
                File userBackupDir = new File(backupDir, USER_FILES);
                if (!userBackupDir.exists()) {
                    userBackupDir.mkdir();
                }
                for (DeployedJar loader : jarList) {
                    File source = new File(loader.getFileCanonicalPath());
                    File dest = new File(userBackupDir, source.getName());
                    if (source.isDirectory()) {
                        FileUtils.copyDirectory((File)source, (File)dest);
                    } else {
                        FileUtils.copyFile((File)source, (File)dest);
                    }
                    restoreScript.addFile(source, dest);
                }
            }
        }
        finally {
            if (null != deployer) {
                deployer.resumeAll();
            }
        }
    }

    private File getBackupDir(File targetDir) throws IOException {
        InternalDistributedMember memberId = this.cache.getInternalDistributedSystem().getDistributedMember();
        String vmId = memberId.toString();
        vmId = this.cleanSpecialCharacters(vmId);
        return new File(targetDir, vmId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBackupDir(File backupDir) throws IOException {
        if (backupDir.exists()) {
            throw new IOException("Backup directory " + backupDir.getAbsolutePath() + " already exists.");
        }
        if (!backupDir.mkdirs()) {
            throw new IOException("Could not create directory: " + backupDir);
        }
        File incompleteFile = new File(backupDir, INCOMPLETE_BACKUP);
        if (!incompleteFile.createNewFile()) {
            throw new IOException("Could not create file: " + incompleteFile);
        }
        File readme = new File(backupDir, README);
        try (FileOutputStream fos = new FileOutputStream(readme);){
            String text = LocalizedStrings.BackupManager_README.toLocalizedString();
            fos.write(text.getBytes());
        }
    }

    private String cleanSpecialCharacters(String string) {
        return string.replaceAll("[^\\w]+", "_");
    }

    @Override
    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
        this.cleanup();
    }

    @Override
    public void memberJoined(InternalDistributedMember id) {
    }

    @Override
    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    @Override
    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }

    public void waitForBackup() {
        try {
            this.allowDestroys.await();
        }
        catch (InterruptedException e) {
            throw new InternalGemFireError(e);
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }
}

