/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.snapshot;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.geode.admin.RegionNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.snapshot.CacheSnapshotService;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.cache.snapshot.SnapshotOptions;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.snapshot.GFSnapshot;
import org.apache.geode.internal.cache.snapshot.SnapshotOptionsImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class CacheSnapshotServiceImpl
implements CacheSnapshotService {
    private final InternalCache cache;

    public CacheSnapshotServiceImpl(InternalCache cache) {
        this.cache = cache;
    }

    @Override
    public SnapshotOptions<Object, Object> createOptions() {
        return new SnapshotOptionsImpl<Object, Object>();
    }

    @Override
    public void save(File dir, SnapshotOptions.SnapshotFormat format) throws IOException {
        this.save(dir, format, this.createOptions());
    }

    @Override
    public void save(File dir, SnapshotOptions.SnapshotFormat format, SnapshotOptions<Object, Object> options) throws IOException {
        boolean created;
        if (!dir.exists() && !(created = dir.mkdirs())) {
            throw new IOException(LocalizedStrings.Snapshot_UNABLE_TO_CREATE_DIR_0.toLocalizedString(dir));
        }
        for (Region<?, ?> r : this.cache.rootRegions()) {
            for (Region<?, ?> sub : r.subregions(true)) {
                this.saveRegion(sub, dir, format, options);
            }
            this.saveRegion(r, dir, format, options);
        }
    }

    @Override
    public void load(File dir, SnapshotOptions.SnapshotFormat format) throws IOException, ClassNotFoundException {
        File[] snapshots = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isDirectory();
            }
        });
        if (snapshots == null) {
            throw new FileNotFoundException(LocalizedStrings.Snapshot_NO_SNAPSHOT_FILES_FOUND_0.toLocalizedString(dir));
        }
        this.load(snapshots, format, this.createOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(File[] snapshots, SnapshotOptions.SnapshotFormat format, SnapshotOptions<Object, Object> options) throws IOException, ClassNotFoundException {
        for (File f : snapshots) {
            try (GFSnapshot.GFSnapshotImporter in = new GFSnapshot.GFSnapshotImporter(f);){
                byte version = in.getVersion();
                if (version == 1) {
                    throw new IOException(LocalizedStrings.Snapshot_UNSUPPORTED_SNAPSHOT_VERSION_0.toLocalizedString(version));
                }
                String regionName = in.getRegionName();
                Region region = this.cache.getRegion(regionName);
                if (region == null) {
                    throw new RegionNotFoundException(LocalizedStrings.Snapshot_COULD_NOT_FIND_REGION_0_1.toLocalizedString(regionName, f));
                }
                RegionSnapshotService<Object, Object> rs = region.getSnapshotService();
                rs.load(f, format, options);
            }
        }
    }

    private void saveRegion(Region<?, ?> region, File dir, SnapshotOptions.SnapshotFormat format, SnapshotOptions options) throws IOException {
        RegionSnapshotService<?, ?> rs = region.getSnapshotService();
        String name = "snapshot" + region.getFullPath().replace('/', '-');
        File f = new File(dir, name);
        rs.save(f, format, options);
    }
}

