/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.Socket;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLSocket;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.CancelCriterion;
import org.apache.geode.DataSerializer;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.CacheCallback;
import org.apache.geode.cache.GatewayConfigurationException;
import org.apache.geode.cache.client.ServerRefusedConnectionException;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.LonerDistributionManager;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.ClassLoadUtil;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.VersionedDataInputStream;
import org.apache.geode.internal.VersionedDataOutputStream;
import org.apache.geode.internal.cache.tier.ClientHandShake;
import org.apache.geode.internal.cache.tier.ConnectionProxy;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerHandShakeProcessor;
import org.apache.geode.internal.cache.tier.sockets.ServerQueueStatus;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.pdx.internal.PeerTypeRegistration;
import org.apache.geode.security.AuthInitialize;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.Authenticator;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;

public class HandShake
implements ClientHandShake {
    private static final Logger logger = LogService.getLogger();
    protected static final byte REPLY_OK = 59;
    protected static final byte REPLY_REFUSED = 60;
    protected static final byte REPLY_INVALID = 61;
    protected static final byte REPLY_EXCEPTION_AUTHENTICATION_REQUIRED = 62;
    protected static final byte REPLY_EXCEPTION_AUTHENTICATION_FAILED = 63;
    protected static final byte REPLY_EXCEPTION_DUPLICATE_DURABLE_CLIENT = 64;
    protected static final byte REPLY_WAN_CREDENTIALS = 65;
    protected static final byte REPLY_AUTH_NOT_REQUIRED = 66;
    public static final byte REPLY_SERVER_IS_LOCATOR = 67;
    private static SecurityService securityService = IntegratedSecurityService.getSecurityService();
    private byte code;
    private int clientReadTimeout = 10000;
    private boolean isRead = false;
    protected final DistributedSystem system;
    protected final ClientProxyMembershipID id;
    private Properties credentials;
    private Version clientVersion;
    private static boolean deltaEnabledOnServer = true;
    public static final byte CREDENTIALS_NONE = 0;
    public static final byte CREDENTIALS_NORMAL = 1;
    public static final byte CREDENTIALS_DHENCRYPT = 2;
    public static final byte SECURITY_MULTIUSER_NOTIFICATIONCHANNEL = 3;
    private byte appSecureMode = 0;
    private PublicKey clientPublicKey = null;
    private String clientSKAlgo = null;
    private boolean multiuserSecureMode = false;
    private static final BigInteger dhP = new BigInteger("135287020639910739997189928970717021771311421882765429190887700940242697307989907008041927806610978529253822307916592536509818186767394634756714063947534092593553024224277712367371302394452615862654308111809029797196494501056604787763641987260783383085570220968104473500348898008043285865193451061481841186553");
    private static final BigInteger dhG = new BigInteger("130583456807197150961665134075139695376245536366239321690167044250081505657615277976871655435431431908701485776974110415733273525810283593126577393912282416840649805564834470583437473176415335737232689814802018696718110109967325936556664646275595822588612548788965341273697569202082715873518528062345259949959");
    private static final int dhL = 1023;
    private static PrivateKey dhPrivateKey = null;
    private static PublicKey dhPublicKey = null;
    private static String dhSKAlgo = null;
    private static String certificateFilePath = null;
    private static HashMap certificateMap = null;
    private static String privateKeyAlias = null;
    private static String privateKeySubject = null;
    private static PrivateKey privateKeyEncrypt = null;
    private static String privateKeySignAlgo = null;
    private static SecureRandom random = null;
    public static final String PUBLIC_KEY_FILE_PROP = "security-client-kspath";
    public static final String PUBLIC_KEY_PASSWD_PROP = "security-client-kspasswd";
    public static final String PRIVATE_KEY_FILE_PROP = "security-server-kspath";
    public static final String PRIVATE_KEY_ALIAS_PROP = "security-server-ksalias";
    public static final String PRIVATE_KEY_PASSWD_PROP = "security-server-kspasswd";
    public static final byte CONFLATION_DEFAULT = 0;
    public static final byte CONFLATION_ON = 1;
    public static final byte CONFLATION_OFF = 2;
    private byte clientConflation = 0;
    private byte[] overrides = null;
    public static byte clientConflationForTesting = 0;
    public static boolean setClientConflationForTesting = false;
    private static Version currentClientVersion = ConnectionProxy.VERSION;
    private static short overrideClientVersion = (short)-1;
    private Cipher _encrypt;
    private Cipher _decrypt = null;

    protected HandShake() {
        this.system = null;
        this.id = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandShake(Socket sock, int timeout, DistributedSystem sys, Version clientVersion, byte communicationMode) throws IOException, AuthenticationRequiredException {
        this.clientVersion = clientVersion;
        this.system = sys;
        int soTimeout = -1;
        try {
            soTimeout = sock.getSoTimeout();
            sock.setSoTimeout(timeout);
            InputStream is = sock.getInputStream();
            int valRead = is.read();
            if (valRead == -1) {
                throw new EOFException(LocalizedStrings.HandShake_HANDSHAKE_EOF_REACHED_BEFORE_CLIENT_CODE_COULD_BE_READ.toLocalizedString());
            }
            this.code = (byte)valRead;
            if (this.code != 59) {
                throw new IOException(LocalizedStrings.HandShake_HANDSHAKE_REPLY_CODE_IS_NOT_OK.toLocalizedString());
            }
            try {
                DataInputStream dis = new DataInputStream(is);
                DataOutputStream dos = new DataOutputStream(sock.getOutputStream());
                this.clientReadTimeout = dis.readInt();
                if (clientVersion.compareTo(Version.CURRENT) < 0) {
                    dis = new VersionedDataInputStream(dis, clientVersion);
                    dos = new VersionedDataOutputStream(dos, clientVersion);
                }
                this.id = ClientProxyMembershipID.readCanonicalized(dis);
                if (clientVersion.compareTo(Version.GFE_603) >= 0) {
                    this.setOverrides(new byte[]{dis.readByte()});
                } else {
                    this.setClientConflation(dis.readByte());
                }
                this.credentials = this.clientVersion.compareTo(Version.GFE_65) < 0 || communicationMode == 103 ? HandShake.readCredentials(dis, dos, sys) : this.readCredential(dis, dos, sys);
            }
            catch (IOException ioe) {
                this.code = (byte)-2;
                throw ioe;
            }
            catch (ClassNotFoundException cnfe) {
                this.code = (byte)-3;
                throw new IOException(LocalizedStrings.HandShake_CLIENTPROXYMEMBERSHIPID_CLASS_COULD_NOT_BE_FOUND_WHILE_DESERIALIZING_THE_OBJECT.toLocalizedString());
            }
        }
        finally {
            if (soTimeout != -1) {
                try {
                    sock.setSoTimeout(soTimeout);
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Version getClientVersion() {
        return this.clientVersion;
    }

    public HandShake(ClientProxyMembershipID id, DistributedSystem sys) {
        this.id = id;
        this.code = (byte)59;
        this.system = sys;
        this.setOverrides();
        this.credentials = null;
    }

    public void updateProxyID(InternalDistributedMember idm) {
        this.id.updateID(idm);
    }

    public HandShake(HandShake handShake) {
        this.appSecureMode = handShake.appSecureMode;
        this.clientConflation = handShake.clientConflation;
        this.clientPublicKey = null;
        this.clientReadTimeout = handShake.clientReadTimeout;
        this.clientSKAlgo = null;
        this.clientVersion = handShake.clientVersion;
        this.code = handShake.code;
        this.credentials = handShake.credentials;
        this.isRead = handShake.isRead;
        this.multiuserSecureMode = handShake.multiuserSecureMode;
        this.overrides = handShake.overrides;
        this.system = handShake.system;
        this.id = handShake.id;
        this._decrypt = null;
        this._encrypt = null;
    }

    private byte setClientConflation() {
        int result = 0;
        String clientConflationValue = this.system.getProperties().getProperty("conflate-events");
        if ("true".equalsIgnoreCase(clientConflationValue)) {
            result = 1;
        } else if ("false".equalsIgnoreCase(clientConflationValue)) {
            result = 2;
        }
        return (byte)result;
    }

    private void setClientConflation(byte value) {
        this.clientConflation = value;
        switch (this.clientConflation) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal clientConflation");
            }
        }
    }

    private void setOverrides() {
        this.clientConflation = this.setClientConflation();
        if (currentClientVersion.compareTo(Version.GFE_603) >= 0) {
            byte override = 0;
            override = this.clientConflation;
            this.overrides = new byte[]{override};
        }
    }

    private void setOverrides(byte[] values) {
        byte override = values[0];
        this.setClientConflation((byte)(override & 3));
    }

    public static byte[] extractOverrides(byte[] values) {
        byte override = values[0];
        byte[] overrides = new byte[1];
        for (int item = 0; item < overrides.length; ++item) {
            overrides[item] = (byte)(override & 3);
            override = (byte)(override >>> 2);
        }
        return overrides;
    }

    public static void setVersionForTesting(short ver) {
        if (ver > Version.CURRENT_ORDINAL) {
            overrideClientVersion = ver;
        } else {
            currentClientVersion = Version.fromOrdinalOrCurrent(ver);
            overrideClientVersion = (short)-1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte write(DataOutputStream dos, DataInputStream dis, byte communicationMode, int replyCode, int readTimeout, List ports, Properties p_credentials, DistributedMember member, boolean isCallbackConnection) throws IOException {
        byte acceptanceCode = -1;
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(32, Version.CURRENT);){
            hdos.writeByte(communicationMode);
            if (overrideClientVersion > 0) {
                Version.writeOrdinal(hdos, overrideClientVersion, true);
            } else {
                Version.writeOrdinal(hdos, currentClientVersion.ordinal(), true);
            }
            hdos.writeByte(replyCode);
            if (ports != null) {
                hdos.writeInt(ports.size());
                for (int i = 0; i < ports.size(); ++i) {
                    hdos.writeInt(Integer.parseInt((String)ports.get(i)));
                }
            } else {
                hdos.writeInt(readTimeout);
            }
            VersionedDataOutputStream idOut = new VersionedDataOutputStream(hdos, Version.GFE_82);
            DataSerializer.writeObject(this.id, idOut);
            if (currentClientVersion.compareTo(Version.GFE_603) >= 0) {
                for (int bytes = 0; bytes < this.overrides.length; ++bytes) {
                    hdos.writeByte(this.overrides[bytes]);
                }
            } else if (setClientConflationForTesting) {
                hdos.writeByte(clientConflationForTesting);
            } else {
                hdos.writeByte(this.clientConflation);
            }
            if (isCallbackConnection || communicationMode == 103) {
                if (isCallbackConnection && this.multiuserSecureMode && communicationMode != 103) {
                    hdos.writeByte(3);
                    hdos.flush();
                    dos.write(hdos.toByteArray());
                    dos.flush();
                } else {
                    this.writeCredentials(dos, dis, p_credentials, ports != null, member, hdos);
                }
            } else {
                String authInitMethod = this.system.getProperties().getProperty("security-client-auth-init");
                acceptanceCode = this.writeCredential(dos, dis, authInitMethod, ports != null, member, hdos);
            }
        }
        return acceptanceCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCredentials(DataOutputStream dos, DataInputStream dis, Properties p_credentials, boolean isNotification, DistributedMember member) throws IOException, GemFireSecurityException {
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(32, Version.CURRENT);){
            this.writeCredentials(dos, dis, p_credentials, isNotification, member, hdos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCredentials(DataOutputStream dos, DataInputStream dis, Properties p_credentials, boolean isNotification, DistributedMember member, HeapDataOutputStream heapdos) throws IOException, GemFireSecurityException {
        block16: {
            if (p_credentials == null) {
                heapdos.writeByte(0);
                heapdos.flush();
                dos.write(heapdos.toByteArray());
                dos.flush();
                return;
            }
            if (dhSKAlgo == null || dhSKAlgo.length() == 0) {
                heapdos.writeByte(1);
                DataSerializer.writeProperties(p_credentials, heapdos);
                heapdos.flush();
                dos.write(heapdos.toByteArray());
                dos.flush();
                return;
            }
            try {
                boolean requireAuthentication;
                InternalLogWriter securityLogWriter = (InternalLogWriter)this.system.getSecurityLogWriter();
                securityLogWriter.fine("HandShake: using Diffie-Hellman key exchange with algo " + dhSKAlgo);
                boolean bl = requireAuthentication = certificateFilePath != null && certificateFilePath.length() > 0;
                if (requireAuthentication) {
                    securityLogWriter.fine("HandShake: server authentication using digital signature required");
                }
                heapdos.writeByte(2);
                heapdos.writeBoolean(requireAuthentication);
                DataSerializer.writeString(dhSKAlgo, heapdos);
                byte[] keyBytes = dhPublicKey.getEncoded();
                DataSerializer.writeByteArray(keyBytes, heapdos);
                byte[] clientChallenge = null;
                if (requireAuthentication) {
                    clientChallenge = new byte[64];
                    random.nextBytes(clientChallenge);
                    DataSerializer.writeByteArray(clientChallenge, heapdos);
                }
                heapdos.flush();
                dos.write(heapdos.toByteArray());
                dos.flush();
                byte acceptanceCode = dis.readByte();
                if (acceptanceCode != 59 && acceptanceCode != 66) {
                    dis.readByte();
                    dis.readInt();
                    if (!isNotification) {
                        DataSerializer.readByteArray(dis);
                    }
                    this.readMessage(dis, dos, acceptanceCode, member);
                    break block16;
                }
                if (acceptanceCode != 59) break block16;
                keyBytes = DataSerializer.readByteArray(dis);
                if (requireAuthentication) {
                    String subject = DataSerializer.readString(dis);
                    byte[] signatureBytes = DataSerializer.readByteArray(dis);
                    if (!certificateMap.containsKey(subject)) {
                        throw new AuthenticationFailedException(LocalizedStrings.HandShake_HANDSHAKE_FAILED_TO_FIND_PUBLIC_KEY_FOR_SERVER_WITH_SUBJECT_0.toLocalizedString(subject));
                    }
                    X509Certificate cert = (X509Certificate)certificateMap.get(subject);
                    Signature sig = Signature.getInstance(cert.getSigAlgName());
                    sig.initVerify(cert);
                    sig.update(clientChallenge);
                    if (!sig.verify(signatureBytes)) {
                        throw new AuthenticationFailedException("Mismatch in client challenge bytes. Malicious server?");
                    }
                    securityLogWriter.fine("HandShake: Successfully verified the digital signature from server");
                }
                byte[] challenge = DataSerializer.readByteArray(dis);
                X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
                KeyFactory keyFact = KeyFactory.getInstance("DH");
                this.clientPublicKey = keyFact.generatePublic(x509KeySpec);
                try (HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);){
                    DataSerializer.writeProperties(p_credentials, hdos);
                    DataSerializer.writeByteArray(challenge, hdos);
                    byte[] encBytes = HandShake.encryptBytes(hdos.toByteArray(), this.getEncryptCipher(dhSKAlgo, this.clientPublicKey));
                    DataSerializer.writeByteArray(encBytes, dos);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (GemFireSecurityException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new AuthenticationFailedException("HandShake failed in Diffie-Hellman key exchange", ex);
            }
        }
        dos.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte writeCredential(DataOutputStream dos, DataInputStream dis, String authInit, boolean isNotification, DistributedMember member, HeapDataOutputStream heapdos) throws IOException, GemFireSecurityException {
        byte acceptanceCode;
        block16: {
            if (!(this.multiuserSecureMode || authInit != null && authInit.length() != 0)) {
                heapdos.writeByte(0);
                heapdos.flush();
                dos.write(heapdos.toByteArray());
                dos.flush();
                return -1;
            }
            if (dhSKAlgo == null || dhSKAlgo.length() == 0) {
                heapdos.writeByte(1);
                this.appSecureMode = 1;
                heapdos.flush();
                dos.write(heapdos.toByteArray());
                dos.flush();
                return -1;
            }
            acceptanceCode = -1;
            try {
                boolean requireAuthentication;
                InternalLogWriter securityLogWriter = (InternalLogWriter)this.system.getSecurityLogWriter();
                securityLogWriter.fine("HandShake: using Diffie-Hellman key exchange with algo " + dhSKAlgo);
                boolean bl = requireAuthentication = certificateFilePath != null && certificateFilePath.length() > 0;
                if (requireAuthentication) {
                    securityLogWriter.fine("HandShake: server authentication using digital signature required");
                }
                heapdos.writeByte(2);
                this.appSecureMode = (byte)2;
                heapdos.writeBoolean(requireAuthentication);
                DataSerializer.writeString(dhSKAlgo, heapdos);
                byte[] keyBytes = dhPublicKey.getEncoded();
                DataSerializer.writeByteArray(keyBytes, heapdos);
                byte[] clientChallenge = null;
                if (requireAuthentication) {
                    clientChallenge = new byte[64];
                    random.nextBytes(clientChallenge);
                    DataSerializer.writeByteArray(clientChallenge, heapdos);
                }
                heapdos.flush();
                dos.write(heapdos.toByteArray());
                dos.flush();
                acceptanceCode = dis.readByte();
                if (acceptanceCode != 59 && acceptanceCode != 66) {
                    dis.readByte();
                    dis.readInt();
                    if (!isNotification) {
                        DataSerializer.readByteArray(dis);
                    }
                    this.readMessage(dis, dos, acceptanceCode, member);
                    break block16;
                }
                if (acceptanceCode != 59) break block16;
                keyBytes = DataSerializer.readByteArray(dis);
                if (requireAuthentication) {
                    String subject = DataSerializer.readString(dis);
                    byte[] signatureBytes = DataSerializer.readByteArray(dis);
                    if (!certificateMap.containsKey(subject)) {
                        throw new AuthenticationFailedException(LocalizedStrings.HandShake_HANDSHAKE_FAILED_TO_FIND_PUBLIC_KEY_FOR_SERVER_WITH_SUBJECT_0.toLocalizedString(subject));
                    }
                    X509Certificate cert = (X509Certificate)certificateMap.get(subject);
                    Signature sig = Signature.getInstance(cert.getSigAlgName());
                    sig.initVerify(cert);
                    sig.update(clientChallenge);
                    if (!sig.verify(signatureBytes)) {
                        throw new AuthenticationFailedException("Mismatch in client challenge bytes. Malicious server?");
                    }
                    securityLogWriter.fine("HandShake: Successfully verified the digital signature from server");
                }
                byte[] serverChallenge = DataSerializer.readByteArray(dis);
                X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
                KeyFactory keyFact = KeyFactory.getInstance("DH");
                this.clientPublicKey = keyFact.generatePublic(x509KeySpec);
                try (HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);){
                    DataSerializer.writeByteArray(serverChallenge, hdos);
                    byte[] encBytes = HandShake.encryptBytes(hdos.toByteArray(), this.getEncryptCipher(dhSKAlgo, this.clientPublicKey));
                    DataSerializer.writeByteArray(encBytes, dos);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (GemFireSecurityException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new AuthenticationFailedException("HandShake failed in Diffie-Hellman key exchange", ex);
            }
        }
        dos.flush();
        return acceptanceCode;
    }

    public byte[] encryptBytes(byte[] data) throws Exception {
        if (this.appSecureMode == 2) {
            String algo = null;
            algo = this.clientSKAlgo != null ? this.clientSKAlgo : dhSKAlgo;
            return HandShake.encryptBytes(data, this.getEncryptCipher(algo, this.clientPublicKey));
        }
        return data;
    }

    public static byte[] encryptBytes(byte[] data, Cipher encrypt) throws Exception {
        byte[] encBytes = encrypt.doFinal(data);
        return encBytes;
    }

    private Cipher getEncryptCipher(String dhSKAlgo, PublicKey publicKey) throws Exception {
        if (this._encrypt == null) {
            Cipher encrypt;
            KeyAgreement ka = KeyAgreement.getInstance("DH");
            ka.init(dhPrivateKey);
            ka.doPhase(publicKey, true);
            int keysize = HandShake.getKeySize(dhSKAlgo);
            int blocksize = HandShake.getBlockSize(dhSKAlgo);
            if (keysize == -1 || blocksize == -1) {
                SecretKey sKey = ka.generateSecret(dhSKAlgo);
                encrypt = Cipher.getInstance(dhSKAlgo);
                encrypt.init(1, sKey);
            } else {
                String dhAlgoStr = HandShake.getDhAlgoStr(dhSKAlgo);
                byte[] sKeyBytes = ka.generateSecret();
                SecretKeySpec sks = new SecretKeySpec(sKeyBytes, 0, keysize, dhAlgoStr);
                IvParameterSpec ivps = new IvParameterSpec(sKeyBytes, keysize, blocksize);
                encrypt = Cipher.getInstance(dhAlgoStr + "/CBC/PKCS5Padding");
                encrypt.init(1, (Key)sks, ivps);
            }
            this._encrypt = encrypt;
        }
        return this._encrypt;
    }

    static void throwIfMissingRequiredCredentials(boolean requireAuthentication, boolean hasCredentials) {
        if (requireAuthentication && !hasCredentials) {
            throw new AuthenticationRequiredException(LocalizedStrings.HandShake_NO_SECURITY_CREDENTIALS_ARE_PROVIDED.toLocalizedString());
        }
    }

    public Properties readCredential(DataInputStream dis, DataOutputStream dos, DistributedSystem system) throws GemFireSecurityException, IOException {
        Properties credentials = null;
        boolean requireAuthentication = securityService.isClientSecurityRequired();
        try {
            byte secureMode = dis.readByte();
            HandShake.throwIfMissingRequiredCredentials(requireAuthentication, secureMode != 0);
            if (secureMode == 1) {
                this.appSecureMode = 1;
            } else if (secureMode == 2) {
                this.appSecureMode = (byte)2;
                boolean sendAuthentication = dis.readBoolean();
                InternalLogWriter securityLogWriter = (InternalLogWriter)system.getSecurityLogWriter();
                this.clientSKAlgo = DataSerializer.readString(dis);
                byte[] keyBytes = DataSerializer.readByteArray(dis);
                byte[] challenge = null;
                if (requireAuthentication) {
                    X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
                    KeyFactory keyFact = KeyFactory.getInstance("DH");
                    this.clientPublicKey = keyFact.generatePublic(x509KeySpec);
                    keyBytes = dhPublicKey.getEncoded();
                    challenge = new byte[64];
                    random.nextBytes(challenge);
                    if (sendAuthentication) {
                        byte[] clientChallenge = DataSerializer.readByteArray(dis);
                        if (privateKeyEncrypt == null) {
                            throw new AuthenticationFailedException(LocalizedStrings.HandShake_SERVER_PRIVATE_KEY_NOT_AVAILABLE_FOR_CREATING_SIGNATURE.toLocalizedString());
                        }
                        Signature sig = Signature.getInstance(privateKeySignAlgo);
                        sig.initSign(privateKeyEncrypt);
                        sig.update(clientChallenge);
                        byte[] signedBytes = sig.sign();
                        dos.writeByte(59);
                        DataSerializer.writeByteArray(keyBytes, dos);
                        DataSerializer.writeString(privateKeySubject, dos);
                        DataSerializer.writeByteArray(signedBytes, dos);
                        securityLogWriter.fine("HandShake: sent the signed client challenge");
                    } else {
                        dos.writeByte(59);
                        DataSerializer.writeByteArray(keyBytes, dos);
                    }
                    DataSerializer.writeByteArray(challenge, dos);
                    securityLogWriter.fine("HandShake: sent the public key and challenge");
                    dos.flush();
                    byte[] encBytes = DataSerializer.readByteArray(dis);
                    Cipher c = this.getDecryptCipher(this.clientSKAlgo, this.clientPublicKey);
                    byte[] credentialBytes = HandShake.decryptBytes(encBytes, c);
                    ByteArrayInputStream bis = new ByteArrayInputStream(credentialBytes);
                    DataInputStream dinp = new DataInputStream(bis);
                    byte[] challengeRes = DataSerializer.readByteArray(dinp);
                    if (!Arrays.equals(challenge, challengeRes)) {
                        throw new AuthenticationFailedException(LocalizedStrings.HandShake_MISMATCH_IN_CHALLENGE_BYTES_MALICIOUS_CLIENT.toLocalizedString());
                    }
                    dinp.close();
                } else {
                    if (sendAuthentication) {
                        DataSerializer.readByteArray(dis);
                    }
                    dos.writeByte(66);
                    dos.flush();
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (GemFireSecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AuthenticationFailedException(LocalizedStrings.HandShake_FAILURE_IN_READING_CREDENTIALS.toLocalizedString(), ex);
        }
        return credentials;
    }

    public byte[] decryptBytes(byte[] data) throws Exception {
        if (this.appSecureMode == 2) {
            String algo = null;
            algo = this.clientSKAlgo != null ? this.clientSKAlgo : dhSKAlgo;
            Cipher c = this.getDecryptCipher(algo, this.clientPublicKey);
            return HandShake.decryptBytes(data, c);
        }
        return data;
    }

    public static byte[] decryptBytes(byte[] data, Cipher decrypt) throws Exception {
        byte[] decrptBytes = decrypt.doFinal(data);
        return decrptBytes;
    }

    private Cipher getDecryptCipher(String dhSKAlgo, PublicKey publicKey) throws Exception {
        if (this._decrypt == null) {
            Cipher decrypt;
            KeyAgreement ka = KeyAgreement.getInstance("DH");
            ka.init(dhPrivateKey);
            ka.doPhase(publicKey, true);
            int keysize = HandShake.getKeySize(dhSKAlgo);
            int blocksize = HandShake.getBlockSize(dhSKAlgo);
            if (keysize == -1 || blocksize == -1) {
                SecretKey sKey = ka.generateSecret(dhSKAlgo);
                decrypt = Cipher.getInstance(dhSKAlgo);
                decrypt.init(2, sKey);
            } else {
                String algoStr = HandShake.getDhAlgoStr(dhSKAlgo);
                byte[] sKeyBytes = ka.generateSecret();
                SecretKeySpec sks = new SecretKeySpec(sKeyBytes, 0, keysize, algoStr);
                IvParameterSpec ivps = new IvParameterSpec(sKeyBytes, keysize, blocksize);
                decrypt = Cipher.getInstance(algoStr + "/CBC/PKCS5Padding");
                decrypt.init(2, (Key)sks, ivps);
            }
            this._decrypt = decrypt;
        }
        return this._decrypt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCertsMap(Properties props) throws Exception {
        certificateMap = new HashMap();
        certificateFilePath = props.getProperty(PUBLIC_KEY_FILE_PROP);
        if (certificateFilePath != null && certificateFilePath.length() > 0) {
            KeyStore ks = KeyStore.getInstance("JKS");
            String keyStorePass = props.getProperty(PUBLIC_KEY_PASSWD_PROP);
            char[] passPhrase = keyStorePass != null ? keyStorePass.toCharArray() : null;
            try (FileInputStream keystorefile = new FileInputStream(certificateFilePath);){
                ks.load(keystorefile, passPhrase);
            }
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = ks.getCertificate(alias);
                if (!(cert instanceof X509Certificate)) continue;
                String subject = ((X509Certificate)cert).getSubjectDN().getName();
                certificateMap.put(subject, cert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPrivateKey(Properties props) throws Exception {
        String privateKeyFilePath = props.getProperty(PRIVATE_KEY_FILE_PROP);
        privateKeyAlias = "";
        privateKeyEncrypt = null;
        if (privateKeyFilePath != null && privateKeyFilePath.length() > 0) {
            String keyStorePass;
            KeyStore ks = KeyStore.getInstance("PKCS12");
            privateKeyAlias = props.getProperty(PRIVATE_KEY_ALIAS_PROP);
            if (privateKeyAlias == null) {
                privateKeyAlias = "";
            }
            char[] passPhrase = (keyStorePass = props.getProperty(PRIVATE_KEY_PASSWD_PROP)) != null ? keyStorePass.toCharArray() : null;
            try (FileInputStream privateKeyFile = new FileInputStream(privateKeyFilePath);){
                ks.load(privateKeyFile, passPhrase);
            }
            Key key = ks.getKey(privateKeyAlias, passPhrase);
            Certificate keyCert = ks.getCertificate(privateKeyAlias);
            if (key instanceof PrivateKey && keyCert instanceof X509Certificate) {
                privateKeyEncrypt = (PrivateKey)key;
                privateKeySignAlgo = ((X509Certificate)keyCert).getSigAlgName();
                privateKeySubject = ((X509Certificate)keyCert).getSubjectDN().getName();
            }
        }
    }

    public static void initDHKeys(DistributionConfig config) throws Exception {
        dhSKAlgo = config.getSecurityClientDHAlgo();
        dhPrivateKey = null;
        dhPublicKey = null;
        if (dhSKAlgo != null && dhSKAlgo.length() > 0 || securityService.isClientSecurityRequired()) {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DH");
            DHParameterSpec dhSpec = new DHParameterSpec(dhP, dhG, 1023);
            keyGen.initialize(dhSpec);
            KeyPair keypair = keyGen.generateKeyPair();
            dhPrivateKey = keypair.getPrivate();
            dhPublicKey = keypair.getPublic();
            random = new SecureRandom();
            byte[] someBytes = new byte[48];
            random.nextBytes(someBytes);
        }
    }

    @Override
    public void accept(OutputStream out, InputStream in, byte epType, int qSize, byte communicationMode, Principal principal) throws IOException {
        DataInputStream dis;
        DataOutputStream dos = new DataOutputStream(out);
        if (this.clientVersion.compareTo(Version.CURRENT) < 0) {
            dis = new VersionedDataInputStream(in, this.clientVersion);
            dos = new VersionedDataOutputStream(dos, this.clientVersion);
        } else {
            dis = new DataInputStream(in);
        }
        if (communicationMode == 103 && principal != null) {
            dos.writeByte(65);
        } else {
            dos.writeByte(59);
        }
        if (communicationMode == 103) {
            Version.writeOrdinal(dos, ServerHandShakeProcessor.currentServerVersion.ordinal(), true);
        }
        dos.writeByte(epType);
        dos.writeInt(qSize);
        DistributedMember member = this.system.getDistributedMember();
        ServerHandShakeProcessor.writeServerMember(member, dos);
        dos.writeUTF("");
        if (communicationMode != 103 && this.clientVersion.compareTo(Version.GFE_61) >= 0) {
            dos.writeBoolean(((InternalDistributedSystem)this.system).getConfig().getDeltaPropagation());
        }
        if (communicationMode == 103 && principal != null) {
            this.sendCredentialsForWan(dos, dis);
        }
        if (communicationMode == 103 && this.clientVersion.compareTo(Version.GFE_66) >= 0 && ServerHandShakeProcessor.currentServerVersion.compareTo(Version.GFE_66) >= 0) {
            dos.writeByte(((InternalDistributedSystem)this.system).getDistributionManager().getDistributedSystemId());
        }
        if (communicationMode == 103 && this.clientVersion.compareTo(Version.GFE_80) >= 0 && ServerHandShakeProcessor.currentServerVersion.compareTo(Version.GFE_80) >= 0) {
            int pdxSize = PeerTypeRegistration.getPdxRegistrySize();
            dos.writeInt(pdxSize);
        }
        dos.flush();
    }

    private DistributedMember getIDForSocket(Socket sock) {
        return new InternalDistributedMember(sock.getInetAddress(), sock.getPort(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerQueueStatus handshakeWithServer(Connection conn, ServerLocation location, byte communicationMode) throws IOException, AuthenticationRequiredException, AuthenticationFailedException, ServerRefusedConnectionException {
        try {
            byte acceptanceCode;
            InternalDistributedMember idm;
            ServerQueueStatus serverQStatus = null;
            Socket sock = conn.getSocket();
            DataOutputStream dos = new DataOutputStream(sock.getOutputStream());
            InputStream in = sock.getInputStream();
            DataInputStream dis = new DataInputStream(in);
            DistributedMember member = this.getIDForSocket(sock);
            DM dm = ((InternalDistributedSystem)this.system).getDistributionManager();
            InternalDistributedMember internalDistributedMember = idm = dm.getDistributionManagerId();
            synchronized (internalDistributedMember) {
                if (idm.getPort() == 0 && dm instanceof LonerDistributionManager) {
                    int port = sock.getLocalPort();
                    ((LonerDistributionManager)dm).updateLonerPort(port);
                    this.updateProxyID(dm.getDistributionManagerId());
                }
            }
            if (communicationMode == 103) {
                this.credentials = this.getCredentials(member);
            }
            byte intermediateAcceptanceCode = this.write(dos, dis, communicationMode, 59, this.clientReadTimeout, null, this.credentials, member, false);
            String authInit = this.system.getProperties().getProperty("security-client-auth-init");
            if (communicationMode != 103 && intermediateAcceptanceCode != 66 && authInit != null && authInit.length() != 0) {
                location.compareAndSetRequiresCredentials(true);
            }
            if ((acceptanceCode = dis.readByte()) == 21 && !(sock instanceof SSLSocket)) {
                throw new AuthenticationRequiredException(LocalizedStrings.HandShake_SERVER_EXPECTING_SSL_CONNECTION.toLocalizedString());
            }
            if (acceptanceCode == 67) {
                throw new GemFireConfigException("Improperly configured client detected.  Server at " + location + " is actually a locator.  Use addPoolLocator to configure locators.");
            }
            if (communicationMode == 103 && acceptanceCode != 62 && acceptanceCode != 63) {
                short wanSiteVersion = Version.readOrdinal(dis);
                conn.setWanSiteVersion(wanSiteVersion);
                if (wanSiteVersion < Version.CURRENT_ORDINAL) {
                    dis = new VersionedDataInputStream(dis, Version.fromOrdinalOrCurrent(wanSiteVersion));
                }
            }
            byte epType = dis.readByte();
            int qSize = dis.readInt();
            member = this.readServerMember(dis);
            serverQStatus = new ServerQueueStatus(epType, qSize, member);
            this.readMessage(dis, dos, acceptanceCode, member);
            if (communicationMode != 103 && currentClientVersion.compareTo(Version.GFE_61) >= 0) {
                deltaEnabledOnServer = dis.readBoolean();
            }
            if (communicationMode == 103 && Version.GFE_66.compareTo(conn.getWanSiteVersion()) <= 0 && currentClientVersion.compareTo(Version.GFE_66) >= 0) {
                int remoteDistributedSystemId = in.read();
                int localDistributedSystemId = ((InternalDistributedSystem)this.system).getDistributionManager().getDistributedSystemId();
                if (localDistributedSystemId >= 0 && localDistributedSystemId == remoteDistributedSystemId) {
                    throw new GatewayConfigurationException("Remote WAN site's distributed system id " + remoteDistributedSystemId + " matches this sites distributed system id " + localDistributedSystemId);
                }
            }
            if (communicationMode == 103 && Version.GFE_80.compareTo(conn.getWanSiteVersion()) <= 0 && currentClientVersion.compareTo(Version.GFE_80) >= 0) {
                int remotePdxSize = dis.readInt();
                serverQStatus.setPdxSize(remotePdxSize);
            }
            return serverQStatus;
        }
        catch (IOException ex) {
            CancelCriterion stopper = this.system.getCancelCriterion();
            stopper.checkCancelInProgress(null);
            throw ex;
        }
    }

    public ServerQueueStatus handshakeWithSubscriptionFeed(Socket sock, boolean isPrimary) throws IOException, AuthenticationRequiredException, AuthenticationFailedException, ServerRefusedConnectionException, ClassNotFoundException {
        ServerQueueStatus sqs = null;
        try {
            DataOutputStream dos = new DataOutputStream(sock.getOutputStream());
            InputStream in = sock.getInputStream();
            DataInputStream dis = new DataInputStream(in);
            DistributedMember member = this.getIDForSocket(sock);
            if (!this.multiuserSecureMode) {
                this.credentials = this.getCredentials(member);
            }
            byte mode = isPrimary ? (byte)101 : 102;
            this.write(dos, dis, mode, 59, 0, new ArrayList(), this.credentials, member, true);
            byte acceptanceCode = dis.readByte();
            if (acceptanceCode == 21 && !(sock instanceof SSLSocket)) {
                throw new AuthenticationRequiredException(LocalizedStrings.HandShake_SERVER_EXPECTING_SSL_CONNECTION.toLocalizedString());
            }
            byte qType = dis.readByte();
            int qSize = dis.readInt();
            sqs = new ServerQueueStatus(qType, qSize, member);
            this.readMessage(dis, dos, acceptanceCode, member);
            if (currentClientVersion.compareTo(Version.GFE_61) < 0) {
                return sqs;
            }
            HashMap instantiatorMap = DataSerializer.readHashMap(dis);
            for (Map.Entry instantiator : instantiatorMap.entrySet()) {
                Integer id = (Integer)instantiator.getKey();
                ArrayList instantiatorArguments = (ArrayList)instantiator.getValue();
                InternalInstantiator.register((String)instantiatorArguments.get(0), (String)instantiatorArguments.get(1), (int)id, false);
            }
            HashMap dataSerializersMap = DataSerializer.readHashMap(dis);
            for (Map.Entry dataSerializer : dataSerializersMap.entrySet()) {
                Integer id = (Integer)dataSerializer.getKey();
                InternalDataSerializer.register((String)dataSerializer.getValue(), false, null, null, id);
            }
            HashMap<Integer, ArrayList<String>> dsToSupportedClassNames = DataSerializer.readHashMap(dis);
            InternalDataSerializer.updateSupportedClassesMap(dsToSupportedClassNames);
        }
        catch (IOException ex) {
            CancelCriterion stopper = this.system.getCancelCriterion();
            stopper.checkCancelInProgress(null);
            throw ex;
        }
        catch (ClassNotFoundException ex) {
            CancelCriterion stopper = this.system.getCancelCriterion();
            stopper.checkCancelInProgress(null);
            throw ex;
        }
        return sqs;
    }

    protected DistributedMember readServerMember(DataInputStream p_dis) throws IOException {
        byte[] memberBytes = DataSerializer.readByteArray(p_dis);
        ByteArrayInputStream bais = new ByteArrayInputStream(memberBytes);
        DataInputStream dis = new DataInputStream(bais);
        Version v = InternalDataSerializer.getVersionForDataStreamOrNull(p_dis);
        if (v != null) {
            dis = new VersionedDataInputStream(dis, v);
        }
        try {
            return (DistributedMember)DataSerializer.readObject(dis);
        }
        catch (EOFException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalGemFireException(LocalizedStrings.HandShake_UNABLE_TO_DESERIALIZE_MEMBER.toLocalizedString(), e);
        }
    }

    protected void readMessage(DataInputStream dis, DataOutputStream dos, byte acceptanceCode, DistributedMember member) throws IOException, AuthenticationRequiredException, AuthenticationFailedException, ServerRefusedConnectionException {
        String message = dis.readUTF();
        if (message.length() == 0 && acceptanceCode != 65) {
            return;
        }
        switch (acceptanceCode) {
            case 62: {
                throw new AuthenticationRequiredException(message);
            }
            case 63: {
                throw new AuthenticationFailedException(message);
            }
            case 64: {
                throw new ServerRefusedConnectionException(member, message);
            }
            case 65: {
                this.checkIfAuthenticWanSite(dis, dos, member);
                break;
            }
            default: {
                throw new ServerRefusedConnectionException(member, message);
            }
        }
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    public boolean isRead() {
        return this.isRead;
    }

    @Override
    public boolean isOK() {
        return this.getCode() == 59;
    }

    public void setClientReadTimeout(int clientReadTimeout) {
        this.clientReadTimeout = clientReadTimeout;
    }

    @Override
    public int getClientReadTimeout() {
        return this.clientReadTimeout;
    }

    public void setMultiuserSecureMode(boolean bool) {
        this.multiuserSecureMode = bool;
    }

    public boolean isMultiuserSecureMode() {
        return this.multiuserSecureMode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HandShake)) {
            return false;
        }
        HandShake that = (HandShake)other;
        return this.id.isSameDSMember(that.id) && this.code == that.code;
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = this.id.hashCode();
        result = 37 * result + this.code;
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append("HandShake@").append(System.identityHashCode(this)).append(" code: ").append(this.code);
        if (this.id != null) {
            buf.append(" identity: ");
            buf.append(this.id.toString());
        }
        return buf.toString();
    }

    @Override
    public ClientProxyMembershipID getMembership() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getCredentials(String authInitMethod, Properties securityProperties, DistributedMember server, boolean isPeer, InternalLogWriter logWriter, InternalLogWriter securityLogWriter) throws AuthenticationRequiredException {
        Properties credentials = null;
        if (StringUtils.isBlank((String)authInitMethod)) {
            return SecurityService.getCredentials(securityProperties);
        }
        try {
            auth.init(logWriter, securityLogWriter);
            try (AuthInitialize auth = SecurityService.getObjectOfType(authInitMethod, AuthInitialize.class);){
                credentials = auth.getCredentials(securityProperties, server, isPeer);
            }
        }
        catch (GemFireSecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AuthenticationRequiredException(LocalizedStrings.HandShake_FAILED_TO_ACQUIRE_AUTHINITIALIZE_METHOD_0.toLocalizedString(authInitMethod), ex);
        }
        return credentials;
    }

    private Properties getCredentials(DistributedMember member) {
        String authInitMethod = this.system.getProperties().getProperty("security-client-auth-init");
        return HandShake.getCredentials(authInitMethod, this.system.getSecurityProperties(), member, false, (InternalLogWriter)this.system.getLogWriter(), (InternalLogWriter)this.system.getSecurityLogWriter());
    }

    public static Properties readCredentials(DataInputStream dis, DataOutputStream dos, DistributedSystem system) throws GemFireSecurityException, IOException {
        boolean requireAuthentication = securityService.isClientSecurityRequired();
        Properties credentials = null;
        try {
            byte secureMode = dis.readByte();
            HandShake.throwIfMissingRequiredCredentials(requireAuthentication, secureMode != 0);
            if (secureMode == 1) {
                if (requireAuthentication) {
                    credentials = DataSerializer.readProperties(dis);
                } else {
                    DataSerializer.readProperties(dis);
                }
            } else if (secureMode == 2) {
                boolean sendAuthentication = dis.readBoolean();
                InternalLogWriter securityLogWriter = (InternalLogWriter)system.getSecurityLogWriter();
                String skAlgo = DataSerializer.readString(dis);
                byte[] keyBytes = DataSerializer.readByteArray(dis);
                byte[] challenge = null;
                PublicKey pubKey = null;
                if (requireAuthentication) {
                    Cipher decrypt;
                    X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
                    KeyFactory keyFact = KeyFactory.getInstance("DH");
                    pubKey = keyFact.generatePublic(x509KeySpec);
                    keyBytes = dhPublicKey.getEncoded();
                    challenge = new byte[64];
                    random.nextBytes(challenge);
                    if (sendAuthentication) {
                        byte[] clientChallenge = DataSerializer.readByteArray(dis);
                        if (privateKeyEncrypt == null) {
                            throw new AuthenticationFailedException(LocalizedStrings.HandShake_SERVER_PRIVATE_KEY_NOT_AVAILABLE_FOR_CREATING_SIGNATURE.toLocalizedString());
                        }
                        Signature sig = Signature.getInstance(privateKeySignAlgo);
                        sig.initSign(privateKeyEncrypt);
                        sig.update(clientChallenge);
                        byte[] signedBytes = sig.sign();
                        dos.writeByte(59);
                        DataSerializer.writeByteArray(keyBytes, dos);
                        DataSerializer.writeString(privateKeySubject, dos);
                        DataSerializer.writeByteArray(signedBytes, dos);
                        securityLogWriter.fine("HandShake: sent the signed client challenge");
                    } else {
                        dos.writeByte(59);
                        DataSerializer.writeByteArray(keyBytes, dos);
                    }
                    DataSerializer.writeByteArray(challenge, dos);
                    securityLogWriter.fine("HandShake: sent the public key and challenge");
                    dos.flush();
                    byte[] encBytes = DataSerializer.readByteArray(dis);
                    KeyAgreement ka = KeyAgreement.getInstance("DH");
                    ka.init(dhPrivateKey);
                    ka.doPhase(pubKey, true);
                    int keysize = HandShake.getKeySize(skAlgo);
                    int blocksize = HandShake.getBlockSize(skAlgo);
                    if (keysize == -1 || blocksize == -1) {
                        SecretKey sKey = ka.generateSecret(skAlgo);
                        decrypt = Cipher.getInstance(skAlgo);
                        decrypt.init(2, sKey);
                    } else {
                        String algoStr = HandShake.getDhAlgoStr(skAlgo);
                        byte[] sKeyBytes = ka.generateSecret();
                        SecretKeySpec sks = new SecretKeySpec(sKeyBytes, 0, keysize, algoStr);
                        IvParameterSpec ivps = new IvParameterSpec(sKeyBytes, keysize, blocksize);
                        decrypt = Cipher.getInstance(algoStr + "/CBC/PKCS5Padding");
                        decrypt.init(2, (Key)sks, ivps);
                    }
                    byte[] credentialBytes = decrypt.doFinal(encBytes);
                    ByteArrayInputStream bis = new ByteArrayInputStream(credentialBytes);
                    DataInputStream dinp = new DataInputStream(bis);
                    credentials = DataSerializer.readProperties(dinp);
                    byte[] challengeRes = DataSerializer.readByteArray(dinp);
                    if (!Arrays.equals(challenge, challengeRes)) {
                        throw new AuthenticationFailedException(LocalizedStrings.HandShake_MISMATCH_IN_CHALLENGE_BYTES_MALICIOUS_CLIENT.toLocalizedString());
                    }
                    dinp.close();
                } else {
                    if (sendAuthentication) {
                        DataSerializer.readByteArray(dis);
                    }
                    dos.writeByte(66);
                    dos.flush();
                }
            } else if (secureMode == 3) {
                logger.debug("readCredential where multiuser mode creating callback connection");
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (GemFireSecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AuthenticationFailedException(LocalizedStrings.HandShake_FAILURE_IN_READING_CREDENTIALS.toLocalizedString(), ex);
        }
        return credentials;
    }

    public static Object verifyCredentials(String authenticatorMethod, Properties credentials, Properties securityProperties, InternalLogWriter logWriter, InternalLogWriter securityLogWriter, DistributedMember member) throws AuthenticationRequiredException, AuthenticationFailedException {
        if (!AcceptorImpl.isAuthenticationRequired()) {
            return null;
        }
        try (CacheCallback auth = null;){
            if (AcceptorImpl.isIntegratedSecurity()) {
                Subject subject = securityService.login(credentials);
                return subject;
            }
            Method instanceGetter = ClassLoadUtil.methodFromName(authenticatorMethod);
            auth = (Authenticator)instanceGetter.invoke(null, (Object[])null);
            auth.init(securityProperties, logWriter, securityLogWriter);
            Principal principal = auth.authenticate(credentials, member);
            return principal;
        }
    }

    public Object verifyCredentials() throws AuthenticationRequiredException, AuthenticationFailedException {
        String methodName = this.system.getProperties().getProperty("security-client-authenticator");
        return HandShake.verifyCredentials(methodName, this.credentials, this.system.getSecurityProperties(), (InternalLogWriter)this.system.getLogWriter(), (InternalLogWriter)this.system.getSecurityLogWriter(), this.id.getDistributedMember());
    }

    public void sendCredentialsForWan(OutputStream out, InputStream in) {
        try {
            Properties wanCredentials = this.getCredentials(this.id.getDistributedMember());
            DataOutputStream dos = new DataOutputStream(out);
            DataInputStream dis = new DataInputStream(in);
            this.writeCredentials(dos, dis, wanCredentials, false, this.system.getDistributedMember());
        }
        catch (Exception e) {
            this.system.getSecurityLogWriter().convertToLogWriterI18n().severe(LocalizedStrings.HandShake_AN_EXCEPTION_WAS_THROWN_WHILE_SENDING_WAN_CREDENTIALS_0, e.getLocalizedMessage());
        }
    }

    private void checkIfAuthenticWanSite(DataInputStream dis, DataOutputStream dos, DistributedMember member) throws GemFireSecurityException, IOException {
        if (this.credentials == null) {
            return;
        }
        String authenticator = this.system.getProperties().getProperty("security-client-authenticator");
        Properties peerWanProps = HandShake.readCredentials(dis, dos, this.system);
        HandShake.verifyCredentials(authenticator, peerWanProps, this.system.getSecurityProperties(), (InternalLogWriter)this.system.getLogWriter(), (InternalLogWriter)this.system.getSecurityLogWriter(), member);
    }

    private static int getKeySize(String skAlgo) {
        String algoStr;
        int colIdx = skAlgo.indexOf(58);
        int algoKeySize = 0;
        if (colIdx >= 0) {
            algoStr = skAlgo.substring(0, colIdx);
            algoKeySize = Integer.parseInt(skAlgo.substring(colIdx + 1));
        } else {
            algoStr = skAlgo;
        }
        int keysize = -1;
        if (algoStr.equalsIgnoreCase("DESede")) {
            keysize = 24;
        } else if (algoStr.equalsIgnoreCase("Blowfish")) {
            keysize = algoKeySize > 128 ? algoKeySize / 8 : 16;
        } else if (algoStr.equalsIgnoreCase("AES")) {
            keysize = algoKeySize != 192 && algoKeySize != 256 ? 16 : algoKeySize / 8;
        }
        return keysize;
    }

    private static String getDhAlgoStr(String skAlgo) {
        int colIdx = skAlgo.indexOf(58);
        String algoStr = colIdx >= 0 ? skAlgo.substring(0, colIdx) : skAlgo;
        return algoStr;
    }

    private static int getBlockSize(String skAlgo) {
        int blocksize = -1;
        String algoStr = HandShake.getDhAlgoStr(skAlgo);
        if (algoStr.equalsIgnoreCase("DESede")) {
            blocksize = 8;
        } else if (algoStr.equalsIgnoreCase("Blowfish")) {
            blocksize = 8;
        } else if (algoStr.equalsIgnoreCase("AES")) {
            blocksize = 16;
        }
        return blocksize;
    }

    @Override
    public Version getVersion() {
        return this.clientVersion;
    }

    public static boolean isDeltaEnabledOnServer() {
        return deltaEnabledOnServer;
    }

    public boolean hasCredentials() {
        return this.credentials != null;
    }
}

