/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.offheap.AddressableMemoryManager;
import org.apache.geode.internal.offheap.StoredObject;

public class Part {
    private static final byte BYTE_CODE = 0;
    private static final byte OBJECT_CODE = 1;
    private Version version;
    private static final byte EMPTY_BYTEARRAY_CODE = 2;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private Object part;
    private byte typeCode;
    private static final Map<Integer, byte[]> CACHED_INTS = new ConcurrentHashMap<Integer, byte[]>();

    public void init(byte[] v, byte tc) {
        this.part = tc == 2 ? (Object)EMPTY_BYTE_ARRAY : (Object)v;
        this.typeCode = tc;
    }

    public void clear() {
        if (this.part != null) {
            if (this.part instanceof HeapDataOutputStream) {
                ((HeapDataOutputStream)this.part).close();
            }
            this.part = null;
        }
        this.typeCode = 0;
    }

    public boolean isNull() {
        byte[] b;
        if (this.part == null) {
            return true;
        }
        return this.isObject() && this.part instanceof byte[] && (b = (byte[])this.part).length == 1 && b[0] == 41;
    }

    public boolean isObject() {
        return this.typeCode == 1;
    }

    public boolean isBytes() {
        return this.typeCode == 0 || this.typeCode == 2;
    }

    public void setPartState(byte[] b, boolean isObject) {
        if (isObject) {
            this.typeCode = 1;
        } else if (b != null && b.length == 0) {
            this.typeCode = (byte)2;
            b = EMPTY_BYTE_ARRAY;
        } else {
            this.typeCode = 0;
        }
        this.part = b;
    }

    public void setPartState(HeapDataOutputStream os, boolean isObject) {
        if (isObject) {
            this.typeCode = 1;
            this.part = os;
        } else if (os != null && os.size() == 0) {
            this.typeCode = (byte)2;
            this.part = EMPTY_BYTE_ARRAY;
        } else {
            this.typeCode = 0;
            this.part = os;
        }
    }

    public void setPartState(StoredObject so, boolean isObject) {
        if (isObject) {
            this.typeCode = 1;
        } else {
            if (so.getDataSize() == 0) {
                this.typeCode = (byte)2;
                this.part = EMPTY_BYTE_ARRAY;
                return;
            }
            this.typeCode = 0;
        }
        this.part = so.hasRefCount() ? so : (Object)so.getValueAsHeapByteArray();
    }

    public byte getTypeCode() {
        return this.typeCode;
    }

    public int getLength() {
        if (this.part == null) {
            return 0;
        }
        if (this.part instanceof byte[]) {
            return ((byte[])this.part).length;
        }
        if (this.part instanceof StoredObject) {
            return ((StoredObject)this.part).getDataSize();
        }
        return ((HeapDataOutputStream)this.part).size();
    }

    public String getString() {
        if (this.part == null) {
            return null;
        }
        if (!this.isBytes()) {
            Assert.assertTrue(false, "expected String part to be of type BYTE, part =" + this.toString());
        }
        return CacheServerHelper.fromUTF((byte[])this.part);
    }

    public int getInt() {
        if (!this.isBytes()) {
            Assert.assertTrue(false, "expected int part to be of type BYTE, part = " + this.toString());
        }
        if (this.getLength() != 4) {
            Assert.assertTrue(false, "expected int length to be 4 but it was " + this.getLength() + "; part = " + this.toString());
        }
        byte[] bytes = this.getSerializedForm();
        return Part.decodeInt(bytes, 0);
    }

    public static int decodeInt(byte[] bytes, int offset) {
        return bytes[offset + 0] << 24 & 0xFF000000 | bytes[offset + 1] << 16 & 0xFF0000 | bytes[offset + 2] << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
    }

    public void setInt(int v) {
        byte[] bytes = CACHED_INTS.get(v);
        if (bytes == null) {
            bytes = new byte[4];
            Part.encodeInt(v, bytes);
            CACHED_INTS.put(v, bytes);
        }
        this.typeCode = 0;
        this.part = bytes;
    }

    public static void encodeInt(int v, byte[] bytes) {
        Part.encodeInt(v, bytes, 0);
    }

    public static void encodeInt(int v, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)((v & 0xFF000000) >> 24);
        bytes[offset + 1] = (byte)((v & 0xFF0000) >> 16);
        bytes[offset + 2] = (byte)((v & 0xFF00) >> 8);
        bytes[offset + 3] = (byte)(v & 0xFF);
    }

    public void setLong(long v) {
        byte[] bytes = new byte[]{(byte)((v & 0xFF00000000000000L) >> 56), (byte)((v & 0xFF000000000000L) >> 48), (byte)((v & 0xFF0000000000L) >> 40), (byte)((v & 0xFF00000000L) >> 32), (byte)((v & 0xFF000000L) >> 24), (byte)((v & 0xFF0000L) >> 16), (byte)((v & 0xFF00L) >> 8), (byte)(v & 0xFFL)};
        this.typeCode = 0;
        this.part = bytes;
    }

    public long getLong() {
        if (!this.isBytes()) {
            Assert.assertTrue(false, "expected long part to be of type BYTE, part = " + this.toString());
        }
        if (this.getLength() != 8) {
            Assert.assertTrue(false, "expected long length to be 8 but it was " + this.getLength() + "; part = " + this.toString());
        }
        byte[] bytes = this.getSerializedForm();
        return (long)bytes[0] << 56 & 0xFF00000000000000L | (long)bytes[1] << 48 & 0xFF000000000000L | (long)bytes[2] << 40 & 0xFF0000000000L | (long)bytes[3] << 32 & 0xFF00000000L | (long)bytes[4] << 24 & 0xFF000000L | (long)bytes[5] << 16 & 0xFF0000L | (long)bytes[6] << 8 & 0xFF00L | (long)bytes[7] & 0xFFL;
    }

    public byte[] getSerializedForm() {
        if (this.part == null) {
            return null;
        }
        if (this.part instanceof byte[]) {
            return (byte[])this.part;
        }
        return null;
    }

    public Object getObject(boolean unzip) throws IOException, ClassNotFoundException {
        if (this.isBytes()) {
            return this.part;
        }
        if (this.version != null) {
            return CacheServerHelper.deserialize((byte[])this.part, this.version, unzip);
        }
        return CacheServerHelper.deserialize((byte[])this.part, unzip);
    }

    public Object getObject() throws IOException, ClassNotFoundException {
        return this.getObject(false);
    }

    public Object getStringOrObject() throws IOException, ClassNotFoundException {
        if (this.isObject()) {
            return this.getObject();
        }
        return this.getString();
    }

    public void writeTo(OutputStream out, ByteBuffer buf) throws IOException {
        if (this.getLength() > 0) {
            if (this.part instanceof byte[]) {
                byte[] bytes = (byte[])this.part;
                out.write(bytes, 0, bytes.length);
            } else if (this.part instanceof StoredObject) {
                StoredObject so = (StoredObject)this.part;
                ByteBuffer sobb = so.createDirectByteBuffer();
                if (sobb != null) {
                    HeapDataOutputStream.writeByteBufferToStream(out, buf, sobb);
                } else {
                    int bytesToSend;
                    long addr = so.getAddressForReadingData(0, bytesToSend);
                    for (bytesToSend = so.getDataSize(); bytesToSend > 0; --bytesToSend) {
                        if (buf.remaining() == 0) {
                            HeapDataOutputStream.flushStream(out, buf);
                        }
                        buf.put(AddressableMemoryManager.readByte(addr));
                        ++addr;
                    }
                }
            } else {
                HeapDataOutputStream hdos = (HeapDataOutputStream)this.part;
                hdos.sendTo(out, buf);
                hdos.rewind();
            }
        }
    }

    public void writeTo(ByteBuffer buf) {
        if (this.getLength() > 0) {
            if (this.part instanceof byte[]) {
                buf.put((byte[])this.part);
            } else if (this.part instanceof StoredObject) {
                StoredObject c = (StoredObject)this.part;
                ByteBuffer bb = c.createDirectByteBuffer();
                if (bb != null) {
                    buf.put(bb);
                } else {
                    int bytesToSend;
                    long addr = c.getAddressForReadingData(0, bytesToSend);
                    for (bytesToSend = c.getDataSize(); bytesToSend > 0; --bytesToSend) {
                        buf.put(AddressableMemoryManager.readByte(addr));
                        ++addr;
                    }
                }
            } else {
                HeapDataOutputStream hdos = (HeapDataOutputStream)this.part;
                hdos.sendTo(buf);
                hdos.rewind();
            }
        }
    }

    public void writeTo(SocketChannel sc, ByteBuffer buf) throws IOException {
        if (this.getLength() > 0) {
            int BUF_MAX = buf.capacity();
            if (this.part instanceof byte[]) {
                byte[] bytes = (byte[])this.part;
                int off = 0;
                int len = bytes.length;
                buf.clear();
                while (len > 0) {
                    int bytesThisTime = len;
                    if (bytesThisTime > BUF_MAX) {
                        bytesThisTime = BUF_MAX;
                    }
                    buf.put(bytes, off, bytesThisTime);
                    len -= bytesThisTime;
                    off += bytesThisTime;
                    buf.flip();
                    while (buf.remaining() > 0) {
                        sc.write(buf);
                    }
                    buf.clear();
                }
            } else if (this.part instanceof StoredObject) {
                StoredObject c = (StoredObject)this.part;
                ByteBuffer bb = c.createDirectByteBuffer();
                if (bb != null) {
                    while (bb.remaining() > 0) {
                        sc.write(bb);
                    }
                } else {
                    int len = c.getDataSize();
                    long addr = c.getAddressForReadingData(0, len);
                    buf.clear();
                    while (len > 0) {
                        int bytesThisTime = len;
                        if (bytesThisTime > BUF_MAX) {
                            bytesThisTime = BUF_MAX;
                        }
                        len -= bytesThisTime;
                        while (bytesThisTime > 0) {
                            buf.put(AddressableMemoryManager.readByte(addr));
                            ++addr;
                            --bytesThisTime;
                        }
                        buf.flip();
                        while (buf.remaining() > 0) {
                            sc.write(buf);
                        }
                        buf.clear();
                    }
                }
            } else {
                HeapDataOutputStream hdos = (HeapDataOutputStream)this.part;
                hdos.sendTo(sc, buf);
                hdos.rewind();
            }
        }
    }

    private static String typeCodeToString(byte c) {
        switch (c) {
            case 0: {
                return "BYTE_CODE";
            }
            case 1: {
                return "OBJECT_CODE";
            }
            case 2: {
                return "EMPTY_BYTEARRAY_CODE";
            }
        }
        return "unknown code " + c;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("partCode=");
        sb.append(Part.typeCodeToString(this.typeCode));
        sb.append(" partLength=" + this.getLength());
        return sb.toString();
    }

    public void setVersion(Version clientVersion) {
        this.version = clientVersion;
    }
}

