/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.logging.log4j.Logger;

public class AddPdxType
extends BaseCommand {
    private static final Logger logger = LogService.getLogger();
    private static final AddPdxType singleton = new AddPdxType();

    public static Command getCommand() {
        return singleton;
    }

    private AddPdxType() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException, ClassNotFoundException {
        serverConnection.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get pdx id for type request ({} parts) from {}", (Object)serverConnection.getName(), (Object)clientMessage.getNumberOfParts(), (Object)serverConnection.getSocketString());
        }
        int noOfParts = clientMessage.getNumberOfParts();
        PdxType type = (PdxType)clientMessage.getPart(0).getObject();
        int typeId = clientMessage.getPart(1).getInt();
        type.setTypeId(typeId);
        try {
            InternalCache cache = serverConnection.getCache();
            TypeRegistry registry = cache.getPdxRegistry();
            registry.addRemoteType(typeId, type);
        }
        catch (Exception e) {
            AddPdxType.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        this.writeReply(clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
    }
}

