/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.security.NotAuthorizedException;

public class ContainsKey
extends BaseCommand {
    private static final ContainsKey singleton = new ContainsKey();

    public static Command getCommand() {
        return singleton;
    }

    private static void writeContainsKeyResponse(boolean containsKey, Message origMsg, ServerConnection servConn) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        responseMsg.addObjPart(containsKey ? Boolean.TRUE : Boolean.FALSE);
        responseMsg.send(servConn);
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException {
        Part regionNamePart = null;
        Part keyPart = null;
        String regionName = null;
        Object key = null;
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadContainsKeyRequestTime(start - oldStart);
        regionNamePart = clientMessage.getPart(0);
        keyPart = clientMessage.getPart(1);
        regionName = regionNamePart.getString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            ContainsKey.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received containsKey request ({} bytes) from {} for region {} key {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)regionName, key);
        }
        if (key == null || regionName == null) {
            String errMessage = "";
            if (key == null) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ContainsKey_0_THE_INPUT_KEY_FOR_THE_CONTAINSKEY_REQUEST_IS_NULL, serverConnection.getName()));
                errMessage = LocalizedStrings.ContainsKey_THE_INPUT_KEY_FOR_THE_CONTAINSKEY_REQUEST_IS_NULL.toLocalizedString();
            }
            if (regionName == null) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ContainsKey_0_THE_INPUT_REGION_NAME_FOR_THE_CONTAINSKEY_REQUEST_IS_NULL, serverConnection.getName()));
                errMessage = LocalizedStrings.ContainsKey_THE_INPUT_REGION_NAME_FOR_THE_CONTAINSKEY_REQUEST_IS_NULL.toLocalizedString();
            }
            ContainsKey.writeErrorResponse(clientMessage, 39, errMessage, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
        if (region == null) {
            String reason = LocalizedStrings.ContainsKey_WAS_NOT_FOUND_DURING_CONTAINSKEY_REQUEST.toLocalizedString();
            ContainsKey.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            this.securityService.authorizeRegionRead(regionName, key.toString());
        }
        catch (NotAuthorizedException ex) {
            ContainsKey.writeException(clientMessage, ex, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
        if (authzRequest != null) {
            try {
                authzRequest.containsKeyAuthorize(regionName, key);
            }
            catch (NotAuthorizedException ex) {
                ContainsKey.writeException(clientMessage, ex, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        boolean containsKey = region.containsKey(key);
        long oldStart2 = start;
        start = DistributionStats.getStatTime();
        stats.incProcessContainsKeyTime(start - oldStart2);
        ContainsKey.writeContainsKeyResponse(containsKey, clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent containsKey response for region {} key {}", (Object)serverConnection.getName(), (Object)regionName, key);
        }
        stats.incWriteContainsKeyResponseTime(DistributionStats.getStatTime() - start);
    }
}

