/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.BucketServerLocation;
import org.apache.geode.internal.cache.BucketServerLocation66;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;

public class GetClientPRMetadataCommand
extends BaseCommand {
    private static final GetClientPRMetadataCommand singleton = new GetClientPRMetadataCommand();

    public static Command getCommand() {
        return singleton;
    }

    private GetClientPRMetadataCommand() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException, ClassNotFoundException, InterruptedException {
        String regionFullPath = null;
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        regionFullPath = clientMessage.getPart(0).getString();
        String errMessage = "";
        if (regionFullPath == null) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.GetClientPRMetadata_THE_INPUT_REGION_PATH_IS_NULL));
            errMessage = LocalizedStrings.GetClientPRMetadata_THE_INPUT_REGION_PATH_IS_NULL.toLocalizedString();
            GetClientPRMetadataCommand.writeErrorResponse(clientMessage, 75, errMessage.toString(), serverConnection);
            serverConnection.setAsTrue(1);
        } else {
            Region region = crHelper.getRegion(regionFullPath);
            if (region == null) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.GetClientPRMetadata_REGION_NOT_FOUND_FOR_SPECIFIED_REGION_PATH, regionFullPath));
                errMessage = LocalizedStrings.GetClientPRMetadata_REGION_NOT_FOUND.toLocalizedString() + regionFullPath;
                GetClientPRMetadataCommand.writeErrorResponse(clientMessage, 75, errMessage.toString(), serverConnection);
                serverConnection.setAsTrue(1);
            } else {
                try {
                    Message responseMsg = serverConnection.getResponseMessage();
                    responseMsg.setTransactionId(clientMessage.getTransactionId());
                    responseMsg.setMessageType(72);
                    PartitionedRegion prRgion = (PartitionedRegion)region;
                    Map<Integer, List<BucketServerLocation66>> bucketToServerLocations = prRgion.getRegionAdvisor().getAllClientBucketProfiles();
                    responseMsg.setNumberOfParts(bucketToServerLocations.size());
                    for (List<BucketServerLocation66> serverLocations : bucketToServerLocations.values()) {
                        ArrayList<BucketServerLocation> oldServerLocations = new ArrayList<BucketServerLocation>();
                        for (BucketServerLocation66 bs : serverLocations) {
                            oldServerLocations.add(new BucketServerLocation(bs.getBucketId(), bs.getPort(), bs.getHostName(), bs.isPrimary(), bs.getVersion()));
                            responseMsg.addObjPart(oldServerLocations);
                        }
                    }
                    responseMsg.send();
                    clientMessage.clearParts();
                }
                catch (Exception e) {
                    GetClientPRMetadataCommand.writeException(clientMessage, e, false, serverConnection);
                }
                finally {
                    serverConnection.setAsTrue(1);
                }
            }
        }
    }
}

