/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;

public class GetClientPartitionAttributesCommand
extends BaseCommand {
    private static final GetClientPartitionAttributesCommand singleton = new GetClientPartitionAttributesCommand();

    public static Command getCommand() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException, ClassNotFoundException, InterruptedException {
        String regionFullPath = null;
        regionFullPath = clientMessage.getPart(0).getString();
        String errMessage = "";
        if (regionFullPath == null) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.GetClientPartitionAttributes_THE_INPUT_REGION_PATH_IS_NULL));
            errMessage = LocalizedStrings.GetClientPartitionAttributes_THE_INPUT_REGION_PATH_IS_NULL.toLocalizedString();
            GetClientPartitionAttributesCommand.writeErrorResponse(clientMessage, 76, errMessage.toString(), serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        Region region = serverConnection.getCache().getRegion(regionFullPath);
        if (region == null) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.GetClientPartitionAttributes_REGION_NOT_FOUND_FOR_SPECIFIED_REGION_PATH, regionFullPath));
            errMessage = LocalizedStrings.GetClientPartitionAttributes_REGION_NOT_FOUND.toLocalizedString() + regionFullPath;
            GetClientPartitionAttributesCommand.writeErrorResponse(clientMessage, 76, errMessage.toString(), serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            Message responseMsg = serverConnection.getResponseMessage();
            responseMsg.setTransactionId(clientMessage.getTransactionId());
            responseMsg.setMessageType(74);
            PartitionedRegion prRgion = (PartitionedRegion)region;
            PartitionResolver partitionResolver = prRgion.getPartitionResolver();
            int numParts = 2;
            if (partitionResolver != null) {
                ++numParts;
            }
            responseMsg.setNumberOfParts(numParts);
            responseMsg.addObjPart(prRgion.getTotalNumberOfBuckets());
            if (partitionResolver != null) {
                responseMsg.addObjPart(partitionResolver.getClass().toString().substring(6));
            }
            String leaderRegionPath = null;
            PartitionedRegion leaderRegion = null;
            String leaderRegionName = prRgion.getColocatedWith();
            if (leaderRegionName != null) {
                InternalCache cache = prRgion.getCache();
                while (leaderRegionName != null) {
                    leaderRegion = (PartitionedRegion)cache.getRegion(leaderRegionName);
                    if (leaderRegion.getColocatedWith() == null) {
                        leaderRegionPath = leaderRegion.getFullPath();
                        break;
                    }
                    leaderRegionName = leaderRegion.getColocatedWith();
                }
            }
            responseMsg.addObjPart(leaderRegionPath);
            responseMsg.send();
            clientMessage.clearParts();
        }
        catch (Exception e) {
            GetClientPartitionAttributesCommand.writeException(clientMessage, e, false, serverConnection);
        }
        finally {
            serverConnection.setAsTrue(1);
        }
    }
}

