/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class GetFunctionAttribute
extends BaseCommand {
    private static final GetFunctionAttribute singleton = new GetFunctionAttribute();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException {
        serverConnection.setAsTrue(2);
        String functionId = clientMessage.getPart(0).getString();
        if (functionId == null) {
            String message = LocalizedStrings.GetFunctionAttribute_THE_INPUT_0_FOR_GET_FUNCTION_ATTRIBUTE_REQUEST_IS_NULL.toLocalizedString("functionId");
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
            this.sendError(clientMessage, message, serverConnection);
            return;
        }
        Function function = FunctionService.getFunction(functionId);
        if (function == null) {
            String message = null;
            message = LocalizedStrings.GetFunctionAttribute_THE_FUNCTION_IS_NOT_REGISTERED_FOR_FUNCTION_ID_0.toLocalizedString(functionId);
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
            this.sendError(clientMessage, message, serverConnection);
            return;
        }
        byte[] functionAttributes = new byte[]{(byte)(function.hasResult() ? 1 : 0), (byte)(function.isHA() ? 1 : 0), (byte)(function.optimizeForWrite() ? 1 : 0)};
        GetFunctionAttribute.writeResponseWithFunctionAttribute(functionAttributes, clientMessage, serverConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError(Message msg, String message, ServerConnection servConn) throws IOException {
        Message message2 = msg;
        synchronized (message2) {
            GetFunctionAttribute.writeErrorResponse(msg, 3, message, servConn);
            servConn.setAsTrue(1);
        }
    }
}

