/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.security.GemFireSecurityException;

public class RemoveUserAuth
extends BaseCommand {
    private static final RemoveUserAuth singleton = new RemoveUserAuth();

    public static Command getCommand() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException, ClassNotFoundException, InterruptedException {
        boolean isSecureMode = clientMessage.isSecureMode();
        if (!isSecureMode) {
            return;
        }
        try {
            serverConnection.setAsTrue(2);
            Part keepalivePart = clientMessage.getPart(0);
            byte[] keepaliveByte = keepalivePart.getSerializedForm();
            boolean keepalive = keepaliveByte != null && keepaliveByte[0] != 0;
            serverConnection.getSecurityLogWriter().fine("remove user auth keep alive " + keepalive);
            serverConnection.removeUserAuth(clientMessage, keepalive);
            this.writeReply(clientMessage, serverConnection);
        }
        catch (GemFireSecurityException gfse) {
            if (serverConnection.getSecurityLogWriter().warningEnabled()) {
                serverConnection.getSecurityLogWriter().warning(LocalizedStrings.ONE_ARG, serverConnection.getName() + ": Security exception: " + gfse.getMessage());
            }
            RemoveUserAuth.writeException(clientMessage, gfse, false, serverConnection);
        }
        catch (Exception ex) {
            if (serverConnection.getLogWriter().warningEnabled()) {
                serverConnection.getLogWriter().warning(LocalizedStrings.CacheClientNotifier_AN_EXCEPTION_WAS_THROWN_FOR_CLIENT_0_1, new Object[]{serverConnection.getProxyID(), ""}, (Throwable)ex);
            }
            RemoveUserAuth.writeException(clientMessage, ex, false, serverConnection);
        }
        finally {
            serverConnection.setAsTrue(1);
        }
    }
}

