/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.CancelException;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TransactionDataNodeHasDepartedException;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.cache.TransactionDataRebalancedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.BucketNotFoundException;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionStats;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.PutAllPartialResultException;
import org.apache.geode.internal.cache.TXStateStub;
import org.apache.geode.internal.cache.partitioned.PutAllPRMessage;
import org.apache.geode.internal.cache.partitioned.RemoteSizeMessage;
import org.apache.geode.internal.cache.partitioned.RemoveAllPRMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.AbstractPeerTXRegionStub;
import org.apache.geode.internal.cache.tx.TXRegionStub;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class PartitionedTXRegionStub
extends AbstractPeerTXRegionStub {
    private Map<Integer, Boolean> buckets = new HashMap<Integer, Boolean>();

    public PartitionedTXRegionStub(TXStateStub txstate, LocalRegion r) {
        super(txstate, r);
    }

    public Map<Integer, Boolean> getBuckets() {
        return this.buckets;
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) {
        PartitionedRegion pr = (PartitionedRegion)event.getLocalRegion();
        try {
            pr.destroyRemotely(this.state.getTarget(), event.getKeyInfo().getBucketId(), event, expectedOldValue);
        }
        catch (TransactionException e) {
            RuntimeException re = this.getTransactionException(event.getKeyInfo(), e);
            re.initCause(e.getCause());
            throw re;
        }
        catch (PrimaryBucketException e) {
            RuntimeException re = this.getTransactionException(event.getKeyInfo(), e);
            re.initCause(e);
            throw re;
        }
        catch (ForceReattemptException e) {
            TransactionException re = this.isBucketNotFoundException(e) ? new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString()) : new TransactionDataNodeHasDepartedException(LocalizedStrings.PartitionedRegion_TRANSACTION_DATA_NODE_0_HAS_DEPARTED_TO_PROCEED_ROLLBACK_THIS_TRANSACTION_AND_BEGIN_A_NEW_ONE.toLocalizedString(this.state.getTarget()));
            re.initCause(e);
            this.waitToRetry();
            throw re;
        }
        this.trackBucketForTx(event.getKeyInfo());
    }

    private RuntimeException getTransactionException(KeyInfo keyInfo, Throwable cause) {
        Throwable ex;
        this.region.getCancelCriterion().checkCancelInProgress(cause);
        for (ex = cause; ex != null; ex = ex.getCause()) {
            if (!(ex instanceof CacheClosedException)) continue;
            return new TransactionDataNodeHasDepartedException(ex.getMessage());
        }
        if (this.isKeyInNonColocatedBucket(keyInfo)) {
            return new TransactionDataNotColocatedException(LocalizedStrings.PartitionedRegion_KEY_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(keyInfo.getKey()));
        }
        for (ex = cause; ex != null; ex = ex.getCause()) {
            if (!(ex instanceof PrimaryBucketException) && !(ex instanceof BucketNotFoundException)) continue;
            return new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString());
        }
        return new TransactionDataNodeHasDepartedException(cause.getLocalizedMessage());
    }

    private boolean isKeyInNonColocatedBucket(KeyInfo keyInfo) {
        Map<Region<?, ?>, TXRegionStub> regionStubs = this.state.getRegionStubs();
        Collection<PartitionedRegion> colcatedRegions = ColocationHelper.getAllColocationRegions((PartitionedRegion)this.region).values();
        for (PartitionedRegion colcatedRegion : colcatedRegions) {
            PartitionedTXRegionStub regionStub = (PartitionedTXRegionStub)regionStubs.get(colcatedRegion);
            if (regionStub == null) continue;
            this.buckets.putAll(regionStub.getBuckets());
        }
        return keyInfo != null && !this.buckets.isEmpty() && !this.buckets.containsKey(keyInfo.getBucketId());
    }

    private void waitToRetry() {
        new PartitionedRegion.RetryTimeKeeper(2000).waitForBucketsRecovery();
    }

    @Override
    public Region.Entry getEntry(KeyInfo keyInfo, boolean allowTombstones) {
        PartitionedRegion pr = (PartitionedRegion)this.region;
        try {
            EntrySnapshot e = pr.getEntryRemotely((InternalDistributedMember)this.state.getTarget(), keyInfo.getBucketId(), keyInfo.getKey(), false, allowTombstones);
            this.trackBucketForTx(keyInfo);
            return e;
        }
        catch (EntryNotFoundException enfe) {
            return null;
        }
        catch (TransactionException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e.getCause());
            throw re;
        }
        catch (PrimaryBucketException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e);
            throw re;
        }
        catch (ForceReattemptException e) {
            TransactionException re = this.isBucketNotFoundException(e) ? new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString()) : new TransactionDataNodeHasDepartedException(LocalizedStrings.PartitionedRegion_TRANSACTION_DATA_NODE_0_HAS_DEPARTED_TO_PROCEED_ROLLBACK_THIS_TRANSACTION_AND_BEGIN_A_NEW_ONE.toLocalizedString(this.state.getTarget()));
            re.initCause(e);
            this.waitToRetry();
            throw re;
        }
    }

    private void trackBucketForTx(KeyInfo keyInfo) {
        if (this.region.getCache().getLoggerI18n().fineEnabled()) {
            this.region.getCache().getLoggerI18n().fine("adding bucket:" + keyInfo.getBucketId() + " for tx:" + this.state.getTransactionId());
        }
        if (keyInfo.getBucketId() >= 0) {
            this.buckets.put(keyInfo.getBucketId(), Boolean.TRUE);
        }
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        PartitionedRegion pr = (PartitionedRegion)event.getLocalRegion();
        try {
            pr.invalidateRemotely(this.state.getTarget(), event.getKeyInfo().getBucketId(), event);
        }
        catch (TransactionException e) {
            RuntimeException re = this.getTransactionException(event.getKeyInfo(), e);
            re.initCause(e.getCause());
            throw re;
        }
        catch (PrimaryBucketException e) {
            RuntimeException re = this.getTransactionException(event.getKeyInfo(), e);
            re.initCause(e);
            throw re;
        }
        catch (ForceReattemptException e) {
            TransactionException re = this.isBucketNotFoundException(e) ? new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString()) : new TransactionDataNodeHasDepartedException(LocalizedStrings.PartitionedRegion_TRANSACTION_DATA_NODE_0_HAS_DEPARTED_TO_PROCEED_ROLLBACK_THIS_TRANSACTION_AND_BEGIN_A_NEW_ONE.toLocalizedString(this.state.getTarget()));
            re.initCause(e);
            this.waitToRetry();
            throw re;
        }
        this.trackBucketForTx(event.getKeyInfo());
    }

    @Override
    public boolean containsKey(KeyInfo keyInfo) {
        PartitionedRegion pr = (PartitionedRegion)this.region;
        try {
            boolean retVal = pr.containsKeyRemotely((InternalDistributedMember)this.state.getTarget(), keyInfo.getBucketId(), keyInfo.getKey());
            this.trackBucketForTx(keyInfo);
            return retVal;
        }
        catch (TransactionException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e.getCause());
            throw re;
        }
        catch (PrimaryBucketException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e);
            throw re;
        }
        catch (ForceReattemptException e) {
            if (this.isBucketNotFoundException(e)) {
                RuntimeException re = this.getTransactionException(keyInfo, e);
                re.initCause(e);
                throw re;
            }
            this.waitToRetry();
            TransactionDataNodeHasDepartedException re = new TransactionDataNodeHasDepartedException(LocalizedStrings.PartitionedRegion_TRANSACTION_DATA_NODE_0_HAS_DEPARTED_TO_PROCEED_ROLLBACK_THIS_TRANSACTION_AND_BEGIN_A_NEW_ONE.toLocalizedString(this.state.getTarget()));
            re.initCause(e);
            throw re;
        }
    }

    private boolean isBucketNotFoundException(ForceReattemptException e) {
        ForceReattemptException fre = e;
        while (fre.getCause() != null && fre.getCause() instanceof ForceReattemptException) {
            fre = (ForceReattemptException)fre.getCause();
        }
        return fre instanceof BucketNotFoundException;
    }

    @Override
    public boolean containsValueForKey(KeyInfo keyInfo) {
        PartitionedRegion pr = (PartitionedRegion)this.region;
        try {
            boolean retVal = pr.containsValueForKeyRemotely((InternalDistributedMember)this.state.getTarget(), keyInfo.getBucketId(), keyInfo.getKey());
            this.trackBucketForTx(keyInfo);
            return retVal;
        }
        catch (TransactionException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e.getCause());
            throw re;
        }
        catch (PrimaryBucketException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e);
            throw re;
        }
        catch (ForceReattemptException e) {
            if (this.isBucketNotFoundException(e)) {
                RuntimeException re = this.getTransactionException(keyInfo, e);
                re.initCause(e);
                throw re;
            }
            this.waitToRetry();
            TransactionDataNodeHasDepartedException re = new TransactionDataNodeHasDepartedException(LocalizedStrings.PartitionedRegion_TRANSACTION_DATA_NODE_0_HAS_DEPARTED_TO_PROCEED_ROLLBACK_THIS_TRANSACTION_AND_BEGIN_A_NEW_ONE.toLocalizedString(this.state.getTarget()));
            re.initCause(e);
            throw re;
        }
    }

    @Override
    public Object findObject(KeyInfo keyInfo, boolean isCreate, boolean generateCallbacks, Object value, boolean peferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent) {
        Object retVal = null;
        Object key = keyInfo.getKey();
        Object callbackArgument = keyInfo.getCallbackArg();
        PartitionedRegion pr = (PartitionedRegion)this.region;
        try {
            retVal = pr.getRemotely((InternalDistributedMember)this.state.getTarget(), keyInfo.getBucketId(), key, callbackArgument, peferCD, requestingClient, clientEvent, false);
        }
        catch (TransactionException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e.getCause());
            throw re;
        }
        catch (PrimaryBucketException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e);
            throw re;
        }
        catch (ForceReattemptException e) {
            if (this.isBucketNotFoundException(e)) {
                RuntimeException re = this.getTransactionException(keyInfo, e);
                re.initCause(e);
                throw re;
            }
            this.waitToRetry();
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e);
            throw re;
        }
        this.trackBucketForTx(keyInfo);
        return retVal;
    }

    @Override
    public Object getEntryForIterator(KeyInfo keyInfo, boolean allowTombstones) {
        PartitionedRegion pr = (PartitionedRegion)this.region;
        InternalDistributedMember primary = pr.getBucketPrimary(keyInfo.getBucketId());
        if (primary.equals(this.state.getTarget())) {
            return this.getEntry(keyInfo, allowTombstones);
        }
        return pr.getSharedDataView().getEntry(keyInfo, pr, allowTombstones);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        boolean retVal = false;
        LocalRegion r = event.getLocalRegion();
        PartitionedRegion pr = (PartitionedRegion)r;
        try {
            retVal = pr.putRemotely(this.state.getTarget(), event, ifNew, ifOld, expectedOldValue, requireOldValue);
        }
        catch (TransactionException e) {
            RuntimeException re = this.getTransactionException(event.getKeyInfo(), e);
            re.initCause(e.getCause());
            throw re;
        }
        catch (PrimaryBucketException e) {
            RuntimeException re = this.getTransactionException(event.getKeyInfo(), e);
            re.initCause(e);
            throw re;
        }
        catch (ForceReattemptException e) {
            this.waitToRetry();
            RuntimeException re = this.getTransactionException(event.getKeyInfo(), e);
            re.initCause(e);
            throw re;
        }
        this.trackBucketForTx(event.getKeyInfo());
        return retVal;
    }

    @Override
    public int entryCount() {
        try {
            RemoteSizeMessage.SizeResponse response = RemoteSizeMessage.send(Collections.singleton(this.state.getTarget()), this.region);
            return response.waitForSize();
        }
        catch (Exception e) {
            throw this.getTransactionException(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postPutAll(DistributedPutAllOperation putallO, VersionedObjectList successfulPuts, LocalRegion r) throws TransactionException {
        if (r.getCache().isCacheAtShutdownAll()) {
            throw new CacheClosedException("Cache is shutting down");
        }
        PartitionedRegion pr = (PartitionedRegion)r;
        long startTime = PartitionedRegionStats.startTime();
        HashMap prMsgMap = putallO.createPRMessages();
        PutAllPartialResultException.PutAllPartialResult partialKeys = new PutAllPartialResultException.PutAllPartialResult(putallO.putAllDataSize);
        successfulPuts.clear();
        for (Map.Entry mapEntry : prMsgMap.entrySet()) {
            Integer bucketId = (Integer)mapEntry.getKey();
            PutAllPRMessage prMsg = (PutAllPRMessage)mapEntry.getValue();
            pr.checkReadiness();
            try {
                VersionedObjectList versions = this.sendMsgByBucket(bucketId, prMsg, pr);
                partialKeys.addKeysAndVersions(versions);
                successfulPuts.addAll(versions);
            }
            catch (PutAllPartialResultException pre) {
                partialKeys.consolidate(pre.getResult());
            }
            catch (Exception ex) {
                EntryEventImpl firstEvent = prMsg.getFirstEvent(pr);
                try {
                    partialKeys.saveFailedKey(firstEvent.getKey(), ex);
                }
                finally {
                    firstEvent.release();
                }
            }
        }
        pr.prStats.endPutAll(startTime);
        if (partialKeys.hasFailure()) {
            pr.getCache().getLoggerI18n().info(LocalizedStrings.Region_PutAll_Applied_PartialKeys_0_1, new Object[]{pr.getFullPath(), partialKeys});
            if (putallO.isBridgeOperation()) {
                if (partialKeys.getFailure() instanceof CancelException) {
                    throw (CancelException)partialKeys.getFailure();
                }
                throw new PutAllPartialResultException(partialKeys);
            }
            if (partialKeys.getFailure() instanceof RuntimeException) {
                throw (RuntimeException)partialKeys.getFailure();
            }
            throw new RuntimeException(partialKeys.getFailure());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRemoveAll(DistributedRemoveAllOperation op, VersionedObjectList successfulOps, LocalRegion r) {
        if (r.getCache().isCacheAtShutdownAll()) {
            throw new CacheClosedException("Cache is shutting down");
        }
        PartitionedRegion pr = (PartitionedRegion)r;
        long startTime = PartitionedRegionStats.startTime();
        HashMap<Integer, RemoveAllPRMessage> prMsgMap = op.createPRMessages();
        PutAllPartialResultException.PutAllPartialResult partialKeys = new PutAllPartialResultException.PutAllPartialResult(op.removeAllDataSize);
        successfulOps.clear();
        for (Map.Entry<Integer, RemoveAllPRMessage> mapEntry : prMsgMap.entrySet()) {
            Integer bucketId = mapEntry.getKey();
            RemoveAllPRMessage prMsg = mapEntry.getValue();
            pr.checkReadiness();
            try {
                VersionedObjectList versions = this.sendMsgByBucket(bucketId, prMsg, pr);
                partialKeys.addKeysAndVersions(versions);
                successfulOps.addAll(versions);
            }
            catch (PutAllPartialResultException pre) {
                partialKeys.consolidate(pre.getResult());
            }
            catch (Exception ex) {
                EntryEventImpl firstEvent = prMsg.getFirstEvent(pr);
                try {
                    partialKeys.saveFailedKey(firstEvent.getKey(), ex);
                }
                finally {
                    firstEvent.release();
                }
            }
        }
        pr.prStats.endRemoveAll(startTime);
        if (partialKeys.hasFailure()) {
            pr.getCache().getLoggerI18n().info(LocalizedStrings.Region_RemoveAll_Applied_PartialKeys_0_1, new Object[]{pr.getFullPath(), partialKeys});
            if (op.isBridgeOperation()) {
                if (partialKeys.getFailure() instanceof CancelException) {
                    throw (CancelException)partialKeys.getFailure();
                }
                throw new PutAllPartialResultException(partialKeys);
            }
            if (partialKeys.getFailure() instanceof RuntimeException) {
                throw (RuntimeException)partialKeys.getFailure();
            }
            throw new RuntimeException(partialKeys.getFailure());
        }
    }

    private VersionedObjectList sendMsgByBucket(Integer bucketId, PutAllPRMessage prMsg, PartitionedRegion pr) {
        InternalDistributedMember currentTarget = pr.getOrCreateNodeForBucketWrite(bucketId, null);
        if (!currentTarget.equals(this.state.getTarget())) {
            EntryEventImpl firstEvent = prMsg.getFirstEvent(pr);
            try {
                throw new TransactionDataNotColocatedException(LocalizedStrings.PartitionedRegion_KEY_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(firstEvent.getKey()));
            }
            catch (Throwable throwable) {
                firstEvent.release();
                throw throwable;
            }
        }
        try {
            return pr.tryToSendOnePutAllMessage(prMsg, currentTarget);
        }
        catch (ForceReattemptException prce) {
            pr.checkReadiness();
            throw new TransactionDataNotColocatedException(prce.getMessage());
        }
        catch (PrimaryBucketException notPrimary) {
            TransactionDataRebalancedException re = new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString());
            re.initCause(notPrimary);
            throw re;
        }
        catch (DataLocationException dle) {
            throw new TransactionException(dle);
        }
    }

    private VersionedObjectList sendMsgByBucket(Integer bucketId, RemoveAllPRMessage prMsg, PartitionedRegion pr) {
        InternalDistributedMember currentTarget = pr.getOrCreateNodeForBucketWrite(bucketId, null);
        if (!currentTarget.equals(this.state.getTarget())) {
            EntryEventImpl firstEvent = prMsg.getFirstEvent(pr);
            try {
                throw new TransactionDataNotColocatedException(LocalizedStrings.PartitionedRegion_KEY_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(firstEvent.getKey()));
            }
            catch (Throwable throwable) {
                firstEvent.release();
                throw throwable;
            }
        }
        try {
            return pr.tryToSendOneRemoveAllMessage(prMsg, currentTarget);
        }
        catch (ForceReattemptException prce) {
            pr.checkReadiness();
            throw new TransactionDataNotColocatedException(prce.getMessage());
        }
        catch (PrimaryBucketException notPrimary) {
            TransactionDataRebalancedException re = new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString());
            re.initCause(notPrimary);
            throw re;
        }
        catch (DataLocationException dle) {
            throw new TransactionException(dle);
        }
    }

    @Override
    public void cleanup() {
    }
}

