/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.versions;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.geode.CancelCriterion;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.versions.DiskRegionVersionVector;
import org.apache.geode.internal.cache.versions.RegionVersionHolder;
import org.apache.geode.internal.cache.versions.VMRegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class RegionVersionVector<T extends VersionSource<?>>
implements DataSerializableFixedID,
MembershipListener {
    private static final Logger logger = LogService.getLogger();
    public static boolean DEBUG = Boolean.getBoolean("gemfire.VersionVector.VERBOSE");
    public static long MAX_DOMINANCE_WAIT_TIME = Long.getLong("gemfire.max-dominance-wait-time", 5000L);
    public static long DOMINANCE_PAUSE_TIME = Math.min(Long.getLong("gemfire.dominance-pause-time", 300L), MAX_DOMINANCE_WAIT_TIME);
    private static int INITIAL_CAPACITY = 2;
    private static int CONCURRENCY_LEVEL = 2;
    private static float LOAD_FACTOR = 0.75f;
    private ConcurrentHashMap<T, RegionVersionHolder<T>> memberToVersion;
    private AtomicLong localVersion = new AtomicLong(0L);
    private RegionVersionHolder<T> localExceptions;
    private AtomicLong localGCVersion = new AtomicLong(0L);
    private T myId;
    private boolean singleMember;
    private transient boolean isLiveVector;
    private transient String regionName;
    private ConcurrentHashMap<T, Long> memberToGCVersion;
    private transient Map<T, T> canonicalIds = Collections.EMPTY_MAP;
    private final Object canonicalIdLock = new Object();
    private transient boolean recordingDisabled;
    private transient boolean clientVector;
    private final transient ReentrantReadWriteLock versionLock = new ReentrantReadWriteLock();
    private volatile transient boolean locked;
    private volatile transient boolean doUnlock;
    private transient InternalDistributedMember lockOwner;
    private final transient Object clearLockSync = new Object();

    public RegionVersionVector(T ownerId) {
        this(ownerId, null);
    }

    public RegionVersionVector(T ownerId, LocalRegion owner) {
        this.myId = ownerId;
        this.isLiveVector = true;
        this.regionName = owner == null ? "" : "region " + owner.getFullPath();
        this.localExceptions = new RegionVersionHolder<long>(0L);
        this.memberToVersion = new ConcurrentHashMap(INITIAL_CAPACITY, LOAD_FACTOR, CONCURRENCY_LEVEL);
        this.memberToGCVersion = new ConcurrentHashMap(INITIAL_CAPACITY, LOAD_FACTOR, CONCURRENCY_LEVEL);
    }

    public RegionVersionVector<T> getCloneForTransmission() {
        HashMap<T, RegionVersionHolder<T>> liveHolders = new HashMap<T, RegionVersionHolder<T>>(this.memberToVersion);
        ConcurrentHashMap clonedHolders = new ConcurrentHashMap(liveHolders.size(), LOAD_FACTOR, CONCURRENCY_LEVEL);
        for (Map.Entry entry : liveHolders.entrySet()) {
            clonedHolders.put(entry.getKey(), ((RegionVersionHolder)entry.getValue()).clone());
        }
        ConcurrentHashMap<T, Long> gcVersions = new ConcurrentHashMap<T, Long>(this.memberToGCVersion.size(), LOAD_FACTOR, CONCURRENCY_LEVEL);
        gcVersions.putAll(this.memberToGCVersion);
        Object clonedLocalHolder = this.localExceptions.clone();
        return this.createCopy(this.myId, clonedHolders, this.localVersion.get(), gcVersions, this.localGCVersion.get(), false, (RegionVersionHolder<T>)clonedLocalHolder);
    }

    protected abstract RegionVersionVector<T> createCopy(T var1, ConcurrentHashMap<T, RegionVersionHolder<T>> var2, long var3, ConcurrentHashMap<T, Long> var5, long var6, boolean var8, RegionVersionHolder<T> var9);

    public RegionVersionVector<T> getCloneForTransmission(T mbr) {
        HashMap<T, RegionVersionHolder<T>> liveHolders = new HashMap<T, RegionVersionHolder<T>>(this.memberToVersion);
        Object holder = (RegionVersionHolder)liveHolders.get(mbr);
        holder = holder == null ? new RegionVersionHolder<long>(-1L) : ((RegionVersionHolder)holder).clone();
        return this.createCopy(this.myId, new ConcurrentHashMap<T, RegionVersionHolder<long>>(Collections.singletonMap(mbr, holder)), 0L, new ConcurrentHashMap(INITIAL_CAPACITY, LOAD_FACTOR, CONCURRENCY_LEVEL), 0L, true, new RegionVersionHolder<long>(-1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<T, Long> getTombstoneGCVector() {
        HashMap<T, Long> result;
        ConcurrentHashMap<T, Long> concurrentHashMap = this.memberToGCVersion;
        synchronized (concurrentHashMap) {
            result = new HashMap<T, Long>(this.memberToGCVersion);
        }
        if (this.localGCVersion.get() != 0L) {
            result.put(this.myId, this.localGCVersion.get());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTombstoneGCVersions(Map<T, Long> regionGCVersions) {
        Long myVersion = regionGCVersions.get(this.myId);
        if (myVersion != null && this.localGCVersion.get() < myVersion) {
            return false;
        }
        ConcurrentHashMap<T, Long> concurrentHashMap = this.memberToGCVersion;
        synchronized (concurrentHashMap) {
            for (Map.Entry<T, Long> entry : regionGCVersions.entrySet()) {
                Long version = this.memberToGCVersion.get(entry.getKey());
                if (version != null && version >= entry.getValue()) continue;
                return false;
            }
        }
        return true;
    }

    public long lockForClear(String regionPath, DM dm, InternalDistributedMember locker) {
        this.lockVersionGeneration(regionPath, dm, locker);
        return this.localVersion.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockForClear(InternalDistributedMember locker) {
        Object object = this.clearLockSync;
        synchronized (object) {
            InternalDistributedSystem instance = InternalDistributedSystem.getAnyInstance();
            if (instance != null && logger.isDebugEnabled()) {
                logger.debug("Unlocking for clear, from member {} RVV {}", (Object)locker, (Object)System.identityHashCode(this));
            }
            if (this.lockOwner != null && !locker.equals(this.lockOwner)) {
                if (instance != null && logger.isDebugEnabled()) {
                    logger.debug("current clear lock owner was {} not unlocking", (Object)this.lockOwner);
                }
                return;
            }
            this.unlockVersionGeneration(locker);
        }
    }

    private void lockVersionGeneration(final String regionPath, final DM dm, final InternalDistributedMember locker) {
        final CountDownLatch acquiredLock = new CountDownLatch(1);
        if (logger.isDebugEnabled()) {
            logger.debug("Locking version generation for {} region {} RVV {}", (Object)locker, (Object)regionPath, (Object)System.identityHashCode(this));
        }
        dm.getWaitingThreadPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @SuppressWarnings(value={"UL_UNRELEASED_LOCK", "IMSE_DONT_CATCH_IMSE"})
            public void run() {
                boolean haveLock = false;
                Object object = RegionVersionVector.this.clearLockSync;
                synchronized (object) {
                    try {
                        while (RegionVersionVector.this.locked && dm.isCurrentMember(locker)) {
                            try {
                                RegionVersionVector.this.clearLockSync.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Waiting thread is now locking version generation for {} region {} RVV {}", (Object)locker, (Object)regionPath, (Object)System.identityHashCode(this));
                        }
                        try {
                            RegionVersionVector.this.versionLock.writeLock().lock();
                            RegionVersionVector.this.lockOwner = locker;
                            RegionVersionVector.this.doUnlock = false;
                            RegionVersionVector.this.locked = true;
                            haveLock = true;
                            acquiredLock.countDown();
                        }
                        catch (IllegalMonitorStateException e) {
                            logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.RVV_LOCKING_CONFUSED, new Object[]{locker, RegionVersionVector.this.lockOwner}));
                            if (haveLock) {
                                RegionVersionVector.this.locked = false;
                                RegionVersionVector.this.versionLock.writeLock().unlock();
                                RegionVersionVector.this.doUnlock = false;
                                RegionVersionVector.this.clearLockSync.notifyAll();
                            }
                            acquiredLock.countDown();
                            return;
                        }
                        while (!RegionVersionVector.this.doUnlock && dm.isCurrentMember(locker)) {
                            try {
                                RegionVersionVector.this.clearLockSync.wait(250L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    finally {
                        if (haveLock) {
                            RegionVersionVector.this.locked = false;
                            RegionVersionVector.this.versionLock.writeLock().unlock();
                            RegionVersionVector.this.doUnlock = false;
                            RegionVersionVector.this.clearLockSync.notifyAll();
                        }
                        acquiredLock.countDown();
                    }
                }
            }
        });
        boolean interrupted = false;
        while (dm.isCurrentMember(locker)) {
            try {
                if (!acquiredLock.await(250L, TimeUnit.MILLISECONDS)) continue;
                break;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Done locking");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockVersionGeneration(InternalDistributedMember locker) {
        Object object = this.clearLockSync;
        synchronized (object) {
            this.doUnlock = true;
            this.clearLockSync.notifyAll();
        }
    }

    public long getNextVersion() {
        return this.getNextVersion(true);
    }

    public long getNextVersionWhileLocked() {
        return this.getNextVersion(false);
    }

    private long getNextVersion(boolean checkLocked) {
        if (checkLocked && this.locked && logger.isDebugEnabled()) {
            logger.debug("Generating a version tag when version generation is locked by {}", (Object)this.lockOwner);
        }
        long new_version = this.localVersion.incrementAndGet();
        this.recordVersion(this.getOwnerId(), new_version);
        return new_version;
    }

    public void lockForCacheModification(LocalRegion owner) {
        if (owner.getServerProxy() == null) {
            this.versionLock.readLock().lock();
        }
    }

    public void releaseCacheModificationLock(LocalRegion owner) {
        if (owner.getServerProxy() == null) {
            this.versionLock.readLock().unlock();
        }
    }

    public void lockForCacheModification() {
        this.versionLock.readLock().lock();
    }

    public void releaseCacheModificationLock() {
        this.versionLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncLocalVersion() {
        long v = this.localVersion.get();
        RegionVersionHolder<T> regionVersionHolder = this.localExceptions;
        synchronized (regionVersionHolder) {
            if (v != this.localExceptions.version) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Adjust localExceptions.version {} to equal localVersion {}", (Object)this.localExceptions.version, (Object)this.localVersion.get());
                }
                this.localExceptions.version = v;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentVersion() {
        RegionVersionHolder<T> regionVersionHolder = this.localExceptions;
        synchronized (regionVersionHolder) {
            this.syncLocalVersion();
            return this.localExceptions.getVersion();
        }
    }

    public RegionVersionHolder<T> getLocalExceptions() {
        return this.localExceptions;
    }

    public RegionVersionHolder<T> getHolderForMember(T id) {
        if (id.equals(this.myId)) {
            return this.localExceptions;
        }
        return this.memberToVersion.get(id);
    }

    public T getOwnerId() {
        return this.myId;
    }

    public void turnOffRecordingForEmptyRegion() {
        this.recordingDisabled = true;
    }

    public void setIsClientVector() {
        this.clientVector = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordVersions(RegionVersionVector<T> otherVector) {
        ConcurrentHashMap<T, RegionVersionHolder<T>> concurrentHashMap = this.memberToVersion;
        synchronized (concurrentHashMap) {
            for (Map.Entry<T, RegionVersionHolder<T>> entry : otherVector.getMemberToVersion().entrySet()) {
                VersionSource mbr = (VersionSource)entry.getKey();
                RegionVersionHolder<T> otherHolder = entry.getValue();
                this.initializeVersionHolder(mbr, otherHolder);
            }
            super.syncLocalVersion();
            this.initializeVersionHolder(otherVector.getOwnerId(), otherVector.localExceptions);
            if (otherVector.getCurrentVersion() > 0L && !this.memberToVersion.containsKey(otherVector.getOwnerId())) {
                this.recordVersion(otherVector.getOwnerId(), otherVector.getCurrentVersion());
            }
            for (VersionSource mbr : this.memberToVersion.keySet()) {
                if (otherVector.memberToVersion.containsKey(mbr) || mbr.equals(otherVector.getOwnerId())) continue;
                RegionVersionHolder<T> holder = this.memberToVersion.get(mbr);
                this.initializeVersionHolder(mbr, new RegionVersionHolder<long>(0L));
            }
            if (!otherVector.memberToVersion.containsKey(this.myId) && !this.myId.equals(otherVector.getOwnerId())) {
                this.initializeVersionHolder(this.myId, new RegionVersionHolder<long>(0L));
            }
            ConcurrentHashMap<T, Long> concurrentHashMap2 = this.memberToGCVersion;
            synchronized (concurrentHashMap2) {
                for (Map.Entry<T, Long> entry : otherVector.getMemberToGCVersion().entrySet()) {
                    VersionSource member = (VersionSource)entry.getKey();
                    Long value = entry.getValue();
                    if (member.equals(this.myId)) {
                        long currentValue;
                        while ((currentValue = this.localGCVersion.get()) < value) {
                            this.localGCVersion.compareAndSet(currentValue, value);
                        }
                        continue;
                    }
                    Long myVersion = this.memberToGCVersion.get(entry.getKey());
                    if (myVersion != null && myVersion >= entry.getValue()) continue;
                    this.memberToGCVersion.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public void initializeVersionHolder(T mbr, RegionVersionHolder<T> otherHolder) {
        RegionVersionHolder<T> h = this.memberToVersion.get(mbr);
        if (h == null) {
            if (!mbr.equals(this.myId)) {
                h = otherHolder.clone();
                h.makeReadyForRecording();
                this.memberToVersion.put(mbr, h);
            } else {
                RegionVersionHolder<T> vh = otherHolder;
                long version = vh.version;
                this.updateLocalVersion(version);
                this.localExceptions.initializeFrom(vh);
            }
        } else {
            h.initializeFrom(otherHolder);
        }
    }

    private void updateLocalVersion(long version) {
        boolean repeat = false;
        do {
            long myVersion;
            if ((myVersion = this.localVersion.get()) >= version) continue;
            boolean bl = repeat = !this.localVersion.compareAndSet(myVersion, version);
        } while (repeat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordVersion(T mbr, VersionTag<T> tag) {
        tag.setRecorded();
        assert (tag.isRecorded());
        T member = tag.getMemberID();
        if (member == null) {
            member = mbr;
        }
        if (this.myId.equals(member)) {
            RegionVersionHolder<T> regionVersionHolder = this.localExceptions;
            synchronized (regionVersionHolder) {
                if (this.localVersion.get() < tag.getRegionVersion()) {
                    Assert.fail("recordVersion invoked for a local version tag that is higher than our local version. rvv=" + this + ", tag=" + tag + " " + this.regionName);
                }
            }
        }
        this.recordVersion(member, tag.getRegionVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordVersion(T member, long version) {
        RegionVersionHolder<T> holder;
        T mbr = member;
        if (this.recordingDisabled || this.clientVector) {
            return;
        }
        if (mbr.equals(this.myId)) {
            RegionVersionHolder<T> regionVersionHolder = holder = this.localExceptions;
            synchronized (regionVersionHolder) {
                holder.version = this.localVersion.get();
            }
            this.updateLocalVersion(version);
        } else {
            holder = this.memberToVersion.get(mbr);
            if (holder == null) {
                ConcurrentHashMap<T, RegionVersionHolder<T>> concurrentHashMap = this.memberToVersion;
                synchronized (concurrentHashMap) {
                    holder = this.memberToVersion.get(mbr);
                    if (holder == null) {
                        mbr = this.getCanonicalId(mbr);
                        holder = new RegionVersionHolder<T>(mbr);
                        this.memberToVersion.put(holder.id, holder);
                    }
                }
            }
        }
        if (logger.isTraceEnabled(LogMarker.RVV)) {
            logger.trace(LogMarker.RVV, "Recording rv{} for {}", (Object)version, mbr);
        }
        holder.recordVersion(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"ML_SYNC_ON_FIELD_TO_GUARD_CHANGING_THAT_FIELD"}, justification="sync on localExceptions guards concurrent modification but this is a replacement")
    public void initRecoveredVersion(T member, RegionVersionHolder<T> v, boolean latestOplog) {
        Object recovered = v.clone();
        if (member == null || member.equals(this.myId)) {
            RegionVersionHolder<T> regionVersionHolder = this.localExceptions;
            synchronized (regionVersionHolder) {
                if (latestOplog || this.localVersion.get() == 0L) {
                    this.localExceptions = recovered;
                    if (logger.isTraceEnabled(LogMarker.RVV)) {
                        logger.trace(LogMarker.RVV, "initRecoveredVersion setting local version to {}", (Object)((RegionVersionHolder)recovered).version);
                    }
                    this.localVersion.set(((RegionVersionHolder)recovered).version);
                }
            }
        }
        Long gcVersion = this.memberToGCVersion.get(member);
        ConcurrentHashMap<T, RegionVersionHolder<T>> concurrentHashMap = this.memberToVersion;
        synchronized (concurrentHashMap) {
            RegionVersionHolder<T> oldVersion = this.memberToVersion.get(member);
            if (latestOplog || oldVersion == null || oldVersion.version == 0L) {
                if (gcVersion != null) {
                    ((RegionVersionHolder)recovered).removeExceptionsOlderThan(gcVersion);
                }
                this.memberToVersion.put(member, (RegionVersionHolder<T>)recovered);
            }
        }
    }

    public long getVersionForMember(T mbr) {
        RegionVersionHolder<T> holder = this.memberToVersion.get(mbr);
        if (holder == null) {
            if (mbr.equals(this.myId)) {
                return this.getCurrentVersion();
            }
            return 0L;
        }
        return holder.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> getDepartedMembersSet() {
        ConcurrentHashMap<T, RegionVersionHolder<T>> concurrentHashMap = this.memberToVersion;
        synchronized (concurrentHashMap) {
            HashSet<VersionSource> result = new HashSet<VersionSource>();
            for (RegionVersionHolder<T> h : this.memberToVersion.values()) {
                if (!h.isDepartedMember) continue;
                result.add((VersionSource)h.id);
            }
            return result;
        }
    }

    public boolean contains(T id, long version) {
        if (id.equals(this.myId)) {
            if (this.getCurrentVersion() < version) {
                return false;
            }
            return !this.localExceptions.hasExceptionFor(version);
        }
        RegionVersionHolder<T> holder = this.memberToVersion.get(id);
        if (holder == null) {
            return this.singleMember;
        }
        return holder.contains(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOldMembers(Set<VersionSource<T>> idsToKeep) {
        ConcurrentHashMap<T, RegionVersionHolder<T>> concurrentHashMap = this.memberToVersion;
        synchronized (concurrentHashMap) {
            Iterator<Map.Entry<T, RegionVersionHolder<T>>> it = this.memberToVersion.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<T, RegionVersionHolder<T>> entry = it.next();
                if (!entry.getValue().isDepartedMember || idsToKeep.contains(entry.getKey())) continue;
                it.remove();
                this.memberToGCVersion.remove(entry.getKey());
                Object object = this.canonicalIdLock;
                synchronized (object) {
                    this.canonicalIds.remove(entry.getKey());
                }
            }
        }
    }

    public boolean containsMember(T id) {
        if (this.memberToVersion.containsKey(id)) {
            return true;
        }
        if (this.memberToGCVersion.containsKey(id)) {
            return true;
        }
        return this.canonicalIds.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markDepartedMember(T id) {
        ConcurrentHashMap<T, RegionVersionHolder<T>> concurrentHashMap = this.memberToVersion;
        synchronized (concurrentHashMap) {
            RegionVersionHolder<T> holder = this.memberToVersion.get(id);
            if (holder != null) {
                holder.isDepartedMember = true;
            }
        }
    }

    public boolean hasHigherTombstoneGCVersions(RegionVersionVector<T> other) {
        if (this.localGCVersion.get() > 0L) {
            Long version = other.memberToGCVersion.get(this.myId);
            if (version == null) {
                return true;
            }
            if (this.localGCVersion.get() > version) {
                return true;
            }
        }
        for (VersionSource versionSource : this.memberToGCVersion.keySet()) {
            if (other.memberToGCVersion.containsKey(versionSource) || versionSource.equals(other.getOwnerId())) continue;
            return true;
        }
        for (VersionSource versionSource : other.memberToGCVersion.keySet()) {
            if (versionSource.equals(this.myId) || this.memberToGCVersion.containsKey(versionSource)) continue;
            return true;
        }
        for (Map.Entry entry : other.memberToGCVersion.entrySet()) {
            Long version = this.memberToGCVersion.get(entry.getKey());
            if (version == null) continue;
            Long otherVersion = (Long)entry.getValue();
            if (version <= otherVersion) continue;
            return true;
        }
        return false;
    }

    public boolean isNewerThanOrCanFillExceptionsFor(RegionVersionVector<T> other) {
        if (other.singleMember) {
            Map.Entry<T, RegionVersionHolder<T>> entry = other.memberToVersion.entrySet().iterator().next();
            RegionVersionHolder<T> holder = this.memberToVersion.get(entry.getKey());
            if (holder == null) {
                return false;
            }
            RegionVersionHolder<T> otherHolder = entry.getValue();
            return holder.isNewerThanOrCanFillExceptionsFor(otherHolder);
        }
        if (this.getCurrentVersion() > 0L) {
            RegionVersionHolder<T> otherHolder = other.memberToVersion.get(this.myId);
            if (otherHolder == null) {
                return true;
            }
            if (this.localExceptions.isNewerThanOrCanFillExceptionsFor(otherHolder)) {
                return true;
            }
        }
        for (Map.Entry<T, RegionVersionHolder<T>> entry : this.memberToVersion.entrySet()) {
            VersionSource mbr = (VersionSource)entry.getKey();
            RegionVersionHolder<T> holder = entry.getValue();
            RegionVersionHolder<T> otherHolder = other.memberToVersion.get(mbr);
            if (otherHolder != null) {
                if (!holder.isNewerThanOrCanFillExceptionsFor(otherHolder)) continue;
                return true;
            }
            if (mbr.equals(other.getOwnerId())) {
                if (!holder.isNewerThanOrCanFillExceptionsFor(other.localExceptions)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isGCVersionDominatedByHolder(Long gcVersion, RegionVersionHolder<T> otherHolder) {
        if (gcVersion == null || gcVersion == 0L) {
            return true;
        }
        RegionVersionHolder<long> holder = new RegionVersionHolder<long>(gcVersion.longValue());
        return !holder.isNewerThanOrCanFillExceptionsFor(otherHolder);
    }

    public synchronized boolean isRVVGCDominatedBy(RegionVersionVector<T> other) {
        if (other.singleMember) {
            Map.Entry<T, RegionVersionHolder<T>> entry = other.memberToVersion.entrySet().iterator().next();
            Long gcVersion = this.memberToGCVersion.get(entry.getKey());
            return this.isGCVersionDominatedByHolder(gcVersion, entry.getValue());
        }
        boolean isDominatedByRemote = true;
        long localgcversion = this.localGCVersion.get();
        if (localgcversion > 0L) {
            RegionVersionHolder<T> otherHolder = other.memberToVersion.get(this.myId);
            isDominatedByRemote = this.isGCVersionDominatedByHolder(localgcversion, otherHolder);
            if (!isDominatedByRemote) {
                return false;
            }
        }
        for (Map.Entry<T, Long> entry : this.memberToGCVersion.entrySet()) {
            VersionSource mbr = (VersionSource)entry.getKey();
            Long gcVersion = entry.getValue();
            RegionVersionHolder<T> otherHolder = null;
            otherHolder = mbr.equals(other.getOwnerId()) ? this.localExceptions : other.memberToVersion.get(mbr);
            isDominatedByRemote = this.isGCVersionDominatedByHolder(gcVersion, otherHolder);
            if (isDominatedByRemote) continue;
            return false;
        }
        return isDominatedByRemote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToDominate(RegionVersionVector<T> otherVector, LocalRegion region) {
        if (otherVector == this) {
            return true;
        }
        boolean result = false;
        long waitTimeRemaining = 0L;
        long startTime = System.currentTimeMillis();
        boolean interrupted = false;
        CancelCriterion stopper = region.getCancelCriterion();
        try {
            do {
                stopper.checkCancelInProgress(null);
                result = this.dominates(otherVector);
                if (result) continue;
                long now = System.currentTimeMillis();
                waitTimeRemaining = MAX_DOMINANCE_WAIT_TIME - (now - startTime);
                if (logger.isTraceEnabled()) {
                    logger.trace("Waiting up to {} ms to achieve dominance", (Object)waitTimeRemaining);
                }
                if (waitTimeRemaining <= 0L) continue;
                long waitTime = Math.min(DOMINANCE_PAUSE_TIME, waitTimeRemaining);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e) {
                    stopper.checkCancelInProgress(e);
                    interrupted = true;
                    break;
                }
            } while (waitTimeRemaining > 0L && !result);
        }
        finally {
            if (interrupted) {
                if (logger.isTraceEnabled()) {
                    logger.trace("waitForDominance has been interrupted");
                }
                Thread.currentThread().interrupt();
            }
        }
        return result;
    }

    public boolean dominates(RegionVersionVector<T> other) {
        return !other.isNewerThanOrCanFillExceptionsFor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExceptionsFor(DistributedMember mbr, long version) {
        RegionVersionHolder<T> holder = this.memberToVersion.get(mbr);
        if (holder != null) {
            RegionVersionHolder<T> regionVersionHolder = holder;
            synchronized (regionVersionHolder) {
                holder.removeExceptionsOlderThan(version);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOldVersions() {
        ConcurrentHashMap<T, RegionVersionHolder<T>> concurrentHashMap = this.memberToVersion;
        synchronized (concurrentHashMap) {
            long currentVersion = this.getCurrentVersion();
            for (Map.Entry<T, RegionVersionHolder<T>> entry : this.memberToVersion.entrySet()) {
                RegionVersionHolder<T> holder = entry.getValue();
                VersionSource id = (VersionSource)entry.getKey();
                holder.removeExceptionsOlderThan(holder.version);
                this.memberToGCVersion.put(id, holder.version);
            }
            this.localGCVersion.set(this.getCurrentVersion());
            if (this.localExceptions != null) {
                RegionVersionHolder<T> regionVersionHolder = this.localExceptions;
                synchronized (regionVersionHolder) {
                    this.localExceptions.removeExceptionsOlderThan(currentVersion);
                }
            }
        }
    }

    public int getExceptionCount(T mbr) {
        if (mbr.equals(this.myId)) {
            return this.localExceptions.getExceptionCount();
        }
        RegionVersionHolder<T> h = this.memberToVersion.get(mbr);
        if (h == null) {
            throw new IllegalStateException("there should be a holder for " + mbr);
        }
        return h.getExceptionCount();
    }

    protected RegionVersionVector(T ownerId, ConcurrentHashMap<T, RegionVersionHolder<T>> vector, long version, ConcurrentHashMap<T, Long> gcVersions, long gcVersion, boolean singleMember, RegionVersionHolder<T> localExceptions) {
        this.myId = ownerId;
        this.memberToVersion = vector;
        this.memberToGCVersion = gcVersions;
        this.localGCVersion.set(gcVersion);
        this.localVersion.set(version);
        this.singleMember = singleMember;
        this.localExceptions = localExceptions;
    }

    public RegionVersionVector() {
        this.memberToVersion = new ConcurrentHashMap(INITIAL_CAPACITY, LOAD_FACTOR, CONCURRENCY_LEVEL);
        this.memberToGCVersion = new ConcurrentHashMap(INITIAL_CAPACITY, LOAD_FACTOR, CONCURRENCY_LEVEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getCanonicalId(T id) {
        InternalDistributedSystem system;
        if (id == null) {
            return null;
        }
        if (id.equals(this.myId)) {
            return this.myId;
        }
        Object can = id;
        VersionSource cId = (VersionSource)this.canonicalIds.get(can);
        if (cId != null) {
            return (T)cId;
        }
        if (id instanceof InternalDistributedMember && (system = InternalDistributedSystem.getConnectedInstance()) != null) {
            can = system.getDistributionManager().getCanonicalId((InternalDistributedMember)id);
        }
        Object object = this.canonicalIdLock;
        synchronized (object) {
            HashMap<T, T> tmp = new HashMap<T, T>(this.canonicalIds);
            tmp.put(can, can);
            this.canonicalIds = tmp;
        }
        return can;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (this.isLiveVector) {
            throw new IllegalStateException("serialization of this object is not allowed");
        }
        this.writeMember(this.myId, out);
        int flags = 0;
        if (this.singleMember) {
            flags |= 1;
        }
        out.writeInt(flags);
        out.writeLong(this.localVersion.get());
        out.writeLong(this.localGCVersion.get());
        out.writeInt(this.memberToVersion.size());
        for (Map.Entry<T, RegionVersionHolder<T>> entry : this.memberToVersion.entrySet()) {
            this.writeMember((VersionSource)entry.getKey(), out);
            InternalDataSerializer.invokeToData(entry.getValue(), out);
        }
        out.writeInt(this.memberToGCVersion.size());
        for (Map.Entry<T, Serializable> entry : this.memberToGCVersion.entrySet()) {
            this.writeMember((VersionSource)entry.getKey(), out);
            out.writeLong((Long)entry.getValue());
        }
        InternalDataSerializer.invokeToData(this.localExceptions, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.myId = this.readMember(in);
        int flags = in.readInt();
        this.singleMember = (flags & 1) == 1;
        this.localVersion.set(in.readLong());
        this.localGCVersion.set(in.readLong());
        int numHolders = in.readInt();
        for (int i = 0; i < numHolders; ++i) {
            T key = this.readMember(in);
            RegionVersionHolder holder = new RegionVersionHolder(in);
            holder.id = key;
            this.memberToVersion.put(key, holder);
        }
        int numGCVersions = in.readInt();
        for (int i = 0; i < numGCVersions; ++i) {
            Object key = this.readMember(in);
            RegionVersionHolder<T> holder = this.memberToVersion.get(key);
            if (holder != null) {
                key = (VersionSource)holder.id;
            }
            long value = in.readLong();
            this.memberToGCVersion.put(key, value);
        }
        this.localExceptions = new RegionVersionHolder(in);
    }

    protected abstract void writeMember(T var1, DataOutput var2) throws IOException;

    protected abstract T readMember(DataInput var1) throws IOException, ClassNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordGCVersion(T mbr, long regionVersion) {
        if (mbr == null) {
            mbr = this.myId;
        }
        this.recordVersion(mbr, regionVersion);
        if (mbr == null || mbr.equals(this.myId)) {
            boolean succeeded;
            long v;
            while ((v = this.localGCVersion.get()) <= regionVersion && !(succeeded = this.localGCVersion.compareAndSet(v, regionVersion))) {
            }
        } else {
            ConcurrentHashMap<T, Long> concurrentHashMap = this.memberToGCVersion;
            synchronized (concurrentHashMap) {
                Long holder = this.memberToGCVersion.get(mbr);
                if (holder != null) {
                    this.memberToGCVersion.put(mbr, Math.max(regionVersion, holder));
                } else {
                    this.memberToGCVersion.put(mbr, regionVersion);
                }
            }
        }
    }

    public void recordGCVersions(RegionVersionVector<T> other) {
        assert (other.memberToGCVersion != null) : "incoming gc version set is null";
        this.recordGCVersion(other.myId, other.localGCVersion.get());
        for (Map.Entry<T, Long> entry : other.memberToGCVersion.entrySet()) {
            this.recordGCVersion((VersionSource)entry.getKey(), entry.getValue());
        }
    }

    public boolean isTombstoneTooOld(T mbr, long gcVersion) {
        Long newestReapedVersion = mbr == null || mbr.equals(this.myId) ? Long.valueOf(this.localGCVersion.get()) : this.memberToGCVersion.get(mbr);
        if (newestReapedVersion != null) {
            return newestReapedVersion >= gcVersion;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGCVersion(T mbr) {
        if (mbr == null || mbr.equals(this.myId)) {
            return this.localGCVersion.get();
        }
        ConcurrentHashMap<T, Long> concurrentHashMap = this.memberToGCVersion;
        synchronized (concurrentHashMap) {
            Long holder = this.memberToGCVersion.get(mbr);
            if (holder != null) {
                return holder;
            }
            return -1L;
        }
    }

    public Map<T, RegionVersionHolder<T>> getMemberToVersion() {
        Object myExceptions = this.localExceptions.clone();
        HashMap<T, RegionVersionHolder<T>> results = new HashMap<T, RegionVersionHolder<T>>(this.memberToVersion);
        results.put(this.getOwnerId(), (RegionVersionHolder<T>)myExceptions);
        return results;
    }

    public synchronized Map<T, Long> getMemberToGCVersion() {
        HashMap<T, Long> results = new HashMap<T, Long>(this.memberToGCVersion);
        if (this.localGCVersion.get() > 0L) {
            results.put(this.getOwnerId(), this.localGCVersion.get());
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pruneOldExceptions() {
        HashSet members = new HashSet(this.memberToGCVersion.keySet());
        for (VersionSource member : members) {
            Long gcVersion = this.memberToGCVersion.get(member);
            RegionVersionHolder<T> holder = this.memberToVersion.get(member);
            if (holder == null || gcVersion == null) continue;
            RegionVersionHolder<T> regionVersionHolder = holder;
            synchronized (regionVersionHolder) {
                holder.removeExceptionsOlderThan(gcVersion);
            }
        }
        this.localExceptions.removeExceptionsOlderThan(this.localGCVersion.get());
    }

    public String toString() {
        if (this.isLiveVector) {
            return "RegionVersionVector{rv" + this.localVersion + " gc" + this.localGCVersion + "}@" + System.identityHashCode(this);
        }
        return this.fullToString();
    }

    public String fullToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RegionVersionVector[").append(this.myId).append("={rv").append(this.localExceptions.version).append(" gc" + this.localGCVersion).append(" localVersion=" + this.localVersion);
        try {
            sb.append(" local exceptions=" + this.localExceptions.exceptionsToString());
        }
        catch (ConcurrentModificationException c) {
            sb.append(" (unable to access local exceptions)");
        }
        sb.append("} others=");
        String mbrVersions = "";
        try {
            mbrVersions = this.memberToVersion.toString();
        }
        catch (ConcurrentModificationException e) {
            mbrVersions = "(unable to access)";
        }
        sb.append(mbrVersions);
        if (this.memberToGCVersion != null) {
            try {
                mbrVersions = this.memberToGCVersion.toString();
            }
            catch (ConcurrentModificationException e) {
                mbrVersions = "(unable to access)";
            }
            sb.append(", gc=").append(mbrVersions);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void memberJoined(InternalDistributedMember id) {
    }

    @Override
    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }

    @Override
    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    @Override
    public void memberDeparted(final InternalDistributedMember id, boolean crashed) {
        InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
        if (system != null) {
            system.getDistributionManager().getWaitingThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    RegionVersionVector.this.unlockForClear(id);
                }
            });
        } else {
            this.unlockForClear(id);
        }
    }

    public static RegionVersionVector<?> create(boolean persistent, DataInput in) throws IOException, ClassNotFoundException {
        RegionVersionVector rvv = persistent ? new DiskRegionVersionVector() : new VMRegionVersionVector();
        InternalDataSerializer.invokeFromData(rvv, in);
        return rvv;
    }

    public static RegionVersionVector<?> create(VersionSource<?> versionMember, LocalRegion owner) {
        if (versionMember instanceof DiskStoreID) {
            return new DiskRegionVersionVector((DiskStoreID)versionMember, owner);
        }
        return new VMRegionVersionVector((InternalDistributedMember)versionMember, owner);
    }

    public boolean sameAs(RegionVersionVector<T> other) {
        Map<T, Long> otherGCVersion;
        Map<T, RegionVersionHolder<T>> myMemberToVersion = this.getMemberToVersion();
        Map<T, RegionVersionHolder<T>> otherMemberToVersion = other.getMemberToVersion();
        if (!myMemberToVersion.keySet().equals(otherMemberToVersion.keySet())) {
            return false;
        }
        for (VersionSource key : myMemberToVersion.keySet()) {
            if (myMemberToVersion.get(key).sameAs(otherMemberToVersion.get(key))) continue;
            return false;
        }
        Map<T, Long> myGCVersion = this.getMemberToGCVersion();
        return myGCVersion.equals(otherGCVersion = other.getMemberToGCVersion());
    }

    public boolean logicallySameAs(RegionVersionVector<T> other) {
        return this.dominates(other) && other.dominates(this);
    }

    public boolean isForSynchronization() {
        return this.singleMember;
    }

    public boolean isDepartedMember(VersionSource<T> mbr) {
        RegionVersionHolder<T> h = this.memberToVersion.get(mbr);
        return h != null && h.isDepartedMember;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

