/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.transaction.TransactionManager;
import org.apache.geode.CancelCriterion;
import org.apache.geode.GemFireIOException;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.GatewayException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.AsyncEventQueueFactory;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueFactoryImpl;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.CqExistsException;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.CqServiceStatistics;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexExistsException;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.IndexNameConflictException;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.MultiIndexCreationException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.snapshot.CacheSnapshotService;
import org.apache.geode.cache.util.GatewayConflictResolver;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewaySenderFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.CacheConfig;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.CacheServerLauncher;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.DiskStoreFactoryImpl;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DiskStoreMonitor;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EventTracker;
import org.apache.geode.internal.cache.ExpirationScheduler;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PoolFactoryImpl;
import org.apache.geode.internal.cache.PoolManagerImpl;
import org.apache.geode.internal.cache.RegionListener;
import org.apache.geode.internal.cache.TXEntryStateFactory;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TombstoneService;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.ResourceAdvisor;
import org.apache.geode.internal.cache.extension.ExtensionPoint;
import org.apache.geode.internal.cache.extension.SimpleExtensionPoint;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.cache.persistence.BackupManager;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.InternalGatewaySenderFactory;
import org.apache.geode.internal.cache.wan.WANServiceProvider;
import org.apache.geode.internal.cache.xmlcache.CacheServerCreation;
import org.apache.geode.internal.cache.xmlcache.CacheTransactionManagerCreation;
import org.apache.geode.internal.cache.xmlcache.DiskStoreAttributesCreation;
import org.apache.geode.internal.cache.xmlcache.FunctionServiceCreation;
import org.apache.geode.internal.cache.xmlcache.IndexCreationData;
import org.apache.geode.internal.cache.xmlcache.RegionAttributesCreation;
import org.apache.geode.internal.cache.xmlcache.RegionCreation;
import org.apache.geode.internal.cache.xmlcache.ResourceManagerCreation;
import org.apache.geode.internal.cache.xmlcache.SerializerCreation;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LocalLogWriter;
import org.apache.geode.internal.logging.LogWriterFactory;
import org.apache.geode.internal.offheap.MemoryAllocator;
import org.apache.geode.management.internal.JmxManagerAdvisor;
import org.apache.geode.management.internal.RestAgent;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxInstanceFactory;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.internal.TypeRegistry;

public class CacheCreation
implements InternalCache {
    private int lockTimeout = GemFireCacheImpl.DEFAULT_LOCK_TIMEOUT;
    private boolean hasLockTimeout = false;
    private int lockLease = GemFireCacheImpl.DEFAULT_LOCK_LEASE;
    private boolean hasLockLease = false;
    private int searchTimeout = GemFireCacheImpl.DEFAULT_SEARCH_TIMEOUT;
    private boolean hasSearchTimeout = false;
    private boolean hasMessageSyncInterval = false;
    protected final Map<String, Region<?, ?>> roots = new LinkedHashMap();
    private DynamicRegionFactory.Config dynamicRegionFactoryConfig = null;
    private boolean hasDynamicRegionFactory = false;
    private boolean isServer = false;
    private boolean hasServer = false;
    private final List<CacheServer> bridgeServers = new ArrayList<CacheServer>();
    private final Map<Declarable, Properties> declarablePropertiesMap = new HashMap<Declarable, Properties>();
    private final Set<GatewaySender> gatewaySenders = new HashSet<GatewaySender>();
    private final Set<GatewayReceiver> gatewayReceivers = new HashSet<GatewayReceiver>();
    private final Set<AsyncEventQueue> asyncEventQueues = new HashSet<AsyncEventQueue>();
    private GatewayConflictResolver gatewayConflictResolver;
    private boolean copyOnRead = false;
    private boolean hasCopyOnRead = false;
    CacheTransactionManagerCreation txMgrCreation = null;
    private final Map<String, RegionAttributes<?, ?>> namedRegionAttributes = new HashMap();
    final List<String> regionAttributesNames = new ArrayList<String>();
    protected final Map<String, DiskStore> diskStores = new LinkedHashMap<String, DiskStore>();
    private final List<File> backups = new ArrayList<File>();
    private final CacheConfig cacheConfig = new CacheConfig();
    private final InternalLogWriter logWriter = new LocalLogWriter(Integer.MIN_VALUE, System.out);
    private final InternalLogWriter securityLogWriter = LogWriterFactory.toSecurityLogWriter(this.logWriter);
    private final SimpleExtensionPoint<Cache> extensionPoint = new SimpleExtensionPoint<CacheCreation>(this, this);
    private static final RegionAttributes defaults = new AttributesFactory().create();
    private static final ThreadLocal<PoolManagerImpl> createInProgress = new ThreadLocal();
    private final PoolManagerImpl poolManager = new PoolManagerImpl(false);
    private volatile FunctionServiceCreation functionServiceCreation;
    private volatile boolean hasResourceManager = false;
    private volatile ResourceManagerCreation resourceManagerCreation;
    private volatile SerializerCreation serializerCreation;
    private Declarable initializer = null;
    private Properties initializerProps = null;
    private final QueryService queryService = new QueryService(){
        private final Map<String, List<Index>> indexes = new HashMap<String, List<Index>>();

        @Override
        public Query newQuery(String queryString) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public Index createHashIndex(String indexName, String indexedExpression, String regionPath) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
            return this.createHashIndex(indexName, indexedExpression, regionPath, "");
        }

        @Override
        public Index createHashIndex(String indexName, String indexedExpression, String regionPath, String imports) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
            return this.createIndex(indexName, IndexType.HASH, indexedExpression, regionPath, imports);
        }

        @Override
        public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
            return this.createIndex(indexName, indexType, indexedExpression, fromClause, "");
        }

        @Override
        public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause, String imports) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
            IndexCreationData indexData = new IndexCreationData(indexName);
            indexData.setFunctionalIndexData(fromClause, indexedExpression, imports);
            indexData.setIndexType(indexType.toString());
            List<Index> indexesForRegion = this.indexes.get(fromClause);
            if (indexesForRegion == null) {
                indexesForRegion = new ArrayList<Index>();
                this.indexes.put(fromClause, indexesForRegion);
            }
            indexesForRegion.add(indexData);
            return indexData;
        }

        @Override
        public Index createIndex(String indexName, String indexedExpression, String regionPath) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
            return this.createIndex(indexName, indexedExpression, regionPath, "");
        }

        @Override
        public Index createIndex(String indexName, String indexedExpression, String regionPath, String imports) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
            return this.createIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, regionPath, imports);
        }

        @Override
        public Index createKeyIndex(String indexName, String indexedExpression, String regionPath) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
            return this.createIndex(indexName, IndexType.PRIMARY_KEY, indexedExpression, regionPath, "");
        }

        @Override
        public Index getIndex(Region<?, ?> region, String indexName) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public Collection<Index> getIndexes() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public Collection<Index> getIndexes(Region<?, ?> region) {
            return this.indexes.get(region.getFullPath());
        }

        @Override
        public Collection<Index> getIndexes(Region<?, ?> region, IndexType indexType) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void removeIndex(Index index) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void removeIndexes() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void removeIndexes(Region<?, ?> region) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqQuery newCq(String queryString, CqAttributes cqAttr) throws QueryInvalidException, CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqQuery newCq(String queryString, CqAttributes cqAttr, boolean isDurable) throws QueryInvalidException, CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqQuery newCq(String name, String queryString, CqAttributes cqAttr) throws QueryInvalidException, CqExistsException, CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqQuery newCq(String name, String queryString, CqAttributes cqAttr, boolean isDurable) throws QueryInvalidException, CqExistsException, CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void closeCqs() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqQuery[] getCqs() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqQuery[] getCqs(String regionName) throws CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqQuery getCq(String cqName) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void executeCqs() throws CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void stopCqs() throws CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void executeCqs(String regionName) throws CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void stopCqs(String regionName) throws CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public List<String> getAllDurableCqsFromServer() throws CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqServiceStatistics getCqStatistics() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void defineKeyIndex(String indexName, String indexedExpression, String regionPath) throws RegionNotFoundException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void defineHashIndex(String indexName, String indexedExpression, String regionPath) throws RegionNotFoundException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void defineHashIndex(String indexName, String indexedExpression, String regionPath, String imports) throws RegionNotFoundException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void defineIndex(String indexName, String indexedExpression, String regionPath) throws RegionNotFoundException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void defineIndex(String indexName, String indexedExpression, String regionPath, String imports) throws RegionNotFoundException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public List<Index> createDefinedIndexes() throws MultiIndexCreationException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public boolean clearDefinedIndexes() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }
    };

    public CacheCreation() {
        this(false);
    }

    public static void clearThreadLocals() {
        createInProgress.remove();
    }

    public CacheCreation(boolean forParsing) {
        this.initializeRegionShortcuts();
        if (!forParsing) {
            createInProgress.set(this.poolManager);
        }
    }

    void startingGenerate() {
        createInProgress.set(null);
    }

    RegionAttributes getDefaultAttributes() {
        return defaults;
    }

    protected void initializeRegionShortcuts() {
        GemFireCacheImpl.initializeRegionShortcuts(this);
    }

    void addRootRegion(RegionCreation root) throws RegionExistsException {
        String name = root.getName();
        RegionCreation existing = (RegionCreation)this.roots.get(name);
        if (existing != null) {
            throw new RegionExistsException(existing);
        }
        this.roots.put(root.getName(), root);
    }

    @Override
    public int getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public void setLockTimeout(int seconds) {
        this.lockTimeout = seconds;
        this.hasLockTimeout = true;
    }

    boolean hasLockTimeout() {
        return this.hasLockTimeout;
    }

    @Override
    public int getLockLease() {
        return this.lockLease;
    }

    @Override
    public void setLockLease(int seconds) {
        this.lockLease = seconds;
        this.hasLockLease = true;
    }

    boolean hasLockLease() {
        return this.hasLockLease;
    }

    @Override
    public int getSearchTimeout() {
        return this.searchTimeout;
    }

    @Override
    public void setSearchTimeout(int seconds) {
        this.searchTimeout = seconds;
        this.hasSearchTimeout = true;
    }

    boolean hasSearchTimeout() {
        return this.hasSearchTimeout;
    }

    @Override
    public int getMessageSyncInterval() {
        return HARegionQueue.getMessageSyncInterval();
    }

    @Override
    public void setMessageSyncInterval(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException(LocalizedStrings.CacheCreation_THE_MESSAGESYNCINTERVAL_PROPERTY_FOR_CACHE_CANNOT_BE_NEGATIVE.toLocalizedString());
        }
        HARegionQueue.setMessageSyncInterval(seconds);
        this.hasMessageSyncInterval = true;
    }

    boolean hasMessageSyncInterval() {
        return this.hasMessageSyncInterval;
    }

    @Override
    public Set<Region<?, ?>> rootRegions() {
        LinkedHashSet regions = new LinkedHashSet(this.roots.values());
        return Collections.unmodifiableSet(regions);
    }

    @Override
    public DiskStoreFactory createDiskStoreFactory() {
        return new DiskStoreFactoryImpl(this);
    }

    public static PoolManagerImpl getCurrentPoolManager() {
        return createInProgress.get();
    }

    void create(InternalCache cache) throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        Serializable creation;
        Map<String, Pool> pools;
        this.extensionPoint.beforeCreate(cache);
        cache.setDeclarativeCacheConfig(this.cacheConfig);
        if (cache.isClient()) {
            throw new IllegalStateException("You must use client-cache in the cache.xml when ClientCacheFactory is used.");
        }
        if (this.hasLockLease()) {
            cache.setLockLease(this.lockLease);
        }
        if (this.hasLockTimeout()) {
            cache.setLockTimeout(this.lockTimeout);
        }
        if (this.hasSearchTimeout()) {
            cache.setSearchTimeout(this.searchTimeout);
        }
        if (this.hasMessageSyncInterval()) {
            cache.setMessageSyncInterval(this.getMessageSyncInterval());
        }
        if (this.gatewayConflictResolver != null) {
            cache.setGatewayConflictResolver(this.gatewayConflictResolver);
        }
        if (!(pools = this.getPools()).isEmpty()) {
            for (Pool pool : pools.values()) {
                PoolFactoryImpl poolFactory = (PoolFactoryImpl)PoolManager.createFactory();
                poolFactory.init(pool);
                poolFactory.create(pool.getName());
            }
        }
        if (this.hasResourceManager()) {
            this.getResourceManager().configure(cache.getResourceManager());
        }
        DiskStoreAttributesCreation pdxRegDSC = this.initializePdxDiskStore(cache);
        cache.initializePdxRegistry();
        for (DiskStore diskStore : this.diskStores.values()) {
            creation = (DiskStoreAttributesCreation)diskStore;
            if (creation == pdxRegDSC) continue;
            this.createDiskStore((DiskStoreAttributesCreation)creation, cache);
        }
        if (this.hasDynamicRegionFactory()) {
            DynamicRegionFactory.get().open(this.getDynamicRegionFactoryConfig());
        }
        if (this.hasServer()) {
            cache.setIsServer(this.isServer);
        }
        if (this.hasCopyOnRead()) {
            cache.setCopyOnRead(this.copyOnRead);
        }
        if (this.txMgrCreation != null && this.txMgrCreation.getListeners().length > 0 && cache.getCacheTransactionManager() != null) {
            cache.getCacheTransactionManager().initListeners(this.txMgrCreation.getListeners());
        }
        if (this.txMgrCreation != null && cache.getCacheTransactionManager() != null) {
            cache.getCacheTransactionManager().setWriter(this.txMgrCreation.getWriter());
        }
        for (GatewaySender senderCreation : this.getGatewaySenders()) {
            GatewaySenderFactory factory = cache.createGatewaySenderFactory();
            ((InternalGatewaySenderFactory)factory).configureGatewaySender(senderCreation);
            GatewaySender gatewaySender = factory.create(senderCreation.getId(), senderCreation.getRemoteDSId());
            if (!gatewaySender.isManualStart()) continue;
            cache.getLoggerI18n().info(LocalizedStrings.CacheCreation_0_IS_NOT_BEING_STARTED_SINCE_IT_IS_CONFIGURED_FOR_MANUAL_START, gatewaySender);
        }
        for (AsyncEventQueue asyncEventQueueCreation : this.getAsyncEventQueues()) {
            AsyncEventQueueFactoryImpl asyncQueueFactory = (AsyncEventQueueFactoryImpl)cache.createAsyncEventQueueFactory();
            asyncQueueFactory.configureAsyncEventQueue(asyncEventQueueCreation);
            AsyncEventQueue asyncEventQueue = cache.getAsyncEventQueue(asyncEventQueueCreation.getId());
            if (asyncEventQueue != null) continue;
            asyncQueueFactory.create(asyncEventQueueCreation.getId(), asyncEventQueueCreation.getAsyncEventListener());
        }
        cache.initializePdxRegistry();
        for (String id : this.regionAttributesNames) {
            creation = (RegionAttributesCreation)this.getRegionAttributes(id);
            ((RegionAttributesCreation)creation).inheritAttributes(cache, false);
            AttributesFactory factory = new AttributesFactory(creation);
            RegionAttributes attrs = factory.create();
            cache.setRegionAttributes(id, attrs);
        }
        this.initializeRegions(this.roots, cache);
        cache.readyDynamicRegionFactory();
        Integer n = CacheServerLauncher.getServerPort();
        String serverBindAdd = CacheServerLauncher.getServerBindAddress();
        Boolean disableDefaultServer = CacheServerLauncher.getDisableDefaultServer();
        this.startCacheServers(this.getCacheServers(), cache, n, serverBindAdd, disableDefaultServer);
        for (GatewayReceiver receiverCreation : this.getGatewayReceivers()) {
            GatewayReceiverFactory factory = cache.createGatewayReceiverFactory();
            factory.setBindAddress(receiverCreation.getBindAddress());
            factory.setMaximumTimeBetweenPings(receiverCreation.getMaximumTimeBetweenPings());
            factory.setStartPort(receiverCreation.getStartPort());
            factory.setEndPort(receiverCreation.getEndPort());
            factory.setSocketBufferSize(receiverCreation.getSocketBufferSize());
            factory.setManualStart(receiverCreation.isManualStart());
            for (GatewayTransportFilter filter : receiverCreation.getGatewayTransportFilters()) {
                factory.addGatewayTransportFilter(filter);
            }
            factory.setHostnameForSenders(receiverCreation.getHost());
            GatewayReceiver receiver = factory.create();
            if (!receiver.isManualStart()) continue;
            cache.getLoggerI18n().info(LocalizedStrings.CacheCreation_0_IS_NOT_BEING_STARTED_SINCE_IT_IS_CONFIGURED_FOR_MANUAL_START, receiver);
        }
        cache.setBackupFiles(this.backups);
        cache.addDeclarableProperties(this.declarablePropertiesMap);
        this.runInitializer();
        cache.setInitializer(this.getInitializer(), this.getInitializerProps());
        this.extensionPoint.fireCreate(cache);
    }

    void initializeRegions(Map<String, Region<?, ?>> declarativeRegions, Cache cache) {
        for (Region<?, ?> region : declarativeRegions.values()) {
            RegionCreation regionCreation = (RegionCreation)region;
            regionCreation.createRoot(cache);
        }
    }

    void startCacheServers(List<CacheServer> declarativeCacheServers, Cache cache, Integer serverPort, String serverBindAdd, Boolean disableDefaultServer) {
        boolean isDefaultServerDisabled;
        if (declarativeCacheServers.size() > 1 && (serverPort != null || serverBindAdd != null)) {
            throw new RuntimeException(LocalizedStrings.CacheServerLauncher_SERVER_PORT_MORE_THAN_ONE_CACHE_SERVER.toLocalizedString());
        }
        CacheServerCreation defaultServer = null;
        boolean hasServerPortOrBindAddress = serverPort != null || serverBindAdd != null;
        boolean bl = isDefaultServerDisabled = disableDefaultServer == null || disableDefaultServer == false;
        if (declarativeCacheServers.isEmpty() && hasServerPortOrBindAddress && isDefaultServerDisabled) {
            boolean existingCacheServer = false;
            List<CacheServer> cacheServers = cache.getCacheServers();
            if (cacheServers != null) {
                for (CacheServer cacheServer : cacheServers) {
                    if (serverPort.intValue() != cacheServer.getPort()) continue;
                    existingCacheServer = true;
                }
            }
            if (!existingCacheServer) {
                defaultServer = new CacheServerCreation((InternalCache)cache, false);
                declarativeCacheServers.add(defaultServer);
            }
        }
        for (CacheServer declarativeCacheServer : declarativeCacheServers) {
            CacheServerCreation declaredCacheServer = (CacheServerCreation)declarativeCacheServer;
            boolean startServer = true;
            List<CacheServer> cacheServers = cache.getCacheServers();
            if (cacheServers != null) {
                for (CacheServer cacheServer : cacheServers) {
                    if (declaredCacheServer.getPort() != cacheServer.getPort()) continue;
                    startServer = false;
                }
            }
            if (!startServer) continue;
            CacheServerImpl impl = (CacheServerImpl)cache.addCacheServer();
            impl.configureFrom(declaredCacheServer);
            if (declaredCacheServer == defaultServer) {
                impl.setIsDefaultServer();
            }
            if (serverPort != null && serverPort != 40404) {
                impl.setPort(serverPort);
            }
            if (serverBindAdd != null) {
                impl.setBindAddress(serverBindAdd.trim());
            }
            try {
                if (impl.isRunning()) continue;
                impl.start();
            }
            catch (IOException ex) {
                throw new GemFireIOException(LocalizedStrings.CacheCreation_WHILE_STARTING_CACHE_SERVER_0.toLocalizedString(impl), ex);
            }
        }
    }

    DiskStoreAttributesCreation initializePdxDiskStore(InternalCache cache) {
        DiskStoreAttributesCreation pdxRegDSC = null;
        if (TypeRegistry.mayNeedDiskStore(cache)) {
            String pdxRegDsName = cache.getPdxDiskStore();
            if (pdxRegDsName == null) {
                pdxRegDsName = "DEFAULT";
            }
            if ((pdxRegDSC = (DiskStoreAttributesCreation)this.diskStores.get(pdxRegDsName)) == null) {
                if (pdxRegDsName.equals("DEFAULT")) {
                    cache.getOrCreateDefaultDiskStore();
                }
            } else {
                this.createDiskStore(pdxRegDSC, cache);
            }
        }
        return pdxRegDSC;
    }

    protected void createDiskStore(DiskStoreAttributesCreation creation, InternalCache cache) {
        DiskStoreFactory factory = cache.createDiskStoreFactory(creation);
        factory.create(creation.getName());
    }

    public boolean sameAs(Cache other) {
        Pool pool;
        boolean sameConfig;
        boolean bl = sameConfig = other.getLockLease() == this.getLockLease() && other.getLockTimeout() == this.getLockTimeout() && other.getSearchTimeout() == this.getSearchTimeout() && other.getMessageSyncInterval() == this.getMessageSyncInterval() && other.getCopyOnRead() == this.getCopyOnRead() && other.isServer() == this.isServer();
        if (!sameConfig) {
            throw new RuntimeException(LocalizedStrings.CacheCreation_SAMECONFIG.toLocalizedString());
        }
        DynamicRegionFactory.Config drc1 = this.getDynamicRegionFactoryConfig();
        if (drc1 != null) {
            DynamicRegionFactory.Config drc2 = null;
            drc2 = other instanceof CacheCreation ? ((CacheCreation)other).getDynamicRegionFactoryConfig() : DynamicRegionFactory.get().getConfig();
            if (drc2 == null) {
                return false;
            }
            if (!drc1.equals(drc2)) {
                return false;
            }
        } else if (other instanceof CacheCreation ? ((CacheCreation)other).getDynamicRegionFactoryConfig() != null : DynamicRegionFactory.get().isOpen()) {
            return false;
        }
        List<CacheServer> myBridges = this.getCacheServers();
        List<CacheServer> otherBridges = other.getCacheServers();
        if (myBridges.size() != otherBridges.size()) {
            throw new RuntimeException(LocalizedStrings.CacheCreation_CACHESERVERS_SIZE.toLocalizedString());
        }
        for (CacheServer myBridge1 : myBridges) {
            CacheServerCreation myBridge = (CacheServerCreation)myBridge1;
            boolean found = false;
            for (CacheServer otherBridge : otherBridges) {
                if (!myBridge.sameAs(otherBridge)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException(LocalizedStrings.CacheCreation_CACHE_SERVER_0_NOT_FOUND.toLocalizedString(myBridge));
        }
        Map<String, Pool> m1 = this.getPools();
        Map<String, Pool> m2 = other instanceof CacheCreation ? ((CacheCreation)other).getPools() : PoolManager.getAll();
        int m1Size = m1.size();
        for (Pool pool2 : m1.values()) {
            if (!((PoolImpl)pool2).isUsedByGateway()) continue;
            --m1Size;
        }
        int m2Size = m2.size();
        for (Pool cp : m2.values()) {
            if (!((PoolImpl)cp).isUsedByGateway()) continue;
            --m2Size;
        }
        if (m2Size == 1 && (pool = m2.values().iterator().next()).getName().equals("DEFAULT")) {
            m2Size = 0;
        }
        if (m1Size != m2Size) {
            throw new RuntimeException("pool sizes differ m1Size=" + m1Size + " m2Size=" + m2Size + " m1=" + m1.values() + " m2=" + m2.values());
        }
        if (m1Size > 0) {
            for (Pool pool3 : m1.values()) {
                PoolImpl poolImpl = (PoolImpl)pool3;
                if (poolImpl.isUsedByGateway()) continue;
                poolImpl.sameAs(m2.get(poolImpl.getName()));
            }
        }
        for (DiskStore diskStore : this.diskStores.values()) {
            DiskStoreAttributesCreation dsac = (DiskStoreAttributesCreation)diskStore;
            String string = dsac.getName();
            DiskStore ds = other.findDiskStore(string);
            if (ds == null) {
                this.getLogger().fine("Disk store " + string + " not found.");
                throw new RuntimeException(LocalizedStrings.CacheCreation_DISKSTORE_NOTFOUND_0.toLocalizedString(string));
            }
            if (dsac.sameAs(ds)) continue;
            this.getLogger().fine("Attributes for disk store " + string + " do not match");
            throw new RuntimeException(LocalizedStrings.CacheCreation_ATTRIBUTES_FOR_DISKSTORE_0_DO_NOT_MATCH.toLocalizedString(string));
        }
        Map<String, RegionAttributes<?, ?>> map = this.listRegionAttributes();
        Map otherNamedAttributes = other.listRegionAttributes();
        if (map.size() != otherNamedAttributes.size()) {
            throw new RuntimeException(LocalizedStrings.CacheCreation_NAMEDATTRIBUTES_SIZE.toLocalizedString());
        }
        for (Object e : map.entrySet()) {
            Map.Entry myEntry = (Map.Entry)e;
            String string = (String)myEntry.getKey();
            Assert.assertTrue(myEntry.getValue() instanceof RegionAttributesCreation, "Entry value is a " + myEntry.getValue().getClass().getName());
            RegionAttributesCreation myAttrs = (RegionAttributesCreation)myEntry.getValue();
            RegionAttributes otherAttrs = other.getRegionAttributes(string);
            if (otherAttrs == null) {
                this.getLogger().fine("No attributes for " + string);
                throw new RuntimeException(LocalizedStrings.CacheCreation_NO_ATTRIBUTES_FOR_0.toLocalizedString(string));
            }
            if (myAttrs.sameAs(otherAttrs)) continue;
            this.getLogger().fine("Attributes for " + string + " do not match");
            throw new RuntimeException(LocalizedStrings.CacheCreation_ATTRIBUTES_FOR_0_DO_NOT_MATCH.toLocalizedString(string));
        }
        Collection<Region<?, ?>> myRoots = this.roots.values();
        Set<Region<?, ?>> set = other.rootRegions();
        if (myRoots.size() != set.size()) {
            throw new RuntimeException(LocalizedStrings.CacheCreation_ROOTS_SIZE.toLocalizedString());
        }
        for (Region region : myRoots) {
            RegionCreation rootRegion = (RegionCreation)region;
            Region otherRegion = other.getRegion(rootRegion.getName());
            if (otherRegion == null) {
                throw new RuntimeException(LocalizedStrings.CacheCreation_NO_ROOT_0.toLocalizedString(rootRegion.getName()));
            }
            if (rootRegion.sameAs(otherRegion)) continue;
            throw new RuntimeException(LocalizedStrings.CacheCreation_REGIONS_DIFFER.toLocalizedString());
        }
        if (this.getCacheTransactionManager() != null) {
            List<TransactionListener> otherTxListeners = Arrays.asList(other.getCacheTransactionManager().getListeners());
            List<TransactionListener> list = Arrays.asList(this.getCacheTransactionManager().getListeners());
            if (!list.equals(otherTxListeners)) {
                throw new RuntimeException(LocalizedStrings.CacheCreation_TXLISTENER.toLocalizedString());
            }
        }
        if (this.hasResourceManager()) {
            this.getResourceManager().sameAs(other.getResourceManager());
        }
        return true;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void close(boolean keepAlive) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isReconnecting() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean waitUntilReconnected(long time, TimeUnit units) throws InterruptedException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void stopReconnecting() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Cache getReconnectedCache() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public LogWriter getLogger() {
        return this.logWriter;
    }

    @Override
    public LogWriter getSecurityLogger() {
        return this.securityLogWriter;
    }

    @Override
    public LogWriterI18n getLoggerI18n() {
        return this.logWriter.convertToLogWriterI18n();
    }

    @Override
    public LogWriterI18n getSecurityLoggerI18n() {
        return this.securityLogWriter.convertToLogWriterI18n();
    }

    @Override
    public DistributedSystem getDistributedSystem() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isClosed() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public QueryService getQueryService() {
        return this.queryService;
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(RegionShortcut shortcut) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(String regionAttributesId) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(RegionAttributes<K, V> regionAttributes) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Region createVMRegion(String name, RegionAttributes aRegionAttributes) throws RegionExistsException, TimeoutException {
        return this.createRegion(name, aRegionAttributes);
    }

    public Region createRegion(String name, RegionAttributes aRegionAttributes) throws RegionExistsException, TimeoutException {
        if (aRegionAttributes instanceof RegionAttributesCreation) {
            ((RegionAttributesCreation)aRegionAttributes).inheritAttributes(this);
            ((RegionAttributesCreation)aRegionAttributes).prepareForValidation();
        }
        AttributesFactory.validateAttributes(aRegionAttributes);
        RegionCreation region = new RegionCreation(this, name, null);
        region.setAttributes(aRegionAttributes);
        this.addRootRegion(region);
        return region;
    }

    public Region createRegion(String name, String refid) throws RegionExistsException, TimeoutException {
        RegionCreation region = new RegionCreation(this, name, refid);
        this.addRootRegion(region);
        return region;
    }

    public Region getRegion(String path) {
        if (path.contains("/")) {
            throw new UnsupportedOperationException("Region path '" + path + "' contains '/'");
        }
        return this.roots.get(path);
    }

    @Override
    public CacheServer addCacheServer() {
        return this.addCacheServer(false);
    }

    @Override
    public CacheServer addCacheServer(boolean isGatewayReceiver) {
        CacheServerCreation bridge = new CacheServerCreation((InternalCache)this, false);
        this.bridgeServers.add(bridge);
        return bridge;
    }

    @Override
    public void setReadSerialized(boolean value) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public PdxInstanceFactory createPdxInstanceFactory(String className, boolean expectDomainClass) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void waitForRegisterInterestsInProgress() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    void addDeclarableProperties(Declarable declarable, Properties properties) {
        this.declarablePropertiesMap.put(declarable, properties);
    }

    @Override
    public List<CacheServer> getCacheServers() {
        return this.bridgeServers;
    }

    @Override
    public void addGatewaySender(GatewaySender sender) {
        this.gatewaySenders.add(sender);
    }

    @Override
    public void addAsyncEventQueue(AsyncEventQueueImpl asyncQueue) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void removeAsyncEventQueue(AsyncEventQueue asyncQueue) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public QueryMonitor getQueryMonitor() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void close(String reason, Throwable systemFailureCause, boolean keepAlive, boolean keepDS) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public JmxManagerAdvisor getJmxManagerAdvisor() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public List<Properties> getDeclarableProperties(String className) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public int getUpTime() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Set<Region<?, ?>> rootRegions(boolean includePRAdminRegions) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Set<LocalRegion> getAllRegions() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public DistributedRegion getRegionInDestroy(String path) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void addRegionOwnedDiskStore(DiskStoreImpl dsi) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public DiskStoreMonitor getDiskStoreMonitor() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void close(String reason, Throwable optionalCause) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public LocalRegion getRegionByPathForProcessing(String path) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public List getCacheServersAndGatewayReceiver() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isGlobalRegionInitializing(String fullPath) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setQueryMonitorRequiredForResourceManager(boolean required) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isQueryMonitorDisabledForLowMemory() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isRESTServiceRunning() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public InternalLogWriter getInternalLogWriter() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public InternalLogWriter getSecurityInternalLogWriter() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Set<LocalRegion> getApplicationRegions() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void removeGatewaySender(GatewaySender sender) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public DistributedLockService getGatewaySenderLockService() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public RestAgent getRestAgent() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Properties getDeclarableProperties(Declarable declarable) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setRESTServiceRunning(boolean isRESTServiceRunning) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void close(String reason, boolean keepAlive, boolean keepDS) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void addGatewayReceiver(GatewayReceiver receiver) {
        this.gatewayReceivers.add(receiver);
    }

    public void addAsyncEventQueue(AsyncEventQueue asyncEventQueue) {
        this.asyncEventQueues.add(asyncEventQueue);
    }

    @Override
    public Set<GatewaySender> getGatewaySenders() {
        HashSet<GatewaySender> tempSet = new HashSet<GatewaySender>();
        for (GatewaySender sender : this.gatewaySenders) {
            if (((AbstractGatewaySender)sender).isForInternalUse()) continue;
            tempSet.add(sender);
        }
        return tempSet;
    }

    @Override
    public GatewaySender getGatewaySender(String id) {
        for (GatewaySender sender : this.gatewaySenders) {
            if (!sender.getId().equals(id)) continue;
            return sender;
        }
        return null;
    }

    @Override
    public Set<GatewayReceiver> getGatewayReceivers() {
        return this.gatewayReceivers;
    }

    @Override
    public Set<AsyncEventQueue> getAsyncEventQueues() {
        return this.asyncEventQueues;
    }

    @Override
    public AsyncEventQueue getAsyncEventQueue(String id) {
        for (AsyncEventQueue asyncEventQueue : this.asyncEventQueues) {
            if (!asyncEventQueue.getId().equals(id)) continue;
            return asyncEventQueue;
        }
        return null;
    }

    @Override
    public void setIsServer(boolean isServer) {
        this.isServer = isServer;
        this.hasServer = true;
    }

    @Override
    public boolean isServer() {
        return this.isServer || !this.bridgeServers.isEmpty();
    }

    boolean hasServer() {
        return this.hasServer;
    }

    public void setDynamicRegionFactoryConfig(DynamicRegionFactory.Config v) {
        this.dynamicRegionFactoryConfig = v;
        this.hasDynamicRegionFactory = true;
    }

    boolean hasDynamicRegionFactory() {
        return this.hasDynamicRegionFactory;
    }

    DynamicRegionFactory.Config getDynamicRegionFactoryConfig() {
        return this.dynamicRegionFactoryConfig;
    }

    @Override
    public CacheTransactionManager getCacheTransactionManager() {
        return this.txMgrCreation;
    }

    @Override
    public void setCopyOnRead(boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
        this.hasCopyOnRead = true;
    }

    @Override
    public boolean getCopyOnRead() {
        return this.copyOnRead;
    }

    boolean hasCopyOnRead() {
        return this.hasCopyOnRead;
    }

    public void addCacheTransactionManagerCreation(CacheTransactionManagerCreation txm) {
        this.txMgrCreation = txm;
    }

    @Override
    public Context getJNDIContext() {
        return JNDIInvoker.getJNDIContext();
    }

    @Override
    public DiskStore findDiskStore(String name) {
        if (name == null) {
            name = GemFireCacheImpl.getDefaultDiskStoreName();
        }
        return this.diskStores.get(name);
    }

    public void addDiskStore(DiskStore ds) {
        this.diskStores.put(ds.getName(), ds);
    }

    @Override
    public Collection<DiskStore> listDiskStores() {
        return this.diskStores.values();
    }

    void setDiskStore(String name, DiskStoreAttributesCreation dsac) {
        this.diskStores.put(name, dsac);
    }

    public RegionAttributes getRegionAttributes(String id) {
        return this.namedRegionAttributes.get(id);
    }

    public void setRegionAttributes(String id, RegionAttributes attrs) {
        RegionAttributes a = attrs;
        if (!(a instanceof RegionAttributesCreation)) {
            a = new RegionAttributesCreation(this, a, false);
        }
        this.namedRegionAttributes.put(id, a);
        this.regionAttributesNames.add(id);
    }

    public Map<String, RegionAttributes<?, ?>> listRegionAttributes() {
        return Collections.unmodifiableMap(this.namedRegionAttributes);
    }

    @Override
    public void loadCacheXml(InputStream is) throws TimeoutException, CacheWriterException, RegionExistsException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void readyForEvents() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Map<String, Pool> getPools() {
        return this.poolManager.getMap();
    }

    public PoolFactory createPoolFactory() {
        return new PoolFactoryImpl(this.poolManager).setStartDisabled(true);
    }

    public void setFunctionServiceCreation(FunctionServiceCreation functionServiceCreation) {
        this.functionServiceCreation = functionServiceCreation;
    }

    public void setResourceManagerCreation(ResourceManagerCreation resourceManagerCreation) {
        this.hasResourceManager = true;
        this.resourceManagerCreation = resourceManagerCreation;
    }

    @Override
    public ResourceManagerCreation getResourceManager() {
        return this.resourceManagerCreation;
    }

    boolean hasResourceManager() {
        return this.hasResourceManager;
    }

    public void setSerializerCreation(SerializerCreation serializerCreation) {
        this.serializerCreation = serializerCreation;
    }

    SerializerCreation getSerializerCreation() {
        return this.serializerCreation;
    }

    public void addBackup(File backup) {
        this.backups.add(backup);
    }

    @Override
    public List<File> getBackupFiles() {
        return Collections.unmodifiableList(this.backups);
    }

    @Override
    public LocalRegion getRegionByPath(String path) {
        return null;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public InternalDistributedSystem getInternalDistributedSystem() {
        return InternalDistributedSystem.getAnyInstance();
    }

    @Override
    public Set<PartitionedRegion> getPartitionedRegions() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void addRegionListener(RegionListener regionListener) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void removeRegionListener(RegionListener regionListener) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Set<RegionListener> getRegionListeners() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public GatewaySenderFactory createGatewaySenderFactory() {
        return WANServiceProvider.createGatewaySenderFactory(this);
    }

    @Override
    public GatewayReceiverFactory createGatewayReceiverFactory() {
        return WANServiceProvider.createGatewayReceiverFactory(this);
    }

    @Override
    public AsyncEventQueueFactory createAsyncEventQueueFactory() {
        return new AsyncEventQueueFactoryImpl(this);
    }

    public void setPdxReadSerialized(boolean readSerialized) {
        this.cacheConfig.setPdxReadSerialized(readSerialized);
    }

    public void setPdxIgnoreUnreadFields(boolean ignore) {
        this.cacheConfig.setPdxIgnoreUnreadFields(ignore);
    }

    public void setPdxSerializer(PdxSerializer serializer) {
        this.cacheConfig.setPdxSerializer(serializer);
    }

    public void setPdxDiskStore(String diskStore) {
        this.cacheConfig.setPdxDiskStore(diskStore);
    }

    public void setPdxPersistent(boolean persistent) {
        this.cacheConfig.setPdxPersistent(persistent);
    }

    @Override
    public boolean getPdxReadSerialized() {
        return this.cacheConfig.isPdxReadSerialized();
    }

    @Override
    public PdxSerializer getPdxSerializer() {
        return this.cacheConfig.getPdxSerializer();
    }

    @Override
    public String getPdxDiskStore() {
        return this.cacheConfig.getPdxDiskStore();
    }

    @Override
    public boolean getPdxPersistent() {
        return this.cacheConfig.isPdxPersistent();
    }

    @Override
    public boolean getPdxIgnoreUnreadFields() {
        return this.cacheConfig.getPdxIgnoreUnreadFields();
    }

    @Override
    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    @Override
    public boolean getPdxReadSerializedByAnyGemFireServices() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public BackupManager getBackupManager() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setDeclarativeCacheConfig(CacheConfig cacheConfig) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void initializePdxRegistry() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void readyDynamicRegionFactory() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setBackupFiles(List<File> backups) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void addDeclarableProperties(Map<Declarable, Properties> mapOfNewDeclarableProps) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Set<DistributedMember> getMembers() {
        return Collections.emptySet();
    }

    @Override
    public Set<DistributedMember> getAdminMembers() {
        return Collections.emptySet();
    }

    @Override
    public Set<DistributedMember> getMembers(Region region) {
        return Collections.emptySet();
    }

    @Override
    public Declarable getInitializer() {
        return this.initializer;
    }

    @Override
    public Properties getInitializerProps() {
        return this.initializerProps;
    }

    @Override
    public void setInitializer(Declarable declarable, Properties props) {
        this.initializer = declarable;
        this.initializerProps = props;
    }

    @Override
    public boolean hasPool() {
        return false;
    }

    @Override
    public DiskStoreFactory createDiskStoreFactory(DiskStoreAttributes attrs) {
        return null;
    }

    @Override
    public void determineDefaultPool() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> Region<K, V> basicCreateRegion(String name, RegionAttributes<K, V> attrs) throws RegionExistsException, TimeoutException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public BackupManager startBackup(InternalDistributedMember sender) throws IOException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Throwable getDisconnectCause() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void addPartitionedRegion(PartitionedRegion region) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void removePartitionedRegion(PartitionedRegion region) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void addDiskStore(DiskStoreImpl dsi) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public TXEntryStateFactory getTXEntryStateFactory() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public EventTracker.ExpiryTask getEventTrackerTask() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void removeDiskStore(DiskStoreImpl diskStore) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    void runInitializer() {
        if (this.getInitializer() != null) {
            this.getInitializer().init(this.getInitializerProps());
        }
    }

    @Override
    public void setGatewayConflictResolver(GatewayConflictResolver resolver) {
        this.gatewayConflictResolver = resolver;
    }

    @Override
    public GatewayConflictResolver getGatewayConflictResolver() {
        return this.gatewayConflictResolver;
    }

    @Override
    public PdxInstanceFactory createPdxInstanceFactory(String className) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public PdxInstance createPdxEnum(String className, String enumName, int enumOrdinal) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public CacheSnapshotService getSnapshotService() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public ExtensionPoint<Cache> getExtensionPoint() {
        return this.extensionPoint;
    }

    @Override
    public InternalDistributedMember getMyId() {
        return null;
    }

    @Override
    public Collection<DiskStore> listDiskStoresIncludingRegionOwned() {
        return null;
    }

    @Override
    public CqService getCqService() {
        return null;
    }

    @Override
    public <T extends CacheService> T getService(Class<T> clazz) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Collection<CacheService> getServices() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public SystemTimer getCCPTimer() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void cleanupForClient(CacheClientNotifier ccn, ClientProxyMembershipID client) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void purgeCCPTimer() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public FilterProfile getFilterProfile(String regionName) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Region getRegion(String path, boolean returnDestroyedRegion) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public MemoryAllocator getOffHeapStore() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> Region<K, V> createVMRegion(String name, RegionAttributes<K, V> p_attrs, InternalRegionArguments internalRegionArgs) throws RegionExistsException, TimeoutException, IOException, ClassNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public DistributedLockService getPartitionedRegionLockService() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public PersistentMemberManager getPersistentMemberManager() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Set<GatewaySender> getAllGatewaySenders() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public CachePerfStats getCachePerfStats() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public DM getDistributionManager() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void regionReinitialized(Region region) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setRegionByPath(String path, LocalRegion r) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public InternalResourceManager getInternalResourceManager() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public ResourceAdvisor getResourceAdvisor() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isCacheAtShutdownAll() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean requiresNotificationFromPR(PartitionedRegion r) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> RegionAttributes<K, V> invokeRegionBefore(LocalRegion parent, String name, RegionAttributes<K, V> attrs, InternalRegionArguments internalRegionArgs) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void invokeRegionAfter(LocalRegion region) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public TXManagerImpl getTXMgr() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean forcedDisconnect() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public InternalResourceManager getInternalResourceManager(boolean checkCancellationInProgress) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isCopyOnRead() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public TombstoneService getTombstoneService() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public QueryService getLocalQueryService() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void registerInterestStarted() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void registerInterestCompleted() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void regionReinitializing(String fullPath) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void unregisterReinitializingRegion(String fullPath) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean removeRoot(LocalRegion rootRgn) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Executor getEventThreadPool() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public LocalRegion getReinitializingRegion(String fullPath) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean keepDurableSubscriptionsAlive() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public CacheClosedException getCacheClosedException(String reason, Throwable cause) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public TypeRegistry getPdxRegistry() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public DiskStoreImpl getOrCreateDefaultDiskStore() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public ExpirationScheduler getExpirationScheduler() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public TransactionManager getJTATransactionManager() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public TXManagerImpl getTxManager() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void beginDestroy(String path, DistributedRegion region) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void endDestroy(String path, DistributedRegion region) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public ClientMetadataService getClientMetadataService() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public long cacheTimeMillis() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void clearBackupManager() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public URL getCacheXmlURL() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }
}

