/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.geode.internal.process.FileAlreadyExistsException;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessUtils;

public class LocalProcessLauncher {
    public static final String PROPERTY_IGNORE_IS_PID_ALIVE = "gemfire.test.LocalProcessLauncher.ignoreIsPidAlive";
    private final int pid = ProcessUtils.identifyPid();
    private final File pidFile;

    public LocalProcessLauncher(File pidFile, boolean force) throws FileAlreadyExistsException, IOException, PidUnavailableException {
        this.pidFile = pidFile;
        this.writePid(force);
    }

    public int getPid() {
        return this.pid;
    }

    public File getPidFile() {
        return this.pidFile;
    }

    void close() {
        this.pidFile.delete();
    }

    private void writePid(boolean force) throws FileAlreadyExistsException, IOException {
        boolean created = this.pidFile.createNewFile();
        if (!created && !force) {
            int otherPid = 0;
            try {
                otherPid = ProcessUtils.readPid(this.pidFile);
            }
            catch (IOException iOException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            boolean ignorePidFile = false;
            if (otherPid != 0 && !LocalProcessLauncher.ignoreIsPidAlive()) {
                boolean bl = ignorePidFile = !ProcessUtils.isProcessAlive(otherPid);
            }
            if (!ignorePidFile) {
                throw new FileAlreadyExistsException("Pid file already exists: " + this.pidFile + " for " + (otherPid > 0 ? "process " + otherPid : "unknown process"));
            }
        }
        this.pidFile.deleteOnExit();
        FileWriter writer = new FileWriter(this.pidFile);
        writer.write(String.valueOf(this.pid));
        writer.flush();
        writer.close();
    }

    private static boolean ignoreIsPidAlive() {
        return Boolean.getBoolean(PROPERTY_IGNORE_IS_PID_ALIVE);
    }
}

