/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import org.apache.geode.internal.process.AttachProcessUtils;
import org.apache.geode.internal.process.NativeProcessUtils;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.util.IOUtils;

public class ProcessUtils {
    private static InternalProcessUtils internal = ProcessUtils.initializeInternalProcessUtils();

    private ProcessUtils() {
    }

    public static int identifyPid() throws PidUnavailableException {
        return ProcessUtils.identifyPid(ManagementFactory.getRuntimeMXBean().getName());
    }

    public static int identifyPid(String name) throws PidUnavailableException {
        try {
            int index = name.indexOf("@");
            if (index < 0) {
                throw new PidUnavailableException("Unable to parse pid from " + name);
            }
            return Integer.valueOf(name.substring(0, index));
        }
        catch (NumberFormatException e) {
            throw new PidUnavailableException("Unable to parse pid from " + name, e);
        }
    }

    public static boolean isProcessAlive(int pid) {
        return internal.isProcessAlive(pid);
    }

    public static boolean isProcessAlive(Process process) {
        return process.isAlive();
    }

    public static boolean killProcess(int pid) {
        return internal.killProcess(pid);
    }

    public static int readPid(File pidFile) throws IOException {
        int n;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(pidFile));
            n = Integer.parseInt(reader.readLine());
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
        return n;
    }

    public static boolean isAvailable() {
        return internal.isAvailable();
    }

    public static boolean isAttachApiAvailable() {
        return internal.isAttachApiAvailable();
    }

    private static InternalProcessUtils initializeInternalProcessUtils() {
        try {
            Class.forName("com.sun.tools.attach.VirtualMachine");
            Class.forName("com.sun.tools.attach.VirtualMachineDescriptor");
            return new AttachProcessUtils();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        try {
            Class.forName("org.apache.geode.internal.shared.NativeCalls");
            NativeProcessUtils inst = new NativeProcessUtils();
            boolean result = inst.isProcessAlive(ProcessUtils.identifyPid());
            if (result) {
                return inst;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
        }
        catch (PidUnavailableException pidUnavailableException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return new InternalProcessUtils(){

            @Override
            public boolean isProcessAlive(int pid) {
                return false;
            }

            @Override
            public boolean killProcess(int pid) {
                return false;
            }

            @Override
            public boolean isAvailable() {
                return false;
            }

            @Override
            public boolean isAttachApiAvailable() {
                return false;
            }
        };
    }

    static interface InternalProcessUtils {
        public boolean isProcessAlive(int var1);

        public boolean killProcess(int var1);

        public boolean isAvailable();

        public boolean isAttachApiAvailable();
    }
}

