/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.security;

import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.GemFireIOException;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.security.shiro.CustomAuthRealm;
import org.apache.geode.internal.security.shiro.GeodeAuthenticationToken;
import org.apache.geode.internal.security.shiro.ShiroPrincipal;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.PostProcessor;
import org.apache.geode.security.ResourcePermission;
import org.apache.geode.security.SecurityManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.ShiroException;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.SubjectThreadState;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.util.ThreadState;

public class IntegratedSecurityService
implements SecurityService {
    private static Logger logger = LogService.getLogger("org.apache.geode.security");
    private static SecurityService defaultInstance = new IntegratedSecurityService();
    private PostProcessor postProcessor;
    private SecurityManager securityManager;
    private Boolean isIntegratedSecurity;
    private boolean isClientAuthenticator;
    private boolean isPeerAuthenticator;

    public static SecurityService getSecurityService() {
        return defaultInstance;
    }

    private IntegratedSecurityService() {
    }

    @Override
    public Subject getSubject() {
        Set<ShiroPrincipal> principals;
        if (!this.isIntegratedSecurity()) {
            return null;
        }
        Subject currentUser = null;
        javax.security.auth.Subject jmxSubject = javax.security.auth.Subject.getSubject(AccessController.getContext());
        if (jmxSubject != null && (principals = jmxSubject.getPrincipals(ShiroPrincipal.class)).size() > 0) {
            ShiroPrincipal principal = principals.iterator().next();
            currentUser = principal.getSubject();
            ThreadContext.bind((Subject)currentUser);
            return currentUser;
        }
        currentUser = SecurityUtils.getSubject();
        if (currentUser == null || currentUser.getPrincipal() == null) {
            throw new GemFireSecurityException("Error: Anonymous User");
        }
        return currentUser;
    }

    @Override
    public Subject login(Properties credentials) {
        if (!this.isIntegratedSecurity()) {
            return null;
        }
        if (credentials == null) {
            return null;
        }
        ThreadContext.remove();
        Subject currentUser = SecurityUtils.getSubject();
        GeodeAuthenticationToken token = new GeodeAuthenticationToken(credentials);
        try {
            logger.debug("Logging in " + token.getPrincipal());
            currentUser.login((AuthenticationToken)token);
        }
        catch (ShiroException e) {
            logger.info(e.getMessage(), (Throwable)e);
            throw new AuthenticationFailedException("Authentication error. Please check your credentials.", e);
        }
        return currentUser;
    }

    @Override
    public void logout() {
        Subject currentUser = this.getSubject();
        if (currentUser == null) {
            return;
        }
        try {
            logger.debug("Logging out " + currentUser.getPrincipal());
            currentUser.logout();
        }
        catch (ShiroException e) {
            logger.info(e.getMessage(), (Throwable)e);
            throw new GemFireSecurityException(e.getMessage(), e);
        }
        ThreadContext.remove();
    }

    @Override
    public Callable associateWith(Callable callable) {
        Subject currentUser = this.getSubject();
        if (currentUser == null) {
            return callable;
        }
        return currentUser.associateWith(callable);
    }

    @Override
    public ThreadState bindSubject(Subject subject) {
        if (subject == null) {
            return null;
        }
        SubjectThreadState threadState = new SubjectThreadState(subject);
        threadState.bind();
        return threadState;
    }

    @Override
    public void authorize(ResourceOperation resourceOperation) {
        if (resourceOperation == null) {
            return;
        }
        this.authorize(resourceOperation.resource().name(), resourceOperation.operation().name(), null);
    }

    @Override
    public void authorizeClusterManage() {
        this.authorize("CLUSTER", "MANAGE");
    }

    @Override
    public void authorizeClusterWrite() {
        this.authorize("CLUSTER", "WRITE");
    }

    @Override
    public void authorizeClusterRead() {
        this.authorize("CLUSTER", "READ");
    }

    @Override
    public void authorizeDataManage() {
        this.authorize("DATA", "MANAGE");
    }

    @Override
    public void authorizeDataWrite() {
        this.authorize("DATA", "WRITE");
    }

    @Override
    public void authorizeDataRead() {
        this.authorize("DATA", "READ");
    }

    @Override
    public void authorizeRegionManage(String regionName) {
        this.authorize("DATA", "MANAGE", regionName);
    }

    @Override
    public void authorizeRegionManage(String regionName, String key) {
        this.authorize("DATA", "MANAGE", regionName, key);
    }

    @Override
    public void authorizeRegionWrite(String regionName) {
        this.authorize("DATA", "WRITE", regionName);
    }

    @Override
    public void authorizeRegionWrite(String regionName, String key) {
        this.authorize("DATA", "WRITE", regionName, key);
    }

    @Override
    public void authorizeRegionRead(String regionName) {
        this.authorize("DATA", "READ", regionName);
    }

    @Override
    public void authorizeRegionRead(String regionName, String key) {
        this.authorize("DATA", "READ", regionName, key);
    }

    @Override
    public void authorize(String resource, String operation) {
        this.authorize(resource, operation, null);
    }

    @Override
    public void authorize(String resource, String operation, String regionName) {
        this.authorize(resource, operation, regionName, null);
    }

    @Override
    public void authorize(String resource, String operation, String regionName, String key) {
        regionName = StringUtils.stripStart((String)regionName, (String)"/");
        this.authorize(new ResourcePermission(resource, operation, regionName, key));
    }

    @Override
    public void authorize(ResourcePermission context) {
        Subject currentUser = this.getSubject();
        if (currentUser == null) {
            return;
        }
        if (context == null) {
            return;
        }
        if (context.getResource() == ResourcePermission.Resource.NULL && context.getOperation() == ResourcePermission.Operation.NULL) {
            return;
        }
        try {
            currentUser.checkPermission((Permission)context);
        }
        catch (ShiroException e) {
            String msg = currentUser.getPrincipal() + " not authorized for " + (Object)((Object)context);
            logger.info(msg);
            throw new NotAuthorizedException(msg, e);
        }
    }

    @Override
    public void initSecurity(Properties securityProps) {
        if (securityProps == null) {
            return;
        }
        String shiroConfig = securityProps.getProperty("security-shiro-init");
        String securityManagerConfig = securityProps.getProperty("security-manager");
        String clientAuthenticatorConfig = securityProps.getProperty("security-client-authenticator");
        String peerAuthenticatorConfig = securityProps.getProperty("security-peer-authenticator");
        if (StringUtils.isNotBlank((String)shiroConfig)) {
            IniSecurityManagerFactory factory = new IniSecurityManagerFactory("classpath:" + shiroConfig);
            Ini.Section main = factory.getIni().addSection("main");
            main.put("geodePermissionResolver", "org.apache.geode.internal.security.shiro.GeodePermissionResolver");
            if (!main.containsKey((Object)"iniRealm.permissionResolver")) {
                main.put("iniRealm.permissionResolver", "$geodePermissionResolver");
            }
            org.apache.shiro.mgt.SecurityManager securityManager = (org.apache.shiro.mgt.SecurityManager)factory.getInstance();
            SecurityUtils.setSecurityManager((org.apache.shiro.mgt.SecurityManager)securityManager);
            this.isIntegratedSecurity = true;
            this.isClientAuthenticator = false;
            this.isPeerAuthenticator = false;
        } else if (StringUtils.isNotBlank((String)securityManagerConfig)) {
            SecurityManager securityManager = SecurityService.getObjectOfTypeFromClassName(securityManagerConfig, SecurityManager.class);
            securityManager.init(securityProps);
            this.setSecurityManager(securityManager);
        } else {
            this.isIntegratedSecurity = null;
            this.isClientAuthenticator = StringUtils.isNotBlank((String)clientAuthenticatorConfig);
            this.isPeerAuthenticator = StringUtils.isNotBlank((String)peerAuthenticatorConfig);
        }
        String customPostProcessor = securityProps.getProperty("security-post-processor");
        if (StringUtils.isNotBlank((String)customPostProcessor)) {
            this.postProcessor = SecurityService.getObjectOfTypeFromClassName(customPostProcessor, PostProcessor.class);
            this.postProcessor.init(securityProps);
        } else {
            this.postProcessor = null;
        }
    }

    @Override
    public void close() {
        if (this.securityManager != null) {
            this.securityManager.close();
            this.securityManager = null;
        }
        if (this.postProcessor != null) {
            this.postProcessor.close();
            this.postProcessor = null;
        }
        ThreadContext.remove();
        SecurityUtils.setSecurityManager(null);
        this.isIntegratedSecurity = null;
        this.isClientAuthenticator = false;
        this.isPeerAuthenticator = false;
    }

    @Override
    public boolean needPostProcess() {
        return this.isIntegratedSecurity() && this.postProcessor != null;
    }

    @Override
    public Object postProcess(String regionPath, Object key, Object value, boolean valueIsSerialized) {
        return this.postProcess(null, regionPath, key, value, valueIsSerialized);
    }

    @Override
    public Object postProcess(Object principal, String regionPath, Object key, Object value, boolean valueIsSerialized) {
        if (!this.needPostProcess()) {
            return value;
        }
        if (principal == null) {
            Subject subject = this.getSubject();
            if (subject == null) {
                return value;
            }
            principal = (Serializable)subject.getPrincipal();
        }
        String regionName = StringUtils.stripStart((String)regionPath, (String)"/");
        Object newValue = null;
        if (valueIsSerialized && value instanceof byte[]) {
            try {
                Object oldObj = EntryEventImpl.deserialize((byte[])value);
                Object newObj = this.postProcessor.processRegionValue(principal, regionName, key, oldObj);
                newValue = BlobHelper.serializeToBlob(newObj);
            }
            catch (IOException | SerializationException e) {
                throw new GemFireIOException("Exception de/serializing entry value", e);
            }
        } else {
            newValue = this.postProcessor.processRegionValue(principal, regionName, key, value);
        }
        return newValue;
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public void setSecurityManager(SecurityManager securityManager) {
        if (securityManager == null) {
            return;
        }
        this.securityManager = securityManager;
        CustomAuthRealm realm = new CustomAuthRealm(securityManager);
        DefaultSecurityManager shiroManager = new DefaultSecurityManager((Realm)realm);
        SecurityUtils.setSecurityManager((org.apache.shiro.mgt.SecurityManager)shiroManager);
        this.increaseShiroGlobalSessionTimeout(shiroManager);
        this.isIntegratedSecurity = true;
        this.isClientAuthenticator = false;
        this.isPeerAuthenticator = false;
    }

    private void increaseShiroGlobalSessionTimeout(DefaultSecurityManager shiroManager) {
        SessionManager sessionManager = shiroManager.getSessionManager();
        if (DefaultSessionManager.class.isInstance(sessionManager)) {
            DefaultSessionManager defaultSessionManager = (DefaultSessionManager)sessionManager;
            defaultSessionManager.setGlobalSessionTimeout(Long.MAX_VALUE);
            long value = defaultSessionManager.getGlobalSessionTimeout();
            if (value != Long.MAX_VALUE) {
                logger.error("Unable to set Shiro Global Session Timeout. Current value is '{}'.", (Object)value);
            }
        } else {
            logger.error("Unable to set Shiro Global Session Timeout. Current SessionManager is '{}'.", sessionManager == null ? "null" : sessionManager.getClass());
        }
    }

    @Override
    public PostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    @Override
    public void setPostProcessor(PostProcessor postProcessor) {
        if (postProcessor == null) {
            return;
        }
        this.postProcessor = postProcessor;
    }

    @Override
    public boolean isIntegratedSecurity() {
        if (this.isIntegratedSecurity != null) {
            return this.isIntegratedSecurity;
        }
        try {
            this.isIntegratedSecurity = SecurityUtils.getSecurityManager() != null;
        }
        catch (UnavailableSecurityManagerException e) {
            this.isIntegratedSecurity = false;
        }
        return this.isIntegratedSecurity;
    }

    @Override
    public boolean isClientSecurityRequired() {
        return this.isClientAuthenticator || this.isIntegratedSecurity();
    }

    @Override
    public boolean isPeerSecurityRequired() {
        return this.isPeerAuthenticator || this.isIntegratedSecurity();
    }
}

