/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.geode.GemFireCheckedException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class ConnectExceptions
extends GemFireCheckedException {
    private static final long serialVersionUID = -4173688946448867706L;
    private List causes = new ArrayList();
    private List members = new ArrayList();

    public ConnectExceptions() {
        super(LocalizedStrings.ConnectException_COULD_NOT_CONNECT.toLocalizedString());
    }

    public void addFailure(InternalDistributedMember member, Throwable cause) {
        this.members.add(member);
        this.causes.add(cause);
    }

    public List getMembers() {
        return this.members;
    }

    public List getCauses() {
        return this.causes;
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.members.iterator();
        while (iter.hasNext()) {
            sb.append(' ').append(iter.next());
        }
        sb.append(" ").append(LocalizedStrings.ConnectException_CAUSES.toLocalizedString());
        iter = this.causes.iterator();
        while (iter.hasNext()) {
            sb.append(" {").append(iter.next()).append("}");
        }
        return LocalizedStrings.ConnectException_COULD_NOT_CONNECT_TO_0.toLocalizedString(sb);
    }
}

