/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.management.internal.JmxManagerLocatorResponse;

public class JmxManagerLocatorRequest
implements DataSerializableFixedID {
    private static final JmxManagerLocatorRequest SINGLETON = new JmxManagerLocatorRequest();

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void toData(DataOutput out) throws IOException {
    }

    @Override
    public int getDSFID() {
        return 2150;
    }

    public String toString() {
        return "JmxManagerLocatorRequest";
    }

    public static JmxManagerLocatorResponse send(String locatorHost, int locatorPort, int msTimeout, Map<String, String> sslConfigProps) throws IOException {
        Properties distributionConfigProps = new Properties();
        InetAddress networkAddress = InetAddress.getByName(locatorHost);
        try {
            if (sslConfigProps != null) {
                distributionConfigProps.putAll(sslConfigProps);
            }
            TcpClient client = new TcpClient(new DistributionConfigImpl(distributionConfigProps));
            Object responseFromServer = client.requestToServer(networkAddress, locatorPort, SINGLETON, msTimeout);
            JmxManagerLocatorResponse jmxManagerLocatorResponse = (JmxManagerLocatorResponse)responseFromServer;
            return jmxManagerLocatorResponse;
        }
        catch (ClassNotFoundException unexpected) {
            throw new IllegalStateException(unexpected);
        }
        catch (ClassCastException unexpected) {
            throw new IllegalStateException(unexpected);
        }
        finally {
            distributionConfigProps.clear();
        }
    }

    public static JmxManagerLocatorResponse send(String locatorHost, int locatorPort, int msTimeout) throws IOException {
        return JmxManagerLocatorRequest.send(locatorHost, locatorPort, msTimeout, null);
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

