/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.LocatorLauncher;
import org.apache.geode.distributed.ServerLauncher;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.DLockStats;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.PureJavaMode;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.cache.DiskDirectoryStats;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DiskStoreStats;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionStats;
import org.apache.geode.internal.cache.control.ResourceManagerStats;
import org.apache.geode.internal.cache.execute.FunctionServiceStats;
import org.apache.geode.internal.cache.lru.LRUStatistics;
import org.apache.geode.internal.cache.persistence.BackupManager;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.logging.log4j.LogWriterAppender;
import org.apache.geode.internal.logging.log4j.LogWriterAppenders;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.offheap.MemoryAllocator;
import org.apache.geode.internal.offheap.OffHeapMemoryStats;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.internal.statistics.GemFireStatSampler;
import org.apache.geode.internal.statistics.HostStatHelper;
import org.apache.geode.internal.statistics.StatSamplerStats;
import org.apache.geode.internal.statistics.VMStatsContract;
import org.apache.geode.internal.statistics.platform.LinuxSystemStats;
import org.apache.geode.internal.statistics.platform.ProcessStats;
import org.apache.geode.internal.statistics.platform.SolarisSystemStats;
import org.apache.geode.internal.statistics.platform.WindowsSystemStats;
import org.apache.geode.internal.stats50.VMStats50;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.management.DependenciesNotFoundException;
import org.apache.geode.management.DiskBackupResult;
import org.apache.geode.management.GemFireProperties;
import org.apache.geode.management.JVMMetrics;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.OSMetrics;
import org.apache.geode.management.cli.CommandService;
import org.apache.geode.management.cli.CommandServiceException;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.ManagementConstants;
import org.apache.geode.management.internal.ManagementStrings;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.beans.BeanUtilFuncs;
import org.apache.geode.management.internal.beans.QueryDataFunction;
import org.apache.geode.management.internal.beans.stats.AggregateRegionStatsMonitor;
import org.apache.geode.management.internal.beans.stats.GCStatsMonitor;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;
import org.apache.geode.management.internal.beans.stats.MemberLevelDiskMonitor;
import org.apache.geode.management.internal.beans.stats.StatType;
import org.apache.geode.management.internal.beans.stats.StatsAverageLatency;
import org.apache.geode.management.internal.beans.stats.StatsLatency;
import org.apache.geode.management.internal.beans.stats.StatsRate;
import org.apache.geode.management.internal.beans.stats.VMStatsMonitor;
import org.apache.geode.management.internal.cli.CommandResponseBuilder;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.remote.MemberCommandService;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class MemberMBeanBridge {
    private static final Logger logger = LogService.getLogger();
    public static MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private static final long MBFactor = 0x100000L;
    private static TimeUnit nanoSeconds = TimeUnit.NANOSECONDS;
    private InternalCache cache;
    private DistributionConfig config;
    private GemFireProperties gemFirePropertyData;
    private InternalDistributedSystem system;
    private DM dm;
    private CommandService commandService;
    private String commandServiceInitError;
    private MemoryMXBean memoryMXBean;
    private ThreadMXBean threadMXBean;
    private RuntimeMXBean runtimeMXBean;
    private OperatingSystemMXBean osBean;
    private String hostname;
    private int processId;
    private ObjectName osObjectName;
    private long lastSystemTime;
    private long lastProcessCpuTime;
    private MBeanStatsMonitor monitor;
    private volatile boolean lockStatsAdded;
    private SystemManagementService service;
    private MemberLevelDiskMonitor diskMonitor;
    private AggregateRegionStatsMonitor regionMonitor;
    private StatsRate createsRate;
    private StatsRate bytesReceivedRate;
    private StatsRate bytesSentRate;
    private StatsRate destroysRate;
    private StatsRate functionExecutionRate;
    private StatsRate getsRate;
    private StatsRate putAllRate;
    private StatsRate putsRate;
    private StatsRate transactionCommitsRate;
    private StatsRate diskReadsRate;
    private StatsRate diskWritesRate;
    private StatsAverageLatency listenerCallsAvgLatency;
    private StatsAverageLatency writerCallsAvgLatency;
    private StatsAverageLatency putsAvgLatency;
    private StatsAverageLatency getsAvgLatency;
    private StatsAverageLatency putAllAvgLatency;
    private StatsAverageLatency loadsAverageLatency;
    private StatsAverageLatency netLoadsAverageLatency;
    private StatsAverageLatency netSearchAverageLatency;
    private StatsAverageLatency transactionCommitsAvgLatency;
    private StatsAverageLatency diskFlushAvgLatency;
    private StatsAverageLatency deserializationAvgLatency;
    private StatsLatency deserializationLatency;
    private StatsRate deserializationRate;
    private StatsAverageLatency serializationAvgLatency;
    private StatsLatency serializationLatency;
    private StatsRate serializationRate;
    private StatsAverageLatency pdxDeserializationAvgLatency;
    private StatsRate pdxDeserializationRate;
    private StatsRate lruDestroyRate;
    private StatsRate lruEvictionRate;
    private String gemFireVersion;
    private String classPath;
    private String name;
    private String id;
    private String osName;
    private GCStatsMonitor gcMonitor;
    private VMStatsMonitor vmStatsMonitor;
    private MBeanStatsMonitor systemStatsMonitor;
    private float instCreatesRate;
    private float instGetsRate;
    private float instPutsRate;
    private float instPutAllRate;
    private GemFireStatSampler sampler;
    private Statistics systemStat;
    private static final String MEMBER_LEVEL_DISK_MONITOR = "MemberLevelDiskMonitor";
    private static final String MEMBER_LEVEL_REGION_MONITOR = "MemberLevelRegionMonitor";
    private boolean cacheServer;
    private String redundancyZone;
    private ResourceManagerStats resourceManagerStats;

    public MemberMBeanBridge(InternalCache cache, SystemManagementService service) {
        block14: {
            block13: {
                this.lastSystemTime = 0L;
                this.lastProcessCpuTime = 0L;
                this.lockStatsAdded = false;
                this.osName = System.getProperty("os.name", "unknown");
                this.instCreatesRate = 0.0f;
                this.instGetsRate = 0.0f;
                this.instPutsRate = 0.0f;
                this.instPutAllRate = 0.0f;
                this.cacheServer = false;
                this.redundancyZone = "";
                this.cache = cache;
                this.service = service;
                this.system = (InternalDistributedSystem)cache.getDistributedSystem();
                this.dm = this.system.getDistributionManager();
                if (this.dm instanceof DistributionManager) {
                    DistributionManager distManager = (DistributionManager)this.system.getDistributionManager();
                    this.redundancyZone = distManager.getRedundancyZone(cache.getInternalDistributedSystem().getDistributedMember());
                }
                this.sampler = this.system.getStatSampler();
                this.config = this.system.getConfig();
                try {
                    this.commandService = CommandService.createLocalCommandService(cache);
                }
                catch (CacheClosedException e) {
                    this.commandServiceInitError = e.getMessage();
                    logger.info(LogMarker.CONFIG, "Command Service could not be initialized. {}", (Object)e.getMessage());
                }
                catch (CommandServiceException e) {
                    this.commandServiceInitError = e.getMessage();
                    logger.info(LogMarker.CONFIG, "Command Service could not be initialized. {}", (Object)e.getMessage());
                }
                catch (DependenciesNotFoundException e) {
                    this.commandServiceInitError = e.getMessage();
                    logger.info(LogMarker.CONFIG, "Command Service could not be initialized. {}", (Object)e.getMessage());
                }
                this.intitGemfireProperties();
                try {
                    InetAddress addr = SocketCreator.getLocalHost();
                    this.hostname = addr.getHostName();
                }
                catch (UnknownHostException ignore) {
                    this.hostname = "localhost";
                }
                try {
                    this.osObjectName = new ObjectName("java.lang:type=OperatingSystem");
                }
                catch (MalformedObjectNameException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(ex.getMessage(), (Throwable)ex);
                    }
                }
                catch (NullPointerException ex) {
                    if (!logger.isDebugEnabled()) break block13;
                    logger.debug(ex.getMessage(), (Throwable)ex);
                }
            }
            this.memoryMXBean = ManagementFactory.getMemoryMXBean();
            this.threadMXBean = ManagementFactory.getThreadMXBean();
            this.runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            this.osBean = ManagementFactory.getOperatingSystemMXBean();
            this.monitor = new MBeanStatsMonitor(ManagementStrings.MEMBER_CACHE_MONITOR.toLocalizedString());
            this.diskMonitor = new MemberLevelDiskMonitor(MEMBER_LEVEL_DISK_MONITOR);
            this.regionMonitor = new AggregateRegionStatsMonitor(MEMBER_LEVEL_REGION_MONITOR);
            this.gcMonitor = new GCStatsMonitor(ManagementStrings.GC_STATS_MONITOR.toLocalizedString());
            this.vmStatsMonitor = new VMStatsMonitor(ManagementStrings.VM_STATS_MONITOR.toLocalizedString());
            this.systemStatsMonitor = new MBeanStatsMonitor(ManagementStrings.SYSTEM_STATS_MONITOR.toLocalizedString());
            this.gemFireVersion = GemFireVersion.asString();
            this.classPath = this.runtimeMXBean.getClassPath();
            this.name = cache.getDistributedSystem().getDistributedMember().getName();
            this.id = cache.getDistributedSystem().getDistributedMember().getId();
            try {
                this.processId = ProcessUtils.identifyPid();
            }
            catch (PidUnavailableException ex) {
                if (!logger.isDebugEnabled()) break block14;
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        QueryDataFunction qDataFunction = new QueryDataFunction();
        FunctionService.registerFunction(qDataFunction);
        this.resourceManagerStats = cache.getInternalResourceManager().getStats();
    }

    public MemberMBeanBridge() {
        this.lastSystemTime = 0L;
        this.lastProcessCpuTime = 0L;
        this.lockStatsAdded = false;
        this.osName = System.getProperty("os.name", "unknown");
        this.instCreatesRate = 0.0f;
        this.instGetsRate = 0.0f;
        this.instPutsRate = 0.0f;
        this.instPutAllRate = 0.0f;
        this.cacheServer = false;
        this.redundancyZone = "";
        this.monitor = new MBeanStatsMonitor(ManagementStrings.MEMBER_CACHE_MONITOR.toLocalizedString());
        this.diskMonitor = new MemberLevelDiskMonitor(MEMBER_LEVEL_DISK_MONITOR);
        this.regionMonitor = new AggregateRegionStatsMonitor(MEMBER_LEVEL_REGION_MONITOR);
        this.gcMonitor = new GCStatsMonitor(ManagementStrings.GC_STATS_MONITOR.toLocalizedString());
        this.vmStatsMonitor = new VMStatsMonitor(ManagementStrings.VM_STATS_MONITOR.toLocalizedString());
        this.systemStatsMonitor = new MBeanStatsMonitor(ManagementStrings.SYSTEM_STATS_MONITOR.toLocalizedString());
        this.system = InternalDistributedSystem.getConnectedInstance();
        this.initializeStats();
    }

    public MemberMBeanBridge init() {
        OffHeapMemoryStats offHeapStats;
        MemoryAllocator allocator;
        CachePerfStats cachePerfStats = this.cache.getCachePerfStats();
        this.addCacheStats(cachePerfStats);
        this.addFunctionStats(this.system.getFunctionServiceStats());
        if (this.system.getDistributionManager().getStats() instanceof DistributionStats) {
            DistributionStats distributionStats = (DistributionStats)this.system.getDistributionManager().getStats();
            this.addDistributionStats(distributionStats);
        }
        if (PureJavaMode.osStatsAreAvailable()) {
            Statistics[] systemStats = null;
            if (HostStatHelper.isSolaris()) {
                systemStats = this.system.findStatisticsByType(SolarisSystemStats.getType());
            } else if (HostStatHelper.isLinux()) {
                systemStats = this.system.findStatisticsByType(LinuxSystemStats.getType());
            } else if (HostStatHelper.isOSX()) {
                systemStats = null;
            } else if (HostStatHelper.isWindows()) {
                systemStats = this.system.findStatisticsByType(WindowsSystemStats.getType());
            }
            if (systemStats != null) {
                this.systemStat = systemStats[0];
            }
        }
        if (null != (allocator = this.cache.getOffHeapStore()) && null != (offHeapStats = allocator.getStats())) {
            this.addOffHeapStats(offHeapStats);
        }
        this.addSystemStats();
        this.addVMStats();
        this.initializeStats();
        return this;
    }

    public void addOffHeapStats(OffHeapMemoryStats offHeapStats) {
        Statistics offHeapMemoryStatistics = offHeapStats.getStats();
        this.monitor.addStatisticsToMonitor(offHeapMemoryStatistics);
    }

    public void addCacheStats(CachePerfStats cachePerfStats) {
        Statistics cachePerfStatistics = cachePerfStats.getStats();
        this.monitor.addStatisticsToMonitor(cachePerfStatistics);
    }

    public void addFunctionStats(FunctionServiceStats functionServiceStats) {
        Statistics functionStatistics = functionServiceStats.getStats();
        this.monitor.addStatisticsToMonitor(functionStatistics);
    }

    public void addDistributionStats(DistributionStats distributionStats) {
        Statistics dsStats = distributionStats.getStats();
        this.monitor.addStatisticsToMonitor(dsStats);
    }

    public void addDiskStore(DiskStore dsi) {
        DiskStoreImpl impl = (DiskStoreImpl)dsi;
        this.addDiskStoreStats(impl.getStats());
    }

    public void addDiskStoreStats(DiskStoreStats stats) {
        this.diskMonitor.addStatisticsToMonitor(stats.getStats());
    }

    public void removeDiskStore(DiskStore dsi) {
        DiskStoreImpl impl = (DiskStoreImpl)dsi;
        this.removeDiskStoreStats(impl.getStats());
    }

    public void removeDiskStoreStats(DiskStoreStats stats) {
        this.diskMonitor.removeStatisticsFromMonitor(stats.getStats());
    }

    public void addRegion(Region region) {
        DiskRegion dr;
        LRUStatistics stats;
        LocalRegion l;
        if (region.getAttributes().getPartitionAttributes() != null) {
            this.addPartionRegionStats(((PartitionedRegion)region).getPrStats());
        }
        if ((l = (LocalRegion)region).getEvictionController() != null && (stats = l.getEvictionController().getLRUHelper().getStats()) != null) {
            this.addLRUStats(stats);
        }
        if ((dr = l.getDiskRegion()) != null) {
            for (DirectoryHolder dh : dr.getDirectories()) {
                this.addDirectoryStats(dh.getDiskDirectoryStats());
            }
        }
    }

    public void addPartionRegionStats(PartitionedRegionStats parStats) {
        this.regionMonitor.addStatisticsToMonitor(parStats.getStats());
    }

    public void addLRUStats(LRUStatistics lruStats) {
        this.regionMonitor.addStatisticsToMonitor(lruStats.getStats());
    }

    public void addDirectoryStats(DiskDirectoryStats diskDirStats) {
        this.regionMonitor.addStatisticsToMonitor(diskDirStats.getStats());
    }

    public void removeRegion(Region region) {
        DiskRegion dr;
        LRUStatistics stats;
        LocalRegion l;
        if (region.getAttributes().getPartitionAttributes() != null) {
            this.removePartionRegionStats(((PartitionedRegion)region).getPrStats());
        }
        if ((l = (LocalRegion)region).getEvictionController() != null && (stats = l.getEvictionController().getLRUHelper().getStats()) != null) {
            this.removeLRUStats(stats);
        }
        if ((dr = l.getDiskRegion()) != null) {
            for (DirectoryHolder dh : dr.getDirectories()) {
                this.removeDirectoryStats(dh.getDiskDirectoryStats());
            }
        }
    }

    public void removePartionRegionStats(PartitionedRegionStats parStats) {
        this.regionMonitor.removePartitionStatistics(parStats.getStats());
    }

    public void removeLRUStats(LRUStatistics lruStats) {
        this.regionMonitor.removeLRUStatistics(lruStats.getStats());
    }

    public void removeDirectoryStats(DiskDirectoryStats diskDirStats) {
        this.regionMonitor.removeDirectoryStatistics(diskDirStats.getStats());
    }

    public void addLockServiceStats(DLockService lock) {
        if (!this.lockStatsAdded) {
            DLockStats stats = (DLockStats)lock.getStats();
            this.addLockServiceStats(stats);
            this.lockStatsAdded = true;
        }
    }

    public void addLockServiceStats(DLockStats stats) {
        this.monitor.addStatisticsToMonitor(stats.getStats());
    }

    public void addSystemStats() {
        GemFireStatSampler sampler = this.system.getStatSampler();
        ProcessStats processStats = sampler.getProcessStats();
        StatSamplerStats samplerStats = sampler.getStatSamplerStats();
        if (processStats != null) {
            this.systemStatsMonitor.addStatisticsToMonitor(processStats.getStatistics());
        }
        if (samplerStats != null) {
            this.systemStatsMonitor.addStatisticsToMonitor(samplerStats.getStats());
        }
    }

    public void addVMStats() {
        VMStatsContract vmStatsContract = this.system.getStatSampler().getVMStats();
        if (vmStatsContract != null && vmStatsContract instanceof VMStats50) {
            Statistics[] gcStats;
            StatisticsType gcType;
            Statistics vmHeapStats;
            VMStats50 vmStats50 = (VMStats50)vmStatsContract;
            Statistics vmStats = vmStats50.getVMStats();
            if (vmStats != null) {
                this.vmStatsMonitor.addStatisticsToMonitor(vmStats);
            }
            if ((vmHeapStats = vmStats50.getVMHeapStats()) != null) {
                this.vmStatsMonitor.addStatisticsToMonitor(vmHeapStats);
            }
            if ((gcType = VMStats50.getGCType()) != null && (gcStats = this.system.findStatisticsByType(gcType)) != null && gcStats.length > 0) {
                for (Statistics gcStat : gcStats) {
                    if (gcStat == null) continue;
                    this.gcMonitor.addStatisticsToMonitor(gcStat);
                }
            }
        }
    }

    public Number getMemberLevelStatistic(String statName) {
        return this.monitor.getStatistic(statName);
    }

    public Number getVMStatistic(String statName) {
        return this.vmStatsMonitor.getStatistic(statName);
    }

    public Number getGCStatistic(String statName) {
        return this.gcMonitor.getStatistic(statName);
    }

    public Number getSystemStatistic(String statName) {
        return this.systemStatsMonitor.getStatistic(statName);
    }

    public void stopMonitor() {
        this.monitor.stopListener();
        this.regionMonitor.stopListener();
        this.gcMonitor.stopListener();
        this.systemStatsMonitor.stopListener();
        this.vmStatsMonitor.stopListener();
    }

    private void initializeStats() {
        this.createsRate = new StatsRate("creates", StatType.INT_TYPE, this.monitor);
        this.bytesReceivedRate = new StatsRate("receivedBytes", StatType.LONG_TYPE, this.monitor);
        this.bytesSentRate = new StatsRate("sentBytes", StatType.LONG_TYPE, this.monitor);
        this.destroysRate = new StatsRate("destroys", StatType.INT_TYPE, this.monitor);
        this.functionExecutionRate = new StatsRate("functionExecutionsCompleted", StatType.INT_TYPE, this.monitor);
        this.getsRate = new StatsRate("gets", StatType.INT_TYPE, this.monitor);
        this.putAllRate = new StatsRate("putalls", StatType.INT_TYPE, this.monitor);
        this.putsRate = new StatsRate("puts", StatType.INT_TYPE, this.monitor);
        this.transactionCommitsRate = new StatsRate("txCommits", StatType.INT_TYPE, this.monitor);
        this.diskReadsRate = new StatsRate("readBytes", StatType.LONG_TYPE, (MBeanStatsMonitor)this.diskMonitor);
        this.diskWritesRate = new StatsRate("writtenBytes", StatType.LONG_TYPE, (MBeanStatsMonitor)this.diskMonitor);
        this.listenerCallsAvgLatency = new StatsAverageLatency("cacheListenerCallsCompleted", StatType.INT_TYPE, "cacheListenerCallTime", this.monitor);
        this.writerCallsAvgLatency = new StatsAverageLatency("cacheWriterCallsCompleted", StatType.INT_TYPE, "cacheWriterCallTime", this.monitor);
        this.getsAvgLatency = new StatsAverageLatency("gets", StatType.INT_TYPE, "getTime", this.monitor);
        this.putAllAvgLatency = new StatsAverageLatency("putalls", StatType.INT_TYPE, "putallTime", this.monitor);
        this.putsAvgLatency = new StatsAverageLatency("puts", StatType.INT_TYPE, "putTime", this.monitor);
        this.loadsAverageLatency = new StatsAverageLatency("loadsCompleted", StatType.INT_TYPE, "loadTime", this.monitor);
        this.netLoadsAverageLatency = new StatsAverageLatency("netloadsCompleted", StatType.INT_TYPE, "netloadTime", this.monitor);
        this.netSearchAverageLatency = new StatsAverageLatency("netsearchesCompleted", StatType.INT_TYPE, "netsearchTime", this.monitor);
        this.transactionCommitsAvgLatency = new StatsAverageLatency("txCommits", StatType.INT_TYPE, "txCommitTime", this.monitor);
        this.diskFlushAvgLatency = new StatsAverageLatency("flushes", StatType.INT_TYPE, "flushTime", this.diskMonitor);
        this.deserializationAvgLatency = new StatsAverageLatency("deserializations", StatType.INT_TYPE, "deserializationTime", this.monitor);
        this.deserializationLatency = new StatsLatency("deserializations", StatType.INT_TYPE, "deserializationTime", this.monitor);
        this.deserializationRate = new StatsRate("deserializations", StatType.INT_TYPE, this.monitor);
        this.serializationAvgLatency = new StatsAverageLatency("serializations", StatType.INT_TYPE, "serializationTime", this.monitor);
        this.serializationLatency = new StatsLatency("serializations", StatType.INT_TYPE, "serializationTime", this.monitor);
        this.serializationRate = new StatsRate("serializations", StatType.INT_TYPE, this.monitor);
        this.pdxDeserializationAvgLatency = new StatsAverageLatency("pdxInstanceDeserializations", StatType.INT_TYPE, "pdxInstanceDeserializationTime", this.monitor);
        this.pdxDeserializationRate = new StatsRate("pdxInstanceDeserializations", StatType.INT_TYPE, this.monitor);
        this.lruDestroyRate = new StatsRate("lruDestroys", StatType.LONG_TYPE, (MBeanStatsMonitor)this.regionMonitor);
        this.lruEvictionRate = new StatsRate("lruEvictions", StatType.LONG_TYPE, (MBeanStatsMonitor)this.regionMonitor);
    }

    private void intitGemfireProperties() {
        if (this.gemFirePropertyData == null) {
            this.gemFirePropertyData = BeanUtilFuncs.initGemfireProperties(this.config);
        }
    }

    public JVMMetrics fetchJVMMetrics() {
        long gcCount = this.getGCStatistic("collections").longValue();
        long gcTimeMillis = this.getGCStatistic("collectionTime").longValue();
        long initMemory = this.memoryMXBean.getHeapMemoryUsage().getInit();
        long committedMemory = this.memoryMXBean.getHeapMemoryUsage().getCommitted();
        long usedMemory = this.getVMStatistic("usedMemory").longValue();
        long maxMemory = this.memoryMXBean.getHeapMemoryUsage().getMax();
        int totalThreads = this.getVMStatistic("threads").intValue();
        return new JVMMetrics(gcCount, gcTimeMillis, initMemory, committedMemory, usedMemory, maxMemory, totalThreads);
    }

    public OSMetrics fetchOSMetrics() {
        OSMetrics metrics;
        block16: {
            metrics = null;
            try {
                long maxFileDescriptorCount = 0L;
                long openFileDescriptorCount = 0L;
                long processCpuTime = 0L;
                long committedVirtualMemorySize = 0L;
                long totalPhysicalMemorySize = 0L;
                long freePhysicalMemorySize = 0L;
                long totalSwapSpaceSize = 0L;
                long freeSwapSpaceSize = 0L;
                String name = this.osBean.getName();
                String version = this.osBean.getVersion();
                String arch = this.osBean.getArch();
                int availableProcessors = this.osBean.getAvailableProcessors();
                double systemLoadAverage = this.osBean.getSystemLoadAverage();
                openFileDescriptorCount = this.getVMStatistic("fdsOpen").longValue();
                processCpuTime = this.getVMStatistic("processCpuTime").longValue();
                try {
                    maxFileDescriptorCount = (Long)mbeanServer.getAttribute(this.osObjectName, "MaxFileDescriptorCount");
                }
                catch (Exception ignore) {
                    maxFileDescriptorCount = -1L;
                }
                try {
                    committedVirtualMemorySize = (Long)mbeanServer.getAttribute(this.osObjectName, "CommittedVirtualMemorySize");
                }
                catch (Exception ignore) {
                    committedVirtualMemorySize = -1L;
                }
                if (PureJavaMode.osStatsAreAvailable() && HostStatHelper.isLinux() && this.systemStat != null) {
                    try {
                        totalPhysicalMemorySize = this.systemStat.get("physicalMemory").longValue();
                    }
                    catch (Exception ignore) {
                        totalPhysicalMemorySize = -1L;
                    }
                    try {
                        freePhysicalMemorySize = this.systemStat.get("freeMemory").longValue();
                    }
                    catch (Exception ignore) {
                        freePhysicalMemorySize = -1L;
                    }
                    try {
                        totalSwapSpaceSize = this.systemStat.get("allocatedSwap").longValue();
                    }
                    catch (Exception ignore) {
                        totalSwapSpaceSize = -1L;
                    }
                    try {
                        freeSwapSpaceSize = this.systemStat.get("unallocatedSwap").longValue();
                    }
                    catch (Exception ignore) {
                        freeSwapSpaceSize = -1L;
                    }
                } else {
                    totalPhysicalMemorySize = -1L;
                    freePhysicalMemorySize = -1L;
                    totalSwapSpaceSize = -1L;
                    freeSwapSpaceSize = -1L;
                }
                metrics = new OSMetrics(maxFileDescriptorCount, openFileDescriptorCount, processCpuTime, committedVirtualMemorySize, totalPhysicalMemorySize, freePhysicalMemorySize, totalSwapSpaceSize, freeSwapSpaceSize, name, version, arch, availableProcessors, systemLoadAverage);
            }
            catch (Exception ex) {
                if (!logger.isTraceEnabled()) break block16;
                logger.trace(ex.getMessage(), (Throwable)ex);
            }
        }
        return metrics;
    }

    public GemFireProperties getGemFireProperty() {
        return this.gemFirePropertyData;
    }

    public boolean createManager() {
        if (this.service.isManager()) {
            return false;
        }
        return this.service.createManager();
    }

    public String[] compactAllDiskStores() {
        ArrayList<String> compactedStores = new ArrayList<String>();
        if (this.cache != null && !this.cache.isClosed()) {
            for (DiskStore store : this.cache.listDiskStoresIncludingRegionOwned()) {
                if (!store.forceCompaction()) continue;
                compactedStores.add(((DiskStoreImpl)store).getPersistentID().getDirectory());
            }
        }
        String[] compactedStoresAr = new String[compactedStores.size()];
        return compactedStores.toArray(compactedStoresAr);
    }

    public String[] listDiskStores(boolean includeRegionOwned) {
        String[] retStr = null;
        Collection<DiskStore> diskCollection = null;
        diskCollection = includeRegionOwned ? this.cache.listDiskStoresIncludingRegionOwned() : this.cache.listDiskStores();
        if (diskCollection != null && diskCollection.size() > 0) {
            retStr = new String[diskCollection.size()];
            Iterator<DiskStore> it = diskCollection.iterator();
            int i = 0;
            while (it.hasNext()) {
                retStr[i] = it.next().getName();
                ++i;
            }
        }
        return retStr;
    }

    public String[] getDiskStores() {
        return this.listDiskStores(true);
    }

    public String fetchLog(int numLines) {
        if (numLines > 100) {
            numLines = 100;
        }
        if (numLines == 0 || numLines < 0) {
            numLines = 30;
        }
        String childTail = null;
        String mainTail = null;
        try {
            InternalDistributedSystem sys = this.system;
            LogWriterAppender lwa = LogWriterAppenders.getAppender(LogWriterAppenders.Identifier.MAIN);
            if (lwa != null) {
                childTail = BeanUtilFuncs.tailSystemLog(lwa.getChildLogFile(), numLines);
                mainTail = BeanUtilFuncs.tailSystemLog(sys.getConfig(), numLines);
                if (mainTail == null) {
                    mainTail = LocalizedStrings.TailLogResponse_NO_LOG_FILE_WAS_SPECIFIED_IN_THE_CONFIGURATION_MESSAGES_WILL_BE_DIRECTED_TO_STDOUT.toLocalizedString();
                }
            } else {
                Assert.assertTrue(false, "TailLogRequest/Response processed in application vm with shared logging.");
            }
        }
        catch (IOException e) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.TailLogResponse_ERROR_OCCURRED_WHILE_READING_SYSTEM_LOG__0, e));
            mainTail = "";
        }
        if (childTail == null && mainTail == null) {
            return LocalizedStrings.SystemMemberImpl_NO_LOG_FILE_CONFIGURED_LOG_MESSAGES_WILL_BE_DIRECTED_TO_STDOUT.toLocalizedString();
        }
        StringBuilder result = new StringBuilder();
        if (mainTail != null) {
            result.append(mainTail);
        }
        if (childTail != null) {
            result.append(SystemUtils.getLineSeparator()).append(LocalizedStrings.SystemMemberImpl_TAIL_OF_CHILD_LOG.toLocalizedString()).append(SystemUtils.getLineSeparator());
            result.append(childTail);
        }
        return result.toString();
    }

    public void shutDownMember() {
        final InternalDistributedSystem ids = this.dm.getSystem();
        if (ids.isConnected()) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ConnectionTable.threadWantsSharedResources();
                    if (ids.isConnected()) {
                        ids.disconnect();
                    }
                }
            });
            t.setDaemon(false);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskBackupResult[] backupMember(String targetDirPath) {
        if (this.cache != null) {
            Collection<DiskStore> diskStores = this.cache.listDiskStoresIncludingRegionOwned();
            for (DiskStore store : diskStores) {
                store.flush();
            }
        }
        DiskBackupResult[] diskBackUpResult = null;
        File targetDir = new File(targetDirPath);
        if (this.cache == null) {
            return null;
        }
        try {
            HashSet<PersistentID> successfulDataStores;
            HashSet<PersistentID> existingDataStores;
            BackupManager manager = this.cache.startBackup(this.cache.getInternalDistributedSystem().getDistributedMember());
            boolean abort = true;
            try {
                existingDataStores = manager.prepareBackup();
                abort = false;
            }
            finally {
                successfulDataStores = manager.finishBackup(targetDir, null, abort);
            }
            diskBackUpResult = new DiskBackupResult[existingDataStores.size()];
            int j = 0;
            for (PersistentID id : existingDataStores) {
                diskBackUpResult[j] = successfulDataStores.contains(id) ? new DiskBackupResult(id.getDirectory(), false) : new DiskBackupResult(id.getDirectory(), true);
                ++j;
            }
        }
        catch (IOException e) {
            throw new ManagementException(e);
        }
        return diskBackUpResult;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getMember() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        return this.id;
    }

    public String[] getGroups() {
        List<String> groups = this.cache.getDistributedSystem().getDistributedMember().getGroups();
        String[] groupsArray = new String[groups.size()];
        groupsArray = groups.toArray(groupsArray);
        return groupsArray;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String[] listConnectedGatewayReceivers() {
        if (this.cache != null && this.cache.getGatewayReceivers().size() > 0) {
            Set<GatewayReceiver> receivers = this.cache.getGatewayReceivers();
            String[] arr = new String[receivers.size()];
            int j = 0;
            for (GatewayReceiver recv : receivers) {
                arr[j] = recv.getBindAddress();
                ++j;
            }
            return arr;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public String[] listConnectedGatewaySenders() {
        if (this.cache != null && this.cache.getGatewaySenders().size() > 0) {
            Set<GatewaySender> senders = this.cache.getGatewaySenders();
            String[] arr = new String[senders.size()];
            int j = 0;
            for (GatewaySender sender : senders) {
                arr[j] = sender.getId();
                ++j;
            }
            return arr;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public float getCpuUsage() {
        return this.vmStatsMonitor.getCpuUsage();
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public String getHost() {
        return this.hostname;
    }

    public int getProcessId() {
        return this.processId;
    }

    public String status() {
        if (LocatorLauncher.getInstance() != null) {
            return LocatorLauncher.getLocatorState().toJson();
        }
        if (ServerLauncher.getInstance() != null) {
            return ServerLauncher.getServerState().toJson();
        }
        return null;
    }

    public long getTotalBytesInUse() {
        MemoryUsage memHeap = this.memoryMXBean.getHeapMemoryUsage();
        return memHeap.getUsed();
    }

    public int getAvailableCpus() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.availableProcessors();
    }

    public String[] fetchJvmThreads() {
        long[] threadIds = this.threadMXBean.getAllThreadIds();
        ThreadInfo[] threadInfos = this.threadMXBean.getThreadInfo(threadIds, 0);
        if (threadInfos == null || threadInfos.length < 1) {
            return ManagementConstants.NO_DATA_STRING;
        }
        ArrayList<String> thrdStr = new ArrayList<String>(threadInfos.length);
        for (ThreadInfo thInfo : threadInfos) {
            if (thInfo == null) continue;
            thrdStr.add(thInfo.getThreadName());
        }
        String[] result = new String[thrdStr.size()];
        return thrdStr.toArray(result);
    }

    public String[] getListOfRegions() {
        Set<LocalRegion> listOfAppRegions = this.cache.getApplicationRegions();
        if (listOfAppRegions != null && listOfAppRegions.size() > 0) {
            String[] regionStr = new String[listOfAppRegions.size()];
            int j = 0;
            for (LocalRegion rg : listOfAppRegions) {
                regionStr[j] = rg.getFullPath();
                ++j;
            }
            return regionStr;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public long getLockLease() {
        return this.cache.getLockLease();
    }

    public long getLockTimeout() {
        return this.cache.getLockTimeout();
    }

    public long getMemberUpTime() {
        return this.cache.getUpTime();
    }

    public String[] getRootRegionNames() {
        Set<Region<?, ?>> listOfRootRegions = this.cache.rootRegions();
        if (listOfRootRegions != null && listOfRootRegions.size() > 0) {
            String[] regionNames = new String[listOfRootRegions.size()];
            int j = 0;
            for (Region<?, ?> region : listOfRootRegions) {
                regionNames[j] = region.getFullPath();
                ++j;
            }
            return regionNames;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public String getVersion() {
        return this.gemFireVersion;
    }

    public boolean hasGatewayReceiver() {
        return this.cache != null && this.cache.getGatewayReceivers().size() > 0;
    }

    public boolean hasGatewaySender() {
        return this.cache != null && this.cache.getAllGatewaySenders().size() > 0;
    }

    public boolean isLocator() {
        return Locator.hasLocator();
    }

    public boolean isManager() {
        if (this.cache == null || this.cache.isClosed()) {
            return false;
        }
        try {
            return this.service.isManager();
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public boolean isManagerCreated() {
        if (this.cache == null || this.cache.isClosed()) {
            return false;
        }
        try {
            return this.service.isManagerCreated();
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public boolean isServer() {
        return this.cache.isServer();
    }

    public int getInitialImageKeysReceived() {
        return this.getMemberLevelStatistic("getInitialImageKeysReceived").intValue();
    }

    public long getInitialImageTime() {
        return this.getMemberLevelStatistic("getInitialImageTime").longValue();
    }

    public int getInitialImagesInProgres() {
        return this.getMemberLevelStatistic("getInitialImagesInProgress").intValue();
    }

    public long getTotalIndexMaintenanceTime() {
        return this.getMemberLevelStatistic("indexUpdateTime").longValue();
    }

    public float getBytesReceivedRate() {
        return this.bytesReceivedRate.getRate();
    }

    public float getBytesSentRate() {
        return this.bytesSentRate.getRate();
    }

    public long getCacheListenerCallsAvgLatency() {
        return this.listenerCallsAvgLatency.getAverageLatency();
    }

    public long getCacheWriterCallsAvgLatency() {
        return this.writerCallsAvgLatency.getAverageLatency();
    }

    public float getCreatesRate() {
        this.instCreatesRate = this.createsRate.getRate();
        return this.instCreatesRate;
    }

    public float getDestroysRate() {
        return this.destroysRate.getRate();
    }

    public float getDiskReadsRate() {
        return this.diskReadsRate.getRate();
    }

    public float getDiskWritesRate() {
        return this.diskWritesRate.getRate();
    }

    public int getTotalBackupInProgress() {
        return this.diskMonitor.getBackupsInProgress();
    }

    public int getTotalBackupCompleted() {
        return this.diskMonitor.getBackupsCompleted();
    }

    public long getDiskFlushAvgLatency() {
        return this.diskFlushAvgLatency.getAverageLatency();
    }

    public float getFunctionExecutionRate() {
        return this.functionExecutionRate.getRate();
    }

    public long getGetsAvgLatency() {
        return this.getsAvgLatency.getAverageLatency();
    }

    public float getGetsRate() {
        this.instGetsRate = this.getsRate.getRate();
        return this.instGetsRate;
    }

    public int getLockWaitsInProgress() {
        return this.getMemberLevelStatistic("lockWaitsInProgress").intValue();
    }

    public int getNumRunningFunctions() {
        return this.getMemberLevelStatistic("functionExecutionsRunning").intValue();
    }

    public int getNumRunningFunctionsHavingResults() {
        return this.getMemberLevelStatistic("functionExecutionsHasResultRunning").intValue();
    }

    public long getPutAllAvgLatency() {
        return this.putAllAvgLatency.getAverageLatency();
    }

    public float getPutAllRate() {
        this.instPutAllRate = this.putAllRate.getRate();
        return this.instPutAllRate;
    }

    public long getPutsAvgLatency() {
        return this.putsAvgLatency.getAverageLatency();
    }

    public float getPutsRate() {
        this.instPutsRate = this.putsRate.getRate();
        return this.instPutsRate;
    }

    public int getLockRequestQueues() {
        return this.getMemberLevelStatistic("requestQueues").intValue();
    }

    public int getPartitionRegionCount() {
        return this.getMemberLevelStatistic("partitionedRegions").intValue();
    }

    public int getTotalPrimaryBucketCount() {
        return this.regionMonitor.getTotalPrimaryBucketCount();
    }

    public int getTotalBucketCount() {
        return this.regionMonitor.getTotalBucketCount();
    }

    public int getTotalBucketSize() {
        return this.regionMonitor.getTotalBucketSize();
    }

    public int getTotalHitCount() {
        return this.getMemberLevelStatistic("gets").intValue() - this.getTotalMissCount();
    }

    public float getLruDestroyRate() {
        return this.lruDestroyRate.getRate();
    }

    public float getLruEvictionRate() {
        return this.lruEvictionRate.getRate();
    }

    public int getTotalLoadsCompleted() {
        return this.getMemberLevelStatistic("loadsCompleted").intValue();
    }

    public long getLoadsAverageLatency() {
        return this.loadsAverageLatency.getAverageLatency();
    }

    public int getTotalNetLoadsCompleted() {
        return this.getMemberLevelStatistic("netloadsCompleted").intValue();
    }

    public long getNetLoadsAverageLatency() {
        return this.netLoadsAverageLatency.getAverageLatency();
    }

    public int getTotalNetSearchCompleted() {
        return this.getMemberLevelStatistic("netsearchesCompleted").intValue();
    }

    public long getNetSearchAverageLatency() {
        return this.netSearchAverageLatency.getAverageLatency();
    }

    public long getTotalLockWaitTime() {
        return this.getMemberLevelStatistic("lockWaitTime").intValue();
    }

    public int getTotalMissCount() {
        return this.getMemberLevelStatistic("misses").intValue();
    }

    public int getTotalNumberOfLockService() {
        return this.getMemberLevelStatistic("services").intValue();
    }

    public int getTotalNumberOfGrantors() {
        return this.getMemberLevelStatistic("grantors").intValue();
    }

    public int getTotalDiskTasksWaiting() {
        return this.getMemberLevelStatistic("diskTasksWaiting").intValue();
    }

    public int getTotalRegionCount() {
        return this.getMemberLevelStatistic("regions").intValue();
    }

    public int getTotalRegionEntryCount() {
        return this.getMemberLevelStatistic("entries").intValue();
    }

    public int getTotalTransactionsCount() {
        return this.getMemberLevelStatistic("txCommits").intValue() + this.getMemberLevelStatistic("txRollbacks").intValue();
    }

    public long getTransactionCommitsAvgLatency() {
        return this.transactionCommitsAvgLatency.getAverageLatency();
    }

    public float getTransactionCommitsRate() {
        return this.transactionCommitsRate.getRate();
    }

    public int getTransactionCommittedTotalCount() {
        return this.getMemberLevelStatistic("txCommits").intValue();
    }

    public int getTransactionRolledBackTotalCount() {
        return this.getMemberLevelStatistic("txRollbacks").intValue();
    }

    public long getDeserializationAvgLatency() {
        return this.deserializationAvgLatency.getAverageLatency();
    }

    public long getDeserializationLatency() {
        return this.deserializationLatency.getLatency();
    }

    public float getDeserializationRate() {
        return this.deserializationRate.getRate();
    }

    public long getSerializationAvgLatency() {
        return this.serializationAvgLatency.getAverageLatency();
    }

    public long getSerializationLatency() {
        return this.serializationLatency.getLatency();
    }

    public float getSerializationRate() {
        return this.serializationRate.getRate();
    }

    public long getPDXDeserializationAvgLatency() {
        return this.pdxDeserializationAvgLatency.getAverageLatency();
    }

    public float getPDXDeserializationRate() {
        return this.pdxDeserializationRate.getRate();
    }

    public String processCommand(String commandString, Map<String, String> env) {
        Result result;
        if (this.commandService == null) {
            throw new JMRuntimeException("Command can not be processed as Command Service did not get initialized. Reason: " + this.commandServiceInitError);
        }
        boolean isGfshRequest = this.isGfshRequest(env);
        if (isGfshRequest) {
            CommandExecutionContext.setShellRequest();
        }
        if (!((result = ((MemberCommandService)this.commandService).processCommand(commandString, env)) instanceof CommandResult)) {
            while (result.hasNextLine()) {
                result = ResultBuilder.createInfoResult(result.nextLine());
            }
        }
        if (isGfshRequest) {
            return CommandResponseBuilder.createCommandResponseJson(this.getMember(), (CommandResult)result);
        }
        return ResultBuilder.resultAsString(result);
    }

    private boolean isGfshRequest(Map<String, String> env) {
        String appName = null;
        if (env != null) {
            appName = env.get("APP_NAME");
        }
        return "gfsh".equals(appName);
    }

    public long getTotalDiskUsage() {
        return this.regionMonitor.getDiskSpace();
    }

    public float getAverageReads() {
        return this.instGetsRate;
    }

    public float getAverageWrites() {
        return this.instCreatesRate + this.instPutsRate + this.instPutAllRate;
    }

    public long getGarbageCollectionTime() {
        return this.getGCStatistic("collectionTime").longValue();
    }

    public long getGarbageCollectionCount() {
        return this.getGCStatistic("collections").longValue();
    }

    public long getJVMPauses() {
        return this.getSystemStatistic("jvmPauses").intValue();
    }

    public double getLoadAverage() {
        return this.osBean.getSystemLoadAverage();
    }

    public int getNumThreads() {
        return this.getVMStatistic("threads").intValue();
    }

    public long getFileDescriptorLimit() {
        if (!this.osName.startsWith("Linux")) {
            return -1L;
        }
        long maxFileDescriptorCount = 0L;
        try {
            maxFileDescriptorCount = (Long)mbeanServer.getAttribute(this.osObjectName, "MaxFileDescriptorCount");
        }
        catch (Exception ignore) {
            maxFileDescriptorCount = -1L;
        }
        return maxFileDescriptorCount;
    }

    public long getTotalFileDescriptorOpen() {
        if (!this.osName.startsWith("Linux")) {
            return -1L;
        }
        return this.getVMStatistic("fdsOpen").longValue();
    }

    public int getOffHeapObjects() {
        int objects = 0;
        OffHeapMemoryStats stats = this.getOffHeapStats();
        if (null != stats) {
            objects = stats.getObjects();
        }
        return objects;
    }

    @Deprecated
    public long getOffHeapFreeSize() {
        return this.getOffHeapFreeMemory();
    }

    @Deprecated
    public long getOffHeapUsedSize() {
        return this.getOffHeapUsedMemory();
    }

    public long getOffHeapMaxMemory() {
        long usedSize = 0L;
        OffHeapMemoryStats stats = this.getOffHeapStats();
        if (null != stats) {
            usedSize = stats.getMaxMemory();
        }
        return usedSize;
    }

    public long getOffHeapFreeMemory() {
        long freeSize = 0L;
        OffHeapMemoryStats stats = this.getOffHeapStats();
        if (null != stats) {
            freeSize = stats.getFreeMemory();
        }
        return freeSize;
    }

    public long getOffHeapUsedMemory() {
        long usedSize = 0L;
        OffHeapMemoryStats stats = this.getOffHeapStats();
        if (null != stats) {
            usedSize = stats.getUsedMemory();
        }
        return usedSize;
    }

    public int getOffHeapFragmentation() {
        int fragmentation = 0;
        OffHeapMemoryStats stats = this.getOffHeapStats();
        if (null != stats) {
            fragmentation = stats.getFragmentation();
        }
        return fragmentation;
    }

    public long getOffHeapCompactionTime() {
        long compactionTime = 0L;
        OffHeapMemoryStats stats = this.getOffHeapStats();
        if (null != stats) {
            compactionTime = stats.getDefragmentationTime();
        }
        return compactionTime;
    }

    private OffHeapMemoryStats getOffHeapStats() {
        OffHeapMemoryStats stats = null;
        MemoryAllocator offHeap = this.cache.getOffHeapStore();
        if (null != offHeap) {
            stats = offHeap.getStats();
        }
        return stats;
    }

    public int getHostCpuUsage() {
        if (this.systemStat != null) {
            return this.systemStat.get("cpuActive").intValue();
        }
        return -1;
    }

    public boolean isCacheServer() {
        return this.cacheServer;
    }

    public void setCacheServer(boolean cacheServer) {
        this.cacheServer = cacheServer;
    }

    public String getRedundancyZone() {
        return this.redundancyZone;
    }

    public int getRebalancesInProgress() {
        return this.resourceManagerStats.getRebalancesInProgress();
    }

    public int getReplyWaitsInProgress() {
        return this.getMemberLevelStatistic("replyWaitsInProgress").intValue();
    }

    public int getReplyWaitsCompleted() {
        return this.getMemberLevelStatistic("replyWaitsCompleted").intValue();
    }

    public int getVisibleNodes() {
        return this.getMemberLevelStatistic("nodes").intValue();
    }

    public long getMaxMemory() {
        Runtime rt = Runtime.getRuntime();
        return rt.maxMemory() / 0x100000L;
    }

    public long getFreeMemory() {
        Runtime rt = Runtime.getRuntime();
        return rt.freeMemory() / 0x100000L;
    }

    public long getUsedMemory() {
        return this.getVMStatistic("usedMemory").longValue() / 0x100000L;
    }
}

