/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterConfigurationService;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.FileResult;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.functions.GetRegionNamesFunction;
import org.apache.geode.management.internal.configuration.functions.RecreateCacheFunction;
import org.apache.geode.management.internal.configuration.utils.ZipUtils;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ExportImportClusterConfigurationCommands
implements GfshCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"export cluster-configuration"}, help="Exports the cluster configuration artifacts as a zip file.")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.ExportImportClusterConfigurationCommands$ExportInterceptor", relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result exportSharedConfig(@CliOption(key={"zip-file-name"}, mandatory=true, help="Path to the zip file containing the exported cluster configuration artifacts") String zipFileName) {
        Result result;
        Path tempDir;
        InternalLocator locator = InternalLocator.getLocator();
        if (!locator.isSharedConfigurationRunning()) {
            return ResultBuilder.createGemFireErrorResult("Cluster configuration service is enabled but has not started yet.");
        }
        try {
            tempDir = Files.createTempDirectory("clusterConfig", new FileAttribute[0]);
        }
        catch (IOException e) {
            this.logSevere(e);
            ErrorResultData errorData = ResultBuilder.createErrorResultData().addLine("Unable to create temp directory");
            return ResultBuilder.buildResult(errorData);
        }
        File zipFile = tempDir.resolve("exportedCC.zip").toFile();
        ClusterConfigurationService sc = locator.getSharedConfiguration();
        try {
            for (Configuration config : sc.getEntireConfiguration().values()) {
                sc.writeConfigToFile(config);
            }
            ZipUtils.zipDirectory(sc.getSharedConfigurationDirPath(), zipFile.getCanonicalPath());
            InfoResultData infoData = ResultBuilder.createInfoResultData();
            byte[] byteData = FileUtils.readFileToByteArray((File)zipFile);
            infoData.addAsFile(zipFileName, byteData, 0, "Downloading cluster configuration : {0}", false);
            result = ResultBuilder.buildResult(infoData);
        }
        catch (Exception e) {
            ErrorResultData errorData = ResultBuilder.createErrorResultData();
            errorData.addLine("Export failed");
            this.logSevere(e);
            result = ResultBuilder.buildResult(errorData);
        }
        finally {
            zipFile.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"import cluster-configuration"}, help="Imports configuration into cluster configuration hosted at the locators")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.ExportImportClusterConfigurationCommands$ImportInterceptor", relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result importSharedConfig(@CliOption(key={"zip-file-name"}, mandatory=true, help="The zip file containing the cluster configuration artifacts, which are to be imported") String zip) {
        InternalLocator locator = InternalLocator.getLocator();
        if (!locator.isSharedConfigurationRunning()) {
            ErrorResultData errorData = ResultBuilder.createErrorResultData();
            errorData.addLine("Cluster configuration service is enabled but has not started yet.");
            return ResultBuilder.buildResult(errorData);
        }
        InternalCache cache = this.getCache();
        Set<DistributedMember> servers = CliUtil.getAllNormalMembers(cache);
        Set regionsWithData = servers.stream().map(this::getRegionNamesOnServer).flatMap(Collection::stream).collect(Collectors.toSet());
        if (!regionsWithData.isEmpty()) {
            return ResultBuilder.createGemFireErrorResult("Cannot import cluster configuration with existing regions: " + regionsWithData.stream().collect(Collectors.joining(",")));
        }
        byte[][] shellBytesData = CommandExecutionContext.getBytesFromShell();
        String zipFileName = CliUtil.bytesToNames(shellBytesData)[0];
        byte[] zipBytes = CliUtil.bytesToData(shellBytesData)[0];
        InfoResultData infoData = ResultBuilder.createInfoResultData();
        File zipFile = new File(zipFileName);
        try {
            ClusterConfigurationService sc = locator.getSharedConfiguration();
            for (Configuration config : sc.getEntireConfiguration().values()) {
                sc.writeConfigToFile(config);
            }
            sc.renameExistingSharedConfigDirectory();
            FileUtils.writeByteArrayToFile((File)zipFile, (byte[])zipBytes);
            ZipUtils.unzip(zipFileName, sc.getSharedConfigurationDirPath());
            sc.loadSharedConfigurationFromDisk();
            infoData.addLine("Cluster configuration successfully imported");
        }
        catch (Exception e) {
            Result result;
            ErrorResultData errorData = ResultBuilder.createErrorResultData();
            errorData.addLine("Import failed");
            this.logSevere(e);
            Result config = result = ResultBuilder.buildResult(errorData);
            return config;
        }
        finally {
            FileUtils.deleteQuietly((File)zipFile);
        }
        Set functionResults = servers.stream().map(this::reCreateCache).collect(Collectors.toSet());
        for (CliFunctionResult functionResult : functionResults) {
            if (functionResult.isSuccessful()) {
                infoData.addLine("Successfully applied the imported cluster configuration on " + functionResult.getMemberIdOrName());
                continue;
            }
            infoData.addLine("Failed to apply the imported cluster configuration on " + functionResult.getMemberIdOrName() + " due to " + functionResult.getMessage());
        }
        Result result = ResultBuilder.buildResult(infoData);
        return result;
    }

    private Set<String> getRegionNamesOnServer(DistributedMember server) {
        ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)new GetRegionNamesFunction(), null, server);
        List results = (List)rc.getResult();
        return (Set)results.get(0);
    }

    private CliFunctionResult reCreateCache(DistributedMember server) {
        ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)new RecreateCacheFunction(), null, server);
        List results = (List)rc.getResult();
        return (CliFunctionResult)results.get(0);
    }

    @CliAvailabilityIndicator(value={"export cluster-configuration", "import cluster-configuration"})
    public boolean sharedConfigCommandsAvailable() {
        boolean isAvailable = true;
        if (CliUtil.isGfshVM()) {
            isAvailable = this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
        }
        return isAvailable;
    }

    public static class ImportInterceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            FileResult fileResult;
            Map<String, String> paramValueMap = parseResult.getParamValueStrings();
            String zip = paramValueMap.get("zip-file-name");
            if ((zip = StringUtils.trim((String)zip)) == null) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Parameter \"{0}\"  is required. Use \"help <command name>\" for assistance.", (Object)"zip-file-name"));
            }
            if (!zip.endsWith(".zip")) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".zip"));
            }
            try {
                fileResult = new FileResult(new String[]{zip});
            }
            catch (FileNotFoundException fnfex) {
                return ResultBuilder.createUserErrorResult("'" + zip + "' not found.");
            }
            catch (IOException ioex) {
                return ResultBuilder.createGemFireErrorResult(ioex.getClass().getName() + ": " + ioex.getMessage());
            }
            return fileResult;
        }
    }

    public static class ExportInterceptor
    extends AbstractCliAroundInterceptor {
        private String saveDirString;
        private static final Logger logger = LogService.getLogger();

        @Override
        public Result preExecution(GfshParseResult parseResult) {
            Map<String, String> paramValueMap = parseResult.getParamValueStrings();
            String zip = paramValueMap.get("zip-file-name");
            if (!zip.endsWith(".zip")) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".zip"));
            }
            return ResultBuilder.createInfoResult("OK");
        }

        @Override
        public Result postExecution(GfshParseResult parseResult, Result commandResult, Path tempFile) {
            if (commandResult.hasIncomingFiles()) {
                try {
                    commandResult.saveIncomingFiles(System.getProperty("user.dir"));
                    return commandResult;
                }
                catch (IOException ioex) {
                    logger.error((Object)ioex);
                    return ResultBuilder.createShellClientErrorResult("Unable to export config: " + ioex.getMessage());
                }
            }
            return null;
        }
    }
}

