/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.LocatorLauncher;
import org.apache.geode.distributed.ServerLauncher;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.process.ClusterConfigurationNotAvailableException;
import org.apache.geode.internal.process.ProcessStreamReader;
import org.apache.geode.internal.process.ProcessType;
import org.apache.geode.internal.process.signal.SignalEvent;
import org.apache.geode.internal.process.signal.SignalListener;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.commands.ShellCommands;
import org.apache.geode.management.internal.cli.domain.ConnectToLocatorResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.JmxOperationInvoker;
import org.apache.geode.management.internal.cli.shell.MXBeanProvider;
import org.apache.geode.management.internal.cli.util.CauseFinder;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.management.internal.cli.util.ConnectionEndpoint;
import org.apache.geode.management.internal.cli.util.HostUtils;
import org.apache.geode.management.internal.cli.util.ThreePhraseGenerator;
import org.apache.geode.management.internal.configuration.utils.ClusterConfigurationStatusRetriever;
import org.apache.geode.security.AuthenticationFailedException;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class LauncherLifecycleCommands
implements GfshCommand {
    private static final String SERVER_TERM_NAME = "Server";
    private static final long PROCESS_STREAM_READER_JOIN_TIMEOUT_MILLIS = 30000L;
    private static final long PROCESS_STREAM_READER_ASYNC_STOP_TIMEOUT_MILLIS = 5000L;
    private static final long WAITING_FOR_STOP_TO_MAKE_PID_GO_AWAY_TIMEOUT_MILLIS = 30000L;
    private static final long WAITING_FOR_PID_FILE_TO_CONTAIN_PID_TIMEOUT_MILLIS = 2000L;
    protected static final int CMS_INITIAL_OCCUPANCY_FRACTION = 60;
    protected static final int INVALID_PID = -1;
    protected static final int MINIMUM_HEAP_FREE_RATIO = 10;
    protected static final String GEODE_HOME = System.getenv("GEODE_HOME");
    protected static final String JAVA_HOME = System.getProperty("java.home");
    protected static final String GEODE_JAR_PATHNAME = IOUtils.appendToPath(GEODE_HOME, "lib", GemFireVersion.getGemFireJarFileName());
    protected static final String CORE_DEPENDENCIES_JAR_PATHNAME = IOUtils.appendToPath(GEODE_HOME, "lib", "geode-dependencies.jar");
    private final ThreePhraseGenerator nameGenerator = new ThreePhraseGenerator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"start locator"}, help="Start a Locator.")
    @CliMetaData(shellOnly=true, relatedTopic={"Locator", "Lifecycle"})
    public Result startLocator(@CliOption(key={"name"}, help="The member name to give this Locator in the Geode cluster.") String memberName, @CliOption(key={"bind-address"}, help="IP address on which the Locator will be bound.  By default, the Locator is bound to all local addresses.") String bindAddress, @CliOption(key={"classpath"}, help="Location of user application classes required by the Locator. The user classpath is prepended to the Locator's classpath.") String classpath, @CliOption(key={"force"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to allow the PID file from a previous Locator run to be overwritten.") Boolean force, @CliOption(key={"group"}, optionContext="geode.converter.member.groups", help="Group(s) the Locator will be a part of.") String group, @CliOption(key={"hostname-for-clients"}, help="Hostname or IP address that will be sent to clients so they can connect to this Locator. The default is the bind-address of the Locator.") String hostnameForClients, @CliOption(key={"include-system-classpath"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Includes the System CLASSPATH on the Locator's CLASSPATH. The System CLASSPATH is not included by default.") Boolean includeSystemClasspath, @CliOption(key={"locators"}, optionContext="geode.converter.locators.discovery.config", help="Sets the list of Locators used by this Locator to join the appropriate Geode cluster.") String locators, @CliOption(key={"log-level"}, optionContext="geode.converter.log.levels:disable-string-converter", help="Sets the level of output logged to the Locator log file.  Possible values for log-level include: ALL, TRACE, DEBUG, INFO, WARN, ERROR, FATAL, OFF.") String logLevel, @CliOption(key={"mcast-address"}, help="The IP address or hostname used to bind the UPD socket for multi-cast networking so the Locator can communicate with other members in the Geode cluster using a common multicast address and port.  If mcast-port is zero, then mcast-address is ignored.") String mcastBindAddress, @CliOption(key={"mcast-port"}, help="Sets the port used for multi-cast networking so the Locator can communicate with other members of the Geode cluster.  A zero value disables mcast.") Integer mcastPort, @CliOption(key={"port"}, help="Port the Locator will listen on.") Integer port, @CliOption(key={"dir"}, help="Directory in which the Locator will be started and ran. The default is ./<locator-member-name>") String workingDirectory, @CliOption(key={"properties-file"}, optionContext="geode.converter.file.path:disable-string-converter", help="The gemfire.properties file for configuring the Locator's distributed system. The file's path can be absolute or relative to the gfsh working directory (--dir=).") String gemfirePropertiesPathname, @CliOption(key={"security-properties-file"}, optionContext="geode.converter.file.path:disable-string-converter", help="The gfsecurity.properties file for configuring the Locator's security configuration in the distributed system. The file's path can be absolute or relative to gfsh directory (--dir=).") String gemfireSecurityPropertiesPathname, @CliOption(key={"initial-heap"}, help="Initial size of the heap in the same format as the JVM -Xms parameter.") String initialHeap, @CliOption(key={"max-heap"}, help="Maximum size of the heap in the same format as the JVM -Xmx parameter.") String maxHeap, @CliOption(key={"J"}, optionContext="splittingRegex=\u001f", help="Argument passed to the JVM on which the Locator will run. For example, --J=-Dfoo.bar=true will set the property \"foo.bar\" to \"true\".") String[] jvmArgsOpts, @CliOption(key={"connect"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="When connect is set to false , Gfsh does not automatically connect to the locator which is started using this command.") boolean connect, @CliOption(key={"enable-cluster-configuration"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="When enable-cluster-configuration is set to true, locator hosts and serves cluster configuration.") boolean enableSharedConfiguration, @CliOption(key={"load-cluster-configuration-from-dir"}, unspecifiedDefaultValue="false", help="When \" load-cluster-configuration-from-dir \" is set to true, the locator loads the cluster configuration from the \"cluster_config\" directory.") boolean loadSharedConfigurationFromDirectory, @CliOption(key={"cluster-config-dir"}, unspecifiedDefaultValue="", help="Directory used by the cluster configuration service to store the cluster configuration on the filesystem") String clusterConfigDir, @CliOption(key={"http-service-port"}, help="Port on which HTTP Service will listen on") Integer httpServicePort, @CliOption(key={"http-service-bind-address"}, help="The IP address on which the HTTP Service will be bound.  By default, the Server is bound to all local addresses.") String httpServiceBindAddress) {
        Result result;
        try {
            LocatorLauncher.LocatorState locatorState;
            if (StringUtils.isBlank((String)memberName)) {
                memberName = this.nameGenerator.generate('-');
            }
            workingDirectory = this.resolveWorkingDir(workingDirectory, memberName);
            if (StringUtils.isNotBlank((String)(gemfirePropertiesPathname = CliUtil.resolvePathname(gemfirePropertiesPathname))) && !IOUtils.isExistingPathname(gemfirePropertiesPathname)) {
                Result result2 = ResultBuilder.createUserErrorResult(CliStrings.format("Warning: The Geode {0}properties file {1} could not be found.", "", gemfirePropertiesPathname));
                return result2;
            }
            if (StringUtils.isNotBlank((String)(gemfireSecurityPropertiesPathname = CliUtil.resolvePathname(gemfireSecurityPropertiesPathname))) && !IOUtils.isExistingPathname(gemfireSecurityPropertiesPathname)) {
                Result result3 = ResultBuilder.createUserErrorResult(CliStrings.format("Warning: The Geode {0}properties file {1} could not be found.", "Security ", gemfireSecurityPropertiesPathname));
                return result3;
            }
            File locatorPidFile = new File(workingDirectory, ProcessType.LOCATOR.getPidFileName());
            int oldPid = this.readPid(locatorPidFile);
            Properties gemfireProperties = new Properties();
            gemfireProperties.setProperty("groups", StringUtils.defaultString((String)group));
            gemfireProperties.setProperty("locators", StringUtils.defaultString((String)locators));
            gemfireProperties.setProperty("log-level", StringUtils.defaultString((String)logLevel));
            gemfireProperties.setProperty("mcast-address", StringUtils.defaultString((String)mcastBindAddress));
            gemfireProperties.setProperty("mcast-port", StringUtils.defaultString(mcastPort));
            gemfireProperties.setProperty("enable-cluster-configuration", StringUtils.defaultString(enableSharedConfiguration));
            gemfireProperties.setProperty("load-cluster-configuration-from-dir", StringUtils.defaultString(loadSharedConfigurationFromDirectory));
            gemfireProperties.setProperty("cluster-configuration-dir", StringUtils.defaultString((String)clusterConfigDir));
            gemfireProperties.setProperty("http-service-port", StringUtils.defaultString(httpServicePort));
            gemfireProperties.setProperty("http-service-bind-address", StringUtils.defaultString((String)httpServiceBindAddress));
            boolean redirectOutput = Boolean.getBoolean("gemfire.OSProcess.ENABLE_OUTPUT_REDIRECTION");
            LocatorLauncher.Builder locatorLauncherBuilder = new LocatorLauncher.Builder().setBindAddress(bindAddress).setForce(force).setPort(port).setRedirectOutput(redirectOutput).setWorkingDirectory(workingDirectory);
            if (hostnameForClients != null) {
                locatorLauncherBuilder.setHostnameForClients(hostnameForClients);
            }
            if (memberName != null) {
                locatorLauncherBuilder.setMemberName(memberName);
            }
            LocatorLauncher locatorLauncher = locatorLauncherBuilder.build();
            String[] locatorCommandLine = this.createStartLocatorCommandLine(locatorLauncher, gemfirePropertiesPathname, gemfireSecurityPropertiesPathname, gemfireProperties, classpath, includeSystemClasspath, jvmArgsOpts, initialHeap, maxHeap);
            Process locatorProcess = new ProcessBuilder(locatorCommandLine).directory(new File(locatorLauncher.getWorkingDirectory())).start();
            locatorProcess.getInputStream().close();
            locatorProcess.getOutputStream().close();
            final ProcessStreamReader.ReadingMode readingMode = SystemUtils.isWindows() ? ProcessStreamReader.ReadingMode.NON_BLOCKING : ProcessStreamReader.ReadingMode.BLOCKING;
            final StringBuffer message = new StringBuffer();
            ProcessStreamReader.InputListener inputListener = new ProcessStreamReader.InputListener(){

                @Override
                public void notifyInputLine(String line) {
                    message.append(line);
                    if (readingMode == ProcessStreamReader.ReadingMode.BLOCKING) {
                        message.append(StringUtils.LINE_SEPARATOR);
                    }
                }
            };
            ProcessStreamReader stderrReader = new ProcessStreamReader.Builder(locatorProcess).inputStream(locatorProcess.getErrorStream()).inputListener(inputListener).readingMode(readingMode).continueReadingMillis(2000L).build().start();
            String previousLocatorStatusMessage = null;
            LauncherSignalListener locatorSignalListener = new LauncherSignalListener();
            boolean registeredLocatorSignalListener = this.getGfsh().getSignalHandler().registerListener(locatorSignalListener);
            try {
                this.getGfsh().logInfo(String.format("Starting a Geode Locator in %1$s...", IOUtils.tryGetCanonicalPathElseGetAbsolutePath(new File(locatorLauncher.getWorkingDirectory()))), null);
                locatorState = LocatorLauncher.LocatorState.fromDirectory(workingDirectory, memberName);
                do {
                    if (locatorProcess.isAlive()) {
                        Gfsh.print(".");
                        LauncherLifecycleCommands launcherLifecycleCommands = this;
                        synchronized (launcherLifecycleCommands) {
                            TimeUnit.MILLISECONDS.timedWait(this, 500L);
                        }
                        locatorState = LocatorLauncher.LocatorState.fromDirectory(workingDirectory, memberName);
                        String currentLocatorStatusMessage = locatorState.getStatusMessage();
                        if (!locatorState.isStartingOrNotResponding() || StringUtils.isBlank((String)currentLocatorStatusMessage) || currentLocatorStatusMessage.equalsIgnoreCase(previousLocatorStatusMessage) || currentLocatorStatusMessage.trim().toLowerCase().equals("null")) continue;
                        Gfsh.println();
                        Gfsh.println(currentLocatorStatusMessage);
                        previousLocatorStatusMessage = currentLocatorStatusMessage;
                        continue;
                    }
                    int exitValue = locatorProcess.exitValue();
                    Result result4 = ResultBuilder.createShellClientErrorResult(String.format("The Locator process terminated unexpectedly with exit status %1$d. Please refer to the log file in %2$s for full details.%n%n%3$s", exitValue, locatorLauncher.getWorkingDirectory(), message.toString()));
                    return result4;
                } while ((!registeredLocatorSignalListener || !locatorSignalListener.isSignaled()) && locatorState.isStartingOrNotResponding());
            }
            finally {
                stderrReader.stopAsync(5000L);
                this.getGfsh().getSignalHandler().unregisterListener(locatorSignalListener);
            }
            Gfsh.println();
            boolean asyncStart = registeredLocatorSignalListener && locatorSignalListener.isSignaled() && ServerLauncher.ServerState.isStartingNotRespondingOrNull(locatorState);
            InfoResultData infoResultData = ResultBuilder.createInfoResultData();
            if (asyncStart) {
                infoResultData.addLine(String.format("Broken out of wait... the %1$s process will continue to startup in the background.%n", "Locator"));
            } else {
                infoResultData.addLine(locatorState.toString());
                InetAddress bindAddr = locatorLauncher.getBindAddress();
                String locatorHostName = bindAddr != null ? bindAddr.getCanonicalHostName() : StringUtils.defaultIfBlank((String)locatorLauncher.getHostnameForClients(), (String)HostUtils.getLocalHost());
                int locatorPort = Integer.parseInt(locatorState.getPort());
                if (this.shouldAutoConnect(connect)) {
                    this.doAutoConnect(locatorHostName, locatorPort, gemfirePropertiesPathname, gemfireSecurityPropertiesPathname, infoResultData);
                }
                if (enableSharedConfiguration) {
                    infoResultData.addLine(ClusterConfigurationStatusRetriever.fromLocator(locatorHostName, locatorPort));
                }
            }
            Result result5 = ResultBuilder.buildResult(infoResultData);
            return result5;
        }
        catch (IllegalArgumentException e) {
            String message = e.getMessage();
            if (message != null && message.matches(LocalizedStrings.Launcher_Builder_UNKNOWN_HOST_ERROR_MESSAGE.toLocalizedString(".+"))) {
                message = CliStrings.format("Failed to start {0}. Reason: {1}", "Locator", message);
            }
            result = ResultBuilder.createUserErrorResult(message);
            return result;
        }
        catch (IllegalStateException e) {
            Result message = ResultBuilder.createUserErrorResult(e.getMessage());
            return message;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            String errorMessage = String.format("An error occurred while attempting to start a Locator in %1$s on %2$s: %3$s", StringUtils.defaultIfBlank((String)workingDirectory, (String)memberName), HostUtils.getLocatorId(bindAddress, port), this.toString(t, this.getGfsh().getDebug()));
            this.getGfsh().logToFile(errorMessage, t);
            result = ResultBuilder.createShellClientErrorResult(errorMessage);
            return result;
        }
        finally {
            Gfsh.redirectInternalJavaLoggers();
        }
    }

    protected String[] createStartLocatorCommandLine(LocatorLauncher launcher, String gemfirePropertiesPathname, String gemfireSecurityPropertiesPathname, Properties gemfireProperties, String userClasspath, Boolean includeSystemClasspath, String[] jvmArgsOpts, String initialHeap, String maxHeap) throws MalformedObjectNameException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getJavaPath());
        commandLine.add("-server");
        commandLine.add("-classpath");
        commandLine.add(this.getLocatorClasspath(Boolean.TRUE.equals(includeSystemClasspath), userClasspath));
        this.addCurrentLocators(commandLine, gemfireProperties);
        this.addGemFirePropertyFile(commandLine, gemfirePropertiesPathname);
        this.addGemFireSecurityPropertyFile(commandLine, gemfireSecurityPropertiesPathname);
        this.addGemFireSystemProperties(commandLine, gemfireProperties);
        this.addJvmArgumentsAndOptions(commandLine, jvmArgsOpts);
        this.addInitialHeap(commandLine, initialHeap);
        this.addMaxHeap(commandLine, maxHeap);
        commandLine.add("-D".concat("gemfire.launcher.registerSignalHandlers".concat("=true")));
        commandLine.add("-Djava.awt.headless=true");
        commandLine.add("-Dsun.rmi.dgc.server.gcInterval".concat("=").concat(Long.toString(0x7FFFFFFFFFFFFFFEL)));
        commandLine.add(LocatorLauncher.class.getName());
        commandLine.add(LocatorLauncher.Command.START.getName());
        if (StringUtils.isNotBlank((String)launcher.getMemberName())) {
            commandLine.add(launcher.getMemberName());
        }
        if (launcher.getBindAddress() != null) {
            commandLine.add("--bind-address=" + launcher.getBindAddress().getCanonicalHostName());
        }
        if (launcher.isDebugging() || this.isDebugging()) {
            commandLine.add("--debug");
        }
        if (launcher.isForcing()) {
            commandLine.add("--force");
        }
        if (StringUtils.isNotBlank((String)launcher.getHostnameForClients())) {
            commandLine.add("--hostname-for-clients=" + launcher.getHostnameForClients());
        }
        if (launcher.getPort() != null) {
            commandLine.add("--port=" + launcher.getPort());
        }
        if (launcher.isRedirectingOutput()) {
            commandLine.add("--redirect-output");
        }
        return commandLine.toArray(new String[commandLine.size()]);
    }

    private boolean shouldAutoConnect(boolean connect) {
        return connect && this.getGfsh() != null && !this.isConnectedAndReady();
    }

    private boolean doAutoConnect(String locatorHostname, int locatorPort, String gemfirePropertiesPathname, String gemfireSecurityPropertiesPathname, InfoResultData infoResultData) {
        boolean connectSuccess = false;
        boolean jmxManagerAuthEnabled = false;
        boolean jmxManagerSslEnabled = false;
        Map<String, String> configurationProperties = this.loadConfigurationProperties(gemfireSecurityPropertiesPathname, this.loadConfigurationProperties(gemfirePropertiesPathname));
        HashMap<String, String> locatorConfigurationProperties = new HashMap<String, String>(configurationProperties);
        String responseFailureMessage = null;
        for (int attempts = 0; attempts < 10 && !connectSuccess; ++attempts) {
            try {
                ConnectToLocatorResult connectToLocatorResult = ShellCommands.connectToLocator(locatorHostname, locatorPort, ShellCommands.getConnectLocatorTimeoutInMS() / 4, locatorConfigurationProperties);
                ConnectionEndpoint memberEndpoint = connectToLocatorResult.getMemberEndpoint();
                jmxManagerSslEnabled = connectToLocatorResult.isJmxManagerSslEnabled();
                if (!jmxManagerSslEnabled) {
                    configurationProperties.clear();
                }
                this.getGfsh().setOperationInvoker(new JmxOperationInvoker(memberEndpoint.getHost(), memberEndpoint.getPort(), null, null, configurationProperties, null));
                String shellAndLogMessage = CliStrings.format("Successfully connected to: {0}", (Object)("JMX Manager " + memberEndpoint.toString(false)));
                infoResultData.addLine("\n");
                infoResultData.addLine(shellAndLogMessage);
                this.getGfsh().logToFile(shellAndLogMessage, null);
                connectSuccess = true;
                responseFailureMessage = null;
                continue;
            }
            catch (IllegalStateException unexpected) {
                if (CauseFinder.indexOfCause(unexpected, ClassCastException.class, false) == -1) continue;
                responseFailureMessage = "The Locator might require SSL Configuration.";
                continue;
            }
            catch (SecurityException ignore) {
                this.getGfsh().logToFile(ignore.getMessage(), ignore);
                jmxManagerAuthEnabled = true;
                break;
            }
            catch (AuthenticationFailedException ignore) {
                this.getGfsh().logToFile(ignore.getMessage(), ignore);
                jmxManagerAuthEnabled = true;
                break;
            }
            catch (SSLException ignore) {
                if (ignore instanceof SSLHandshakeException) {
                    locatorConfigurationProperties.clear();
                    continue;
                }
                this.getGfsh().logToFile(ignore.getMessage(), ignore);
                responseFailureMessage = "Check your SSL configuration and try again.";
                break;
            }
            catch (Exception ignore) {
                this.getGfsh().logToFile(ignore.getMessage(), ignore);
                responseFailureMessage = "Failed to connect; unknown cause: " + ignore.getMessage();
            }
        }
        if (!connectSuccess) {
            this.doOnConnectionFailure(locatorHostname, locatorPort, jmxManagerAuthEnabled, jmxManagerSslEnabled, infoResultData);
        }
        if (StringUtils.isNotBlank(responseFailureMessage)) {
            infoResultData.addLine("\n");
            infoResultData.addLine(responseFailureMessage);
        }
        return connectSuccess;
    }

    private void doOnConnectionFailure(String locatorHostName, int locatorPort, boolean jmxManagerAuthEnabled, boolean jmxManagerSslEnabled, InfoResultData infoResultData) {
        infoResultData.addLine("\n");
        infoResultData.addLine(CliStrings.format("Please use \"{0}\" to connect Gfsh to the locator.", (Object)new CommandStringBuilder("connect").addOption("locator", locatorHostName + "[" + locatorPort + "]").toString()));
        StringBuilder message = new StringBuilder();
        if (jmxManagerAuthEnabled) {
            message.append("Authentication");
        }
        if (jmxManagerSslEnabled) {
            message.append(jmxManagerAuthEnabled ? " and " : "").append("SSL configuration");
        }
        if (jmxManagerAuthEnabled || jmxManagerSslEnabled) {
            message.append(" required to connect to the Manager.");
            infoResultData.addLine("\n");
            infoResultData.addLine(message.toString());
        }
    }

    private Map<String, String> loadConfigurationProperties(String configurationPropertiesPathname) {
        return this.loadConfigurationProperties(configurationPropertiesPathname, null);
    }

    private Map<String, String> loadConfigurationProperties(String configurationPropertiesPathname, Map<String, String> configurationProperties) {
        HashMap<String, String> hashMap = configurationProperties = configurationProperties != null ? configurationProperties : new HashMap<String, String>();
        if (IOUtils.isExistingPathname(configurationPropertiesPathname)) {
            try {
                configurationProperties.putAll(ShellCommands.loadPropertiesFromURL(new File(configurationPropertiesPathname).toURI().toURL()));
            }
            catch (MalformedURLException ignore) {
                LogWrapper.getInstance().warning(String.format("Failed to load GemFire configuration properties from pathname (%1$s)!", configurationPropertiesPathname), ignore);
            }
        }
        return configurationProperties;
    }

    protected void addCurrentLocators(List<String> commandLine, Properties gemfireProperties) throws MalformedObjectNameException {
        String currentLocators;
        if (StringUtils.isBlank((String)gemfireProperties.getProperty("locators")) && StringUtils.isNotBlank((String)(currentLocators = this.getCurrentLocators()))) {
            commandLine.add("-D".concat("gemfire.default.").concat("locators").concat("=").concat(currentLocators));
        }
    }

    protected void addGemFirePropertyFile(List<String> commandLine, String gemfirePropertiesPathname) {
        if (StringUtils.isNotBlank((String)gemfirePropertiesPathname)) {
            commandLine.add("-DgemfirePropertyFile=" + gemfirePropertiesPathname);
        }
    }

    protected void addGemFireSecurityPropertyFile(List<String> commandLine, String gemfireSecurityPropertiesPathname) {
        if (StringUtils.isNotBlank((String)gemfireSecurityPropertiesPathname)) {
            commandLine.add("-DgemfireSecurityPropertyFile=" + gemfireSecurityPropertiesPathname);
        }
    }

    protected void addGemFireSystemProperties(List<String> commandLine, Properties gemfireProperties) {
        for (Object property : gemfireProperties.keySet()) {
            String propertyName = property.toString();
            String propertyValue = gemfireProperties.getProperty(propertyName);
            if (!StringUtils.isNotBlank((String)propertyValue)) continue;
            commandLine.add("-Dgemfire." + propertyName + "=" + propertyValue);
        }
    }

    protected void addInitialHeap(List<String> commandLine, String initialHeap) {
        if (StringUtils.isNotBlank((String)initialHeap)) {
            commandLine.add("-Xms" + initialHeap);
        }
    }

    protected void addJvmArgumentsAndOptions(List<String> commandLine, String[] jvmArgsOpts) {
        if (jvmArgsOpts != null) {
            commandLine.addAll(Arrays.asList(jvmArgsOpts));
        }
    }

    protected void addJvmOptionsForOutOfMemoryErrors(List<String> commandLine) {
        if (SystemUtils.isHotSpotVM()) {
            if (SystemUtils.isWindows()) {
                commandLine.add("-XX:OnOutOfMemoryError=taskkill /F /PID %p");
            } else {
                commandLine.add("-XX:OnOutOfMemoryError=kill -KILL %p");
            }
        } else if (SystemUtils.isJ9VM()) {
            commandLine.add("-Xcheck:memory");
        } else if (SystemUtils.isJRockitVM()) {
            commandLine.add("-XXexitOnOutOfMemory");
        }
    }

    protected void addMaxHeap(List<String> commandLine, String maxHeap) {
        if (StringUtils.isNotBlank((String)maxHeap)) {
            commandLine.add("-Xmx" + maxHeap);
            commandLine.add("-XX:+UseConcMarkSweepGC");
            commandLine.add("-XX:CMSInitiatingOccupancyFraction=60");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readPid(File pidFile) {
        assert (pidFile != null) : "The file from which to read the process ID (pid) cannot be null!";
        if (pidFile.isFile()) {
            int n;
            BufferedReader fileReader = null;
            try {
                fileReader = new BufferedReader(new FileReader(pidFile));
                n = Integer.parseInt(fileReader.readLine());
            }
            catch (IOException | NumberFormatException exception) {
                IOUtils.close(fileReader);
            }
            catch (Throwable throwable) {
                IOUtils.close(fileReader);
                throw throwable;
            }
            IOUtils.close(fileReader);
            return n;
        }
        return -1;
    }

    @Deprecated
    protected String getClasspath(String userClasspath) {
        String classpath = this.getSystemClasspath();
        if (StringUtils.isNotBlank((String)userClasspath)) {
            classpath = classpath + File.pathSeparator + userClasspath;
        }
        return classpath;
    }

    protected String getLocatorClasspath(boolean includeSystemClasspath, String userClasspath) {
        return this.toClasspath(includeSystemClasspath, new String[]{CORE_DEPENDENCIES_JAR_PATHNAME}, userClasspath);
    }

    protected String getServerClasspath(boolean includeSystemClasspath, String userClasspath) {
        ArrayList<String> jarFilePathnames = new ArrayList<String>();
        jarFilePathnames.add(CORE_DEPENDENCIES_JAR_PATHNAME);
        return this.toClasspath(includeSystemClasspath, jarFilePathnames.toArray(new String[jarFilePathnames.size()]), userClasspath);
    }

    protected String getSystemClasspath() {
        return System.getProperty("java.class.path");
    }

    String toClasspath(boolean includeSystemClasspath, String[] jarFilePathnames, String ... userClasspaths) {
        StringBuilder classpath = new StringBuilder(this.getGemFireJarPath());
        for (String userClasspath : userClasspaths = userClasspaths != null ? userClasspaths : ArrayUtils.EMPTY_STRING_ARRAY) {
            if (!StringUtils.isNotBlank((String)userClasspath)) continue;
            classpath.append(classpath.length() == 0 ? "" : File.pathSeparator);
            classpath.append(userClasspath);
        }
        if (includeSystemClasspath) {
            classpath.append(File.pathSeparator);
            classpath.append(this.getSystemClasspath());
        }
        jarFilePathnames = jarFilePathnames != null ? jarFilePathnames : ArrayUtils.EMPTY_STRING_ARRAY;
        for (String jarFilePathname : jarFilePathnames) {
            if (!StringUtils.isNotBlank((String)jarFilePathname)) continue;
            classpath.append(classpath.length() == 0 ? "" : File.pathSeparator);
            classpath.append(jarFilePathname);
        }
        return classpath.toString();
    }

    protected String getGemFireJarPath() {
        String classpath = this.getSystemClasspath();
        String gemfireJarPath = GEODE_JAR_PATHNAME;
        for (String classpathElement : classpath.split(File.pathSeparator)) {
            if (!classpathElement.endsWith("gemfire-core-8.2.0.0-SNAPSHOT.jar")) continue;
            gemfireJarPath = classpathElement;
            break;
        }
        return gemfireJarPath;
    }

    protected String getJavaPath() {
        return new File(new File(JAVA_HOME, "bin"), "java").getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CliCommand(value={"start server"}, help="Start a Geode Cache Server.")
    @CliMetaData(shellOnly=true, relatedTopic={"Server", "Lifecycle"})
    public Result startServer(@CliOption(key={"name"}, help="The member name to give this Cache Server in the Geode cluster.") String memberName, @CliOption(key={"assign-buckets"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to assign buckets to the partitioned regions of the cache on server start.") Boolean assignBuckets, @CliOption(key={"bind-address"}, help="The IP address on which the Server will be bound.  By default, the Server is bound to all local addresses.") String bindAddress, @CliOption(key={"cache-xml-file"}, optionContext="geode.converter.file.path:disable-string-converter", help="Specifies the name of the XML file or resource to initialize the cache with when it is created.") String cacheXmlPathname, @CliOption(key={"classpath"}, help="Location of user application classes required by the Server. The user classpath is prepended to the Server's classpath.") String classpath, @CliOption(key={"critical-heap-percentage"}, help="Set the percentage of heap at or above which the cache is considered in danger of becoming inoperable due to garbage collection pauses or out of memory exceptions") Float criticalHeapPercentage, @CliOption(key={"critical-off-heap-percentage"}, help="Set the percentage of off-heap memory at or above which the cache is considered in danger of becoming inoperable due to out of memory exceptions") Float criticalOffHeapPercentage, @CliOption(key={"dir"}, help="Directory in which the Cache Server will be started and ran. The default is ./<server-member-name>") String workingDirectory, @CliOption(key={"disable-default-server"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether the Cache Server will be started by default.") Boolean disableDefaultServer, @CliOption(key={"disable-exit-when-out-of-memory"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Prevents the JVM from exiting when an OutOfMemoryError occurs.") Boolean disableExitWhenOutOfMemory, @CliOption(key={"enable-time-statistics"}, specifiedDefaultValue="true", help="Causes additional time-based statistics to be gathered for Geode operations.") Boolean enableTimeStatistics, @CliOption(key={"eviction-heap-percentage"}, help="Set the percentage of heap at or above which the eviction should begin on Regions configured for HeapLRU eviction. Changing this value may cause eviction to begin immediately.Only one change to this attribute or critical heap percentage will be allowed at any given time and its effect will be fully realized before the next change is allowed. This feature requires additional VM flags to perform properly. ") Float evictionHeapPercentage, @CliOption(key={"eviction-off-heap-percentage"}, help="Set the percentage of off-heap memory at or above which the eviction should begin on Regions configured for off-heap and HeapLRU eviction. Changing this value may cause eviction to begin immediately. Only one change to this attribute or critical off-heap percentage will be allowed at any given time and its effect will be fully realized before the next change is allowed.") Float evictionOffHeapPercentage, @CliOption(key={"force"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to allow the PID file from a previous Cache Server run to be overwritten.") Boolean force, @CliOption(key={"group"}, optionContext="geode.converter.member.groups", help="Group(s) the Cache Server will be a part of.") String group, @CliOption(key={"hostname-for-clients"}, help="Sets the ip address or host name that this cache server is to listen on for client connections.Setting a specific hostname-for-clients will cause server locators to use this value when telling clients how to connect to this cache server. This is useful in the case where the cache server may refer to itself with one hostname, but the clients need to use a different hostname to find the cache server.The value \"\" causes the bind-address to be given to clients.A null value will be treated the same as the default \"\".") String hostNameForClients, @CliOption(key={"include-system-classpath"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Includes the System CLASSPATH on the Server's CLASSPATH. The System CLASSPATH is not included by default.") Boolean includeSystemClasspath, @CliOption(key={"initial-heap"}, help="Initial size of the heap in the same format as the JVM -Xms parameter.") String initialHeap, @CliOption(key={"J"}, optionContext="splittingRegex=\u001f", help="Argument passed to the JVM on which the server will run. For example, --J=-Dfoo.bar=true will set the system property \"foo.bar\" to \"true\".") String[] jvmArgsOpts, @CliOption(key={"locators"}, optionContext="geode.converter.locators.discovery.config", help="Sets the list of Locators used by the Cache Server to join the appropriate Geode cluster.") String locators, @CliOption(key={"locator-wait-time"}, help="Sets the number of seconds the server will wait for a locator to become available during startup before giving up.") Integer locatorWaitTime, @CliOption(key={"lock-memory"}, specifiedDefaultValue="true", help="Causes Geode to lock heap and off-heap memory pages into RAM. This prevents the operating system from swapping the pages out to disk, which can cause severe performance degradation. When you use this option, also configure the operating system limits for locked memory.") Boolean lockMemory, @CliOption(key={"log-level"}, optionContext="geode.converter.log.levels:disable-string-converter", help="Sets the level of output logged to the Cache Server log file.  Possible values for log-level include: ALL, TRACE, DEBUG, INFO, WARN, ERROR, FATAL, OFF.") String logLevel, @CliOption(key={"max-connections"}, help="Sets the maxium number of client connections allowed. When the maximum is reached the cache server will stop accepting connections") Integer maxConnections, @CliOption(key={"max-heap"}, help="Maximum size of the heap in the same format as the JVM -Xmx parameter.") String maxHeap, @CliOption(key={"max-message-count"}, help="Sets maximum number of messages that can be enqueued in a client-queue.") Integer maxMessageCount, @CliOption(key={"max-threads"}, help="Sets the maxium number of threads allowed in this cache server to service client requests. The default of 0 causes the cache server to dedicate a thread for every client connection") Integer maxThreads, @CliOption(key={"mcast-address"}, help="The IP address or hostname used to bind the UPD socket for multi-cast networking so the Cache Server can communicate with other members in the Geode cluster.  If mcast-port is zero, then mcast-address is ignored.") String mcastBindAddress, @CliOption(key={"mcast-port"}, help="Sets the port used for multi-cast networking so the Cache Server can communicate with other members of the Geode cluster.  A zero value disables mcast.") Integer mcastPort, @CliOption(key={"memcached-port"}, help="Sets the port that the Geode memcached service listens on for memcached clients.") Integer memcachedPort, @CliOption(key={"memcached-protocol"}, help="Sets the protocol that the Geode memcached service uses (ASCII or BINARY).") String memcachedProtocol, @CliOption(key={"memcached-bind-address"}, help="Sets the IP address the Geode memcached service listens on for memcached clients. The default is to bind to the first non-loopback address for this machine.") String memcachedBindAddress, @CliOption(key={"redis-port"}, help="Sets the port that the Geode Redis service listens on for Redis clients.") Integer redisPort, @CliOption(key={"redis-bind-address"}, help="Sets the IP address the Geode Redis service listens on for Redis clients. The default is to bind to the first non-loopback address for this machine.") String redisBindAddress, @CliOption(key={"redis-password"}, help="Sets the authentication password for GeodeRedisServer") String redisPassword, @CliOption(key={"message-time-to-live"}, help="Sets the time (in seconds ) after which a message in the client queue will expire") Integer messageTimeToLive, @CliOption(key={"off-heap-memory-size"}, help="The total size of off-heap memory specified as off-heap-memory-size=<n>[g|m]. <n> is the size. [g|m] indicates whether the size should be interpreted as gigabytes or megabytes. A non-zero size causes that much memory to be allocated from the operating system and reserved for off-heap use.") String offHeapMemorySize, @CliOption(key={"properties-file"}, optionContext="geode.converter.file.path:disable-string-converter", help="The gemfire.properties file for configuring the Cache Server's distributed system. The file's path can be absolute or relative to the gfsh working directory.") String gemfirePropertiesPathname, @CliOption(key={"rebalance"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to initiate rebalancing across the Geode cluster.") Boolean rebalance, @CliOption(key={"security-properties-file"}, optionContext="geode.converter.file.path:disable-string-converter", help="The gfsecurity.properties file for configuring the Server's security configuration in the distributed system. The file's path can be absolute or relative to gfsh directory.") String gemfireSecurityPropertiesPathname, @CliOption(key={"server-bind-address"}, unspecifiedDefaultValue="", help="The IP address that this distributed system's server sockets in a client-server topology will be bound. If set to an empty string then all of the local machine's addresses will be listened on.") String serverBindAddress, @CliOption(key={"server-port"}, unspecifiedDefaultValue="40404", help="The port that the distributed system's server sockets in a client-server topology will listen on.  The default server-port is 40404.") Integer serverPort, @CliOption(key={"socket-buffer-size"}, help="Sets the buffer size in bytes of the socket connection for this CacheServer. The default is 32768 bytes.") Integer socketBufferSize, @CliOption(key={"spring-xml-location"}, help="Specifies the location of a Spring XML configuration file(s) for bootstrapping and configuring a Geode Server.") String springXmlLocation, @CliOption(key={"statistic-archive-file"}, help="The file that statistic samples are written to.  An empty string (default) disables statistic archival.") String statisticsArchivePathname, @CliOption(key={"use-cluster-configuration"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="When set to true, the server requests the configuration from locator's cluster configuration service.") Boolean requestSharedConfiguration, @CliOption(key={"start-rest-api"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="When set to true, will start the REST API service.") Boolean startRestApi, @CliOption(key={"http-service-port"}, unspecifiedDefaultValue="", help="Port on which HTTP Service will listen on") String httpServicePort, @CliOption(key={"http-service-bind-address"}, unspecifiedDefaultValue="", help="The IP address on which the HTTP Service will be bound.  By default, the Server is bound to all local addresses.") String httpServiceBindAddress, @CliOption(key={"user"}, unspecifiedDefaultValue="", help="User name to securely connect to the cluster. If the --password parameter is not specified then it will be prompted for.") String userName, @CliOption(key={"password"}, unspecifiedDefaultValue="", help="Password to securely connect to the cluster.") String passwordToUse) {
        try {
            ServerLauncher.ServerState serverState;
            if (StringUtils.isBlank((String)memberName)) {
                memberName = this.nameGenerator.generate('-');
            }
            if (StringUtils.isNotBlank((String)userName)) {
                if (StringUtils.isBlank((String)passwordToUse)) {
                    passwordToUse = this.getGfsh().readPassword("password: ");
                }
                if (StringUtils.isBlank((String)passwordToUse)) {
                    return ResultBuilder.createConnectionErrorResult("password must be specified.");
                }
            }
            workingDirectory = this.resolveWorkingDir(workingDirectory, memberName);
            if (StringUtils.isNotBlank((String)(cacheXmlPathname = CliUtil.resolvePathname(cacheXmlPathname))) && !IOUtils.isExistingPathname(cacheXmlPathname)) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Warning: The Geode cache XML file {0} could not be found.", (Object)cacheXmlPathname));
            }
            if (StringUtils.isNotBlank((String)(gemfirePropertiesPathname = CliUtil.resolvePathname(gemfirePropertiesPathname))) && !IOUtils.isExistingPathname(gemfirePropertiesPathname)) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Warning: The Geode {0}properties file {1} could not be found.", "", gemfirePropertiesPathname));
            }
            if (StringUtils.isNotBlank((String)(gemfireSecurityPropertiesPathname = CliUtil.resolvePathname(gemfireSecurityPropertiesPathname))) && !IOUtils.isExistingPathname(gemfireSecurityPropertiesPathname)) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Warning: The Geode {0}properties file {1} could not be found.", "Security ", gemfireSecurityPropertiesPathname));
            }
            File serverPidFile = new File(workingDirectory, ProcessType.SERVER.getPidFileName());
            int oldPid = this.readPid(serverPidFile);
            Properties gemfireProperties = new Properties();
            gemfireProperties.setProperty("bind-address", StringUtils.defaultString((String)bindAddress));
            gemfireProperties.setProperty("cache-xml-file", StringUtils.defaultString((String)cacheXmlPathname));
            gemfireProperties.setProperty("enable-time-statistics", StringUtils.defaultString(enableTimeStatistics));
            gemfireProperties.setProperty("groups", StringUtils.defaultString((String)group));
            gemfireProperties.setProperty("locators", StringUtils.defaultString((String)locators));
            gemfireProperties.setProperty("locator-wait-time", StringUtils.defaultString(locatorWaitTime));
            gemfireProperties.setProperty("log-level", StringUtils.defaultString((String)logLevel));
            gemfireProperties.setProperty("mcast-address", StringUtils.defaultString((String)mcastBindAddress));
            gemfireProperties.setProperty("mcast-port", StringUtils.defaultString(mcastPort));
            gemfireProperties.setProperty("memcached-port", StringUtils.defaultString(memcachedPort));
            gemfireProperties.setProperty("memcached-protocol", StringUtils.defaultString((String)memcachedProtocol));
            gemfireProperties.setProperty("memcached-bind-address", StringUtils.defaultString((String)memcachedBindAddress));
            gemfireProperties.setProperty("redis-port", StringUtils.defaultString(redisPort));
            gemfireProperties.setProperty("redis-bind-address", StringUtils.defaultString((String)redisBindAddress));
            gemfireProperties.setProperty("redis-password", StringUtils.defaultString((String)redisPassword));
            gemfireProperties.setProperty("statistic-archive-file", StringUtils.defaultString((String)statisticsArchivePathname));
            gemfireProperties.setProperty("use-cluster-configuration", StringUtils.defaultString(requestSharedConfiguration, Boolean.TRUE.toString()));
            gemfireProperties.setProperty("lock-memory", StringUtils.defaultString(lockMemory));
            gemfireProperties.setProperty("off-heap-memory-size", StringUtils.defaultString((String)offHeapMemorySize));
            gemfireProperties.setProperty("start-dev-rest-api", StringUtils.defaultString(startRestApi));
            gemfireProperties.setProperty("http-service-port", StringUtils.defaultString((String)httpServicePort));
            gemfireProperties.setProperty("http-service-bind-address", StringUtils.defaultString((String)httpServiceBindAddress));
            if (StringUtils.isNotBlank((String)userName)) {
                gemfireProperties.setProperty("security-username", userName);
                gemfireProperties.setProperty("security-password", passwordToUse);
            }
            boolean redirectOutput = Boolean.getBoolean("gemfire.OSProcess.ENABLE_OUTPUT_REDIRECTION");
            ServerLauncher.Builder serverLauncherBuilder = new ServerLauncher.Builder().setAssignBuckets(assignBuckets).setDisableDefaultServer(disableDefaultServer).setForce(force).setRebalance(rebalance).setRedirectOutput(redirectOutput).setServerBindAddress(serverBindAddress).setServerPort(serverPort).setSpringXmlLocation(springXmlLocation).setWorkingDirectory(workingDirectory).setCriticalHeapPercentage(criticalHeapPercentage).setEvictionHeapPercentage(evictionHeapPercentage).setCriticalOffHeapPercentage(criticalOffHeapPercentage).setEvictionOffHeapPercentage(evictionOffHeapPercentage).setMaxConnections(maxConnections).setMaxMessageCount(maxMessageCount).setMaxThreads(maxThreads).setMessageTimeToLive(messageTimeToLive).setSocketBufferSize(socketBufferSize);
            if (hostNameForClients != null) {
                serverLauncherBuilder.setHostNameForClients(hostNameForClients);
            }
            if (memberName != null) {
                serverLauncherBuilder.setMemberName(memberName);
            }
            ServerLauncher serverLauncher = serverLauncherBuilder.build();
            Object[] serverCommandLine = this.createStartServerCommandLine(serverLauncher, gemfirePropertiesPathname, gemfireSecurityPropertiesPathname, gemfireProperties, classpath, includeSystemClasspath, jvmArgsOpts, disableExitWhenOutOfMemory, initialHeap, maxHeap);
            if (this.getGfsh().getDebug()) {
                this.getGfsh().logInfo(StringUtils.join((Object[])serverCommandLine, (String)" "), null);
            }
            Process serverProcess = new ProcessBuilder((String[])serverCommandLine).directory(new File(serverLauncher.getWorkingDirectory())).start();
            serverProcess.getInputStream().close();
            serverProcess.getOutputStream().close();
            final ProcessStreamReader.ReadingMode readingMode = SystemUtils.isWindows() ? ProcessStreamReader.ReadingMode.NON_BLOCKING : ProcessStreamReader.ReadingMode.BLOCKING;
            final StringBuffer message = new StringBuffer();
            ProcessStreamReader.InputListener inputListener = new ProcessStreamReader.InputListener(){

                @Override
                public void notifyInputLine(String line) {
                    message.append(line);
                    if (readingMode == ProcessStreamReader.ReadingMode.BLOCKING) {
                        message.append(StringUtils.LINE_SEPARATOR);
                    }
                }
            };
            ProcessStreamReader stderrReader = new ProcessStreamReader.Builder(serverProcess).inputStream(serverProcess.getErrorStream()).inputListener(inputListener).readingMode(readingMode).continueReadingMillis(2000L).build().start();
            String previousServerStatusMessage = null;
            LauncherSignalListener serverSignalListener = new LauncherSignalListener();
            boolean registeredServerSignalListener = this.getGfsh().getSignalHandler().registerListener(serverSignalListener);
            try {
                this.getGfsh().logInfo(String.format("Starting a Geode Server in %1$s...", IOUtils.tryGetCanonicalPathElseGetAbsolutePath(new File(serverLauncher.getWorkingDirectory()))), null);
                serverState = ServerLauncher.ServerState.fromDirectory(workingDirectory, memberName);
                do {
                    if (!serverProcess.isAlive()) {
                        int exitValue = serverProcess.exitValue();
                        Result result = ResultBuilder.createShellClientErrorResult(String.format("The Cache Server process terminated unexpectedly with exit status %1$d. Please refer to the log file in %2$s for full details.%n%n%3$s", exitValue, serverLauncher.getWorkingDirectory(), message.toString()));
                        return result;
                    }
                    Gfsh.print(".");
                    LauncherLifecycleCommands launcherLifecycleCommands = this;
                    synchronized (launcherLifecycleCommands) {
                        TimeUnit.MILLISECONDS.timedWait(this, 500L);
                    }
                    serverState = ServerLauncher.ServerState.fromDirectory(workingDirectory, memberName);
                    String currentServerStatusMessage = serverState.getStatusMessage();
                    if (!serverState.isStartingOrNotResponding() || StringUtils.isBlank((String)currentServerStatusMessage) || currentServerStatusMessage.equalsIgnoreCase(previousServerStatusMessage) || currentServerStatusMessage.trim().toLowerCase().equals("null")) continue;
                    Gfsh.println();
                    Gfsh.println(currentServerStatusMessage);
                    previousServerStatusMessage = currentServerStatusMessage;
                } while ((!registeredServerSignalListener || !serverSignalListener.isSignaled()) && serverState.isStartingOrNotResponding());
            }
            finally {
                stderrReader.stopAsync(5000L);
                this.getGfsh().getSignalHandler().unregisterListener(serverSignalListener);
            }
            Gfsh.println();
            boolean asyncStart = ServerLauncher.ServerState.isStartingNotRespondingOrNull(serverState);
            if (!asyncStart) return ResultBuilder.createInfoResult(serverState.toString());
            Gfsh.print(String.format("Broken out of wait... the %1$s process will continue to startup in the background.%n", SERVER_TERM_NAME));
            return ResultBuilder.createInfoResult("");
        }
        catch (IllegalArgumentException e) {
            String message = e.getMessage();
            if (message == null) return ResultBuilder.createUserErrorResult(message);
            if (!message.matches(LocalizedStrings.Launcher_Builder_UNKNOWN_HOST_ERROR_MESSAGE.toLocalizedString(".+"))) return ResultBuilder.createUserErrorResult(message);
            message = CliStrings.format("Failed to start {0}. Reason: {1}", SERVER_TERM_NAME, message);
            return ResultBuilder.createUserErrorResult(message);
        }
        catch (IllegalStateException e) {
            return ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (ClusterConfigurationNotAvailableException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createShellClientErrorResult(String.format("An error occurred while attempting to start a Geode Cache Server: %1$s", this.toString(t, this.getGfsh().getDebug())));
        }
    }

    protected String[] createStartServerCommandLine(ServerLauncher launcher, String gemfirePropertiesPathname, String gemfireSecurityPropertiesPathname, Properties gemfireProperties, String userClasspath, Boolean includeSystemClasspath, String[] jvmArgsOpts, Boolean disableExitWhenOutOfMemory, String initialHeap, String maxHeap) throws MalformedObjectNameException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getJavaPath());
        commandLine.add("-server");
        commandLine.add("-classpath");
        commandLine.add(this.getServerClasspath(Boolean.TRUE.equals(includeSystemClasspath), userClasspath));
        this.addCurrentLocators(commandLine, gemfireProperties);
        this.addGemFirePropertyFile(commandLine, gemfirePropertiesPathname);
        this.addGemFireSecurityPropertyFile(commandLine, gemfireSecurityPropertiesPathname);
        this.addGemFireSystemProperties(commandLine, gemfireProperties);
        this.addJvmArgumentsAndOptions(commandLine, jvmArgsOpts);
        if (!Boolean.TRUE.equals(disableExitWhenOutOfMemory)) {
            this.addJvmOptionsForOutOfMemoryErrors(commandLine);
        }
        this.addInitialHeap(commandLine, initialHeap);
        this.addMaxHeap(commandLine, maxHeap);
        commandLine.add("-D".concat("gemfire.launcher.registerSignalHandlers".concat("=true")));
        commandLine.add("-Djava.awt.headless=true");
        commandLine.add("-Dsun.rmi.dgc.server.gcInterval".concat("=").concat(Long.toString(0x7FFFFFFFFFFFFFFEL)));
        commandLine.add(ServerLauncher.class.getName());
        commandLine.add(ServerLauncher.Command.START.getName());
        if (StringUtils.isNotBlank((String)launcher.getMemberName())) {
            commandLine.add(launcher.getMemberName());
        }
        if (launcher.isAssignBuckets()) {
            commandLine.add("--assign-buckets");
        }
        if (launcher.isDebugging() || this.isDebugging()) {
            commandLine.add("--debug");
        }
        if (launcher.isDisableDefaultServer()) {
            commandLine.add("--disable-default-server");
        }
        if (launcher.isForcing()) {
            commandLine.add("--force");
        }
        if (launcher.isRebalancing()) {
            commandLine.add("--rebalance");
        }
        if (launcher.isRedirectingOutput()) {
            commandLine.add("--redirect-output");
        }
        if (launcher.getServerBindAddress() != null) {
            commandLine.add("--server-bind-address=" + launcher.getServerBindAddress().getCanonicalHostName());
        }
        if (launcher.getServerPort() != null) {
            commandLine.add("--server-port=" + launcher.getServerPort());
        }
        if (launcher.isSpringXmlLocationSpecified()) {
            commandLine.add("--spring-xml-location=".concat(launcher.getSpringXmlLocation()));
        }
        if (launcher.getCriticalHeapPercentage() != null) {
            commandLine.add("--critical-heap-percentage=" + launcher.getCriticalHeapPercentage());
        }
        if (launcher.getEvictionHeapPercentage() != null) {
            commandLine.add("--eviction-heap-percentage=" + launcher.getEvictionHeapPercentage());
        }
        if (launcher.getCriticalOffHeapPercentage() != null) {
            commandLine.add("--critical-off-heap-percentage=" + launcher.getCriticalOffHeapPercentage());
        }
        if (launcher.getEvictionOffHeapPercentage() != null) {
            commandLine.add("--eviction-off-heap-percentage=" + launcher.getEvictionOffHeapPercentage());
        }
        if (launcher.getMaxConnections() != null) {
            commandLine.add("--max-connections=" + launcher.getMaxConnections());
        }
        if (launcher.getMaxMessageCount() != null) {
            commandLine.add("--max-message-count=" + launcher.getMaxMessageCount());
        }
        if (launcher.getMaxThreads() != null) {
            commandLine.add("--max-threads=" + launcher.getMaxThreads());
        }
        if (launcher.getMessageTimeToLive() != null) {
            commandLine.add("--message-time-to-live=" + launcher.getMessageTimeToLive());
        }
        if (launcher.getSocketBufferSize() != null) {
            commandLine.add("--socket-buffer-size=" + launcher.getSocketBufferSize());
        }
        if (launcher.getHostNameForClients() != null) {
            commandLine.add("--hostname-for-clients=" + launcher.getHostNameForClients());
        }
        return commandLine.toArray(new String[commandLine.size()]);
    }

    private String getCurrentLocators() throws MalformedObjectNameException {
        String delimitedLocators = "";
        try {
            String[] locators;
            DistributedSystemMXBean dsMBeanProxy;
            if (this.isConnectedAndReady() && (dsMBeanProxy = MXBeanProvider.getDistributedSystemMXBean()) != null && (locators = dsMBeanProxy.listLocators()) != null && locators.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < locators.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(locators[i]);
                }
                delimitedLocators = sb.toString();
            }
        }
        catch (IOException e) {
            this.getGfsh().logWarning("DistributedSystemMXBean is unavailable\n", e);
        }
        return delimitedLocators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected File readIntoTempFile(String classpathResourceLocation) throws IOException {
        String resourceName = classpathResourceLocation.substring(classpathResourceLocation.lastIndexOf(File.separator) + 1);
        File resourceFile = new File(System.getProperty("java.io.tmpdir"), resourceName);
        if (!resourceFile.exists() && resourceFile.createNewFile()) {
            BufferedReader resourceReader = new BufferedReader(new InputStreamReader(ClassLoader.getSystemClassLoader().getResourceAsStream(classpathResourceLocation)));
            BufferedWriter resourceFileWriter = new BufferedWriter(new FileWriter(resourceFile, false));
            try {
                String line = resourceReader.readLine();
                while (line != null) {
                    resourceFileWriter.write(line);
                    resourceFileWriter.write(StringUtils.LINE_SEPARATOR);
                    line = resourceReader.readLine();
                }
                resourceFileWriter.flush();
            }
            finally {
                IOUtils.close(resourceReader);
                IOUtils.close(resourceFileWriter);
            }
        }
        resourceFile.deleteOnExit();
        return resourceFile;
    }

    @CliAvailabilityIndicator(value={"start locator", "stop locator", "status locator", "start server", "stop server", "status server", "start manager", "start pulse", "start vsd", "start data-browser"})
    public boolean launcherCommandsAvailable() {
        return true;
    }

    protected String resolveWorkingDir(String userSpecifiedDir, String memberName) {
        File workingDir = userSpecifiedDir == null ? new File(memberName) : new File(userSpecifiedDir);
        String workingDirPath = IOUtils.tryGetCanonicalPathElseGetAbsolutePath(workingDir);
        if (!workingDir.exists() && !workingDir.mkdirs()) {
            throw new IllegalStateException(String.format("Could not create directory %s. Please verify directory path or user permissions.", workingDirPath));
        }
        return workingDirPath;
    }

    protected static class LauncherSignalListener
    implements SignalListener {
        private volatile boolean signaled = false;

        protected LauncherSignalListener() {
        }

        public boolean isSignaled() {
            return this.signaled;
        }

        @Override
        public void handle(SignalEvent event) {
            this.signaled = true;
        }
    }
}

