/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class LogLevelConverter
implements Converter<String> {
    private Set<Completion> logLevels = new LinkedHashSet<Completion>();

    public LogLevelConverter() {
        Level[] levels;
        for (Level level : levels = Level.values()) {
            this.logLevels.add(new Completion(level.name()));
        }
    }

    public boolean supports(Class<?> type, String optionContext) {
        return String.class.equals(type) && optionContext.contains("geode.converter.log.levels:disable-string-converter");
    }

    public String convertFromText(String value, Class<?> targetType, String optionContext) {
        return value;
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        completions.addAll(this.logLevels);
        return !completions.isEmpty();
    }
}

