/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

public class CliFunctionResult
implements Comparable<CliFunctionResult>,
DataSerializableFixedID {
    private String memberIdOrName;
    private Serializable[] serializables = new String[0];
    private Throwable throwable;
    private boolean successful;
    private XmlEntity xmlEntity;
    private byte[] byteData = new byte[0];

    public CliFunctionResult() {
    }

    public CliFunctionResult(String memberIdOrName) {
        this.memberIdOrName = memberIdOrName;
        this.successful = true;
    }

    public CliFunctionResult(String memberIdOrName, Serializable[] serializables) {
        this.memberIdOrName = memberIdOrName;
        this.serializables = serializables;
        this.successful = true;
    }

    public CliFunctionResult(String memberIdOrName, byte[] byteData, Serializable[] serializables) {
        this.byteData = byteData;
        this.serializables = serializables;
        this.successful = true;
    }

    public CliFunctionResult(String memberIdOrName, XmlEntity xmlEntity) {
        this.memberIdOrName = memberIdOrName;
        this.xmlEntity = xmlEntity;
        this.successful = true;
    }

    public CliFunctionResult(String memberIdOrName, XmlEntity xmlEntity, Serializable[] serializables) {
        this.memberIdOrName = memberIdOrName;
        this.xmlEntity = xmlEntity;
        this.serializables = serializables;
        this.successful = true;
    }

    public CliFunctionResult(String memberIdOrName, XmlEntity xmlEntity, String message) {
        this.memberIdOrName = memberIdOrName;
        this.xmlEntity = xmlEntity;
        if (message != null) {
            this.serializables = new String[]{message};
        }
        this.successful = true;
    }

    public CliFunctionResult(String memberIdOrName, boolean successful, String message) {
        this.memberIdOrName = memberIdOrName;
        this.successful = successful;
        if (message != null) {
            this.serializables = new String[]{message};
        }
    }

    public CliFunctionResult(String memberIdOrName, Throwable throwable, String message) {
        this.memberIdOrName = memberIdOrName;
        this.throwable = throwable;
        if (message != null) {
            this.serializables = new String[]{message};
        }
        this.successful = false;
    }

    public String getMemberIdOrName() {
        return this.memberIdOrName;
    }

    public String getMessage() {
        if (this.serializables.length == 0 || !(this.serializables[0] instanceof String)) {
            return null;
        }
        return (String)((Object)this.serializables[0]);
    }

    public Serializable[] getSerializables() {
        return this.serializables;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public int getDSFID() {
        return 152;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.memberIdOrName, out);
        DataSerializer.writePrimitiveBoolean(this.successful, out);
        DataSerializer.writeObject(this.xmlEntity, out);
        DataSerializer.writeObjectArray(this.serializables, out);
        DataSerializer.writeObject(this.throwable, out);
        DataSerializer.writeByteArray(this.byteData, out);
    }

    public void toDataPre_GFE_8_0_0_0(DataOutput out) throws IOException {
        DataSerializer.writeString(this.memberIdOrName, out);
        DataSerializer.writeObjectArray(this.serializables, out);
        DataSerializer.writeObject(this.throwable, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.memberIdOrName = DataSerializer.readString(in);
        this.successful = DataSerializer.readPrimitiveBoolean(in);
        this.xmlEntity = (XmlEntity)DataSerializer.readObject(in);
        this.serializables = (Serializable[])DataSerializer.readObjectArray(in);
        this.throwable = (Throwable)DataSerializer.readObject(in);
        this.byteData = DataSerializer.readByteArray(in);
    }

    public void fromDataPre_GFE_8_0_0_0(DataInput in) throws IOException, ClassNotFoundException {
        this.memberIdOrName = DataSerializer.readString(in);
        this.throwable = (Throwable)DataSerializer.readObject(in);
        this.serializables = (Serializable[])DataSerializer.readObjectArray(in);
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public XmlEntity getXmlEntity() {
        return this.xmlEntity;
    }

    public byte[] getByteData() {
        return this.byteData;
    }

    @Override
    public int compareTo(CliFunctionResult o) {
        if (this.memberIdOrName == null && o.memberIdOrName == null) {
            return 0;
        }
        if (this.memberIdOrName == null && o.memberIdOrName != null) {
            return -1;
        }
        if (this.memberIdOrName != null && o.memberIdOrName == null) {
            return 1;
        }
        return this.getMemberIdOrName().compareTo(o.memberIdOrName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.memberIdOrName == null ? 0 : this.memberIdOrName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CliFunctionResult other = (CliFunctionResult)obj;
        return !(this.memberIdOrName == null ? other.memberIdOrName != null : !this.memberIdOrName.equals(other.memberIdOrName));
    }

    public String toString() {
        return "CliFunctionResult [memberId=" + this.memberIdOrName + ", successful=" + this.successful + ", xmlEntity=" + this.xmlEntity + ", serializables=" + Arrays.toString(this.serializables) + ", throwable=" + this.throwable + ", byteData=" + Arrays.toString(this.byteData) + "]";
    }

    public static List<CliFunctionResult> cleanResults(List<?> results) {
        ArrayList<CliFunctionResult> returnResults = new ArrayList<CliFunctionResult>(results.size());
        for (Object result : results) {
            if (!(result instanceof CliFunctionResult)) continue;
            returnResults.add((CliFunctionResult)result);
        }
        Collections.sort(returnResults);
        return returnResults;
    }

    @Override
    public Version[] getSerializationVersions() {
        return new Version[]{Version.GFE_80};
    }
}

