/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.IndexTrackingQueryObserver;
import org.apache.geode.cache.query.internal.QCompiler;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.Undefined;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.DataCommands;
import org.apache.geode.management.internal.cli.domain.DataCommandRequest;
import org.apache.geode.management.internal.cli.domain.DataCommandResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.multistep.CLIMultiStepHelper;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.util.JsonUtil;
import org.apache.geode.pdx.PdxInstance;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;
import org.json.JSONArray;

public class DataCommandFunction
extends FunctionAdapter
implements InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    private boolean optimizeForWrite = false;
    protected static final String SELECT_STEP_DISPLAY = "SELECT_DISPLAY";
    protected static final String SELECT_STEP_MOVE = "SELECT_PAGE_MOVE";
    protected static final String SELECT_STEP_END = "SELECT_END";
    protected static final String SELECT_STEP_EXEC = "SELECT_EXEC";
    private static final int NESTED_JSON_LENGTH = 20;
    private static SecurityService securityService = SecurityService.getSecurityService();
    private static DataCommandResult cachedResult = null;

    @Override
    public String getId() {
        return DataCommandFunction.class.getName();
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public boolean optimizeForWrite() {
        return this.optimizeForWrite;
    }

    public void setOptimizeForWrite(boolean optimizeForWrite) {
        this.optimizeForWrite = optimizeForWrite;
    }

    public void execute(FunctionContext functionContext) {
        try {
            InternalCache cache = this.getCache();
            DataCommandRequest request = (DataCommandRequest)functionContext.getArguments();
            if (logger.isDebugEnabled()) {
                logger.debug("Executing function : \n{}\n on member {}", (Object)request, (Object)System.getProperty("memberName"));
            }
            DataCommandResult result = null;
            if (request.isGet()) {
                result = this.get(request);
            } else if (request.isLocateEntry()) {
                result = this.locateEntry(request);
            } else if (request.isPut()) {
                result = this.put(request);
            } else if (request.isRemove()) {
                result = this.remove(request);
            } else if (request.isSelect()) {
                result = this.select(request);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Result is {}", (Object)result);
            }
            functionContext.getResultSender().lastResult(result);
        }
        catch (Exception e) {
            logger.info("Exception occurred:", (Throwable)e);
            functionContext.getResultSender().sendException(e);
        }
    }

    private InternalCache getCache() {
        return (InternalCache)CacheFactory.getAnyInstance();
    }

    public DataCommandResult remove(DataCommandRequest request) {
        String key = request.getKey();
        String keyClass = request.getKeyClass();
        String regionName = request.getRegionName();
        String removeAllKeys = request.getRemoveAllKeys();
        return this.remove(key, keyClass, regionName, removeAllKeys);
    }

    public DataCommandResult get(DataCommandRequest request) {
        String key = request.getKey();
        String keyClass = request.getKeyClass();
        String valueClass = request.getValueClass();
        String regionName = request.getRegionName();
        Boolean loadOnCacheMiss = request.isLoadOnCacheMiss();
        return this.get(request.getPrincipal(), key, keyClass, valueClass, regionName, loadOnCacheMiss);
    }

    public DataCommandResult locateEntry(DataCommandRequest request) {
        String key = request.getKey();
        String keyClass = request.getKeyClass();
        String valueClass = request.getValueClass();
        String regionName = request.getRegionName();
        boolean recursive = request.isRecursive();
        return this.locateEntry(key, keyClass, valueClass, regionName, recursive);
    }

    public DataCommandResult put(DataCommandRequest request) {
        String key = request.getKey();
        String value = request.getValue();
        boolean putIfAbsent = request.isPutIfAbsent();
        String keyClass = request.getKeyClass();
        String valueClass = request.getValueClass();
        String regionName = request.getRegionName();
        return this.put(key, value, putIfAbsent, keyClass, valueClass, regionName);
    }

    public DataCommandResult select(DataCommandRequest request) {
        String query = request.getQuery();
        return this.select(request.getPrincipal(), query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataCommandResult select(Object principal, String queryString) {
        InternalCache cache = this.getCache();
        AtomicInteger nestedObjectCount = new AtomicInteger(0);
        if (StringUtils.isEmpty((String)queryString)) {
            return DataCommandResult.createSelectInfoResult(null, null, -1, null, "Query is either empty or Null", false);
        }
        QueryService qs = cache.getQueryService();
        Query query = qs.newQuery(queryString);
        DefaultQuery tracedQuery = (DefaultQuery)query;
        WrappedIndexTrackingQueryObserver queryObserver = null;
        String queryVerboseMsg = null;
        long startTime = -1L;
        if (tracedQuery.isTraced()) {
            startTime = NanoTimer.getTime();
            queryObserver = new WrappedIndexTrackingQueryObserver();
            QueryObserverHolder.setInstance(queryObserver);
        }
        ArrayList<DataCommandResult.SelectResultRow> list = new ArrayList<DataCommandResult.SelectResultRow>();
        try {
            Object results = query.execute();
            if (tracedQuery.isTraced()) {
                queryVerboseMsg = DataCommandFunction.getLogMessage(queryObserver, startTime, queryString);
                queryObserver.reset2();
            }
            if (results instanceof SelectResults) {
                this.select_SelectResults((SelectResults)results, principal, list, nestedObjectCount);
            } else {
                this.select_NonSelectResults(results, list);
            }
            DataCommandResult dataCommandResult = DataCommandResult.createSelectResult(queryString, list, queryVerboseMsg, null, null, true);
            return dataCommandResult;
        }
        catch (FunctionDomainException | NameResolutionException | QueryInvocationTargetException | TypeMismatchException | GfJsonException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            DataCommandResult dataCommandResult = DataCommandResult.createSelectResult(queryString, null, queryVerboseMsg, e, e.getMessage(), false);
            return dataCommandResult;
        }
        finally {
            if (queryObserver != null) {
                QueryObserverHolder.reset();
            }
        }
    }

    private void select_NonSelectResults(Object results, List<DataCommandResult.SelectResultRow> list) {
        GfJsonObject jsonBean;
        if (logger.isDebugEnabled()) {
            logger.debug("BeanResults : Bean Results class is {}", results.getClass());
        }
        String str = this.toJson(results);
        try {
            jsonBean = new GfJsonObject(str);
        }
        catch (GfJsonException e) {
            logger.info("Exception occurred:", (Throwable)e);
            jsonBean = new GfJsonObject();
            try {
                jsonBean.put("msg", e.getMessage());
            }
            catch (GfJsonException e1) {
                logger.warn("Ignored GfJsonException:", (Throwable)e1);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("BeanResults : Adding bean json string : {}", (Object)jsonBean);
        }
        list.add(new DataCommandResult.SelectResultRow(200, jsonBean.toString()));
    }

    private void select_SelectResults(SelectResults selectResults, Object principal, List<DataCommandResult.SelectResultRow> list, AtomicInteger nestedObjectCount) throws GfJsonException {
        for (Object object : selectResults) {
            GfJsonObject jsonBean;
            if ((object = securityService.postProcess(principal, null, null, object, false)) instanceof Struct) {
                StructImpl impl = (StructImpl)object;
                GfJsonObject jsonStruct = this.getJSONForStruct(impl, nestedObjectCount);
                if (logger.isDebugEnabled()) {
                    logger.debug("SelectResults : Adding select json string : {}", (Object)jsonStruct);
                }
                list.add(new DataCommandResult.SelectResultRow(100, jsonStruct.toString()));
                continue;
            }
            if (JsonUtil.isPrimitiveOrWrapper(object.getClass())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("SelectResults : Adding select primitive : {}", object);
                }
                list.add(new DataCommandResult.SelectResultRow(300, object));
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("SelectResults : Bean Results class is {}", object.getClass());
            }
            String str = this.toJson(object);
            try {
                jsonBean = new GfJsonObject(str);
            }
            catch (GfJsonException e) {
                logger.error(e.getMessage(), (Throwable)e);
                jsonBean = new GfJsonObject();
                try {
                    jsonBean.put("msg", e.getMessage());
                }
                catch (GfJsonException e1) {
                    logger.warn("Ignored GfJsonException:", (Throwable)e1);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("SelectResults : Adding bean json string : {}", (Object)jsonBean);
            }
            list.add(new DataCommandResult.SelectResultRow(200, jsonBean.toString()));
        }
    }

    private String toJson(Object object) {
        if (object instanceof Undefined) {
            return "{\"Value\":\"UNDEFINED\"}";
        }
        if (object instanceof PdxInstance) {
            return DataCommandFunction.pdxToJson((PdxInstance)object);
        }
        return JsonUtil.objectToJsonNestedChkCDep(object, 20);
    }

    private GfJsonObject getJSONForStruct(StructImpl impl, AtomicInteger ai) throws GfJsonException {
        String[] fields = impl.getFieldNames();
        Object[] values = impl.getFieldValues();
        GfJsonObject jsonObject = new GfJsonObject();
        for (int i = 0; i < fields.length; ++i) {
            Object value = values[i];
            if (value != null) {
                if (JsonUtil.isPrimitiveOrWrapper(value.getClass())) {
                    jsonObject.put(fields[i], value);
                    continue;
                }
                jsonObject.put(fields[i], this.toJson(value));
                continue;
            }
            jsonObject.put(fields[i], "null");
        }
        return jsonObject;
    }

    public DataCommandResult remove(String key, String keyClass, String regionName, String removeAllKeys) {
        InternalCache cache = this.getCache();
        if (StringUtils.isEmpty((String)regionName)) {
            return DataCommandResult.createRemoveResult(key, null, null, "Region name is either empty or Null", false);
        }
        if (StringUtils.isEmpty((String)removeAllKeys) && key == null) {
            return DataCommandResult.createRemoveResult(null, null, null, "Key is Null", false);
        }
        Region region = cache.getRegion(regionName);
        if (region == null) {
            return DataCommandResult.createRemoveInfoResult(key, null, null, CliStrings.format("Region <{0}> Not Found", (Object)regionName), false);
        }
        if (removeAllKeys == null) {
            Object keyObject;
            try {
                keyObject = this.getClassObject(key, keyClass);
            }
            catch (ClassNotFoundException e) {
                return DataCommandResult.createRemoveResult(key, null, null, "ClassNotFoundException " + keyClass, false);
            }
            catch (IllegalArgumentException e) {
                return DataCommandResult.createRemoveResult(key, null, null, "Error in converting JSON " + e.getMessage(), false);
            }
            if (region.containsKey(keyObject)) {
                Object value = region.remove(keyObject);
                if (logger.isDebugEnabled()) {
                    logger.debug("Removed key {} successfully", (Object)key);
                }
                Object[] array = DataCommandFunction.getJSONForNonPrimitiveObject(value);
                DataCommandResult result = DataCommandResult.createRemoveResult(key, array[1], null, null, true);
                if (array[0] != null) {
                    result.setValueClass((String)array[0]);
                }
                return result;
            }
            return DataCommandResult.createRemoveInfoResult(key, null, null, "Key is not present in the region", false);
        }
        DataPolicy policy = region.getAttributes().getDataPolicy();
        if (!policy.withPartitioning()) {
            region.clear();
            if (logger.isDebugEnabled()) {
                logger.debug("Cleared all keys in the region - {}", (Object)regionName);
            }
            return DataCommandResult.createRemoveInfoResult(key, null, null, CliStrings.format("Cleared all keys in the region", (Object)regionName), true);
        }
        return DataCommandResult.createRemoveInfoResult(key, null, null, "Option --all is not supported on partitioned region", false);
    }

    public DataCommandResult get(Object principal, String key, String keyClass, String valueClass, String regionName, Boolean loadOnCacheMiss) {
        Object keyObject;
        InternalCache cache = this.getCache();
        if (StringUtils.isEmpty((String)regionName)) {
            return DataCommandResult.createGetResult(key, null, null, "Region name is either empty or Null", false);
        }
        if (StringUtils.isEmpty((String)key)) {
            return DataCommandResult.createGetResult(key, null, null, "Key is either empty or Null", false);
        }
        Region region = cache.getRegion(regionName);
        if (region == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Region Not Found - {}", (Object)regionName);
            }
            return DataCommandResult.createGetResult(key, null, null, CliStrings.format("Region <{0}> Not Found", (Object)regionName), false);
        }
        try {
            keyObject = this.getClassObject(key, keyClass);
        }
        catch (ClassNotFoundException e) {
            return DataCommandResult.createGetResult(key, null, null, "ClassNotFoundException " + keyClass, false);
        }
        catch (IllegalArgumentException e) {
            return DataCommandResult.createGetResult(key, null, null, "Error in converting JSON " + e.getMessage(), false);
        }
        boolean doGet = Boolean.TRUE.equals(loadOnCacheMiss);
        if (doGet || region.containsKey(keyObject)) {
            Object value = region.get(keyObject);
            value = securityService.postProcess(principal, regionName, keyObject, value, false);
            if (logger.isDebugEnabled()) {
                logger.debug("Get for key {} value {}", (Object)key, value);
            }
            Object[] array = DataCommandFunction.getJSONForNonPrimitiveObject(value);
            if (value != null) {
                DataCommandResult result = DataCommandResult.createGetResult(key, array[1], null, null, true);
                if (array[0] != null) {
                    result.setValueClass((String)array[0]);
                }
                return result;
            }
            return DataCommandResult.createGetResult(key, array[1], null, null, false);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Key is not present in the region {}", (Object)regionName);
        }
        return DataCommandResult.createGetInfoResult(key, null, null, "Key is not present in the region", false);
    }

    public DataCommandResult locateEntry(String key, String keyClass, String valueClass, String regionPath, boolean recursive) {
        Object keyObject;
        InternalCache cache = this.getCache();
        if (StringUtils.isEmpty((String)regionPath)) {
            return DataCommandResult.createLocateEntryResult(key, null, null, "Region name is either empty or Null", false);
        }
        if (StringUtils.isEmpty((String)key)) {
            return DataCommandResult.createLocateEntryResult(key, null, null, "Key is either empty or Null", false);
        }
        ArrayList listOfRegionsStartingWithRegionPath = new ArrayList();
        if (recursive) {
            List regionPaths = DataCommandFunction.getAllRegionPaths(cache, true);
            for (String path : regionPaths) {
                if (!path.startsWith(regionPath) && !path.startsWith("/" + regionPath)) continue;
                Region targetRegion = cache.getRegion(path);
                listOfRegionsStartingWithRegionPath.add(targetRegion);
            }
            if (listOfRegionsStartingWithRegionPath.size() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Region Not Found - {}", (Object)regionPath);
                }
                return DataCommandResult.createLocateEntryResult(key, null, null, CliStrings.format("Region <{0}> Not Found", (Object)regionPath), false);
            }
        } else {
            Region region = cache.getRegion(regionPath);
            if (region == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Region Not Found - {}", (Object)regionPath);
                }
                return DataCommandResult.createLocateEntryResult(key, null, null, CliStrings.format("Region <{0}> Not Found", (Object)regionPath), false);
            }
            listOfRegionsStartingWithRegionPath.add(region);
        }
        try {
            keyObject = this.getClassObject(key, keyClass);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return DataCommandResult.createLocateEntryResult(key, null, null, "ClassNotFoundException " + keyClass, false);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return DataCommandResult.createLocateEntryResult(key, null, null, "Error in converting JSON " + e.getMessage(), false);
        }
        DataCommandResult.KeyInfo keyInfo = new DataCommandResult.KeyInfo();
        DistributedMember member = cache.getDistributedSystem().getDistributedMember();
        keyInfo.setHost(member.getHost());
        keyInfo.setMemberId(member.getId());
        keyInfo.setMemberName(member.getName());
        for (Region region : listOfRegionsStartingWithRegionPath) {
            Object value;
            if (region instanceof PartitionedRegion) {
                PartitionedRegion pr = (PartitionedRegion)region;
                Region localRegion = PartitionRegionHelper.getLocalData(region);
                value = localRegion.get(keyObject);
                if (value != null) {
                    DistributedMember primaryMember = PartitionRegionHelper.getPrimaryMemberForKey(region, keyObject);
                    int bucketId = pr.getKeyInfo(keyObject).getBucketId();
                    boolean isPrimary = member == primaryMember;
                    keyInfo.addLocation(new Object[]{region.getFullPath(), true, DataCommandFunction.getJSONForNonPrimitiveObject(value)[1], isPrimary, "" + bucketId});
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Key is not present in the region {}", (Object)regionPath);
                }
                return DataCommandResult.createLocateEntryInfoResult(key, null, null, "Key is not present in the region", false);
            }
            if (region.containsKey(keyObject)) {
                value = region.get(keyObject);
                if (logger.isDebugEnabled()) {
                    logger.debug("Get for key {} value {} in region {}", (Object)key, value, (Object)region.getFullPath());
                }
                if (value != null) {
                    keyInfo.addLocation(new Object[]{region.getFullPath(), true, DataCommandFunction.getJSONForNonPrimitiveObject(value)[1], false, null});
                    continue;
                }
                keyInfo.addLocation(new Object[]{region.getFullPath(), false, null, false, null});
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Key is not present in the region {}", (Object)regionPath);
            }
            keyInfo.addLocation(new Object[]{region.getFullPath(), false, null, false, null});
        }
        if (keyInfo.hasLocation()) {
            return DataCommandResult.createLocateEntryResult(key, keyInfo, null, null, true);
        }
        return DataCommandResult.createLocateEntryInfoResult(key, null, null, "Key is not present in the region", false);
    }

    public DataCommandResult put(String key, String value, boolean putIfAbsent, String keyClass, String valueClass, String regionName) {
        Object valueObject;
        Object keyObject;
        if (StringUtils.isEmpty((String)regionName)) {
            return DataCommandResult.createPutResult(key, null, null, "Region name is either empty or Null", false);
        }
        if (StringUtils.isEmpty((String)key)) {
            return DataCommandResult.createPutResult(key, null, null, "Key is either empty or Null", false);
        }
        if (StringUtils.isEmpty((String)value)) {
            return DataCommandResult.createPutResult(key, null, null, "Value is either empty or Null", false);
        }
        InternalCache cache = this.getCache();
        Region<Object, Object> region = cache.getRegion(regionName);
        if (region == null) {
            return DataCommandResult.createPutResult(key, null, null, CliStrings.format("Region <{0}> Not Found", (Object)regionName), false);
        }
        try {
            keyObject = this.getClassObject(key, keyClass);
        }
        catch (ClassNotFoundException e) {
            return DataCommandResult.createPutResult(key, null, null, "ClassNotFoundException " + keyClass, false);
        }
        catch (IllegalArgumentException e) {
            return DataCommandResult.createPutResult(key, null, null, "Error in converting JSON " + e.getMessage(), false);
        }
        try {
            valueObject = this.getClassObject(value, valueClass);
        }
        catch (ClassNotFoundException e) {
            return DataCommandResult.createPutResult(key, null, null, "ClassNotFoundException " + valueClass, false);
        }
        Object returnValue = putIfAbsent && region.containsKey(keyObject) ? region.get(keyObject) : region.put(keyObject, valueObject);
        Object[] array = DataCommandFunction.getJSONForNonPrimitiveObject(returnValue);
        DataCommandResult result = DataCommandResult.createPutResult(key, array[1], null, null, true);
        if (array[0] != null) {
            result.setValueClass((String)array[0]);
        }
        return result;
    }

    private Object getClassObject(String string, String klassString) throws ClassNotFoundException, IllegalArgumentException {
        if (StringUtils.isEmpty((String)klassString)) {
            return string;
        }
        Class<?> klass = ClassPathLoader.getLatest().forName(klassString);
        if (klass.equals(String.class)) {
            return string;
        }
        if (JsonUtil.isPrimitiveOrWrapper(klass)) {
            try {
                if (klass.equals(Byte.class)) {
                    return Byte.parseByte(string);
                }
                if (klass.equals(Short.class)) {
                    return Short.parseShort(string);
                }
                if (klass.equals(Integer.class)) {
                    return Integer.parseInt(string);
                }
                if (klass.equals(Long.class)) {
                    return Long.parseLong(string);
                }
                if (klass.equals(Double.class)) {
                    return Double.parseDouble(string);
                }
                if (klass.equals(Boolean.class)) {
                    return Boolean.parseBoolean(string);
                }
                if (klass.equals(Float.class)) {
                    return Float.valueOf(Float.parseFloat(string));
                }
                return null;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to convert input key to " + klassString + " Msg : " + e.getMessage());
            }
        }
        return DataCommandFunction.getObjectFromJson(string, klass);
    }

    public static Object[] getJSONForNonPrimitiveObject(Object obj) {
        Object[] array = new Object[2];
        if (obj == null) {
            array[0] = null;
            array[1] = "<NULL>";
            return array;
        }
        array[0] = obj.getClass().getCanonicalName();
        Class<?> klass = obj.getClass();
        if (JsonUtil.isPrimitiveOrWrapper(klass)) {
            array[1] = obj;
        } else if (obj instanceof PdxInstance) {
            String str = DataCommandFunction.pdxToJson((PdxInstance)obj);
            array[1] = str;
        } else {
            GfJsonObject object = new GfJsonObject(obj, true);
            Iterator<String> keysIterator = object.keys();
            while (keysIterator.hasNext()) {
                String key = keysIterator.next();
                Object value = object.get(key);
                if (GfJsonObject.isJSONKind(value)) {
                    GfJsonObject jsonVal = new GfJsonObject(value);
                    try {
                        if (jsonVal.has("type-class")) {
                            object.put(key, jsonVal.get("type-class"));
                            continue;
                        }
                        object.put(key, "a Map");
                        continue;
                    }
                    catch (GfJsonException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!(value instanceof JSONArray)) continue;
                try {
                    object.put(key, "a Collection");
                }
                catch (GfJsonException e) {
                    throw new RuntimeException(e);
                }
            }
            String str = object.toString();
            array[1] = str;
        }
        return array;
    }

    private static String pdxToJson(PdxInstance obj) {
        if (obj != null) {
            try {
                GfJsonObject json = new GfJsonObject();
                for (String field : obj.getFieldNames()) {
                    Object fieldValue = obj.getField(field);
                    if (fieldValue == null) continue;
                    if (JsonUtil.isPrimitiveOrWrapper(fieldValue.getClass())) {
                        json.put(field, fieldValue);
                        continue;
                    }
                    json.put(field, fieldValue.getClass());
                }
                return json.toString();
            }
            catch (GfJsonException e) {
                return null;
            }
        }
        return null;
    }

    public static <V> V getObjectFromJson(String json, Class<V> klass) {
        String newString = json.replaceAll("'", "\"");
        if (newString.charAt(0) == '(') {
            int len = newString.length();
            StringBuilder sb = new StringBuilder();
            sb.append("{").append(newString.substring(1, len - 1)).append("}");
            newString = sb.toString();
        }
        return JsonUtil.jsonToObject(newString, klass);
    }

    public static List getAllRegionPaths(InternalCache cache, boolean recursive) {
        ArrayList<String> list = new ArrayList<String>();
        if (cache == null) {
            return list;
        }
        Set<Region<?, ?>> regions = cache.rootRegions();
        for (Region<?, ?> rootRegion : regions) {
            String regionPath = rootRegion.getFullPath();
            Region region = cache.getRegion(regionPath);
            list.add(regionPath);
            Set<Region<?, ?>> subregionSet = region.subregions(true);
            if (!recursive) continue;
            for (Region<?, ?> aSubregionSet : subregionSet) {
                list.add(aSubregionSet.getFullPath());
            }
        }
        Collections.sort(list);
        return list;
    }

    public static int getPageSize() {
        int pageSize = -1;
        Map<String, String> session = CliUtil.isGfshVM() ? Gfsh.getCurrentInstance().getEnv() : CommandExecutionContext.getShellEnv();
        if (session != null) {
            String size = session.get("APP_COLLECTION_LIMIT");
            pageSize = StringUtils.isEmpty((String)size) ? 20 : Integer.parseInt(size);
        }
        if (pageSize == -1) {
            pageSize = 20;
        }
        return pageSize;
    }

    private static int getFetchSize() {
        return CommandExecutionContext.getShellFetchSize();
    }

    public static String getLogMessage(QueryObserver observer, long startTime, String query) {
        String usedIndexesString = null;
        float time = 0.0f;
        if (startTime > 0L) {
            time = (float)(NanoTimer.getTime() - startTime) / 1000000.0f;
        }
        if (observer != null && observer instanceof IndexTrackingQueryObserver) {
            IndexTrackingQueryObserver indexObserver = (IndexTrackingQueryObserver)observer;
            Map usedIndexes = indexObserver.getUsedIndexes();
            indexObserver.reset();
            StringBuffer buf = new StringBuffer();
            buf.append(" indexesUsed(");
            buf.append(usedIndexes.size());
            buf.append(")");
            if (usedIndexes.size() > 0) {
                buf.append(":");
                Iterator itr = usedIndexes.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    buf.append(entry.getKey().toString()).append(entry.getValue());
                    if (!itr.hasNext()) continue;
                    buf.append(",");
                }
            }
            usedIndexesString = buf.toString();
        } else if (DefaultQuery.QUERY_VERBOSE) {
            usedIndexesString = " indexesUsed(NA due to other observer in the way: " + observer.getClass().getName() + ")";
        }
        return String.format("Query Executed%s%s", startTime > 0L ? " in " + time + " ms;" : ";", usedIndexesString != null ? usedIndexesString : "");
    }

    public static class SelectQuitStep
    extends CLIMultiStepHelper.RemoteStep {
        private static final long serialVersionUID = 1L;

        public SelectQuitStep(Object[] arguments) {
            super(DataCommandFunction.SELECT_STEP_END, arguments);
        }

        @Override
        public Result exec() {
            boolean interactive = (Boolean)this.commandArguments[2];
            GfJsonObject args = CLIMultiStepHelper.getStepArgs();
            DataCommandResult dataResult = cachedResult;
            cachedResult = null;
            if (interactive) {
                return CLIMultiStepHelper.createEmptyResult("END");
            }
            CompositeResultData rd = dataResult.toSelectCommandResult();
            CompositeResultData.SectionResultData section = rd.addSection("STEP_SECTION");
            section.addData("NEXT_STEP_NAME", "END");
            return ResultBuilder.buildResult(rd);
        }
    }

    public static class SelectExecStep
    extends CLIMultiStepHelper.RemoteStep {
        private static final long serialVersionUID = 1L;
        private static SecurityService securityService = SecurityService.getSecurityService();

        public SelectExecStep(Object[] arguments) {
            super(DataCommandFunction.SELECT_STEP_EXEC, arguments);
        }

        @Override
        public Result exec() {
            String remainingQuery = (String)this.commandArguments[0];
            boolean interactive = (Boolean)this.commandArguments[2];
            DataCommandResult result = this._select(remainingQuery);
            int endCount = 0;
            cachedResult = result;
            if (interactive) {
                endCount = DataCommandFunction.getPageSize();
            } else if (result.getSelectResult() != null) {
                endCount = result.getSelectResult().size();
            }
            if (interactive) {
                return result.pageResult(0, endCount, DataCommandFunction.SELECT_STEP_DISPLAY);
            }
            return CLIMultiStepHelper.createBannerResult(new String[0], new Object[0], DataCommandFunction.SELECT_STEP_END);
        }

        public DataCommandResult _select(String query) {
            InternalCache cache = (InternalCache)CacheFactory.getAnyInstance();
            if (StringUtils.isEmpty((String)query)) {
                DataCommandResult dataResult = DataCommandResult.createSelectInfoResult(null, null, -1, null, "Query is either empty or Null", false);
                return dataResult;
            }
            Object[] array = DataCommands.replaceGfshEnvVar(query, CommandExecutionContext.getShellEnv());
            query = (String)array[1];
            query = this.addLimit(query);
            QCompiler compiler = new QCompiler();
            try {
                CompiledValue compiledQuery = compiler.compileQuery(query);
                HashSet regions = new HashSet();
                compiledQuery.getRegionsInQuery(regions, null);
                for (String region : regions) {
                    securityService.authorizeRegionRead(region);
                }
                Set<String> regionsInQuery = Collections.unmodifiableSet(regions);
                if (regionsInQuery.size() > 0) {
                    Set<DistributedMember> members = DataCommands.getQueryRegionsAssociatedMembers(regionsInQuery, cache, false);
                    if (members != null && members.size() > 0) {
                        DataCommandFunction function = new DataCommandFunction();
                        DataCommandRequest request = new DataCommandRequest();
                        request.setCommand("query");
                        request.setQuery(query);
                        Subject subject = securityService.getSubject();
                        if (subject != null) {
                            request.setPrincipal(subject.getPrincipal());
                        }
                        DataCommandResult dataResult = DataCommands.callFunctionForRegion(request, function, members);
                        dataResult.setInputQuery(query);
                        return dataResult;
                    }
                    return DataCommandResult.createSelectInfoResult(null, null, -1, null, CliStrings.format("Cannot find regions <{0}> in any of the members", (Object)regionsInQuery.toString()), false);
                }
                return DataCommandResult.createSelectInfoResult(null, null, -1, null, CliStrings.format("Query is invalid due for error : <{0}>", (Object)"Region mentioned in query probably missing /"), false);
            }
            catch (QueryInvalidException qe) {
                logger.error("{} Failed Error {}", (Object)query, (Object)qe.getMessage(), (Object)qe);
                return DataCommandResult.createSelectInfoResult(null, null, -1, null, CliStrings.format("Query is invalid due for error : <{0}>", (Object)qe.getMessage()), false);
            }
        }

        private String addLimit(String query) {
            if (StringUtils.containsIgnoreCase((String)query, (String)" limit") || StringUtils.containsIgnoreCase((String)query, (String)" count(")) {
                return query;
            }
            return query + " limit " + DataCommandFunction.getFetchSize();
        }
    }

    public static class SelectMoveStep
    extends CLIMultiStepHelper.RemoteStep {
        private static final long serialVersionUID = 1L;

        public SelectMoveStep(Object[] arguments) {
            super(DataCommandFunction.SELECT_STEP_MOVE, arguments);
        }

        @Override
        public Result exec() {
            GfJsonObject args = CLIMultiStepHelper.getStepArgs();
            int startCount = args.getInt("startCount");
            int endCount = args.getInt("endCount");
            return cachedResult.pageResult(startCount, endCount, DataCommandFunction.SELECT_STEP_DISPLAY);
        }
    }

    public static class SelectDisplayStep
    extends CLIMultiStepHelper.LocalStep {
        public SelectDisplayStep(Object[] arguments) {
            super(DataCommandFunction.SELECT_STEP_DISPLAY, arguments);
        }

        @Override
        public Result exec() {
            boolean interactive = (Boolean)this.commandArguments[2];
            GfJsonObject args = CLIMultiStepHelper.getStepArgs();
            int startCount = args.getInt("startCount");
            int endCount = args.getInt("endCount");
            int rows = args.getInt("Rows");
            boolean flag = args.getBoolean("Result");
            CommandResult commandResult = CLIMultiStepHelper.getDisplayResultFromArgs(args);
            Gfsh.println();
            while (commandResult.hasNextLine()) {
                Gfsh.println(commandResult.nextLine());
            }
            if (flag) {
                boolean paginationNeeded;
                boolean bl = paginationNeeded = startCount < rows && endCount < rows && interactive;
                if (paginationNeeded) {
                    while (true) {
                        String message = "Press n to move to next page, q to quit and p to previous page : ";
                        try {
                            String step = Gfsh.getCurrentInstance().interact(message);
                            if ("n".equals(step)) {
                                int nextStart = startCount + DataCommandFunction.getPageSize();
                                return CLIMultiStepHelper.createBannerResult(new String[]{"startCount", "endCount"}, new Object[]{nextStart, nextStart + DataCommandFunction.getPageSize()}, DataCommandFunction.SELECT_STEP_MOVE);
                            }
                            if ("p".equals(step)) {
                                int nextStart = startCount - DataCommandFunction.getPageSize();
                                if (nextStart < 0) {
                                    nextStart = 0;
                                }
                                return CLIMultiStepHelper.createBannerResult(new String[]{"startCount", "endCount"}, new Object[]{nextStart, nextStart + DataCommandFunction.getPageSize()}, DataCommandFunction.SELECT_STEP_MOVE);
                            }
                            if ("q".equals(step)) {
                                return CLIMultiStepHelper.createBannerResult(new String[0], new Object[0], DataCommandFunction.SELECT_STEP_END);
                            }
                            Gfsh.println("Unknown option ");
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            return CLIMultiStepHelper.createBannerResult(new String[0], new Object[0], DataCommandFunction.SELECT_STEP_END);
        }
    }

    public static class WrappedIndexTrackingQueryObserver
    extends IndexTrackingQueryObserver {
        @Override
        public void reset() {
        }

        public void reset2() {
            super.reset();
        }
    }
}

