/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.CreateDiskStoreFunction;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.logging.log4j.Logger;

public class DestroyDiskStoreFunction
extends FunctionAdapter
implements InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;

    private InternalCache getCache() {
        return (InternalCache)CacheFactory.getAnyInstance();
    }

    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            CliFunctionResult result;
            DiskStore diskStore;
            Object[] args = (Object[])context.getArguments();
            String diskStoreName = (String)args[0];
            InternalCache cache = this.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            if ((diskStore = cache.findDiskStore(diskStoreName)) != null) {
                XmlEntity xmlEntity = new XmlEntity("disk-store", "name", diskStoreName);
                diskStore.destroy();
                result = new CliFunctionResult(memberId, xmlEntity, "Success");
            } else {
                result = new CliFunctionResult(memberId, false, "Disk store not found on this member");
            }
            context.getResultSender().lastResult(result);
        }
        catch (IllegalStateException isex) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, isex.getMessage());
            context.getResultSender().lastResult(result);
        }
        catch (CacheClosedException cce) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult(result);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error("Could not destroy disk store: {}", (Object)th.getMessage(), (Object)th);
            CliFunctionResult result = new CliFunctionResult(memberId, th, null);
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return CreateDiskStoreFunction.class.getName();
    }
}

