/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.File;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.cache.snapshot.SnapshotOptions;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class ExportDataFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext context) {
        String[] args = (String[])context.getArguments();
        String regionName = args[0];
        String fileName = args[1];
        try {
            Cache cache = CacheFactory.getAnyInstance();
            Region region = cache.getRegion(regionName);
            String hostName = cache.getDistributedSystem().getDistributedMember().getHost();
            if (region == null) {
                throw new IllegalArgumentException(CliStrings.format("Region : {0} not found", (Object)regionName));
            }
            RegionSnapshotService snapshotService = region.getSnapshotService();
            File exportFile = new File(fileName);
            snapshotService.save(exportFile, SnapshotOptions.SnapshotFormat.GEMFIRE);
            String successMessage = CliStrings.format("Data succesfully exported from region : {0} to file : {1} on host : {2}", regionName, exportFile.getCanonicalPath(), hostName);
            context.getResultSender().lastResult(successMessage);
        }
        catch (Exception e) {
            context.getResultSender().sendException(e);
        }
    }

    @Override
    public String getId() {
        return ExportDataFunction.class.getName();
    }
}

