/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashMap;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.util.BytesToString;

public class GarbageCollectionFunction
implements Function,
InternalEntity {
    public static final String ID = GarbageCollectionFunction.class.getName();
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext context) {
        BytesToString bytesToString = new BytesToString();
        HashMap<String, String> resultMap = null;
        try {
            Cache cache = CacheFactory.getAnyInstance();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            long freeMemoryBeforeGC = Runtime.getRuntime().freeMemory();
            long totalMemoryBeforeGC = Runtime.getRuntime().totalMemory();
            long timeBeforeGC = System.currentTimeMillis();
            Runtime.getRuntime().gc();
            long freeMemoryAfterGC = Runtime.getRuntime().freeMemory();
            long totalMemoryAfterGC = Runtime.getRuntime().totalMemory();
            long timeAfterGC = System.currentTimeMillis();
            resultMap = new HashMap<String, String>();
            resultMap.put("MemberId", member.getId());
            resultMap.put("HeapSizeBeforeGC", bytesToString.of(totalMemoryBeforeGC - freeMemoryBeforeGC));
            resultMap.put("HeapSizeAfterGC", bytesToString.of(totalMemoryAfterGC - freeMemoryAfterGC));
            resultMap.put("TimeSpentInGC", String.valueOf(timeAfterGC - timeBeforeGC));
        }
        catch (Exception ex) {
            String message = "Exception in GC:" + ex.getMessage() + CliUtil.stackTraceAsString(ex);
            context.getResultSender().lastResult(message);
        }
        context.getResultSender().lastResult(resultMap);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

