/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashSet;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.domain.RegionInformation;

public class GetRegionsFunction
implements Function,
InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public String getId() {
        return GetRegionsFunction.class.toString();
    }

    public void execute(FunctionContext functionContext) {
        try {
            Cache cache = CacheFactory.getAnyInstance();
            Set<Region<?, ?>> regions = cache.rootRegions();
            if (regions == null || regions.isEmpty()) {
                functionContext.getResultSender().lastResult(null);
            } else {
                HashSet<RegionInformation> regionInformationSet = new HashSet<RegionInformation>();
                for (Region<?, ?> region : regions) {
                    RegionInformation regInfo = new RegionInformation(region, true);
                    regionInformationSet.add(regInfo);
                }
                functionContext.getResultSender().lastResult(regionInformationSet.toArray());
            }
        }
        catch (Exception e) {
            functionContext.getResultSender().sendException(e);
        }
    }
}

